/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network;

import io.netty.buffer.ByteBuf;
import java.io.File;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nimble.portable_blueprints.altro.Blueprint;

public record CtoS_BlueprintRemove(String nome) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CtoS_BlueprintRemove> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"ctos_blueprint_remove"));
    public static final StreamCodec<ByteBuf, CtoS_BlueprintRemove> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, CtoS_BlueprintRemove::nome, CtoS_BlueprintRemove::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CtoS_BlueprintRemove packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            ServerLevel level = player.serverLevel();
            File[] files = Blueprint.getFileForBlueprints(level, player.getUUID()).listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                if (!f.getName().substring(0, f.getName().length() - 3).equals(packet.nome())) continue;
                Blueprint.RimuoviBlueprint(level, player, packet.nome());
            }
        });
    }
}

