/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.network.custom_codecs.ModCustomCodecs;

public record CtoS_CreaItemBlueprint(String nome, Optional<UUID> bpOwner, boolean isGlobalInstance, boolean isServerBlueprint) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CtoS_CreaItemBlueprint> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"ctos_create_item_blueprint"));
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final StreamCodec<ByteBuf, CtoS_CreaItemBlueprint> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, CtoS_CreaItemBlueprint::nome, (StreamCodec)ByteBufCodecs.optional(ModCustomCodecs.UUID), CtoS_CreaItemBlueprint::bpOwner, (StreamCodec)ByteBufCodecs.BOOL, CtoS_CreaItemBlueprint::isGlobalInstance, (StreamCodec)ByteBufCodecs.BOOL, CtoS_CreaItemBlueprint::isServerBlueprint, CtoS_CreaItemBlueprint::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CtoS_CreaItemBlueprint packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            ServerLevel level = player.serverLevel();
            String nome = packet.nome();
            Optional<UUID> ownerOpt = packet.bpOwner();
            boolean isServer = packet.isServerBlueprint();
            if (isServer) {
                File blueprintFile = null;
                for (File f : Blueprint.getServerBlueprintFile(level).listFiles()) {
                    if (!f.getName().equals(nome + ".bp")) continue;
                    blueprintFile = f;
                    break;
                }
                if (blueprintFile != null) {
                    try {
                        Blueprint.BlueprintDatas bd = (Blueprint.BlueprintDatas)GSON.fromJson((Reader)new FileReader(blueprintFile), Blueprint.BlueprintDatas.class);
                        Blueprint.CreaItemServerBlueprintEDaiAGiocatore(player, nome, bd.altezza, bd.lunghezzaX, bd.lunghezzaZ);
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            } else {
                UUID blueprintOwner = ownerOpt.orElse(player.getUUID());
                File blueprintFile = null;
                for (File f : Blueprint.getFileForBlueprints(level, blueprintOwner).listFiles()) {
                    if (!f.getName().equals(nome + ".bp")) continue;
                    blueprintFile = f;
                    break;
                }
                if (blueprintFile != null) {
                    try {
                        Blueprint.BlueprintDatas bd = (Blueprint.BlueprintDatas)GSON.fromJson((Reader)new FileReader(blueprintFile), Blueprint.BlueprintDatas.class);
                        Blueprint.CreaItemBlueprintEDaiAGiocatore(player, blueprintOwner, nome, bd.altezza, bd.lunghezzaX, bd.lunghezzaZ);
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    public static void send(boolean isServerBlueprint, String nome) {
        PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_CreaItemBlueprint(nome, Optional.of(UUID.randomUUID()), false, isServerBlueprint), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void send(UUID BPOwner, String nome, boolean is_global_instance) {
        PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_CreaItemBlueprint(nome, Optional.of(BPOwner), is_global_instance, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void send(UUID BPOwner, String nome) {
        PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_CreaItemBlueprint(nome, Optional.of(BPOwner), false, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void send(String nome) {
        PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_CreaItemBlueprint(nome, Optional.empty(), false, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

