/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nimble.portable_blueprints.altro.BlockBlueprintUsage;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.network.custom_codecs.ModCustomCodecs;

public record CtoS_CreateBlueprint(BlockPos angolo1, BlockPos angolo2, String nome, boolean consideraCreativeBlocks, String datoLista, UUID uuidRichiesta) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CtoS_CreateBlueprint> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"ctos_create_blueprint"));
    public static final StreamCodec<ByteBuf, CtoS_CreateBlueprint> STREAM_CODEC = StreamCodec.composite(ModCustomCodecs.BLOCKPOS, CtoS_CreateBlueprint::angolo1, ModCustomCodecs.BLOCKPOS, CtoS_CreateBlueprint::angolo2, (StreamCodec)ByteBufCodecs.STRING_UTF8, CtoS_CreateBlueprint::nome, (StreamCodec)ByteBufCodecs.BOOL, CtoS_CreateBlueprint::consideraCreativeBlocks, (StreamCodec)ByteBufCodecs.STRING_UTF8, CtoS_CreateBlueprint::datoLista, ModCustomCodecs.UUID, CtoS_CreateBlueprint::uuidRichiesta, CtoS_CreateBlueprint::new);
    private static Map<UUID, PachettoDati> DatiPachetto = new HashMap<UUID, PachettoDati>();

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CtoS_CreateBlueprint packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            ServerLevel level = player.serverLevel();
            if (BlockBlueprintUsage.PlayersBlock.contains(player.getName().getString())) {
                if (!packet.nome.equals("")) {
                    player.displayClientMessage((Component)Component.translatable((String)"chat_message.portable_blueprints.block_scanner").withStyle(ChatFormatting.RED), false);
                }
                return;
            }
            if ((packet.nome.equals("") || packet.nome.isEmpty()) && DatiPachetto.containsKey(packet.uuidRichiesta)) {
                if (packet.datoLista.equals("\ufffdEND\ufffd")) {
                    PachettoDati pachettoDati = DatiPachetto.get(packet.uuidRichiesta);
                    Blueprint.CreateBlueprint(level, pachettoDati.angolo1, pachettoDati.angolo2, pachettoDati.nome, player.getUUID(), pachettoDati.consideraCreativeBlocks, pachettoDati.ScannerIgnoredBlocks);
                    DatiPachetto.remove(packet.uuidRichiesta);
                } else {
                    CtoS_CreateBlueprint.DatiPachetto.get((Object)packet.uuidRichiesta).ScannerIgnoredBlocks.add(packet.datoLista);
                }
            } else if (!(packet.nome.equals("") || packet.nome.isEmpty() || DatiPachetto.containsKey(packet.uuidRichiesta))) {
                player.displayClientMessage((Component)Component.literal((String)Component.translatable((String)"hotbar_message.portable_blueprints.blueprint_creation").getString().replace("%v%", packet.nome)).withStyle(ChatFormatting.GREEN), true);
                DatiPachetto.put(packet.uuidRichiesta, new PachettoDati(packet.angolo1, packet.angolo2, packet.nome, packet.consideraCreativeBlocks));
            }
        });
    }

    public static List<String> creaListaDati(List<String> dati) {
        ArrayList<String> listaDati = new ArrayList<String>();
        for (String s : dati) {
            if (s.length() <= 30000) {
                listaDati.add(s);
                continue;
            }
            listaDati.add(s.substring(0, 30000));
        }
        listaDati.add("\ufffdEND\ufffd");
        return listaDati;
    }

    public static void inviaRichiestaNormale(BlockPos angolo1, BlockPos angolo2, String nome, boolean consideraCreativeBlocks, UUID uuidRichiesta) {
        PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_CreateBlueprint(angolo1, angolo2, nome, consideraCreativeBlocks, "", uuidRichiesta), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void inviaRichiestaLista(String dato, UUID uuidRichiesta) {
        PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_CreateBlueprint(BlockPos.ZERO, BlockPos.ZERO, "", false, dato, uuidRichiesta), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static class PachettoDati {
        public List<String> ScannerIgnoredBlocks = new ArrayList<String>();
        private final BlockPos angolo1;
        private final BlockPos angolo2;
        private final String nome;
        private final boolean consideraCreativeBlocks;

        public PachettoDati(BlockPos angolo1, BlockPos angolo2, String nome, boolean consideraCreativeBlocks) {
            this.angolo1 = angolo1;
            this.angolo2 = angolo2;
            this.nome = nome;
            this.consideraCreativeBlocks = consideraCreativeBlocks;
        }
    }
}

