/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nimble.portable_blueprints.altro.BlockBlueprintUsage;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.altro.BlueprintUsageCooldown;
import nimble.portable_blueprints.altro.PlacingBlockManager;
import nimble.portable_blueprints.init.ModItems;
import nimble.portable_blueprints.mod_compatibility.ModCompatibilityInit;
import nimble.portable_blueprints.mod_compatibility.projecte.ProjectEMetodi;
import nimble.portable_blueprints.network.StoC_ObstructionBlock;
import nimble.portable_blueprints.network.custom_codecs.ModCustomCodecs;
import nimble.portable_blueprints.portable_blueprints.ModServerConfig;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;
import nimble.portable_blueprints.robautile.Operazioni;

public record CtoS_CreateStructureByBlueprint(ItemStack blueprintItem, boolean isServerBlueprint, boolean isWornBlueprint, BlockPos origin) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CtoS_CreateStructureByBlueprint> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"ctos_create_structure_by_blueprint"));
    public static final StreamCodec<ByteBuf, CtoS_CreateStructureByBlueprint> STREAM_CODEC = StreamCodec.composite(ModCustomCodecs.ITEM_STACK, CtoS_CreateStructureByBlueprint::blueprintItem, (StreamCodec)ByteBufCodecs.BOOL, CtoS_CreateStructureByBlueprint::isServerBlueprint, (StreamCodec)ByteBufCodecs.BOOL, CtoS_CreateStructureByBlueprint::isWornBlueprint, ModCustomCodecs.BLOCKPOS, CtoS_CreateStructureByBlueprint::origin, CtoS_CreateStructureByBlueprint::new);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CtoS_CreateStructureByBlueprint packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            UUID owner_blueprint;
            if (packet.blueprintItem.equals(ItemStack.EMPTY)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)context.player();
            ServerLevel level = player.serverLevel();
            if (BlockBlueprintUsage.PlayersBlock.contains(player.getName().getString())) {
                player.displayClientMessage((Component)Component.translatable((String)"chat_message.portable_blueprints.block").withStyle(ChatFormatting.RED), false);
                return;
            }
            if (BlueprintUsageCooldown.hasCooldown(player.getUUID()) != 0) {
                player.displayClientMessage((Component)Component.literal((String)Component.translatable((String)"chat_message.portable_blueprints.blueprint_cooldown").getString().replace("%v%", String.valueOf(BlueprintUsageCooldown.hasCooldown(player.getUUID())))).withStyle(ChatFormatting.RED), false);
                return;
            }
            CompoundTag nbt = OldVersionUtilities.getItemStackNBT(packet.blueprintItem);
            BlockPos origin_pos = packet.origin;
            boolean mirrowX = nbt.getBoolean("mirrowX");
            boolean mirrowY = nbt.getBoolean("mirrowY");
            boolean mirrowZ = nbt.getBoolean("mirrowZ");
            boolean skipObstructionBlock = nbt.getBoolean("skipObstructionBlock");
            short rotation = nbt.getShort("rotateValue");
            String nome = nbt.getString("nome");
            String posizioni_inventari_blocco = nbt.getString("inventari_blocco_selezionati");
            try {
                owner_blueprint = !nbt.getString("owner").equals("") && !packet.isServerBlueprint && !packet.isWornBlueprint ? UUID.fromString(nbt.getString("owner")) : null;
            }
            catch (Exception e) {
                owner_blueprint = null;
            }
            boolean buildAniway = nbt.getBoolean("buildAnyway");
            if (player.getMainHandItem() != null && player.getMainHandItem().getItem().equals(ModItems.BLUEPRINT.get())) {
                nbt.putBoolean("visualizeBuild", false);
                nbt.remove("originPos");
            }
            File blueprintFile = Arrays.stream(packet.isServerBlueprint ? Blueprint.getServerBlueprintFile(level).listFiles() : (packet.isWornBlueprint ? Blueprint.getWornBlueprintFile(level).listFiles() : Blueprint.getFileForBlueprints(level, owner_blueprint).listFiles())).filter(f -> f.getName().equals(nome + ".bp")).findFirst().orElse(null);
            ArrayList BlocksDataToRemove = new ArrayList();
            ArrayList NotSolidBlocksDataToRemove = new ArrayList();
            if (blueprintFile != null) {
                new Thread(() -> {
                    block34: {
                        try {
                            Blueprint.BlueprintDatas bd = (Blueprint.BlueprintDatas)GSON.fromJson((Reader)new FileReader(blueprintFile), Blueprint.BlueprintDatas.class);
                            if (rotation != 0) {
                                bd = bd.rotate(rotation);
                            }
                            if (mirrowX || mirrowY || mirrowZ) {
                                bd = bd.Mirrow(mirrowX, mirrowY, mirrowZ);
                            }
                            bd.offset = Operazioni.SommaBlockPos(bd.offset == null ? BlockPos.ZERO : bd.offset, origin_pos);
                            ArrayList<BlockPos> posInventari = new ArrayList<BlockPos>();
                            for (String pos : posizioni_inventari_blocco.split("!;!")) {
                                if (pos.equals("")) continue;
                                posInventari.add(new BlockPos(Operazioni.getVec3iFromString(pos)));
                            }
                            Map<Item, Integer> ItemDisponibili = Blueprint.getAllItemQuantityFromInventory(player, level, posInventari);
                            boolean free_build = nbt.contains("free_build") && nbt.getBoolean("free_build");
                            boolean emc_active = nbt.contains("projecte_active_emc") && nbt.getBoolean("projecte_active_emc");
                            HashMap<Item, Integer> QuantitaItemRichiesti = new HashMap<Item, Integer>();
                            long PlayerEMC = ProjectEMetodi.getEMCPlayer(player.getUUID());
                            boolean AreaLibera = true;
                            boolean erroreBloccoOstruzione = false;
                            ArrayList<BlockPos> posBlocchiCheOstruiscono = new ArrayList<BlockPos>();
                            for (int alt = 0; alt <= bd.altezza && (AreaLibera || erroreBloccoOstruzione); ++alt) {
                                block6: for (int x = 0; x < 2; ++x) {
                                    boolean isSolidBlocks;
                                    boolean bl = isSolidBlocks = x == 0;
                                    if (!(isSolidBlocks ? bd.BlocksData.containsKey(alt) : bd.NotSolidBlocksData.containsKey(alt))) continue;
                                    int counting = 0;
                                    for (String pos : isSolidBlocks ? bd.BlocksData.get(alt).keySet() : bd.NotSolidBlocksData.get(alt).keySet()) {
                                        if (!AreaLibera && !erroreBloccoOstruzione) continue block6;
                                        BlockPos blockPos = new BlockPos(Operazioni.getVec3iFromString(pos));
                                        String datiBlocco = isSolidBlocks ? bd.BlocksData.get(alt).get(Operazioni.getVec3iString(new Vec3i(blockPos.getX(), blockPos.getY(), blockPos.getZ()))) : bd.NotSolidBlocksData.get(alt).get(Operazioni.getVec3iString(new Vec3i(blockPos.getX(), blockPos.getY(), blockPos.getZ())));
                                        String bloccoId = datiBlocco.substring(datiBlocco.indexOf("<bid>") + 5, datiBlocco.indexOf("</bid>"));
                                        datiBlocco = datiBlocco.replaceFirst("<bid>" + bloccoId + "</bid>", "");
                                        if (ModServerConfig.blacklistBlock.contains(bloccoId)) {
                                            if (isSolidBlocks) {
                                                BlocksDataToRemove.add(alt + "<daRimuovere>" + pos);
                                                continue;
                                            }
                                            NotSolidBlocksDataToRemove.add(alt + "<daRimuovere>" + pos);
                                            continue;
                                        }
                                        BlockState blockState = datiBlocco.equals("null") ? Operazioni.getBlockFromString(bloccoId).defaultBlockState() : Operazioni.getPropertiesStringToBlock(Operazioni.getBlockFromString(bloccoId), datiBlocco);
                                        Block blocco = Operazioni.getBlockFromString(bloccoId);
                                        BlockState PlacedBlockBlockState = level.getBlockState(Operazioni.SommaBlockPos(bd.offset, blockPos));
                                        Item bi = Operazioni.getCorrectItemStackFromId(blocco).getItem();
                                        if (QuantitaItemRichiesti.containsKey(bi)) {
                                            QuantitaItemRichiesti.replace(bi, (Integer)QuantitaItemRichiesti.get(bi) + 1);
                                        } else {
                                            QuantitaItemRichiesti.put(bi, 1);
                                        }
                                        if (!(skipObstructionBlock || PlacedBlockBlockState.is(Blocks.AIR) || PlacedBlockBlockState.is(blocco) || PlacingBlockManager.isRimpiazzabile(PlacedBlockBlockState))) {
                                            AreaLibera = false;
                                            erroreBloccoOstruzione = true;
                                            posBlocchiCheOstruiscono.add(Operazioni.SommaBlockPos(bd.offset, blockPos));
                                        }
                                        if (free_build || buildAniway || player.isCreative() || player.isSpectator() || blockState.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && !((DoubleBlockHalf)blockState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.LOWER) || blockState.hasProperty((Property)BlockStateProperties.BED_PART) && !((BedPart)blockState.getValue((Property)BlockStateProperties.BED_PART)).equals((Object)BedPart.FOOT)) continue;
                                        if (ItemDisponibili.containsKey(blocco.asItem())) {
                                            int newQuantity = ItemDisponibili.get(blocco.asItem()) - 1;
                                            if (newQuantity <= 0) {
                                                ItemDisponibili.remove(blocco.asItem());
                                            } else {
                                                ItemDisponibili.replace(blocco.asItem(), newQuantity);
                                            }
                                        } else if (!blocco.asItem().equals(Items.AIR)) {
                                            if (ModCompatibilityInit.isProjectELoaded && emc_active) {
                                                long vEMC = ProjectEMetodi.getEMCForItem(Operazioni.getCorrectItemStackFromId(blocco).getItem());
                                                if (vEMC == 0L) {
                                                    AreaLibera = false;
                                                    player.displayClientMessage((Component)Component.literal((String)Component.translatable((String)"hotbar_message.portable_blueprints.item_missing").getString().replace("%v%", Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).getItem().toString())).withStyle(ChatFormatting.RED), false);
                                                } else if (PlayerEMC >= vEMC) {
                                                    PlayerEMC -= vEMC;
                                                } else {
                                                    AreaLibera = false;
                                                    player.displayClientMessage((Component)Component.literal((String)Component.translatable((String)"gui.portable_blueprints.compatibility.projecte.emc_missing").getString().replace("%v%", Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).getItem().toString())).withStyle(ChatFormatting.RED), false);
                                                }
                                            } else {
                                                AreaLibera = false;
                                                player.displayClientMessage((Component)Component.literal((String)Component.translatable((String)"hotbar_message.portable_blueprints.item_missing").getString().replace("%v%", Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).getItem().toString())).withStyle(ChatFormatting.RED), false);
                                            }
                                        }
                                        if (++counting % 50 != 0) continue;
                                        Thread.sleep(2L);
                                    }
                                }
                                Thread.sleep(1L);
                            }
                            if (AreaLibera) {
                                if (packet.isWornBlueprint) {
                                    for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                                        ItemStack stack = player.getInventory().getItem(i);
                                        if (stack.isEmpty() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)packet.blueprintItem) || !OldVersionUtilities.getItemStackNBT(stack).getString("blueprint_name").equals(OldVersionUtilities.getItemStackNBT(packet.blueprintItem).getString("blueprint_name"))) continue;
                                        CompoundTag _nbt = OldVersionUtilities.getItemStackNBT(stack);
                                        if (!_nbt.contains("remaining_uses")) break;
                                        int uses = _nbt.getInt("remaining_uses") - 1;
                                        _nbt.putInt("remaining_uses", uses);
                                        OldVersionUtilities.impostaItemStackNBT(stack, _nbt);
                                        if (uses > 0) break;
                                        level.playSound(null, player.blockPosition(), SoundEvents.ITEM_BREAK, SoundSource.AMBIENT, 1.0f, 2.0f);
                                        player.getInventory().removeItem(stack);
                                        break;
                                    }
                                }
                                for (String elemento : BlocksDataToRemove) {
                                    String[] split = elemento.split("<daRimuovere>");
                                    bd.BlocksData.get(Integer.parseInt(split[0])).remove(split[1]);
                                }
                                for (String elemento : NotSolidBlocksDataToRemove) {
                                    String[] split = elemento.split("<daRimuovere>");
                                    bd.BlocksData.get(Integer.parseInt(split[0])).remove(split[1]);
                                }
                                if (!player.hasPermissions(1)) {
                                    BlueprintUsageCooldown.setInCooldown(level, player.getUUID());
                                }
                                Blueprint.AggiungiStructureAllaCoda(level, bd, (Player)player, posInventari, free_build, (short)(nbt.contains("allow_nbt") ? (nbt.getBoolean("allow_nbt") ? 1 : 0) : -1), emc_active);
                                break block34;
                            }
                            if (!erroreBloccoOstruzione) break block34;
                            player.displayClientMessage((Component)Component.literal((String)Component.translatable((String)"hotbar_message.portable_blueprints.block_obstruction").getString().replace("%v%", String.valueOf(posBlocchiCheOstruiscono.size()))).withStyle(ChatFormatting.RED), false);
                            int count = 0;
                            for (BlockPos pos : posBlocchiCheOstruiscono) {
                                try {
                                    if (++count % 500 == 0) {
                                        Thread.sleep(10L);
                                    }
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StoC_ObstructionBlock(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
            }
        });
    }
}

