/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nimble.portable_blueprints.network.custom_codecs.ModCustomCodecs;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;

public record CtoS_RemoveItem(ItemStack itemDaRimuovere) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CtoS_RemoveItem> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"ctos_remove_item"));
    public static final StreamCodec<ByteBuf, CtoS_RemoveItem> STREAM_CODEC = StreamCodec.composite(ModCustomCodecs.ITEM_STACK, CtoS_RemoveItem::itemDaRimuovere, CtoS_RemoveItem::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CtoS_RemoveItem packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            ItemStack daRimuovere = packet.itemDaRimuovere();
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack current = player.getInventory().getItem(i);
                if (!current.getItem().equals(daRimuovere.getItem())) continue;
                CompoundTag currentNBT = OldVersionUtilities.getItemStackNBT(current);
                if (!OldVersionUtilities.getItemStackNBT(daRimuovere).equals((Object)currentNBT)) continue;
                player.getInventory().setItem(i, ItemStack.EMPTY);
                player.displayClientMessage((Component)Component.translatable((String)"hotbar_message.portable_blueprints.blueprint_missing").withStyle(ChatFormatting.RED), true);
                break;
            }
        });
    }
}

