/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.network.custom_codecs.ModCustomCodecs;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;

public record CtoS_RemoveItemIfBlueprintNotExist(ItemStack item, String nome) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CtoS_RemoveItemIfBlueprintNotExist> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"ctos_remove_if_bp_missing"));
    public static final StreamCodec<ByteBuf, CtoS_RemoveItemIfBlueprintNotExist> STREAM_CODEC = StreamCodec.composite(ModCustomCodecs.ITEM_STACK, CtoS_RemoveItemIfBlueprintNotExist::item, (StreamCodec)ByteBufCodecs.STRING_UTF8, CtoS_RemoveItemIfBlueprintNotExist::nome, CtoS_RemoveItemIfBlueprintNotExist::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CtoS_RemoveItemIfBlueprintNotExist packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            ServerLevel level = player.serverLevel();
            ItemStack item = packet.item();
            String nome = packet.nome();
            boolean exists = false;
            try {
                File[] files;
                File[] owner;
                for (File f : files = (switch (owner = OldVersionUtilities.getItemStackNBT(item).getString("owner")) {
                    case "server" -> Blueprint.getServerBlueprintFile(level).listFiles();
                    case "worn" -> Blueprint.getWornBlueprintFile(level).listFiles();
                    default -> Blueprint.getFileForBlueprints(level, UUID.fromString((String)owner)).listFiles();
                })) {
                    if (!f.getName().equals(nome + ".bp")) continue;
                    exists = true;
                    break;
                }
            }
            catch (Exception owner) {
                // empty catch block
            }
            if (!exists) {
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    ItemStack current = player.getInventory().getItem(i);
                    CompoundTag nbt = OldVersionUtilities.getItemStackNBT(current);
                    CompoundTag nbtItem = OldVersionUtilities.getItemStackNBT(item);
                    if (!nbt.contains("nome") || !current.getItem().equals(item.getItem()) || !nbt.getString("nome").equals(nbtItem.getString("nome")) || !nbt.contains("owner") || !nbt.getString("owner").equals(nbtItem.getString("owner"))) continue;
                    player.getInventory().setItem(i, ItemStack.EMPTY);
                    player.displayClientMessage((Component)Component.translatable((String)"hotbar_message.portable_blueprints.blueprint_missing").withStyle(ChatFormatting.RED), true);
                    break;
                }
            }
        });
    }
}

