/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.init.ModGameRules;
import nimble.portable_blueprints.robautile.Operazioni;

public record CtoS_SaveGlobalBlueprintInServer(String valore) implements CustomPacketPayload
{
    public static final Map<UUID, Boolean> StaGiaGestendoUnaBlueprint = new HashMap<UUID, Boolean>();
    public static final Map<UUID, String> ID_blueprint_in_gestione = new HashMap<UUID, String>();
    public static final Map<UUID, String> NOME_BLUEPRINT = new HashMap<UUID, String>();
    public static final CustomPacketPayload.Type<CtoS_SaveGlobalBlueprintInServer> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"ctos_save_global_blueprint_in_server"));
    public static final StreamCodec<FriendlyByteBuf, CtoS_SaveGlobalBlueprintInServer> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, CtoS_SaveGlobalBlueprintInServer::valore, CtoS_SaveGlobalBlueprintInServer::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static boolean handle(CtoS_SaveGlobalBlueprintInServer msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (player == null) {
                return;
            }
            ServerLevel level = player.serverLevel();
            UUID uuidPlayer = player.getUUID();
            if (!level.getGameRules().getBoolean(ModGameRules.AllowGlobalBlueprints)) {
                return;
            }
            StaGiaGestendoUnaBlueprint.putIfAbsent(uuidPlayer, false);
            ID_blueprint_in_gestione.putIfAbsent(uuidPlayer, "");
            NOME_BLUEPRINT.putIfAbsent(uuidPlayer, "");
            String valore = msg.valore;
            if (valore.contains("[INIZIO DATI BLUEPRINT ") && !StaGiaGestendoUnaBlueprint.get(uuidPlayer).booleanValue()) {
                StaGiaGestendoUnaBlueprint.put(uuidPlayer, true);
                ID_blueprint_in_gestione.put(uuidPlayer, Operazioni.getValueInsideTag(valore, "id"));
                NOME_BLUEPRINT.put(uuidPlayer, Operazioni.getValueInsideTag(valore, "nome") + " [Global]");
                try {
                    File dir = Blueprint.getFileForBlueprints(level, uuidPlayer);
                    File blueprintFile = new File(dir, NOME_BLUEPRINT.get(uuidPlayer) + ".bp");
                    if (blueprintFile.exists()) {
                        blueprintFile.delete();
                    }
                    File tmpFile = new File(dir, NOME_BLUEPRINT.get(uuidPlayer) + ".tmp");
                    tmpFile.createNewFile();
                    Files.write(tmpFile.toPath(), "".getBytes(), new OpenOption[0]);
                    player.sendSystemMessage((Component)Component.literal((String)Component.translatable((String)"chat_message.portable_blueprints.server_global_blueprint_start").getString().replace("%v%", NOME_BLUEPRINT.get(uuidPlayer))).withStyle(ChatFormatting.GOLD));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (valore.contains("[FINE DATI BLUEPRINT DI ID: ") && StaGiaGestendoUnaBlueprint.get(uuidPlayer).booleanValue() && valore.contains(ID_blueprint_in_gestione.get(uuidPlayer))) {
                File dir = Blueprint.getFileForBlueprints(level, uuidPlayer);
                new File(dir, NOME_BLUEPRINT.get(uuidPlayer) + ".tmp").renameTo(new File(dir, NOME_BLUEPRINT.get(uuidPlayer) + ".bp"));
                player.sendSystemMessage((Component)Component.literal((String)Component.translatable((String)"chat_message.portable_blueprints.server_global_blueprint_end").getString().replace("%v%", NOME_BLUEPRINT.get(uuidPlayer))).withStyle(ChatFormatting.GOLD));
                NOME_BLUEPRINT.put(uuidPlayer, "");
                StaGiaGestendoUnaBlueprint.put(uuidPlayer, false);
                ID_blueprint_in_gestione.put(uuidPlayer, "");
            } else if (valore.contains("[" + ID_blueprint_in_gestione.get(uuidPlayer) + "]")) {
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(Blueprint.getFileForBlueprints(level, uuidPlayer), NOME_BLUEPRINT.get(uuidPlayer) + ".tmp"), true));){
                    writer.write(valore.replace("[" + ID_blueprint_in_gestione.get(uuidPlayer) + "]", ""));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return true;
    }

    public static void resetPlayer(UUID uuid) {
        NOME_BLUEPRINT.remove(uuid);
        StaGiaGestendoUnaBlueprint.remove(uuid);
        ID_blueprint_in_gestione.remove(uuid);
    }
}

