/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.ServerBlueprints;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.network.ServerBlueprints.StoC_ServerBlueprintsData;

public record CtoS_ServerBlueprintsData() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CtoS_ServerBlueprintsData> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"ctos_server_blueprints_data"));
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final StreamCodec<ByteBuf, CtoS_ServerBlueprintsData> STREAM_CODEC = StreamCodec.unit((Object)new CtoS_ServerBlueprintsData());

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CtoS_ServerBlueprintsData packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (player == null) {
                return;
            }
            ServerLevel level = player.serverLevel();
            File permissionFile = Blueprint.getServerPremissionFile(level);
            try {
                Blueprint.BlueprintPermission bp = (Blueprint.BlueprintPermission)GSON.fromJson((Reader)new FileReader(permissionFile), Blueprint.BlueprintPermission.class);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StoC_ServerBlueprintsData("START"), (CustomPacketPayload[])new CustomPacketPayload[0]);
                for (String blueprint : bp.getPlayerAllAllowedBlueprints(player.getUUID())) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StoC_ServerBlueprintsData(blueprint), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        });
    }
}

