/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nimble.portable_blueprints.Events.RenderScannerAnimation;
import nimble.portable_blueprints.network.custom_codecs.ModCustomCodecs;
import nimble.portable_blueprints.portable_blueprints.ModConfig;

public record StoC_ScannerAnimation(UUID animationID, boolean active, BlockPos angolo1, BlockPos angolo2, boolean add) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<StoC_ScannerAnimation> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"stoc_scanner_animation"));
    public static final StreamCodec<ByteBuf, StoC_ScannerAnimation> STREAM_CODEC = StreamCodec.composite(ModCustomCodecs.UUID, StoC_ScannerAnimation::animationID, (StreamCodec)ByteBufCodecs.BOOL, StoC_ScannerAnimation::active, ModCustomCodecs.BLOCKPOS, StoC_ScannerAnimation::angolo1, ModCustomCodecs.BLOCKPOS, StoC_ScannerAnimation::angolo2, (StreamCodec)ByteBufCodecs.BOOL, StoC_ScannerAnimation::add, StoC_ScannerAnimation::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(StoC_ScannerAnimation msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (!((Boolean)ModConfig.ScanningAnimationEnabled.get()).booleanValue()) {
                return;
            }
            if (msg.add()) {
                RenderScannerAnimation.addProgress(msg.animationID());
            } else if (msg.active()) {
                RenderScannerAnimation.addAnimation(msg.animationID(), msg.angolo1(), msg.angolo2());
            } else {
                RenderScannerAnimation.removeAnimazione(msg.animationID());
            }
        });
    }
}

