/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.custom_codecs;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import nimble.portable_blueprints.network.richiesta_contenuto.CtoS_RichiestaGamerule;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;
import nimble.portable_blueprints.robautile.Operazioni;

public class ModCustomCodecs {
    public static final StreamCodec<ByteBuf, ItemStack> ITEM_STACK = StreamCodec.of((buf, stack) -> {
        FriendlyByteBuf fb = new FriendlyByteBuf(buf);
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        fb.writeUtf(id.toString());
        fb.writeInt(stack.getCount());
        fb.writeNbt((Tag)OldVersionUtilities.getItemStackNBT(stack));
    }, buf -> {
        FriendlyByteBuf fb = new FriendlyByteBuf(buf);
        ItemStack itemStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)fb.readUtf())), fb.readInt());
        OldVersionUtilities.impostaItemStackNBT(itemStack, fb.readNbt());
        return itemStack;
    });
    public static final StreamCodec<ByteBuf, BlockPos> BLOCKPOS = StreamCodec.of((buf, pos) -> {
        FriendlyByteBuf fb = new FriendlyByteBuf(buf);
        fb.writeBlockPos(pos);
    }, buf -> {
        FriendlyByteBuf fb = new FriendlyByteBuf(buf);
        return fb.readBlockPos();
    });
    public static final StreamCodec<ByteBuf, List<BlockPos>> LIST_BLOCKPOS = StreamCodec.of((buf, poss) -> {
        FriendlyByteBuf fb = new FriendlyByteBuf(buf);
        fb.writeInt(poss.size());
        for (BlockPos pos : poss) {
            fb.writeBlockPos(pos);
        }
    }, buf -> {
        FriendlyByteBuf fb = new FriendlyByteBuf(buf);
        ArrayList<BlockPos> poss = new ArrayList<BlockPos>();
        int size = fb.readInt();
        for (int i = 0; i < size; ++i) {
            poss.add(fb.readBlockPos());
        }
        return poss;
    });
    public static final StreamCodec<ByteBuf, UUID> UUID = StreamCodec.of((buf, uuid) -> {
        FriendlyByteBuf fb = new FriendlyByteBuf(buf);
        fb.writeBoolean(uuid != null);
        if (uuid != null) {
            fb.writeUUID(uuid);
        }
    }, buf -> {
        FriendlyByteBuf fb = new FriendlyByteBuf(buf);
        return fb.readBoolean() ? fb.readUUID() : null;
    });
    public static final StreamCodec<ByteBuf, Item> ITEM = StreamCodec.of((buf, item) -> {
        FriendlyByteBuf fb = new FriendlyByteBuf(buf);
        ResourceLocation id = BuiltInRegistries.ITEM.getKey(item);
        fb.writeUtf(id.toString());
    }, buf -> {
        FriendlyByteBuf fb = new FriendlyByteBuf(buf);
        return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)fb.readUtf()));
    });
    public static final StreamCodec<ByteBuf, Vec3> VEC3 = StreamCodec.of((buf, vec3) -> {
        FriendlyByteBuf fb = new FriendlyByteBuf(buf);
        fb.writeUtf(Operazioni.getVec3String(vec3));
    }, buf -> {
        FriendlyByteBuf fb = new FriendlyByteBuf(buf);
        return Operazioni.getVec3FromString(fb.readUtf());
    });
    public static final StreamCodec<ByteBuf, CtoS_RichiestaGamerule.TipoRichiesta> ENUM_TIPORICHIESTA = StreamCodec.of((buf, TipoRichiesta2) -> {
        FriendlyByteBuf fb = new FriendlyByteBuf(buf);
        fb.writeEnum((Enum)TipoRichiesta2);
    }, buf -> {
        FriendlyByteBuf fb = new FriendlyByteBuf(buf);
        return (CtoS_RichiestaGamerule.TipoRichiesta)fb.readEnum(CtoS_RichiestaGamerule.TipoRichiesta.class);
    });
}

