/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.ottieni_nome_x_blueprint;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.network.ottieni_nome_x_blueprint.StoC_BlueprintXName;

public record CtoS_BlueprintXName(int idRichesta, int xPosition) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CtoS_BlueprintXName> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"ctos_blueprint_x_name"));
    public static final StreamCodec<ByteBuf, CtoS_BlueprintXName> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CtoS_BlueprintXName::idRichesta, (StreamCodec)ByteBufCodecs.INT, CtoS_BlueprintXName::xPosition, CtoS_BlueprintXName::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CtoS_BlueprintXName packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            ServerLevel level = player.serverLevel();
            ArrayList<File> files = new ArrayList<File>();
            for (File file : Blueprint.getFileForBlueprints(level, player.getUUID()).listFiles()) {
                if (!file.getName().contains(".bp")) continue;
                files.add(file);
            }
            String risultato = "";
            if (packet.xPosition() >= 0 && packet.xPosition() < files.size()) {
                String fileName = ((File)files.get(packet.xPosition())).getName();
                risultato = fileName.substring(0, fileName.length() - ".bp".length());
            }
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StoC_BlueprintXName(packet.idRichesta(), risultato), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }
}

