/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.save_global_blueprint;

import java.io.File;
import java.nio.file.Files;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.init.ModGameRules;
import nimble.portable_blueprints.network.save_global_blueprint.StoC_SaveGlobalBlueprint;
import nimble.portable_blueprints.robautile.Operazioni;

public record CtoS_SaveGlobalBlueprint(String nome) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CtoS_SaveGlobalBlueprint> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"ctos_save_global_blueprint"));
    public static final StreamCodec<FriendlyByteBuf, CtoS_SaveGlobalBlueprint> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, CtoS_SaveGlobalBlueprint::nome, CtoS_SaveGlobalBlueprint::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CtoS_SaveGlobalBlueprint packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            ServerLevel level = player.serverLevel();
            if (level.getGameRules().getBoolean(ModGameRules.AllowGlobalBlueprints)) {
                String nomeBlueprint = packet.nome.contains(";") ? packet.nome.split(";")[0] : packet.nome;
                String nomeDiRename = packet.nome.contains(";") ? packet.nome.split(";")[1] : packet.nome;
                File blueprintFile = null;
                File[] files = Blueprint.getFileForBlueprints(level, player.getUUID()).listFiles();
                if (files != null) {
                    for (File f : files) {
                        if (!f.getName().equals(nomeBlueprint + ".bp")) continue;
                        blueprintFile = f;
                        break;
                    }
                }
                if (blueprintFile != null) {
                    File finalBlueprintFile = blueprintFile;
                    new Thread(() -> {
                        try {
                            String bdStringDatas = new String(Files.readAllBytes(finalBlueprintFile.toPath()));
                            String idRichiesta = UUID.randomUUID().toString();
                            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StoC_SaveGlobalBlueprint("[INIZIO DATI BLUEPRINT <id>" + idRichiesta + "</id><nome>" + nomeDiRename + "</nome>"), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StoC_SaveGlobalBlueprint("[NOME DEL FILE:" + nomeDiRename), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            for (String val : Operazioni.splitStringByLength(bdStringDatas, 10000)) {
                                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StoC_SaveGlobalBlueprint("[" + idRichiesta + "]" + val), (CustomPacketPayload[])new CustomPacketPayload[0]);
                                Thread.sleep(10L);
                            }
                            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StoC_SaveGlobalBlueprint("[FINE DATI BLUEPRINT DI ID: " + idRichiesta + "]"), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }).start();
                }
            }
        });
    }
}

