/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.save_global_blueprint;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.robautile.Operazioni;

public record StoC_SaveGlobalBlueprint(String valore) implements CustomPacketPayload
{
    public static boolean StaGiaGestendoUnaBlueprint = false;
    private static String ID_blueprint_in_gestione = "";
    private static String NOME_BLUEPRINT = "";
    public static final CustomPacketPayload.Type<StoC_SaveGlobalBlueprint> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"stoc_save_global_blueprint"));
    public static final StreamCodec<FriendlyByteBuf, StoC_SaveGlobalBlueprint> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, StoC_SaveGlobalBlueprint::valore, StoC_SaveGlobalBlueprint::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(StoC_SaveGlobalBlueprint msg, IPayloadContext context) {
        Minecraft minecraft = Minecraft.getInstance();
        context.enqueueWork(() -> {
            String valore = msg.valore;
            if (valore.contains("[INIZIO DATI BLUEPRINT ") && !StaGiaGestendoUnaBlueprint) {
                StaGiaGestendoUnaBlueprint = true;
                ID_blueprint_in_gestione = Operazioni.getValueInsideTag(valore, "id");
                NOME_BLUEPRINT = Operazioni.getValueInsideTag(valore, "nome");
                try {
                    File dir = Blueprint.getGlobalBlueprintDir();
                    File blueprintFile = new File(dir, NOME_BLUEPRINT + ".bp");
                    if (blueprintFile.exists()) {
                        blueprintFile.delete();
                    }
                    File tmpFile = new File(dir, NOME_BLUEPRINT + ".tmp");
                    tmpFile.createNewFile();
                    Files.write(tmpFile.toPath(), "".getBytes(), new OpenOption[0]);
                    minecraft.player.displayClientMessage((Component)Component.literal((String)Component.translatable((String)"chat_message.portable_blueprints.global_blueprint_start").getString().replace("%v%", NOME_BLUEPRINT)).withStyle(ChatFormatting.GOLD), false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (valore.contains("[FINE DATI BLUEPRINT DI ID: ") && StaGiaGestendoUnaBlueprint && valore.contains(ID_blueprint_in_gestione)) {
                File dir = Blueprint.getGlobalBlueprintDir();
                File tmpFile = new File(dir, NOME_BLUEPRINT + ".tmp");
                File finalFile = new File(dir, NOME_BLUEPRINT + ".bp");
                tmpFile.renameTo(finalFile);
                minecraft.player.displayClientMessage((Component)Component.literal((String)Component.translatable((String)"chat_message.portable_blueprints.global_blueprint_end").getString().replace("%v%", NOME_BLUEPRINT)).withStyle(ChatFormatting.GOLD), false);
                NOME_BLUEPRINT = "";
                StaGiaGestendoUnaBlueprint = false;
                ID_blueprint_in_gestione = "";
            } else if (valore.contains("[" + ID_blueprint_in_gestione + "]")) {
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(Blueprint.getGlobalBlueprintDir(), NOME_BLUEPRINT + ".tmp"), true));){
                    writer.write(valore.replace("[" + ID_blueprint_in_gestione + "]", ""));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

