/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.update_item_blueprint_nbt;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nimble.portable_blueprints.network.custom_codecs.ModCustomCodecs;
import nimble.portable_blueprints.network.update_item_blueprint_nbt.StoC_UpdateItemBlueprintNBT;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;
import nimble.portable_blueprints.robautile.Operazioni;

public record CtoS_UpdateItemBlueprintNBT(ItemStack item, String nome, boolean valoreBooleano, short valoreShort, BlockPos posNuova) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CtoS_UpdateItemBlueprintNBT> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"ctos_update_item_blueprint_nbt"));
    public static final StreamCodec<ByteBuf, CtoS_UpdateItemBlueprintNBT> STREAM_CODEC = StreamCodec.composite(ModCustomCodecs.ITEM_STACK, CtoS_UpdateItemBlueprintNBT::item, (StreamCodec)ByteBufCodecs.STRING_UTF8, CtoS_UpdateItemBlueprintNBT::nome, (StreamCodec)ByteBufCodecs.BOOL, CtoS_UpdateItemBlueprintNBT::valoreBooleano, (StreamCodec)ByteBufCodecs.SHORT, CtoS_UpdateItemBlueprintNBT::valoreShort, ModCustomCodecs.BLOCKPOS, CtoS_UpdateItemBlueprintNBT::posNuova, CtoS_UpdateItemBlueprintNBT::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CtoS_UpdateItemBlueprintNBT msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (player == null) {
                return;
            }
            CompoundTag nbt = OldVersionUtilities.getItemStackNBT(player.getMainHandItem());
            if (msg.nome().equals("skipObstructionBlock") || msg.nome().equals("mirrowX") || msg.nome().equals("mirrowY") || msg.nome().equals("mirrowZ") || msg.nome().equals("buildAnyway") || msg.nome.equals("projecte_active_emc")) {
                nbt.putBoolean(msg.nome(), msg.valoreBooleano());
            } else if (msg.nome().equals("rotateValue")) {
                nbt.putShort(msg.nome(), msg.valoreShort());
            } else if (msg.nome().equals("originPos")) {
                nbt.putString(msg.nome(), Operazioni.getVec3iString((Vec3i)msg.posNuova()));
            }
            OldVersionUtilities.impostaItemStackNBT(player.getMainHandItem(), nbt);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StoC_UpdateItemBlueprintNBT(!msg.nome().equals("originPos")), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }
}

