/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.update_item_scanner_nbt;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nimble.portable_blueprints.network.custom_codecs.ModCustomCodecs;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;

public record CtoS_UpdateItemScannerNBT(ItemStack item, String nome, String valore_stringa) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CtoS_UpdateItemScannerNBT> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"ctos_update_item_scanner_nbt"));
    public static final StreamCodec<ByteBuf, CtoS_UpdateItemScannerNBT> STREAM_CODEC = StreamCodec.composite(ModCustomCodecs.ITEM_STACK, CtoS_UpdateItemScannerNBT::item, (StreamCodec)ByteBufCodecs.STRING_UTF8, CtoS_UpdateItemScannerNBT::nome, (StreamCodec)ByteBufCodecs.STRING_UTF8, CtoS_UpdateItemScannerNBT::valore_stringa, CtoS_UpdateItemScannerNBT::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CtoS_UpdateItemScannerNBT msg, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (player != null) {
                ItemStack item = player.getMainHandItem();
                CompoundTag nbt = OldVersionUtilities.getItemStackNBT(item);
                if (msg.nome().equals("coordinateAngolo1") || msg.nome().equals("coordinateAngolo2")) {
                    nbt.putString(msg.nome(), msg.valore_stringa());
                } else if (msg.nome().equals("angolo1") || msg.nome().equals("angolo2")) {
                    nbt.putBoolean(msg.nome(), Boolean.parseBoolean(msg.valore_stringa()));
                }
                OldVersionUtilities.impostaItemStackNBT(item, nbt);
            }
        });
    }
}

