/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.visualize_blueprint_data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.network.custom_codecs.ModCustomCodecs;
import nimble.portable_blueprints.network.visualize_blueprint_data.StoC_VisualizeBlueprintData;
import nimble.portable_blueprints.robautile.Operazioni;

public record CtoS_VisualizeBlueprintData(int idRichiestaBlueprint, String nomeBlueprintRichiesto, UUID ownerBlueprint, boolean isServerBlueprint, boolean isWornBlueprint) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CtoS_VisualizeBlueprintData> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"ctos_visualize_blueprint_data"));
    public static final StreamCodec<ByteBuf, CtoS_VisualizeBlueprintData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CtoS_VisualizeBlueprintData::idRichiestaBlueprint, (StreamCodec)ByteBufCodecs.STRING_UTF8, CtoS_VisualizeBlueprintData::nomeBlueprintRichiesto, ModCustomCodecs.UUID, CtoS_VisualizeBlueprintData::ownerBlueprint, (StreamCodec)ByteBufCodecs.BOOL, CtoS_VisualizeBlueprintData::isServerBlueprint, (StreamCodec)ByteBufCodecs.BOOL, CtoS_VisualizeBlueprintData::isWornBlueprint, CtoS_VisualizeBlueprintData::new);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CtoS_VisualizeBlueprintData packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            File[] files;
            ServerPlayer player = (ServerPlayer)context.player();
            ServerLevel level = player.serverLevel();
            File blueprintFile = null;
            File[] fileArray = packet.isServerBlueprint() ? Blueprint.getServerBlueprintFile(level).listFiles() : (files = packet.isWornBlueprint() ? Blueprint.getWornBlueprintFile(level).listFiles() : Blueprint.getFileForBlueprints(level, packet.ownerBlueprint()).listFiles());
            if (files == null) {
                return;
            }
            for (File f : files) {
                if (!f.getName().equals(packet.nomeBlueprintRichiesto() + ".bp")) continue;
                blueprintFile = f;
                break;
            }
            if (blueprintFile != null) {
                List<String> pacchetti;
                Blueprint.BlueprintDatas bd;
                try {
                    bd = (Blueprint.BlueprintDatas)GSON.fromJson((Reader)new FileReader(blueprintFile), Blueprint.BlueprintDatas.class);
                }
                catch (FileNotFoundException e) {
                    return;
                }
                if (bd == null) {
                    return;
                }
                try {
                    String content = Files.readString(blueprintFile.toPath());
                    if (content.isEmpty()) {
                        return;
                    }
                    pacchetti = Operazioni.splitStringByLength(content, 30000);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (pacchetti == null) {
                    return;
                }
                List<String> finalPacchetti = pacchetti;
                int id = packet.idRichiestaBlueprint();
                new Thread(() -> {
                    try {
                        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StoC_VisualizeBlueprintData(id, "[DATI INIZIALI]<bsize>" + finalPacchetti.size() + "</bsize>"), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        int count = 0;
                        for (String p : finalPacchetti) {
                            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StoC_VisualizeBlueprintData(id, p), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            if (++count % 4 != 0) continue;
                            Thread.sleep(1L);
                        }
                        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StoC_VisualizeBlueprintData(id, "[DATI FINITI]"), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }).start();
            }
        });
    }

    public static void send(int IDRichiestaBlueprint, String nomeBlueprintRichiesto, UUID owner_blueprint) {
        PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_VisualizeBlueprintData(IDRichiestaBlueprint, nomeBlueprintRichiesto, owner_blueprint, false, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void send(int IDRichiestaBlueprint, String nomeBlueprintRichiesto, boolean isServerBlueprint) {
        PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_VisualizeBlueprintData(IDRichiestaBlueprint, nomeBlueprintRichiesto, UUID.randomUUID(), isServerBlueprint, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void send(int IDRichiestaBlueprint, String nomeBlueprintRichiesto, boolean isServerBlueprint, boolean isWornBlueprint) {
        PacketDistributor.sendToServer((CustomPacketPayload)new CtoS_VisualizeBlueprintData(IDRichiestaBlueprint, nomeBlueprintRichiesto, UUID.randomUUID(), false, isWornBlueprint), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

