/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.portable_blueprints;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import nimble.portable_blueprints.portable_blueprints.Mod;
import nimble.portable_blueprints.robautile.Operazioni;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class OldVersionUtilities {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Optional.class, (src, typeOfSrc, context) -> src.isPresent() ? context.serialize(src.get()) : JsonNull.INSTANCE).create();

    public static CompoundTag getItemStackNBT(ItemStack stack) {
        if (stack == null || stack.isEmpty() || stack.get(DataComponents.CUSTOM_DATA) == null) {
            return new CompoundTag();
        }
        return ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
    }

    public static void impostaItemStackNBT(ItemStack stack, CompoundTag nbt) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
    }

    public static PoseStack getEventPosestack() {
        PoseStack p = new PoseStack();
        Quaternionf rotation = new Quaternionf((Quaternionfc)Minecraft.getInstance().gameRenderer.getMainCamera().rotation());
        p.mulPose(rotation.invert());
        return p;
    }

    public static ItemContainerContents getItemInventoryData(ItemStack stack) {
        if (stack == null || stack.isEmpty() || stack.get(DataComponents.CONTAINER) == null) {
            return null;
        }
        return (ItemContainerContents)stack.get(DataComponents.CONTAINER);
    }

    public static void impostaItemInventoryData(ItemStack stack, ItemContainerContents icc) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        stack.set(DataComponents.CONTAINER, (Object)icc);
    }

    public static String getAllComponentasAndNBTInJson(BlockEntity blockEntity) {
        Object nbt = "";
        try {
            DataComponentMap map = blockEntity.collectComponents();
            JsonObject obj = new JsonObject();
            for (DataComponentType entry : map.keySet()) {
                try {
                    obj.addProperty(entry.toString(), Objects.requireNonNull(map.get(entry)).toString());
                }
                catch (Exception exception) {}
            }
            String json = obj.toString();
            if (json != null && !json.isEmpty() && !json.equals("null")) {
                nbt = "<components>" + json + "</components>";
            }
            if (blockEntity.getLevel() != null) {
                nbt = (String)nbt + "<nbt>" + String.valueOf(blockEntity.getUpdateTag((HolderLookup.Provider)blockEntity.getLevel().registryAccess())) + "</nbt>";
            }
        }
        catch (Exception e) {
            Mod.LOGGER.error("[Portable Blueprint] error extracting block entity nbt");
        }
        return nbt;
    }

    public static Tuple<DataComponentMap, CompoundTag> convertJsonToDataComponentMapAndNBT(String json) {
        DataComponentMap map = DataComponentMap.EMPTY;
        CompoundTag nbt = new CompoundTag();
        try {
            if (json.contains("<components>")) {
                map = (DataComponentMap)GSON.fromJson(Operazioni.getValueInsideTag(json, "components"), DataComponentMap.class);
            }
        }
        catch (Exception e) {
            Mod.LOGGER.error("[Portable Blueprint] error load block entity nbt id:1");
            System.out.println("DataComponentMap ERROR!");
        }
        try {
            if (json.contains("<nbt>") && TagParser.parseTag((String)Operazioni.getValueInsideTag(json, "nbt")) != null) {
                nbt = TagParser.parseTag((String)Operazioni.getValueInsideTag(json, "nbt"));
            }
        }
        catch (Exception e) {
            Mod.LOGGER.error("[Portable Blueprint] error load block entity nbt id:2");
            System.out.println("NBT ERROR!");
        }
        return new Tuple((Object)map, (Object)nbt);
    }
}

