/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.robautile;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import nimble.portable_blueprints.portable_blueprints.OldVersionUtilities;

public class ModifiableItemInventory {
    private final ItemStack source;
    private final Container container;
    private final boolean isVanillaShulker;
    private final ServerLevel serverLevel;

    private ModifiableItemInventory(ServerLevel serverLevel, ItemStack source, Container container, boolean isVanillaShulker) {
        this.source = source;
        this.container = container;
        this.isVanillaShulker = isVanillaShulker;
        this.serverLevel = serverLevel;
    }

    public static Optional<ModifiableItemInventory> of(ServerLevel serverLevel, ItemStack stack) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        Optional<IItemHandler> opt = Optional.ofNullable((IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM));
        ItemContainerContents itemContainerContents = OldVersionUtilities.getItemInventoryData(stack);
        if (itemContainerContents == null && opt.isPresent() && opt != null && opt.get().getSlots() > 0) {
            SimpleContainer container = new SimpleContainer(opt.get().getSlots());
            for (int i = 0; i < opt.get().getSlots(); ++i) {
                container.setItem(i, opt.get().getStackInSlot(i));
            }
            return Optional.of(new ModifiableItemInventory(serverLevel, stack, (Container)container, false));
        }
        if (itemContainerContents != null) {
            int size = itemContainerContents.stream().toArray().length;
            NonNullList[] items = new NonNullList[]{NonNullList.withSize((int)size, (Object)ItemStack.EMPTY)};
            int[] x = new int[]{0};
            itemContainerContents.stream().forEach(itemStack -> {
                items[0].set(x[0], itemStack);
                x[0] = x[0] + 1;
            });
            SimpleContainer container = new SimpleContainer(size);
            for (int i = 0; i < items[0].size(); ++i) {
                container.setItem(i, (ItemStack)items[0].get(i));
            }
            return Optional.of(new ModifiableItemInventory(serverLevel, stack, (Container)container, true));
        }
        return Optional.empty();
    }

    public Container getContainer() {
        return this.container;
    }

    public void save() {
        if (this.isVanillaShulker) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            for (int x = 0; x < this.container.getContainerSize(); ++x) {
                itemStacks.add(this.container.getItem(x));
            }
            OldVersionUtilities.impostaItemInventoryData(this.source, ItemContainerContents.fromItems(itemStacks));
        } else {
            IItemHandler opt = (IItemHandler)this.source.getCapability(Capabilities.ItemHandler.ITEM);
            if (opt instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable iItemHandlerModifiable = (IItemHandlerModifiable)opt;
                for (int i = 0; i < iItemHandlerModifiable.getSlots(); ++i) {
                    iItemHandlerModifiable.setStackInSlot(i, this.container.getItem(i));
                }
            }
        }
    }

    @Nullable
    public static BlockEntityType<?> getBlockEntityType(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return null;
        }
        BlockItem blockItem = (BlockItem)item;
        for (BlockEntityType type : BuiltInRegistries.BLOCK_ENTITY_TYPE) {
            if (!type.isValid(blockItem.getBlock().defaultBlockState())) continue;
            return type;
        }
        return null;
    }

    private NonNullList<ItemStack> containerItems() {
        NonNullList items = NonNullList.withSize((int)this.container.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            items.set(i, (Object)this.container.getItem(i));
        }
        return items;
    }
}

