/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.robautile;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import nimble.portable_blueprints.portable_blueprints.Mod;

public class Operazioni {
    public static double getRandomBetween(double min, double max) {
        Random random = new Random();
        return random.nextDouble() * (max - min) + min;
    }

    public static int getRandomBetween(int min, int max) {
        Random random = new Random();
        return random.nextInt(max - min + 1) + min;
    }

    public static double lerp(double start, double end, double t) {
        return start + t * (end - start);
    }

    public static float lerp(float start, float end, float t) {
        return start + t * (end - start);
    }

    public static double getDistanceToGround(Level level, Entity entity, double distanzaMax) {
        Vec3 endPosition;
        Vec3 startPosition = entity.position();
        BlockHitResult result = level.clip(new ClipContext(startPosition, endPosition = startPosition.subtract(0.0, distanzaMax, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        if (result.getType() == HitResult.Type.BLOCK) {
            return result.getLocation().distanceTo(startPosition);
        }
        return Double.MAX_VALUE;
    }

    public static int lerpColor(int colorStart, int colorEnd, float t) {
        t = Math.max(0.0f, Math.min(1.0f, t));
        int a1 = colorStart >> 24 & 0xFF;
        int r1 = colorStart >> 16 & 0xFF;
        int g1 = colorStart >> 8 & 0xFF;
        int b1 = colorStart & 0xFF;
        int a2 = colorEnd >> 24 & 0xFF;
        int r2 = colorEnd >> 16 & 0xFF;
        int g2 = colorEnd >> 8 & 0xFF;
        int b2 = colorEnd & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * t);
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static Vec3 getColorFromHex(int hex) {
        int r = hex >> 16 & 0xFF;
        int g = hex >> 8 & 0xFF;
        int b = hex & 0xFF;
        return new Vec3((double)((float)r / 255.0f), (double)((float)g / 255.0f), (double)((float)b / 255.0f));
    }

    public static float calculateDistance(Vec2 point1, Vec2 point2) {
        float dx = point2.x - point1.x;
        float dy = point2.y - point1.y;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public static ItemStack getItemStackFromId(String itemId) {
        Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemId));
        if (item != null) {
            return new ItemStack((ItemLike)item);
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getCorrectItemStackFromId(Block blocco) {
        Item item = Item.byBlock((Block)blocco);
        if (item == Items.AIR) {
            item = blocco.asItem();
        }
        if (item == Items.AIR) {
            if (blocco.equals(Blocks.WALL_TORCH)) {
                item = Items.TORCH;
            } else if (blocco.equals(Blocks.REDSTONE_WALL_TORCH)) {
                item = Items.REDSTONE_TORCH;
            } else if (blocco.equals(Blocks.WATER) || blocco.equals(Blocks.BUBBLE_COLUMN)) {
                item = Items.WATER_BUCKET;
            } else if (blocco.equals(Blocks.LAVA)) {
                item = Items.LAVA_BUCKET;
            }
        }
        return new ItemStack((ItemLike)item);
    }

    public static String getValueInsideTag(String input, String Tag2) {
        try {
            int start = input.indexOf("<" + Tag2 + ">") + Tag2.length() + 2;
            int end = input.indexOf("</" + Tag2 + ">");
            if (start != -1 && end != -1 && start < end) {
                return input.substring(start, end);
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static int addItemToInventory(Inventory pInventory, ItemStack stack, int quantity) {
        int quantitaRimasta;
        ItemStack stackNuovo;
        for (quantitaRimasta = quantity; pInventory.getFreeSlot() != -1 && quantitaRimasta > 0; quantitaRimasta -= stackNuovo.getCount()) {
            stackNuovo = stack.copy();
            stackNuovo.setCount(quantitaRimasta >= 64 ? 64 : quantitaRimasta);
            pInventory.add(stackNuovo);
        }
        for (int slot = 0; slot < pInventory.getContainerSize() && quantitaRimasta > 0; ++slot) {
            ItemStack stackSlot = pInventory.getItem(slot);
            if (!ItemStack.isSameItem((ItemStack)stackSlot, (ItemStack)stack)) continue;
            int quantitaChePuoMettere = 64 - stackSlot.getCount();
            if (quantitaChePuoMettere > quantitaRimasta) {
                quantitaChePuoMettere = quantitaRimasta;
            }
            stackSlot.setCount(stackSlot.getCount() + quantitaChePuoMettere);
            quantitaRimasta -= quantitaChePuoMettere;
        }
        return quantitaRimasta;
    }

    public static void dropItem(Level level, Vec3 pos, ItemStack stack) {
        if (!level.isClientSide && !stack.isEmpty()) {
            level.addFreshEntity((Entity)new ItemEntity(level, pos.x + 0.5, pos.y + 0.5, pos.z + 0.5, stack));
        }
    }

    public static BlockPos SommaBlockPos(BlockPos blockPos, BlockPos offsetBloccoSecondario) {
        int x = blockPos.getX() + offsetBloccoSecondario.getX();
        int y = blockPos.getY() + offsetBloccoSecondario.getY();
        int z = blockPos.getZ() + offsetBloccoSecondario.getZ();
        return new BlockPos(x, y, z);
    }

    public static int getEuclideaBlockDistance(BlockPos pos1, BlockPos pos2) {
        return (int)Math.round(Math.sqrt(pos1.distSqr((Vec3i)pos2)));
    }

    public static int getManhattanBlockDistance(BlockPos pos1, BlockPos pos2) {
        return Math.abs(pos1.getX() - pos2.getX()) + Math.abs(pos1.getY() - pos2.getY()) + Math.abs(pos1.getZ() - pos2.getZ());
    }

    public static void glowingItemStack(ItemStack item, boolean effectOn) {
        item.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)effectOn);
    }

    public static void saveVec3iToNBTIntArray(String nome, Vec3i vec, CompoundTag nbt) {
        if (vec != null && nbt != null) {
            nbt.putIntArray(nome + "_Vec3i", new int[]{vec.getX(), vec.getY(), vec.getZ()});
        }
    }

    public static Vec3i getVec3iByNBTIntArray(String nome, CompoundTag nbt) {
        if (nbt != null && nbt.contains(nome + "_Vec3i")) {
            int[] valori = nbt.getIntArray(nome + "_Vec3i");
            return new Vec3i(valori[0], valori[1], valori[2]);
        }
        return null;
    }

    public static Direction getDirectionBetween(Vec3 vec1, Vec3 vec2) {
        double dx = vec2.x - vec1.x;
        double dy = vec2.y - vec1.y;
        double dz = vec2.z - vec1.z;
        if (Math.abs(dx) > Math.abs(dy) && Math.abs(dx) > Math.abs(dz)) {
            return dx > 0.0 ? Direction.EAST : Direction.WEST;
        }
        if (Math.abs(dy) > Math.abs(dx) && Math.abs(dy) > Math.abs(dz)) {
            return dy > 0.0 ? Direction.UP : Direction.DOWN;
        }
        return dz > 0.0 ? Direction.SOUTH : Direction.NORTH;
    }

    public static String getVec3iString(Vec3i v) {
        return "x=" + v.getX() + ",y=" + v.getY() + ",z=" + v.getZ();
    }

    public static String getVec3String(Vec3 v) {
        return "x=" + v.x() + ",y=" + v.y() + ",z=" + v.z();
    }

    public static Vec3i getVec3iFromString(String v) {
        if (v.isEmpty()) {
            return Vec3i.ZERO;
        }
        v = v.replaceAll("=", "").replaceAll("x", "").replaceAll("y", "").replaceAll("z", "");
        String[] p = v.split(",");
        return new Vec3i(Integer.parseInt(p[0]), Integer.parseInt(p[1]), Integer.parseInt(p[2]));
    }

    public static Vec3 getVec3FromString(String v) {
        if (v.isEmpty()) {
            return Vec3.ZERO;
        }
        v = v.replaceAll("=", "").replaceAll("x", "").replaceAll("y", "").replaceAll("z", "");
        String[] p = v.split(",");
        return new Vec3(Double.parseDouble(p[0]), Double.parseDouble(p[1]), Double.parseDouble(p[2]));
    }

    public static String getBlockStateString(BlockState state) {
        Block block = state.getBlock();
        String id = BuiltInRegistries.BLOCK.getKey((Object)block).toString();
        String nbtString = "null";
        if (state.getProperties().size() > 0) {
            nbtString = Operazioni.ConvertPropertiesToString(state);
        }
        return "<bid>" + id + "</bid>" + nbtString;
    }

    public static String ConvertPropertiesToString(BlockState state) {
        Object compilation = "<properties>";
        for (Property p : state.getProperties()) {
            compilation = (String)compilation + "<propertie><name>" + p.getName() + "</name><value>" + String.valueOf(state.getValue(p)) + "</value><classe>" + p.getValueClass().toString().replace("class ", "") + "</classe></propertie>;!v!;";
        }
        compilation = (String)compilation + "</properties>";
        return compilation;
    }

    public static Block getBlockFromString(String v) {
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)v));
    }

    public static BlockState getPropertiesStringToBlock(Block blocco, String proprieta) {
        BlockState state = blocco.defaultBlockState();
        HashMap<String, Tuple> data = new HashMap<String, Tuple>();
        proprieta = proprieta.replace("<properties>", "").replace("</properties>", "");
        for (String v : proprieta.split(";!v!;")) {
            if (v.equals("")) continue;
            data.put(v.substring(v.indexOf("<name>") + 6, v.indexOf("</name>")), new Tuple((Object)v.substring(v.indexOf("<value>") + 7, v.indexOf("</value>")), (Object)v.substring(v.indexOf("<classe>") + 8, v.indexOf("</classe>"))));
        }
        for (Property p : state.getProperties()) {
            if (!data.containsKey(p.getName())) continue;
            state = Operazioni.setDynamicProperty(state, p, (String)((Tuple)data.get(p.getName())).getA());
        }
        return state;
    }

    public static <T extends Comparable<T>> BlockState setDynamicProperty(BlockState state, Property<T> property, String value) {
        try {
            Object parsedValue;
            Class valueClass = property.getValueClass();
            if (valueClass.isEnum()) {
                parsedValue = Enum.valueOf(valueClass.asSubclass(Enum.class), value.toUpperCase());
            } else if (valueClass == Boolean.class) {
                parsedValue = Boolean.valueOf(value.toLowerCase());
            } else if (valueClass == Integer.class) {
                parsedValue = Integer.valueOf(value);
            } else {
                Mod.LOGGER.warn("[Portable blueprint] Unsupported property type: " + valueClass.getName());
                return state;
            }
            return (BlockState)state.setValue(property, (Comparable)parsedValue);
        }
        catch (Exception e) {
            Mod.LOGGER.error("[Portable blueprint] Failed to set property '" + property.getName() + "' to value '" + value + "'", (Throwable)e);
            return state;
        }
    }

    public static Direction rotateFacing(Direction currentFacing, int rotations) {
        if (currentFacing.equals((Object)Direction.DOWN) || currentFacing.equals((Object)Direction.UP)) {
            return currentFacing;
        }
        Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        int currentIndex = 0;
        for (int i = 0; i < directions.length; ++i) {
            if (directions[i] != currentFacing) continue;
            currentIndex = i;
            break;
        }
        int newIndex = (currentIndex + rotations) % directions.length;
        return directions[newIndex];
    }

    public static Vec3 lerp(Vec3 start, Vec3 end, double t) {
        double x = start.x + (end.x - start.x) * t;
        double y = start.y + (end.y - start.y) * t;
        double z = start.z + (end.z - start.z) * t;
        return new Vec3(x, y, z);
    }

    public Item getItemFromId(String id) {
        ResourceLocation itemId = ResourceLocation.parse((String)id);
        Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
        return item;
    }

    public static BufferedImage getPlayerFace(UUID uuid) {
        try {
            String url = "https://minotar.net/helm/" + String.valueOf(uuid) + "/8";
            InputStream inputStream = new URL(url).openStream();
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getPlayerNameFromUUID(UUID uuid) {
        try {
            String line;
            URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString().replaceAll("-", ""));
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setConnectTimeout(500);
            con.setReadTimeout(500);
            int status = con.getResponseCode();
            if (status != 200) {
                return null;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder content = new StringBuilder();
            while ((line = in.readLine()) != null) {
                content.append(line);
            }
            in.close();
            JsonObject obj = JsonParser.parseString((String)content.toString()).getAsJsonObject();
            return obj.get("name").getAsString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static List<String> splitStringByLength(String input, int chunkSize) {
        ArrayList<String> result = new ArrayList<String>();
        int length = input.length();
        for (int i = 0; i < length; i += chunkSize) {
            result.add(input.substring(i, Math.min(length, i + chunkSize)));
        }
        return result;
    }
}

