/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.robautile;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RenderingGraphics {
    private static final RenderType TEXTURE_BORDER = RenderType.create((String)"texture_border_no_light", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionTexColorShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"portable_blueprints", (String)"textures/others/border.png"), false, false)).setTransparencyState(new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }, () -> RenderSystem.disableBlend())).setDepthTestState(new RenderStateShard.DepthTestStateShard("lequal", 515)).setCullState(new RenderStateShard.CullStateShard(false)).setWriteMaskState(new RenderStateShard.WriteMaskStateShard(true, false)).setLightmapState(new RenderStateShard.LightmapStateShard(false)).createCompositeState(false));

    public static void addLineWidthToBufferBuilder(BufferBuilder buffer, Vector3f start, float lunghezza, float size, Direction direction, Vec3 color, float alpha) {
        float meta = size / 2.0f;
        if (direction.equals((Object)Direction.UP) || direction.equals((Object)Direction.DOWN)) {
            float yAdd = direction.equals((Object)Direction.UP) ? lunghezza : -lunghezza;
            buffer.addVertex(start.x + meta, start.y, start.z + meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta, start.y, start.z - meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta, start.y + yAdd, start.z - meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta, start.y + yAdd, start.z + meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta, start.y, start.z - meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta, start.y, start.z + meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta, start.y + yAdd, start.z + meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta, start.y + yAdd, start.z - meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta, start.y, start.z + meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta, start.y, start.z + meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta, start.y + yAdd, start.z + meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta, start.y + yAdd, start.z + meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta, start.y, start.z - meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta, start.y, start.z - meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta, start.y + yAdd, start.z - meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta, start.y + yAdd, start.z - meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta, start.y, start.z - meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta, start.y, start.z - meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta, start.y, start.z + meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta, start.y, start.z + meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta, start.y + yAdd, start.z - meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta, start.y + yAdd, start.z + meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta, start.y + yAdd, start.z + meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta, start.y + yAdd, start.z - meta).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
        } else if (direction.equals((Object)Direction.NORTH) || direction.equals((Object)Direction.SOUTH)) {
            float xAdd;
            float f = direction.equals((Object)Direction.NORTH) ? meta : (xAdd = direction.equals((Object)Direction.SOUTH) ? -meta : 0.0f);
            float zAdd = direction.equals((Object)Direction.NORTH) ? -lunghezza : (direction.equals((Object)Direction.SOUTH) ? lunghezza : 0.0f);
            int molt = direction.equals((Object)Direction.NORTH) ? 1 : -1;
            buffer.addVertex(start.x - xAdd, start.y + meta, start.z).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + xAdd, start.y + meta, start.z).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + xAdd, start.y + meta, start.z + zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - xAdd, start.y + meta, start.z + zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + xAdd, start.y - meta, start.z).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - xAdd, start.y - meta, start.z).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - xAdd, start.y - meta, start.z + zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + xAdd, start.y - meta, start.z + zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta * (float)molt, start.y + meta, start.z).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta * (float)molt, start.y - meta, start.z).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta * (float)molt, start.y - meta, start.z + zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta * (float)molt, start.y + meta, start.z + zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta * (float)molt, start.y - meta, start.z).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta * (float)molt, start.y + meta, start.z).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta * (float)molt, start.y + meta, start.z + zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta * (float)molt, start.y - meta, start.z + zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta * (float)molt, start.y - meta, start.z).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta * (float)molt, start.y - meta, start.z).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta * (float)molt, start.y + meta, start.z).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta * (float)molt, start.y + meta, start.z).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta * (float)molt, start.y - meta, start.z + zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta * (float)molt, start.y - meta, start.z + zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x - meta * (float)molt, start.y + meta, start.z + zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + meta * (float)molt, start.y + meta, start.z + zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
        } else {
            float zAdd;
            float f = direction.equals((Object)Direction.EAST) ? meta : (zAdd = direction.equals((Object)Direction.WEST) ? -meta : 0.0f);
            float xAdd = direction.equals((Object)Direction.EAST) ? lunghezza : (direction.equals((Object)Direction.WEST) ? -lunghezza : 0.0f);
            int molt = direction.equals((Object)Direction.EAST) ? 1 : -1;
            buffer.addVertex(start.x, start.y + meta, start.z - zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x, start.y + meta, start.z + zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + xAdd, start.y + meta, start.z + zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + xAdd, start.y + meta, start.z - zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x, start.y - meta, start.z + zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x, start.y - meta, start.z - zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + xAdd, start.y - meta, start.z - zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + xAdd, start.y - meta, start.z + zAdd).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x, start.y + meta, start.z + meta * (float)molt).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x, start.y - meta, start.z + meta * (float)molt).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + xAdd, start.y - meta, start.z + meta * (float)molt).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + xAdd, start.y + meta, start.z + meta * (float)molt).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x, start.y - meta, start.z - meta * (float)molt).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x, start.y + meta, start.z - meta * (float)molt).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + xAdd, start.y + meta, start.z - meta * (float)molt).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + xAdd, start.y - meta, start.z - meta * (float)molt).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x, start.y - meta, start.z - meta * (float)molt).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x, start.y - meta, start.z + meta * (float)molt).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x, start.y + meta, start.z + meta * (float)molt).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x, start.y + meta, start.z - meta * (float)molt).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + xAdd, start.y - meta, start.z + meta * (float)molt).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + xAdd, start.y - meta, start.z - meta * (float)molt).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + xAdd, start.y + meta, start.z - meta * (float)molt).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
            buffer.addVertex(start.x + xAdd, start.y + meta, start.z + meta * (float)molt).setColor((float)color.x, (float)color.y, (float)color.z, alpha);
        }
    }

    public static void renderBorderBox(PoseStack poseStack, Matrix4f matrix4f, Vec3 angolo1, Vec3 angolo2, Vec3 colore, float alpha, boolean hasTexture) {
        RenderSystem.enableDepthTest();
        Vec3 view = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        VertexBuffer vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        float size = 0.1f;
        double y_minore = angolo1.y > angolo2.y ? angolo2.y : angolo1.y;
        double y_maggiore = angolo1.y < angolo2.y ? angolo2.y : angolo1.y;
        double x_minore = angolo1.x > angolo2.x ? angolo2.x : angolo1.x;
        double x_maggiore = angolo1.x < angolo2.x ? angolo2.x : angolo1.x;
        double z_minore = angolo1.z > angolo2.z ? angolo2.z : angolo1.z;
        double z_maggiore = angolo1.z < angolo2.z ? angolo2.z : angolo1.z;
        Vec3 vMinore = new Vec3(x_minore, y_minore, z_minore);
        Vec3 vMaggiore = new Vec3(x_maggiore, y_maggiore, z_maggiore);
        for (int x = 0; x < 2; ++x) {
            float y = (float)(x == 0 ? vMinore.y : vMaggiore.y + 1.0);
            RenderingGraphics.addLineWidthToBufferBuilder(buffer, new Vec3(vMaggiore.x + 1.0, (double)y, vMinore.z).toVector3f(), (float)(vMaggiore.x - vMinore.x + 1.0), size, Direction.WEST, colore, alpha);
            RenderingGraphics.addLineWidthToBufferBuilder(buffer, new Vec3(vMinore.x, (double)y, vMinore.z).toVector3f(), (float)(Math.abs(vMaggiore.z - vMinore.z) + 1.0), size, Direction.SOUTH, colore, alpha);
            RenderingGraphics.addLineWidthToBufferBuilder(buffer, new Vec3(vMinore.x, (double)y, vMaggiore.z + 1.0).toVector3f(), (float)(Math.abs(vMaggiore.x - vMinore.x) + 1.0), size, Direction.EAST, colore, alpha);
            RenderingGraphics.addLineWidthToBufferBuilder(buffer, new Vec3(vMaggiore.x + 1.0, (double)y, vMaggiore.z + 1.0).toVector3f(), (float)(Math.abs(vMaggiore.z - vMinore.z) + 1.0), size, Direction.NORTH, colore, alpha);
        }
        RenderingGraphics.addLineWidthToBufferBuilder(buffer, new Vec3(vMaggiore.x + 1.0, vMinore.y - (double)0.05f, vMinore.z).toVector3f(), (float)(vMaggiore.y - vMinore.y + (double)1.1f), size, Direction.UP, colore, alpha);
        RenderingGraphics.addLineWidthToBufferBuilder(buffer, new Vec3(vMinore.x, vMinore.y - (double)0.05f, vMinore.z).toVector3f(), (float)(vMaggiore.y - vMinore.y + (double)1.1f), size, Direction.UP, colore, alpha);
        RenderingGraphics.addLineWidthToBufferBuilder(buffer, new Vec3(vMinore.x, vMinore.y - (double)0.05f, vMaggiore.z + 1.0).toVector3f(), (float)(vMaggiore.y - vMinore.y + (double)1.1f), size, Direction.UP, colore, alpha);
        RenderingGraphics.addLineWidthToBufferBuilder(buffer, new Vec3(vMaggiore.x + 1.0, vMinore.y - (double)0.05f, vMaggiore.z + 1.0).toVector3f(), (float)(vMaggiore.y - vMinore.y + (double)1.1f), size, Direction.UP, colore, alpha);
        vertexBuffer.bind();
        vertexBuffer.upload(buffer.build());
        poseStack.pushPose();
        Quaternionf rotation = new Quaternionf((Quaternionfc)Minecraft.getInstance().gameRenderer.getMainCamera().rotation());
        poseStack.mulPose(rotation.invert());
        poseStack.translate(-view.x, -view.y, -view.z);
        ShaderInstance shader = GameRenderer.getPositionColorShader();
        vertexBuffer.drawWithShader(poseStack.last().pose(), matrix4f, shader);
        poseStack.popPose();
        VertexBuffer.unbind();
        if (hasTexture) {
            poseStack.pushPose();
            poseStack.translate(-view.x, -view.y, -view.z);
            RenderingGraphics.renderBorderTexturedFaces(poseStack, angolo1, angolo2, colore, alpha);
            poseStack.popPose();
        }
    }

    public static void renderBorderTexturedFaces(PoseStack poseStack, Vec3 angolo1, Vec3 angolo2, Vec3 colore, float alpha) {
        long time = System.currentTimeMillis();
        float period = 5000.0f;
        float scroll = (float)(time % (long)period) / period;
        double xMin = Math.min(angolo1.x, angolo2.x) - (double)0.001f;
        double xMax = Math.max(angolo1.x, angolo2.x) + 1.0 + (double)0.001f;
        double yMin = Math.min(angolo1.y, angolo2.y) - (double)0.001f;
        double yMax = Math.max(angolo1.y, angolo2.y) + 1.0 + (double)0.001f;
        double zMin = Math.min(angolo1.z, angolo2.z) - (double)0.001f;
        double zMax = Math.max(angolo1.z, angolo2.z) + 1.0 + (double)0.001f;
        float width = (float)(xMax - xMin);
        float height = (float)(yMax - yMin);
        float depth = (float)(zMax - zMin);
        int r = (int)(colore.x * 255.0);
        int g = (int)(colore.y * 255.0);
        int b = (int)(colore.z * 255.0);
        int a = (int)(alpha * 200.0f);
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(TEXTURE_BORDER);
        Matrix4f matrix4f = poseStack.last().pose();
        float uMaxN = width;
        float vMaxN = height;
        vertexConsumer.addVertex(matrix4f, (float)xMin, (float)yMin, (float)zMin).setColor(r, g, b, a).setUv(0.0f + scroll, 0.0f - scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, (float)xMax, (float)yMin, (float)zMin).setColor(r, g, b, a).setUv(uMaxN + scroll, 0.0f - scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, (float)xMax, (float)yMax, (float)zMin).setColor(r, g, b, a).setUv(uMaxN + scroll, vMaxN - scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, (float)xMin, (float)yMax, (float)zMin).setColor(r, g, b, a).setUv(0.0f + scroll, vMaxN - scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        float uMaxS = width;
        float vMaxS = height;
        vertexConsumer.addVertex(matrix4f, (float)xMax, (float)yMin, (float)zMax).setColor(r, g, b, a).setUv(0.0f - scroll, vMaxS + scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, (float)xMin, (float)yMin, (float)zMax).setColor(r, g, b, a).setUv(uMaxS - scroll, vMaxS + scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, (float)xMin, (float)yMax, (float)zMax).setColor(r, g, b, a).setUv(uMaxS - scroll, 0.0f + scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, (float)xMax, (float)yMax, (float)zMax).setColor(r, g, b, a).setUv(0.0f - scroll, 0.0f + scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        float uMaxW = depth;
        float vMaxW = height;
        vertexConsumer.addVertex(matrix4f, (float)xMin, (float)yMin, (float)zMax).setColor(r, g, b, a).setUv(0.0f + scroll, 0.0f - scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, (float)xMin, (float)yMin, (float)zMin).setColor(r, g, b, a).setUv(uMaxW + scroll, 0.0f - scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, (float)xMin, (float)yMax, (float)zMin).setColor(r, g, b, a).setUv(uMaxW + scroll, vMaxW - scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, (float)xMin, (float)yMax, (float)zMax).setColor(r, g, b, a).setUv(0.0f + scroll, vMaxW - scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        float uMaxE = depth;
        float vMaxE = height;
        vertexConsumer.addVertex(matrix4f, (float)xMax, (float)yMin, (float)zMin).setColor(r, g, b, a).setUv(uMaxE + scroll, 0.0f - scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, (float)xMax, (float)yMin, (float)zMax).setColor(r, g, b, a).setUv(0.0f + scroll, 0.0f - scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, (float)xMax, (float)yMax, (float)zMax).setColor(r, g, b, a).setUv(0.0f + scroll, vMaxE - scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, (float)xMax, (float)yMax, (float)zMin).setColor(r, g, b, a).setUv(uMaxE + scroll, vMaxE - scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        float uMaxU = width;
        float vMaxU = depth;
        vertexConsumer.addVertex(matrix4f, (float)xMin, (float)yMax, (float)zMin).setColor(r, g, b, a).setUv(0.0f + scroll, 0.0f - scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, (float)xMax, (float)yMax, (float)zMin).setColor(r, g, b, a).setUv(uMaxU + scroll, 0.0f - scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, (float)xMax, (float)yMax, (float)zMax).setColor(r, g, b, a).setUv(uMaxU + scroll, vMaxU - scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, (float)xMin, (float)yMax, (float)zMax).setColor(r, g, b, a).setUv(0.0f + scroll, vMaxU - scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        float uMaxD = width;
        float vMaxD = depth;
        vertexConsumer.addVertex(matrix4f, (float)xMin, (float)yMin, (float)zMax).setColor(r, g, b, a).setUv(uMaxD - scroll, 0.0f + scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, (float)xMax, (float)yMin, (float)zMax).setColor(r, g, b, a).setUv(0.0f - scroll, 0.0f + scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, (float)xMax, (float)yMin, (float)zMin).setColor(r, g, b, a).setUv(0.0f - scroll, vMaxD + scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(matrix4f, (float)xMin, (float)yMin, (float)zMin).setColor(r, g, b, a).setUv(uMaxD - scroll, vMaxD + scroll).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 0.0f, 0.0f);
        bufferSource.endBatch(TEXTURE_BORDER);
    }
}

