/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.Events;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nimble.portable_blueprints.Events.BlueprintEvent;
import nimble.portable_blueprints.Events.ChangeShapeScanningAreaEvent;
import nimble.portable_blueprints.Events.RenderBlueprintsPreview;
import nimble.portable_blueprints.Events.RenderScannerAnimation;
import nimble.portable_blueprints.client.BlueprintsPreviewMethods;
import nimble.portable_blueprints.client.ClientMethods;
import nimble.portable_blueprints.init.ModItems;
import nimble.portable_blueprints.items.Scanner;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.ServerBlueprints.CtoS_ServerBlueprintsData;
import nimble.portable_blueprints.network.ottieni_shared_blueprint_data.CtoS_SharedBlueprintData;
import nimble.portable_blueprints.network.request_specific_data.CtoS_RequestSpecificData;
import nimble.portable_blueprints.network.save_global_blueprint.StoC_SaveGlobalBlueprint;
import nimble.portable_blueprints.portable_blueprints.ModConfig;
import nimble.portable_blueprints.robautile.Operazioni;
import nimble.portable_blueprints.robautile.RenderingGraphics;
import nimble.portable_blueprints.robautile.RenderingMethods;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="portable_blueprints", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ModEventClientForge {
    public static List<AnimazionePosizionamentoBlocco> AnimPosBlocks = new ArrayList<AnimazionePosizionamentoBlocco>();
    public static List<Tuple<BlockState, Vec3>> datiBlocchi = new ArrayList<Tuple<BlockState, Vec3>>();
    public static BlockPos offsetVisualizeBlueprint = BlockPos.f_121853_;
    public static BlockPos ultimaLXAltezzaLZSalvata = BlockPos.f_121853_;
    public static Vec3 posPrima = Vec3.f_82478_;
    public static Vec3 posNonFinita = Vec3.f_82478_;
    public static Vec3 posTarget = Vec3.f_82478_;
    public static Long inizioAnim = System.currentTimeMillis();
    public static Direction DirezioneHitboxSelected = null;
    private static boolean hasJoinedWorld = false;

    @SubscribeEvent
    public static void renderLevelStageEvent(RenderLevelStageEvent event) {
        event.getPoseStack().m_85836_();
        if (BlueprintsPreviewMethods.BlueprintPreviewData.AllUsedStage.contains(event.getStage())) {
            ModEventClientForge.renderAnimazionePosizionamentoBlocco(event);
        }
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES)) {
            CompoundTag nbt;
            ModEventClientForge.renderHoloScannerSelectionBox(event);
            ItemStack item = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND);
            if (ModItems.getBlueprintItems().contains(item.m_41720_()) && (nbt = item.m_41784_()).m_128441_("inventari_blocco_selezionati")) {
                for (String pos : nbt.m_128461_("inventari_blocco_selezionati").split("!;!")) {
                    if (pos.equals("")) continue;
                    Vec3i v_ = Operazioni.getVec3iFromString(pos);
                    Vec3 v = new Vec3((double)v_.m_123341_(), (double)v_.m_123342_(), (double)v_.m_123343_());
                    RenderingGraphics.renderBorderBox(event.getPoseStack(), event.getProjectionMatrix(), v, v, ModConfig.getContainerAreaColor(), 1.0f, (Boolean)ModConfig.SelectedContainerAreaTextureEnabled.get());
                }
            }
        } else if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS)) {
            ObstructionBlockManager.render(event.getPoseStack(), event.getProjectionMatrix(), event.getCamera());
        }
        event.getPoseStack().m_85849_();
    }

    private static void renderAnimazionePosizionamentoBlocco(RenderLevelStageEvent event) {
        if (AnimPosBlocks.isEmpty()) {
            return;
        }
        ArrayList<AnimazionePosizionamentoBlocco> daRimuovere = new ArrayList<AnimazionePosizionamentoBlocco>();
        for (AnimazionePosizionamentoBlocco apb : AnimPosBlocks) {
            apb.render(event.getPoseStack(), event.getProjectionMatrix(), event.getStage());
            if (!apb.animazioneFinita) continue;
            daRimuovere.add(apb);
        }
        for (AnimazionePosizionamentoBlocco apb : daRimuovere) {
            AnimPosBlocks.remove(apb);
        }
        if (AnimPosBlocks.isEmpty() && !AnimazionePosizionamentoBlocco.CACHE.isEmpty()) {
            AnimazionePosizionamentoBlocco.CACHE.clear();
        }
    }

    public static void renderHoloScannerSelectionBox(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null && player.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ModItems.SCANNER.get()) && player.m_21120_(InteractionHand.MAIN_HAND).m_41783_() != null) {
            ItemStack item = player.m_21120_(InteractionHand.MAIN_HAND);
            CompoundTag nbt = item.m_41784_();
            boolean angolo1 = nbt.m_128441_("angolo1") ? nbt.m_128471_("angolo1") : false;
            boolean angolo2 = nbt.m_128441_("angolo2") ? nbt.m_128471_("angolo2") : false;
            boolean angoloFantasma = nbt.m_128441_("angoloFantasma") ? nbt.m_128471_("angoloFantasma") : false;
            Vec3i i1 = null;
            Vec3i i2 = null;
            if (!angolo1 && angoloFantasma) {
                i2 = i1 = Operazioni.getVec3iFromString(item.m_41784_().m_128461_("coordinateAngoloFantasma"));
            } else if (!angolo2 && angoloFantasma) {
                i1 = Operazioni.getVec3iFromString(item.m_41784_().m_128461_("coordinateAngolo1"));
                i2 = Operazioni.getVec3iFromString(item.m_41784_().m_128461_("coordinateAngoloFantasma"));
            } else if (angolo1 && angolo2) {
                i1 = Operazioni.getVec3iFromString(item.m_41784_().m_128461_("coordinateAngolo1"));
                i2 = Operazioni.getVec3iFromString(item.m_41784_().m_128461_("coordinateAngolo2"));
            }
            if (i1 != null && i2 != null) {
                Vec3 Vec3Angolo2 = new Vec3((double)i2.m_123341_(), (double)i2.m_123342_(), (double)i2.m_123343_());
                if (angolo1 && angolo2 && System.currentTimeMillis() >= inizioAnim) {
                    posNonFinita = null;
                    posPrima = Vec3.f_82478_;
                    posTarget = Vec3.f_82478_;
                } else if (angolo1) {
                    if (!posTarget.equals((Object)Vec3Angolo2)) {
                        posPrima = posNonFinita == null ? new Vec3((double)i1.m_123341_(), (double)i1.m_123342_(), (double)i1.m_123343_()) : posNonFinita;
                        posTarget = Vec3Angolo2;
                        inizioAnim = System.currentTimeMillis() + 300L;
                    }
                    float t = 1.0f;
                    if (inizioAnim - System.currentTimeMillis() <= 300L) {
                        t = 1.0f - (float)(inizioAnim - System.currentTimeMillis()) / 300.0f;
                    }
                    if (t <= 1.0f) {
                        posNonFinita = Vec3Angolo2 = Operazioni.lerp(posPrima, posTarget, (double)t);
                    }
                } else {
                    posNonFinita = null;
                }
                RenderingGraphics.renderBorderBox(event.getPoseStack(), event.getProjectionMatrix(), angolo1 ? new Vec3((double)i1.m_123341_(), (double)i1.m_123342_(), (double)i1.m_123343_()) : Vec3Angolo2, Vec3Angolo2, ModConfig.getScannerAreaColor(), 1.0f, (Boolean)ModConfig.ScanningAreaTextureEnabled.get());
                if (DirezioneHitboxSelected != null) {
                    ModEventClientForge.renderScannerShapeZone(event.getPoseStack(), new Vec3((double)i1.m_123341_(), (double)i1.m_123342_(), (double)i1.m_123343_()), Vec3Angolo2);
                }
            }
        }
    }

    private static void renderScannerShapeZone(PoseStack poseStack, Vec3 angolo1, Vec3 angolo2) {
        angolo2 = angolo2.m_82520_(1.0, 1.0, 1.0);
        AABB box = null;
        if (DirezioneHitboxSelected.equals((Object)Direction.NORTH)) {
            box = new AABB(angolo1, new Vec3(angolo2.f_82479_, angolo2.f_82480_, angolo1.f_82481_));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.SOUTH)) {
            box = new AABB(angolo2, new Vec3(angolo1.f_82479_, angolo1.f_82480_, angolo2.f_82481_));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.WEST)) {
            box = new AABB(angolo1, new Vec3(angolo1.f_82479_, angolo2.f_82480_, angolo2.f_82481_));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.EAST)) {
            box = new AABB(angolo2, new Vec3(angolo2.f_82479_, angolo1.f_82480_, angolo1.f_82481_));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.DOWN)) {
            box = new AABB(angolo1, new Vec3(angolo2.f_82479_, angolo1.f_82480_, angolo2.f_82481_));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.UP)) {
            box = new AABB(angolo2, new Vec3(angolo1.f_82479_, angolo2.f_82480_, angolo1.f_82481_));
        }
        Vec3 colore = ModConfig.getScannerAreaColor();
        float r = (float)colore.f_82479_;
        float g = (float)colore.f_82480_;
        float b = (float)colore.f_82481_;
        float a = 0.8f;
        if (box == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Vec3 view = mc.f_91063_.m_109153_().m_90583_();
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix = pose.m_252922_();
        float minX = (float)(box.f_82288_ - view.f_82479_);
        float maxX = (float)(box.f_82291_ - view.f_82479_);
        float minZ = (float)(box.f_82290_ - view.f_82481_);
        float maxZ = (float)(box.f_82293_ - view.f_82481_);
        float maxY = (float)(box.f_82292_ - view.f_82480_);
        float minY = (float)(box.f_82289_ - view.f_82480_);
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_280070_());
        if (DirezioneHitboxSelected.equals((Object)Direction.NORTH) || DirezioneHitboxSelected.equals((Object)Direction.SOUTH)) {
            buffer.m_252986_(matrix, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        }
        if (DirezioneHitboxSelected.equals((Object)Direction.EAST) || DirezioneHitboxSelected.equals((Object)Direction.WEST)) {
            buffer.m_252986_(matrix, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        }
        if (DirezioneHitboxSelected.equals((Object)Direction.UP) || DirezioneHitboxSelected.equals((Object)Direction.DOWN)) {
            buffer.m_252986_(matrix, minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        }
        bufferSource.m_109911_();
    }

    @SubscribeEvent
    public static void playerEsceDalMondo(PlayerEvent.PlayerLoggedOutEvent event) {
        ClientMethods.Reset();
        offsetVisualizeBlueprint = BlockPos.f_121853_;
        datiBlocchi.clear();
        StoC_SaveGlobalBlueprint.StaGiaGestendoUnaBlueprint = false;
        RenderBlueprintsPreview.doCleanUp();
        RenderScannerAnimation.resetAll();
    }

    @SubscribeEvent
    public static void playerEntraNelMondo(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && mc.f_91074_ != null && !hasJoinedWorld) {
                hasJoinedWorld = true;
                Thread tickerThread = new Thread(() -> {
                    try {
                        Thread.sleep(1000L);
                        PacketHandler.sendToServer(new CtoS_RequestSpecificData(510, CtoS_RequestSpecificData.TipoRichiesta.ALLOW_GLOBAL_BLUEPRINTS));
                        PacketHandler.sendToServer(new CtoS_SharedBlueprintData());
                        PacketHandler.sendToServer(new CtoS_ServerBlueprintsData());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
                tickerThread.setDaemon(true);
                tickerThread.start();
            }
        }
    }

    @SubscribeEvent
    public static void ScrollingMouseEvent(InputEvent.MouseScrollingEvent event) {
        boolean scrollAvanti;
        BlueprintEvent.ScrollingMouseEvent(event);
        ChangeShapeScanningAreaEvent.ScrollingMouseEvent(event);
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91080_ != null) {
            return;
        }
        ItemStack item = mc.f_91074_.m_21205_().m_41777_();
        boolean bl = scrollAvanti = event.getScrollDelta() > 0.0;
        if (item.m_150930_((Item)ModItems.SCANNER.get())) {
            boolean isCtrlDown;
            boolean bl2 = isCtrlDown = InputConstants.m_84830_((long)mc.m_91268_().m_85439_(), (int)341) || InputConstants.m_84830_((long)mc.m_91268_().m_85439_(), (int)345);
            if (!isCtrlDown) {
                return;
            }
            int valore = Scanner.ScrollingDistanceAttuale + (scrollAvanti ? 1 : -1);
            if (valore > 100) {
                valore = 100;
            } else if (valore < 5) {
                valore = 5;
            }
            Scanner.ScrollingDistanceAttuale = valore;
            event.setCanceled(true);
        }
    }

    public static class ObstructionBlockManager {
        public static List<Tuple<Long, BlockPos>> Blocks = new ArrayList<Tuple<Long, BlockPos>>();
        private static VertexBuffer dynamicMesh = null;
        private static Long updateAfter = System.currentTimeMillis();
        private static boolean updated = true;

        public static void aggiungiBlocco(BlockPos pos) {
            boolean trovato = false;
            Tuple<Long, BlockPos> toRemove = null;
            for (Tuple<Long, BlockPos> data : Blocks) {
                if (!((BlockPos)data.m_14419_()).equals((Object)pos)) continue;
                trovato = true;
                toRemove = data;
                break;
            }
            if (!trovato) {
                Blocks.add((Tuple<Long, BlockPos>)new Tuple((Object)(System.currentTimeMillis() + 60000L), (Object)pos));
                updateAfter = System.currentTimeMillis() + 100L;
                updated = false;
            } else {
                Blocks.remove(toRemove);
                Blocks.add((Tuple<Long, BlockPos>)new Tuple((Object)(System.currentTimeMillis() + 60000L), (Object)pos));
            }
        }

        private static void updateMesh() {
            if (dynamicMesh != null) {
                dynamicMesh.close();
            }
            BufferBuilder builder = Tesselator.m_85913_().m_85915_();
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            for (Tuple<Long, BlockPos> pos : Blocks) {
                ObstructionBlockManager.addCube(builder, (float)((BlockPos)pos.m_14419_()).m_123341_() - 0.0025f, (float)((BlockPos)pos.m_14419_()).m_123342_() - 0.0025f, (float)((BlockPos)pos.m_14419_()).m_123343_() - 0.0025f, 1.005f, 255, 0, 0, 80);
            }
            BufferBuilder.RenderedBuffer meshData = builder.m_231175_();
            dynamicMesh = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
            dynamicMesh.m_85921_();
            dynamicMesh.m_231221_(meshData);
            VertexBuffer.m_85931_();
        }

        private static void addCube(BufferBuilder builder, float x, float y, float z, float size, int r, int g, int b, int a) {
            float x1 = x;
            float y1 = y;
            float z1 = z;
            float x2 = x + size;
            float y2 = y + size;
            float z2 = z + size;
            builder.m_5483_((double)x1, (double)y1, (double)z2).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x2, (double)y1, (double)z2).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x2, (double)y2, (double)z2).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x1, (double)y2, (double)z2).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x2, (double)y1, (double)z1).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x1, (double)y1, (double)z1).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x1, (double)y2, (double)z1).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x2, (double)y2, (double)z1).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x1, (double)y1, (double)z1).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x1, (double)y1, (double)z2).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x1, (double)y2, (double)z2).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x1, (double)y2, (double)z1).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x2, (double)y1, (double)z2).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x2, (double)y1, (double)z1).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x2, (double)y2, (double)z1).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x2, (double)y2, (double)z2).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x1, (double)y2, (double)z2).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x2, (double)y2, (double)z2).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x2, (double)y2, (double)z1).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x1, (double)y2, (double)z1).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x1, (double)y1, (double)z1).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x2, (double)y1, (double)z1).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x2, (double)y1, (double)z2).m_6122_(r, g, b, a).m_5752_();
            builder.m_5483_((double)x1, (double)y1, (double)z2).m_6122_(r, g, b, a).m_5752_();
        }

        public static void reset() {
            Blocks.clear();
            updateAfter = System.currentTimeMillis() + 100L;
            updated = false;
        }

        public static void render(PoseStack poseStack, Matrix4f projectMatrix4f, Camera camera) {
            if (dynamicMesh != null) {
                poseStack.m_85836_();
                poseStack.m_85837_(-camera.m_90583_().f_82479_, -camera.m_90583_().f_82480_, -camera.m_90583_().f_82481_);
                RenderSystem.disableDepthTest();
                RenderSystem.setShader(GameRenderer::m_172811_);
                dynamicMesh.m_85921_();
                dynamicMesh.m_253207_(poseStack.m_85850_().m_252922_(), projectMatrix4f, RenderSystem.getShader());
                VertexBuffer.m_85931_();
                RenderSystem.enableDepthTest();
                poseStack.m_85849_();
                ArrayList<Tuple<Long, BlockPos>> toRemove = new ArrayList<Tuple<Long, BlockPos>>();
                for (Tuple<Long, BlockPos> tuple : Blocks) {
                    if (System.currentTimeMillis() <= (Long)tuple.m_14418_() && !Minecraft.m_91087_().f_91074_.m_9236_().m_8055_((BlockPos)tuple.m_14419_()).m_60734_().equals(net.minecraft.world.level.block.Blocks.f_50016_)) continue;
                    toRemove.add(tuple);
                }
                for (Tuple tuple : toRemove) {
                    Blocks.remove(tuple);
                }
                if (toRemove.size() > 0) {
                    updateAfter = System.currentTimeMillis() + 100L;
                    updated = false;
                }
            }
            if (!updated && System.currentTimeMillis() > updateAfter) {
                updated = true;
                ObstructionBlockManager.updateMesh();
            }
        }
    }

    public static class AnimazionePosizionamentoBlocco {
        public Vec3 posIniziale;
        public Vec3 posObbiettivo;
        public Item item;
        public Long EndTime;
        public boolean animazioneFinita = false;
        public Block block;
        private List<LayerVBO> datiBlocco = null;
        private static final Map<BlockState, List<LayerVBO>> CACHE = new HashMap<BlockState, List<LayerVBO>>();

        public AnimazionePosizionamentoBlocco(String blockData, Long EndTime, Vec3 posIniziale, Vec3 posObbiettivo) {
            this.EndTime = EndTime;
            this.posIniziale = posIniziale;
            this.posObbiettivo = posObbiettivo;
            this.block = Operazioni.getBlockFromString(blockData);
            Item it = Operazioni.getCorrectItemStackFromId(this.block).m_41720_();
            if (!it.equals(Items.f_41852_)) {
                this.item = it;
            }
        }

        public void render(PoseStack poseStack, Matrix4f projectionMatrix, RenderLevelStageEvent.Stage stageAttuale) {
            float time;
            if (this.block != null && this.datiBlocco == null) {
                this.datiBlocco = AnimazionePosizionamentoBlocco.getOrCreate(this.block.m_49966_(), new BlockPos((int)this.posObbiettivo.f_82479_, (int)this.posObbiettivo.f_82480_, (int)this.posObbiettivo.f_82481_));
            }
            if ((time = 1.0f - (float)(this.EndTime - System.currentTimeMillis()) / 1000.0f) > 1.0f) {
                time = 1.0f;
            }
            if (time < 0.0f) {
                time = 0.0f;
            }
            if (this.datiBlocco != null) {
                Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
                Vec3 cam = camera.m_90583_();
                Vec3 pos = Operazioni.lerp(this.posIniziale, this.posObbiettivo, (double)time).m_82520_(-0.5, -0.5, -0.5);
                poseStack.m_85836_();
                poseStack.m_85837_(pos.f_82479_ - cam.f_82479_, pos.f_82480_ - cam.f_82480_, pos.f_82481_ - cam.f_82481_);
                List<LayerVBO> layers = AnimazionePosizionamentoBlocco.getOrCreate(this.block.m_49966_(), new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableDepthTest();
                for (LayerVBO layer : layers) {
                    if (!layer.stage.equals(stageAttuale)) continue;
                    RenderType rt = layer.layer();
                    rt.m_110185_();
                    layer.vbo().m_85921_();
                    layer.vbo().m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, Objects.requireNonNull(RenderSystem.getShader()));
                    VertexBuffer.m_85931_();
                    rt.m_110188_();
                }
                RenderSystem.disableBlend();
                poseStack.m_85849_();
            } else if (this.item != null) {
                RenderingMethods.RenderItemInWorld(poseStack, Operazioni.lerp(this.posIniziale, this.posObbiettivo, (double)time), this.item, time < 0.25f ? 0.25f : time);
            }
            if (System.currentTimeMillis() > this.EndTime) {
                this.animazioneFinita = true;
            }
        }

        public static List<LayerVBO> getOrCreate(BlockState state, BlockPos pos) {
            if (CACHE.containsKey(state)) {
                return CACHE.get(state);
            }
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            BakedModel model = dispatcher.m_110910_(state);
            ArrayList<LayerVBO> list = new ArrayList<LayerVBO>();
            BlockColors blockColors = Minecraft.m_91087_().m_91298_();
            int color = blockColors.m_92577_(state, (BlockAndTintGetter)Minecraft.m_91087_().f_91073_, pos, 0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            for (RenderType layer : model.getRenderTypes(state, RandomSource.m_216335_((long)42L), ModelData.EMPTY)) {
                BufferBuilder builder = new BufferBuilder(2048);
                builder.m_166779_(layer.m_173186_(), layer.m_110508_());
                PoseStack ps = new PoseStack();
                dispatcher.m_110937_().renderModel(ps.m_85850_(), (VertexConsumer)builder, state, model, r, g, b, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, layer);
                BufferBuilder.RenderedBuffer rendered = builder.m_231175_();
                VertexBuffer vbo = new VertexBuffer(VertexBuffer.Usage.STATIC);
                vbo.m_85921_();
                vbo.m_231221_(rendered);
                VertexBuffer.m_85931_();
                list.add(new LayerVBO(layer, vbo, AnimazionePosizionamentoBlocco.getStageForLayer(layer)));
            }
            CACHE.put(state, list);
            return list;
        }

        public static RenderLevelStageEvent.Stage getStageForLayer(RenderType type) {
            if (type == RenderType.m_110451_()) {
                return RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS;
            }
            if (type == RenderType.m_110463_() || type == RenderType.m_110457_()) {
                return RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS;
            }
            if (type == RenderType.m_110466_()) {
                return RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS;
            }
            return RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS;
        }

        private record LayerVBO(RenderType layer, VertexBuffer vbo, RenderLevelStageEvent.Stage stage) {
        }
    }
}

