/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.Events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nimble.portable_blueprints.portable_blueprints.ModConfig;
import nimble.portable_blueprints.robautile.Operazioni;
import nimble.portable_blueprints.robautile.RenderingGraphics;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(modid="portable_blueprints", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class RenderScannerAnimation {
    private static Map<UUID, AnimazioneScanningDatas> animazioneScanningDatas = new HashMap<UUID, AnimazioneScanningDatas>();

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (UUID id : animazioneScanningDatas.keySet()) {
            AnimazioneScanningDatas animazioneScanningData = animazioneScanningDatas.get(id);
            animazioneScanningData.render(event);
            if (!animazioneScanningData.canRemove) continue;
            toRemove.add(id);
        }
        for (UUID id : toRemove) {
            animazioneScanningDatas.remove(id);
        }
    }

    public static void resetAll() {
        animazioneScanningDatas.clear();
    }

    public static void addAnimation(UUID idAnimazione, BlockPos angolo1, BlockPos angolo2) {
        animazioneScanningDatas.put(idAnimazione, new AnimazioneScanningDatas(angolo1, angolo2));
    }

    public static void removeAnimazione(UUID idAnimazione) {
        if (animazioneScanningDatas.containsKey(idAnimazione)) {
            animazioneScanningDatas.get(idAnimazione).stop();
        }
    }

    public static void addProgress(UUID animationID) {
        if (animazioneScanningDatas.containsKey(animationID)) {
            animazioneScanningDatas.get(animationID).addProgresso();
        }
    }

    private static class AnimazioneScanningDatas {
        private static final int TempoOscillazione = 1000;
        private final BlockPos angolo1;
        private final BlockPos angolo2;
        private long startTime;
        private boolean canStartOscillatingScanArea = false;
        private long startOscillatingTime = System.currentTimeMillis();
        private boolean oscillatingDirection = false;
        private final Vec3 minAngolo;
        private final Vec3 maxAngolo;
        private boolean isStopped = false;
        public boolean canRemove = false;
        private boolean usedOnce = false;
        private double altezzaLast = 0.0;
        private int progresso = 0;
        private int maxProgresso;

        public AnimazioneScanningDatas(BlockPos angolo1, BlockPos angolo2) {
            this.angolo1 = angolo1;
            this.angolo2 = angolo2;
            this.startTime = System.currentTimeMillis();
            int minX = Math.min(angolo1.m_123341_(), angolo2.m_123341_());
            int maxX = Math.max(angolo1.m_123341_(), angolo2.m_123341_()) + 1;
            int minZ = Math.min(angolo1.m_123343_(), angolo2.m_123343_());
            int maxZ = Math.max(angolo1.m_123343_(), angolo2.m_123343_()) + 1;
            int maxY = Math.max(angolo1.m_123342_(), angolo2.m_123342_()) + 1;
            int minY = Math.min(angolo1.m_123342_(), angolo2.m_123342_());
            this.minAngolo = new Vec3((double)minX, (double)minY, (double)minZ);
            this.maxAngolo = new Vec3((double)maxX, (double)maxY, (double)maxZ);
            this.maxProgresso = (maxX - minX) * (maxY - minY) * (maxZ - minZ);
            this.altezzaLast = this.minAngolo.f_82480_ + (double)0.05f;
        }

        public void addProgresso() {
            ++this.progresso;
            if (this.progresso >= this.maxProgresso) {
                this.stop();
            }
        }

        public void render(RenderLevelStageEvent event) {
            Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder buffer = tesselator.m_85915_();
            VertexBuffer vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            PoseStack poseStack = event.getPoseStack();
            this.renderScanningArea(poseStack, buffer);
            vertexBuffer.m_85921_();
            vertexBuffer.m_231221_(buffer.m_231175_());
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            poseStack.m_85836_();
            poseStack.m_85837_(-view.f_82479_, -view.f_82480_, -view.f_82481_);
            ShaderInstance shader = GameRenderer.m_172811_();
            vertexBuffer.m_253207_(poseStack.m_85850_().m_252922_(), event.getProjectionMatrix(), shader);
            poseStack.m_85849_();
            VertexBuffer.m_85931_();
            RenderSystem.disableBlend();
        }

        private void renderScanningArea(PoseStack poseStack, BufferBuilder bufferBuilder) {
            double altezza;
            float minX = (float)this.minAngolo.f_82479_;
            float minY = (float)this.minAngolo.f_82480_;
            float minZ = (float)this.minAngolo.f_82481_;
            float maxX = (float)this.maxAngolo.f_82479_;
            float maxY = (float)this.maxAngolo.f_82480_;
            float maxZ = (float)this.maxAngolo.f_82481_;
            double alphaV = (float)(System.currentTimeMillis() - this.startTime) / 250.0f;
            if (alphaV > 1.0) {
                alphaV = 1.0;
            } else if (alphaV < 0.0) {
                alphaV = 0.0;
            }
            alphaV = !this.isStopped ? alphaV : 1.0 - alphaV;
            float alphaInside = (float)Operazioni.lerp(0.0, 0.5, alphaV);
            float alphaOutside = (float)Operazioni.lerp(0.0, 1.0, alphaV);
            if (this.isStopped && alphaV <= 0.0) {
                this.canRemove = true;
            }
            double Targetaltezza = this.minAngolo.f_82480_ + (double)0.05f;
            if (alphaV >= 1.0 || this.isStopped) {
                Targetaltezza = (double)((float)this.progresso / (float)this.maxProgresso) * (this.maxAngolo.f_82480_ - (double)0.05f - (this.minAngolo.f_82480_ + (double)0.05f)) + this.minAngolo.f_82480_;
            }
            this.altezzaLast = altezza = Operazioni.lerp(this.altezzaLast, Targetaltezza, (double)0.05f);
            float lunghezzaX = (float)(this.maxAngolo.f_82479_ - this.minAngolo.f_82479_);
            float lunghezzaZ = (float)(this.maxAngolo.f_82481_ - this.minAngolo.f_82481_);
            Vec3 color = ModConfig.getScannerAreaColor();
            bufferBuilder.m_5483_((double)minX, altezza, (double)minZ).m_85950_((float)color.f_82479_, (float)color.f_82480_, (float)color.f_82481_, alphaInside).m_5752_();
            bufferBuilder.m_5483_((double)maxX, altezza, (double)minZ).m_85950_((float)color.f_82479_, (float)color.f_82480_, (float)color.f_82481_, alphaInside).m_5752_();
            bufferBuilder.m_5483_((double)maxX, altezza, (double)maxZ).m_85950_((float)color.f_82479_, (float)color.f_82480_, (float)color.f_82481_, alphaInside).m_5752_();
            bufferBuilder.m_5483_((double)minX, altezza, (double)maxZ).m_85950_((float)color.f_82479_, (float)color.f_82480_, (float)color.f_82481_, alphaInside).m_5752_();
            bufferBuilder.m_5483_((double)minX, altezza, (double)maxZ).m_85950_((float)color.f_82479_, (float)color.f_82480_, (float)color.f_82481_, alphaInside).m_5752_();
            bufferBuilder.m_5483_((double)maxX, altezza, (double)maxZ).m_85950_((float)color.f_82479_, (float)color.f_82480_, (float)color.f_82481_, alphaInside).m_5752_();
            bufferBuilder.m_5483_((double)maxX, altezza, (double)minZ).m_85950_((float)color.f_82479_, (float)color.f_82480_, (float)color.f_82481_, alphaInside).m_5752_();
            bufferBuilder.m_5483_((double)minX, altezza, (double)minZ).m_85950_((float)color.f_82479_, (float)color.f_82480_, (float)color.f_82481_, alphaInside).m_5752_();
            float scale = 0.25f;
            float meta = scale / 2.0f;
            RenderingGraphics.addLineWidthToBufferBuilder(bufferBuilder, new Vec3((double)(minX - meta), altezza, (double)(minZ - scale)), lunghezzaZ + scale, scale, Direction.SOUTH, color.m_82490_(0.8), alphaOutside);
            RenderingGraphics.addLineWidthToBufferBuilder(bufferBuilder, new Vec3((double)(maxX + meta), altezza, (double)(maxZ + scale)), lunghezzaZ + scale, scale, Direction.NORTH, color.m_82490_(0.8), alphaOutside);
            RenderingGraphics.addLineWidthToBufferBuilder(bufferBuilder, new Vec3((double)(minX - scale), altezza, (double)(maxZ + meta)), lunghezzaX + scale, scale, Direction.EAST, color.m_82490_(0.8), alphaOutside);
            RenderingGraphics.addLineWidthToBufferBuilder(bufferBuilder, new Vec3((double)(maxX + scale), altezza, (double)(minZ - meta)), lunghezzaX + scale, scale, Direction.WEST, color.m_82490_(0.8), alphaOutside);
            if (alphaV >= 1.0) {
                this.renderParticles(altezza);
            }
        }

        private void renderParticles(double altezza) {
            if (System.currentTimeMillis() % 5L != 0L) {
                return;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            double randomX = this.minAngolo.f_82479_ + (this.maxAngolo.f_82479_ - this.minAngolo.f_82479_) * Math.random();
            double randomZ = this.minAngolo.f_82481_ + (this.maxAngolo.f_82481_ - this.minAngolo.f_82481_) * Math.random();
            altezza = altezza + 2.0 * Math.random() - 1.0;
            if (player.m_20183_().m_123333_(new Vec3i((int)randomX, (int)altezza, (int)randomZ)) > 30) {
                return;
            }
            Vec3 color = ModConfig.getScannerAreaColor();
            player.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f((float)color.f_82479_, (float)color.f_82480_, (float)color.f_82481_), 1.5f), randomX, altezza, randomZ, 0.0, 0.0, 0.0);
        }

        public void stop() {
            if (!this.isStopped) {
                this.isStopped = true;
                this.startTime = System.currentTimeMillis();
            }
        }
    }
}

