/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.altro;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import nimble.portable_blueprints.altro.CustomBlockProprietyHandle;
import nimble.portable_blueprints.altro.PlacingBlockManager;
import nimble.portable_blueprints.altro.ProgressBarBlueprintPlayer;
import nimble.portable_blueprints.client.ClientMethods;
import nimble.portable_blueprints.client.ServerToClientDatasShared;
import nimble.portable_blueprints.init.ModItems;
import nimble.portable_blueprints.init.ModToast;
import nimble.portable_blueprints.mod_compatibility.ModCompatibilityInit;
import nimble.portable_blueprints.mod_compatibility.projecte.ProjectEMetodi;
import nimble.portable_blueprints.mod_compatibility.sophisticatedbackpacks.SophisticatedBackpacksMetodi;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.StoC_AnimazionePosizionamentoBlocco;
import nimble.portable_blueprints.network.StoC_ScannerAnimation;
import nimble.portable_blueprints.network.global_blueprint_net.CtoS_SaveGlobalBlueprintInServer;
import nimble.portable_blueprints.network.progress_bar_player.StoC_ProgressBarPlayer;
import nimble.portable_blueprints.portable_blueprints.Mod;
import nimble.portable_blueprints.portable_blueprints.ModServerConfig;
import nimble.portable_blueprints.robautile.ModifiableItemInventory;
import nimble.portable_blueprints.robautile.Operazioni;

@Mod.EventBusSubscriber
public class Blueprint {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final String extension = ".bp";
    public static final String extension_swm = ".swm";
    private static final int MAX_BLOCKS_FOR_TICK = 500;
    public static List<Block> ILLEGAL_BLOCK_IN_SURVIVAL = new ArrayList<Block>();
    private static List<BlueprintStructure> structureDaFare = new ArrayList<BlueprintStructure>();
    private static Map<BlueprintStartingData, BlueprintDatas> creazioneDati = new HashMap<BlueprintStartingData, BlueprintDatas>();

    public static void setup() {
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50752_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50257_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50258_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50142_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50272_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50447_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50448_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50375_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50677_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50454_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50678_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_152480_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50110_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50449_);
    }

    public static void CreateBlueprint(ServerLevel level, BlockPos angolo1, BlockPos angolo2, String nome, UUID richiedente, boolean consideraCreativeBlocks, List<String> ScannerIgnoredBlocks) {
        BlueprintStartingData bsd;
        BlockPos angoloIniziale = new BlockPos(Math.min(angolo1.m_123341_(), angolo2.m_123341_()), Math.min(angolo1.m_123342_(), angolo2.m_123342_()), Math.min(angolo1.m_123343_(), angolo2.m_123343_()));
        BlockPos angoloFinale = new BlockPos(Math.max(angolo1.m_123341_(), angolo2.m_123341_()), Math.max(angolo1.m_123342_(), angolo2.m_123342_()), Math.max(angolo1.m_123343_(), angolo2.m_123343_()));
        UUID uuidAnimazioneScanner = UUID.randomUUID();
        if (level.m_46003_(richiedente) != null) {
            PacketHandler.sendToPlayer(new StoC_ScannerAnimation(uuidAnimazioneScanner, true, angoloIniziale, angoloFinale), (ServerPlayer)level.m_46003_(richiedente));
        }
        if (!creazioneDati.containsKey(bsd = new BlueprintStartingData(level, nome, angoloIniziale, angoloFinale, richiedente, consideraCreativeBlocks, ScannerIgnoredBlocks, uuidAnimazioneScanner))) {
            BlueprintDatas bd = new BlueprintDatas(nome);
            bd.setX(angoloFinale.m_123341_() - angoloIniziale.m_123341_() + 1);
            bd.setZ(angoloFinale.m_123343_() - angoloIniziale.m_123343_() + 1);
            bd.altezza = angoloFinale.m_123342_() - angoloIniziale.m_123342_() + 1;
            creazioneDati.put(bsd, bd);
            PacketHandler.sendToPlayer(new StoC_ProgressBarPlayer(4, bd.lunghezzaX * bd.altezza * bd.lunghezzaZ, true), (ServerPlayer)level.m_46003_(richiedente));
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        block77: {
            block78: {
                if (event.phase != TickEvent.Phase.END) break block77;
                if (creazioneDati.isEmpty()) break block78;
                BlueprintStartingData key = null;
                Iterator<BlueprintStartingData> iterator = creazioneDati.keySet().iterator();
                if (iterator.hasNext()) {
                    BlueprintStartingData k;
                    key = k = iterator.next();
                }
                if (key.serverLevel.m_46003_(key.uuid) == null) {
                    creazioneDati.remove(key);
                    PacketHandler.sendToPlayer(new StoC_ProgressBarPlayer(4, 0, true), (ServerPlayer)key.serverLevel.m_46003_(key.uuid));
                    key = null;
                }
                if (key == null) break block77;
                int controllati = 0;
                ServerPlayer player = (ServerPlayer)key.serverLevel.m_46003_(key.uuid);
                while (key.posYControllata != key.angolo2.m_123342_() + 1) {
                    while (key.posXControllata != key.angolo2.m_123341_() + 1) {
                        while (key.posZControllata != key.angolo2.m_123343_() + 1 && controllati < 500) {
                            BlockPos position = new BlockPos(key.posXControllata, key.posYControllata, key.posZControllata);
                            BlockState blockState = key.serverLevel.m_8055_(position);
                            if (blockState.m_60734_().equals(Blocks.f_50628_)) {
                                blockState = Blocks.f_49990_.m_49966_();
                            }
                            if (!(blockState.m_60713_(Blocks.f_50016_) || !key.consideraCreativeBlocks && (key.consideraCreativeBlocks || ILLEGAL_BLOCK_IN_SURVIVAL.contains(blockState.m_60734_())) || key.scannerIgnoredBlocks.contains(ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_()).toString()))) {
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61422_)) {
                                    if (blockState.m_60734_() instanceof LiquidBlock && (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61422_) != 0) {
                                        ++key.posZControllata;
                                        ++controllati;
                                        continue;
                                    }
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61422_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61418_)) {
                                    blockState = blockState.m_60734_().equals(Blocks.f_152476_) || blockState.m_60734_().equals(Blocks.f_152477_) ? Blocks.f_50256_.m_49966_() : (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61418_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61419_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61419_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61420_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61420_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61421_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61421_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61405_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61405_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61406_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61406_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61407_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_222999_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_222999_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61408_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61408_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61409_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61410_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61410_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61411_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61411_, (Comparable)Integer.valueOf(0));
                                }
                                String nbt = "";
                                BlockEntity blockEntity = key.serverLevel.m_7702_(position);
                                if (blockEntity != null && !blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
                                    nbt = key.serverLevel.m_7702_(position).serializeNBT().m_7916_();
                                }
                                if (!blockState.m_60811_().name().equals("DESTROY") && !blockState.m_60812_((BlockGetter)key.serverLevel, position).m_83281_()) {
                                    creazioneDati.get(key).addBlock(key.altezzaArrivato, Operazioni.getVec3iString(new Vec3i(key.posXControllata - key.angolo1.m_123341_(), key.posYControllata - key.angolo1.m_123342_(), key.posZControllata - key.angolo1.m_123343_())), Operazioni.getBlockStateString(blockState), nbt);
                                } else {
                                    creazioneDati.get(key).addNonSolidBlock(key.altezzaArrivato, Operazioni.getVec3iString(new Vec3i(key.posXControllata - key.angolo1.m_123341_(), key.posYControllata - key.angolo1.m_123342_(), key.posZControllata - key.angolo1.m_123343_())), Operazioni.getBlockStateString(blockState), nbt);
                                }
                            }
                            if (key.serverLevel.m_46003_(key.uuid) != null) {
                                if (!key.annullaAnimazioneScanner) {
                                    PacketHandler.sendToPlayer(new StoC_ScannerAnimation(key.uuidAnimazioneScanner), (ServerPlayer)key.serverLevel.m_46003_(key.uuid));
                                }
                            } else {
                                key.annullaAnimazioneScanner = true;
                            }
                            PacketHandler.sendToPlayer(new StoC_ProgressBarPlayer(4, 0, false), player);
                            ++key.posZControllata;
                            ++controllati;
                        }
                        if (controllati >= 500) break;
                        ++key.posXControllata;
                        key.posZControllata = key.angolo1.m_123343_();
                    }
                    if (controllati >= 500) break;
                    ++key.posYControllata;
                    ++key.altezzaArrivato;
                    key.posXControllata = key.angolo1.m_123341_();
                }
                if (controllati >= 500) break block77;
                File jsonFile = new File(Blueprint.getFileForBlueprints(key.serverLevel, key.uuid), key.nome + extension);
                try (FileWriter writer = new FileWriter(jsonFile);){
                    GSON.toJson((Object)creazioneDati.get(key), (Appendable)writer);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (key.serverLevel.m_46003_(key.uuid) != null) {
                    PacketHandler.sendToPlayer(new StoC_ProgressBarPlayer(4, 0, true), player);
                    PacketHandler.sendToPlayer(new StoC_ScannerAnimation(key.uuidAnimazioneScanner, false, BlockPos.f_121853_, BlockPos.f_121853_), (ServerPlayer)key.serverLevel.m_46003_(key.uuid));
                }
                creazioneDati.remove(key);
                break block77;
            }
            if (structureDaFare.size() > 0) {
                ArrayList<BlueprintStructure> toRemove = new ArrayList<BlueprintStructure>();
                int nBlocchiArrivati = 0;
                boolean skip = false;
                for (BlueprintStructure bs : structureDaFare) {
                    if (skip) break;
                    if (!Blueprint.playerIsOnline(bs.owner)) {
                        toRemove.add(bs);
                        continue;
                    }
                    ArrayList<BlockPos> blocchiDaScartareDaEspansione = new ArrayList<BlockPos>();
                    for (BlockPos posBlocco : new ArrayList<BlockPos>(bs.posDiEspansione)) {
                        BlockPos newPos;
                        if (skip) break;
                        BlockState b = bs.serverLevel.m_8055_(Operazioni.SommaBlockPos(bs.bd.offset, posBlocco));
                        if (b.m_60713_(Blocks.f_50016_) || PlacingBlockManager.isRimpiazzabile(b)) {
                            if (bs.solidi && bs.bd.BlocksData.containsKey(posBlocco.m_123342_()) && bs.bd.BlocksData.get(posBlocco.m_123342_()).containsKey(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_())))) {
                                datiBlocco = bs.bd.BlocksData.get(posBlocco.m_123342_()).get(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_())));
                                bloccoId = datiBlocco.substring(datiBlocco.indexOf("<bid>") + 5, datiBlocco.indexOf("</bid>"));
                                blockState = (datiBlocco = datiBlocco.replaceFirst("<bid>" + bloccoId + "</bid>", "")).equals("null") ? Operazioni.getBlockFromString(bloccoId).m_49966_() : Operazioni.getPropertiesStringToBlock(Operazioni.getBlockFromString(bloccoId), datiBlocco);
                                posizioneAnim = Vec3.f_82478_;
                                item_trovato = false;
                                if (Blueprint.playerIsOnline(bs.owner)) {
                                    posizioneAnim = bs.owner.m_20182_().m_82520_(0.0, 1.0, 0.0);
                                    if (bs.free_build || ILLEGAL_BLOCK_IN_SURVIVAL.contains(blockState.m_60734_()) && bs.owner.m_7500_() || bs.owner.m_5833_()) {
                                        item_trovato = true;
                                    } else if (ILLEGAL_BLOCK_IN_SURVIVAL.contains(blockState.m_60734_())) {
                                        item_trovato = false;
                                    } else if (bs.owner.m_7500_() || bs.owner.m_5833_() || blockState.m_61138_((Property)BlockStateProperties.f_61401_) && ((DoubleBlockHalf)blockState.m_61143_((Property)BlockStateProperties.f_61401_)).equals((Object)DoubleBlockHalf.UPPER) || blockState.m_61138_((Property)BlockStateProperties.f_61391_) && ((BedPart)blockState.m_61143_((Property)BlockStateProperties.f_61391_)).equals((Object)BedPart.HEAD)) {
                                        item_trovato = true;
                                    } else {
                                        v = Blueprint.removeItemFromTheContainers((ServerPlayer)bs.owner, bs.serverLevel, bs.posizione_container, Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).m_41720_());
                                        if (!((Boolean)v.m_14418_()).booleanValue() && bs.emc_active && ProjectEMetodi.removeEMCForItem((ServerPlayer)bs.owner, Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).m_41720_())) {
                                            item_trovato = true;
                                        } else {
                                            item_trovato = (Boolean)v.m_14418_();
                                            posizioneAnim = (Vec3)v.m_14419_();
                                        }
                                    }
                                } else {
                                    toRemove.add(bs);
                                    continue;
                                }
                                if (item_trovato) {
                                    if (!blockState.m_61138_((Property)BlockStateProperties.f_61401_) || blockState.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
                                        p = Operazioni.SommaBlockPos(bs.bd.offset, posBlocco);
                                        PacketHandler.sendToAllClients(new StoC_AnimazionePosizionamentoBlocco(bloccoId, System.currentTimeMillis() + 1000L, posizioneAnim, new Vec3((double)((float)p.m_123341_() + 0.5f), (double)((float)p.m_123342_() + 0.5f), (double)((float)p.m_123343_() + 0.5f))));
                                    }
                                    PacketHandler.sendToPlayer(new StoC_ProgressBarPlayer(0, 0, false), (ServerPlayer)bs.owner);
                                    nbt = bs.bd.BlocksNBT != null && bs.bd.BlocksNBT.containsKey(posBlocco.m_123342_()) && bs.bd.BlocksNBT.get(posBlocco.m_123342_()).containsKey(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_()))) ? bs.bd.BlocksNBT.get(posBlocco.m_123342_()).get(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_()))) : "";
                                    PlacingBlockManager.addNewPlaceBlock((ServerPlayer)bs.owner, bs.serverLevel, Operazioni.SommaBlockPos(bs.bd.offset, posBlocco), blockState, nbt, bs.allow_nbt, 1000L);
                                }
                            } else if (!bs.solidi && bs.bd.NotSolidBlocksData.containsKey(posBlocco.m_123342_()) && bs.bd.NotSolidBlocksData.get(posBlocco.m_123342_()).containsKey(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_())))) {
                                datiBlocco = bs.bd.NotSolidBlocksData.get(posBlocco.m_123342_()).get(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_())));
                                bloccoId = datiBlocco.substring(datiBlocco.indexOf("<bid>") + 5, datiBlocco.indexOf("</bid>"));
                                blockState = (datiBlocco = datiBlocco.replaceFirst("<bid>" + bloccoId + "</bid>", "")).equals("null") ? Operazioni.getBlockFromString(bloccoId).m_49966_() : Operazioni.getPropertiesStringToBlock(Operazioni.getBlockFromString(bloccoId), datiBlocco);
                                posizioneAnim = Vec3.f_82478_;
                                item_trovato = false;
                                if (Blueprint.playerIsOnline(bs.owner)) {
                                    posizioneAnim = bs.owner.m_20182_().m_82520_(0.0, 1.0, 0.0);
                                    if (bs.free_build || ILLEGAL_BLOCK_IN_SURVIVAL.contains(blockState.m_60734_()) && bs.owner.m_7500_() || bs.owner.m_5833_()) {
                                        item_trovato = true;
                                    } else if (ILLEGAL_BLOCK_IN_SURVIVAL.contains(blockState.m_60734_())) {
                                        item_trovato = false;
                                    } else if (bs.owner.m_7500_() || bs.owner.m_5833_() || blockState.m_61138_((Property)BlockStateProperties.f_61401_) && ((DoubleBlockHalf)blockState.m_61143_((Property)BlockStateProperties.f_61401_)).equals((Object)DoubleBlockHalf.UPPER) || blockState.m_61138_((Property)BlockStateProperties.f_61391_) && ((BedPart)blockState.m_61143_((Property)BlockStateProperties.f_61391_)).equals((Object)BedPart.HEAD)) {
                                        item_trovato = true;
                                    } else {
                                        v = Blueprint.removeItemFromTheContainers((ServerPlayer)bs.owner, bs.serverLevel, bs.posizione_container, Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).m_41720_());
                                        if (!((Boolean)v.m_14418_()).booleanValue() && bs.emc_active && ProjectEMetodi.removeEMCForItem((ServerPlayer)bs.owner, Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).m_41720_())) {
                                            item_trovato = true;
                                        } else {
                                            item_trovato = (Boolean)v.m_14418_();
                                            posizioneAnim = (Vec3)v.m_14419_();
                                        }
                                    }
                                } else {
                                    toRemove.add(bs);
                                    continue;
                                }
                                if (item_trovato) {
                                    if (!blockState.m_61138_((Property)BlockStateProperties.f_61401_) || blockState.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
                                        p = Operazioni.SommaBlockPos(bs.bd.offset, posBlocco);
                                        PacketHandler.sendToAllClients(new StoC_AnimazionePosizionamentoBlocco(bloccoId, System.currentTimeMillis() + 1000L, posizioneAnim, new Vec3((double)((float)p.m_123341_() + 0.5f), (double)((float)p.m_123342_() + 0.5f), (double)((float)p.m_123343_() + 0.5f))));
                                    }
                                    PacketHandler.sendToPlayer(new StoC_ProgressBarPlayer(0, 0, false), (ServerPlayer)bs.owner);
                                    nbt = bs.bd.BlocksNBT != null && bs.bd.BlocksNBT.containsKey(posBlocco.m_123342_()) && bs.bd.BlocksNBT.get(posBlocco.m_123342_()).containsKey(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_()))) ? bs.bd.BlocksNBT.get(posBlocco.m_123342_()).get(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_()))) : "";
                                    PlacingBlockManager.addNewPlaceBlock((ServerPlayer)bs.owner, bs.serverLevel, Operazioni.SommaBlockPos(bs.bd.offset, posBlocco), blockState, nbt, bs.allow_nbt, 1000L);
                                }
                            }
                        } else if (Blueprint.playerIsOnline(bs.owner) && (bs.solidi && bs.bd.BlocksData.containsKey(posBlocco.m_123342_()) && bs.bd.BlocksData.get(posBlocco.m_123342_()).containsKey(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_()))) || !bs.solidi && bs.bd.NotSolidBlocksData.containsKey(posBlocco.m_123342_()) && bs.bd.NotSolidBlocksData.get(posBlocco.m_123342_()).containsKey(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_()))))) {
                            PacketHandler.sendToPlayer(new StoC_ProgressBarPlayer(0, 0, false), (ServerPlayer)bs.owner);
                        }
                        if (posBlocco.m_123341_() - 1 >= 0 && !bs.posDiEspansione.contains(newPos = Operazioni.SommaBlockPos(posBlocco, new BlockPos(-1, 0, 0)))) {
                            bs.posDiEspansione.add(newPos);
                        }
                        if (posBlocco.m_123343_() - 1 >= 0 && !bs.posDiEspansione.contains(newPos = Operazioni.SommaBlockPos(posBlocco, new BlockPos(0, 0, -1)))) {
                            bs.posDiEspansione.add(newPos);
                        }
                        if (posBlocco.m_123342_() + 1 < bs.bd.altezza && !bs.posDiEspansione.contains(newPos = Operazioni.SommaBlockPos(posBlocco, new BlockPos(0, 1, 0)))) {
                            bs.posDiEspansione.add(newPos);
                        }
                        if (posBlocco.m_123341_() - 1 >= 0 && posBlocco.m_123343_() - 1 >= 0 && !bs.posDiEspansione.contains(newPos = Operazioni.SommaBlockPos(posBlocco, new BlockPos(-1, 0, -1)))) {
                            bs.posDiEspansione.add(newPos);
                        }
                        blocchiDaScartareDaEspansione.add(posBlocco);
                        if (++nBlocchiArrivati < 500) continue;
                        skip = true;
                    }
                    for (BlockPos posDelet : blocchiDaScartareDaEspansione) {
                        bs.posDiEspansione.remove(posDelet);
                    }
                    if (bs.solidi && bs.posDiEspansione.size() == 0) {
                        bs.solidi = false;
                        bs.posDiEspansione.add(new BlockPos(bs.bd.lunghezzaX - 1, 0, bs.bd.lunghezzaZ - 1));
                    }
                    if (bs.posDiEspansione != null && bs.posDiEspansione.size() != 0) continue;
                    toRemove.add(bs);
                }
                for (BlueprintStructure b : toRemove) {
                    PacketHandler.sendToPlayer(new StoC_ProgressBarPlayer(0, 0, true), (ServerPlayer)b.owner);
                    structureDaFare.remove(b);
                }
            }
        }
    }

    private static boolean playerIsOnline(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return serverPlayer.m_20194_().m_6846_().m_11259_(serverPlayer.m_20148_()) != null;
        }
        return false;
    }

    public static File getFileForBlueprints(ServerLevel level, UUID uuid) {
        File CartellaMod = new File(level.m_7654_().m_129843_(LevelResource.f_78182_).toFile(), "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "blueprints")).exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, uuid.toString())).exists()) {
            CartellaMod.mkdir();
        }
        return CartellaMod;
    }

    public static boolean BlueprintExist(ServerLevel level, String nome, UUID richiedente) {
        File cartella = Blueprint.getFileForBlueprints(level, richiedente);
        for (File child : cartella.listFiles()) {
            if (!child.getName().equals(nome + extension)) continue;
            return true;
        }
        return false;
    }

    public static void RimuoviBlueprint(ServerLevel level, ServerPlayer player, String nome) {
        SharedWithMe swm = Blueprint.getSharedBlueprints(level, player.m_20148_());
        for (UUID shared_with : swm.getAllSpecificSWOBPlayersUUID(nome)) {
            Blueprint.removeSharedBlueprint(level, nome, player.m_20148_(), shared_with);
        }
        for (File f : Blueprint.getFileForBlueprints(level, player.m_20148_()).listFiles()) {
            if (!f.getName().equals(nome + extension)) continue;
            f.delete();
            break;
        }
    }

    public static void CreaItemBlueprintEDaiAGiocatore(ServerPlayer player, UUID owner, String nome, int altezza, int lunghezzaX, int lunghezzaZ) {
        boolean added;
        ItemStack blueprint = nome.contains("[Global]") ? new ItemStack((ItemLike)ModItems.GLOBAL_BLUEPRINT.get(), 1) : new ItemStack((ItemLike)ModItems.BLUEPRINT.get(), 1);
        Item item = blueprint.m_41720_();
        if (item instanceof nimble.portable_blueprints.items.Blueprint) {
            nimble.portable_blueprints.items.Blueprint blueprintItem = (nimble.portable_blueprints.items.Blueprint)item;
            blueprintItem.setBlueprint(blueprint, player, owner, nome, altezza, lunghezzaX, lunghezzaZ);
        }
        if (!(added = player.m_150109_().m_36054_(blueprint))) {
            player.m_240418_((Component)Component.m_237115_((String)"system.portable_blueprints.inv_full"), true);
        }
    }

    public static void CreaItemServerBlueprintEDaiAGiocatore(ServerPlayer player, String nome, int altezza, int lunghezzaX, int lunghezzaZ) {
        boolean added;
        ItemStack blueprint = new ItemStack((ItemLike)ModItems.SERVER_BLUEPRINT.get(), 1);
        Item item = blueprint.m_41720_();
        if (item instanceof nimble.portable_blueprints.items.Blueprint) {
            nimble.portable_blueprints.items.Blueprint blueprintItem = (nimble.portable_blueprints.items.Blueprint)item;
            blueprintItem.setServerBlueprint(blueprint, nome, altezza, lunghezzaX, lunghezzaZ);
        }
        if (!(added = player.m_150109_().m_36054_(blueprint))) {
            player.m_240418_((Component)Component.m_237115_((String)"system.portable_blueprints.inv_full"), true);
        }
    }

    public static void AggiungiStructureAllaCoda(ServerLevel level, BlueprintDatas bd, Player player, List<BlockPos> posizione_container, boolean free_build, short allow_nbt, boolean emc_active) {
        if (!structureDaFare.contains(new BlueprintStructure(level, bd, player, posizione_container, free_build, allow_nbt, emc_active))) {
            structureDaFare.add(new BlueprintStructure(level, bd, player, posizione_container, free_build, allow_nbt, emc_active));
            PacketHandler.sendToPlayer(new StoC_ProgressBarPlayer(0, bd.getAllBlocksCount() + 1, true), (ServerPlayer)player);
        }
    }

    public static Map<Item, Integer> getAllItemQuantityFromInventory(ServerPlayer player, ServerLevel level, List<BlockPos> posizioniContainer) {
        HashMap<Item, Integer> ItemQuantity = new HashMap<Item, Integer>();
        for (ItemStack item : player.m_150109_().f_35974_) {
            if (ItemQuantity.containsKey(item.m_41720_())) {
                ItemQuantity.replace(item.m_41720_(), (Integer)ItemQuantity.get(item.m_41720_()) + item.m_41613_());
            } else {
                ItemQuantity.put(item.m_41720_(), item.m_41613_());
            }
            if (SophisticatedBackpacksMetodi.isABackpack(item)) {
                SophisticatedBackpacksMetodi.getAllItemFromBackpack(item, ItemQuantity);
                continue;
            }
            if (Mod.ListaModContainerNonConsentiti.contains(BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_()).m_135827_())) continue;
            ModifiableItemInventory.of(item).ifPresent(inv -> {
                Container container = inv.getContainer();
                for (int x = 0; x < container.m_6643_(); ++x) {
                    ItemStack itemStack = container.m_8020_(x);
                    if (ItemQuantity.containsKey(itemStack.m_41720_())) {
                        ItemQuantity.replace(itemStack.m_41720_(), (Integer)ItemQuantity.get(itemStack.m_41720_()) + itemStack.m_41613_() * item.m_41613_());
                        continue;
                    }
                    ItemQuantity.put(itemStack.m_41720_(), itemStack.m_41613_() * item.m_41613_());
                }
            });
        }
        for (ItemStack armorItem : player.m_150109_().f_35975_) {
            if (ItemQuantity.containsKey(armorItem.m_41720_())) {
                ItemQuantity.replace(armorItem.m_41720_(), (Integer)ItemQuantity.get(armorItem.m_41720_()) + armorItem.m_41613_());
            } else {
                ItemQuantity.put(armorItem.m_41720_(), armorItem.m_41613_());
            }
            if (SophisticatedBackpacksMetodi.isABackpack(armorItem)) {
                SophisticatedBackpacksMetodi.getAllItemFromBackpack(armorItem, ItemQuantity);
                continue;
            }
            if (Mod.ListaModContainerNonConsentiti.contains(BuiltInRegistries.f_257033_.m_7981_((Object)armorItem.m_41720_()).m_135827_())) continue;
            ModifiableItemInventory.of(armorItem).ifPresent(inv -> {
                Container container = inv.getContainer();
                for (int x = 0; x < container.m_6643_(); ++x) {
                    ItemStack itemStack = container.m_8020_(x);
                    if (ItemQuantity.containsKey(itemStack.m_41720_())) {
                        ItemQuantity.replace(itemStack.m_41720_(), (Integer)ItemQuantity.get(itemStack.m_41720_()) + itemStack.m_41613_() * armorItem.m_41613_());
                        continue;
                    }
                    ItemQuantity.put(itemStack.m_41720_(), itemStack.m_41613_() * armorItem.m_41613_());
                }
            });
        }
        for (BlockPos posizione : posizioniContainer) {
            BlockEntity be = level.m_7702_(posizione);
            if (be != null) {
                if (SophisticatedBackpacksMetodi.isABackpack(be)) {
                    SophisticatedBackpacksMetodi.getAllItemFromBackpack(be, ItemQuantity);
                    continue;
                }
                be.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                    for (int x = 0; x < handler.getSlots(); ++x) {
                        ItemStack item = handler.getStackInSlot(x);
                        if (ItemQuantity.containsKey(item.m_41720_())) {
                            ItemQuantity.replace(item.m_41720_(), (Integer)ItemQuantity.get(item.m_41720_()) + item.m_41613_());
                        } else {
                            ItemQuantity.put(item.m_41720_(), item.m_41613_());
                        }
                        if (Mod.ListaModContainerNonConsentiti.contains(BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_()).m_135827_())) continue;
                        ModifiableItemInventory.of(item).ifPresent(inv -> {
                            Container container_item = inv.getContainer();
                            for (int xItem = 0; xItem < container_item.m_6643_(); ++xItem) {
                                ItemStack itemStack = container_item.m_8020_(xItem);
                                if (ItemQuantity.containsKey(itemStack.m_41720_())) {
                                    ItemQuantity.replace(itemStack.m_41720_(), (Integer)ItemQuantity.get(itemStack.m_41720_()) + itemStack.m_41613_() * item.m_41613_());
                                    continue;
                                }
                                ItemQuantity.put(itemStack.m_41720_(), itemStack.m_41613_() * item.m_41613_());
                            }
                        });
                    }
                });
                continue;
            }
            System.err.println("Il container non \u00e8 una entity");
        }
        return ItemQuantity;
    }

    public static Tuple<Boolean, Vec3> removeItemFromTheContainers(ServerPlayer player, ServerLevel level, List<BlockPos> posizioniContainer, Item Target) {
        Object v;
        for (ItemStack item : player.m_150109_().f_35974_) {
            if (item.m_41720_().equals(Target)) {
                if (item.m_41720_().equals(Items.f_42447_) || item.m_41720_().equals(Items.f_42448_)) {
                    item.m_41764_(item.m_41613_() - 1);
                    int item_rimasti = Operazioni.addItemToInventory(player.m_150109_(), new ItemStack((ItemLike)Items.f_42446_), 1);
                    if (item_rimasti > 0) {
                        Operazioni.dropItem((Level)level, player.m_20182_(), new ItemStack((ItemLike)Items.f_42446_));
                    }
                } else {
                    item.m_41764_(item.m_41613_() - 1);
                }
                return new Tuple((Object)true, (Object)player.m_20182_().m_82520_(0.0, 1.0, 0.0));
            }
            if (SophisticatedBackpacksMetodi.isABackpack(item)) {
                v = SophisticatedBackpacksMetodi.removeItemFromBackpack(player, level, item, Target);
                if (v == null) continue;
                return v;
            }
            if (Mod.ListaModContainerNonConsentiti.contains(BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_()).m_135827_())) continue;
            v = new AtomicReference();
            ModifiableItemInventory.of(item).ifPresent(inv -> {
                Container container = inv.getContainer();
                for (int x = 0; x < container.m_6643_(); ++x) {
                    ItemStack itemStack = container.m_8020_(x);
                    if (!itemStack.m_41720_().equals(Target)) continue;
                    if (itemStack.m_41720_().equals(Items.f_42447_) || itemStack.m_41720_().equals(Items.f_42448_)) {
                        itemStack.m_41764_(itemStack.m_41613_() - 1);
                        int item_rimasti = Operazioni.addItemToInventory(player.m_150109_(), new ItemStack((ItemLike)Items.f_42446_), 1);
                        if (item_rimasti > 0) {
                            Operazioni.dropItem((Level)level, player.m_20182_(), new ItemStack((ItemLike)Items.f_42446_));
                        }
                    } else {
                        itemStack.m_41764_(itemStack.m_41613_() - 1);
                    }
                    v.set(new Tuple((Object)true, (Object)player.m_20182_().m_82520_(0.0, 1.0, 0.0)));
                }
                inv.save();
            });
            if (((AtomicReference)v).get() == null) continue;
            return (Tuple)((AtomicReference)v).get();
        }
        for (ItemStack armorItem : player.m_150109_().f_35975_) {
            if (armorItem.m_41720_().equals(Target)) {
                if (armorItem.m_41720_().equals(Items.f_42447_) || armorItem.m_41720_().equals(Items.f_42448_)) {
                    armorItem.m_41764_(armorItem.m_41613_() - 1);
                    int item_rimasti = Operazioni.addItemToInventory(player.m_150109_(), new ItemStack((ItemLike)Items.f_42446_), 1);
                    if (item_rimasti > 0) {
                        Operazioni.dropItem((Level)level, player.m_20182_(), new ItemStack((ItemLike)Items.f_42446_));
                    }
                } else {
                    armorItem.m_41764_(armorItem.m_41613_() - 1);
                }
                return new Tuple((Object)true, (Object)player.m_20182_().m_82520_(0.0, 1.0, 0.0));
            }
            if (SophisticatedBackpacksMetodi.isABackpack(armorItem)) {
                v = SophisticatedBackpacksMetodi.removeItemFromBackpack(player, level, armorItem, Target);
                if (v == null) continue;
                return v;
            }
            if (Mod.ListaModContainerNonConsentiti.contains(BuiltInRegistries.f_257033_.m_7981_((Object)armorItem.m_41720_()).m_135827_())) continue;
            v = new AtomicReference();
            ModifiableItemInventory.of(armorItem).ifPresent(arg_0 -> Blueprint.lambda$removeItemFromTheContainers$5(Target, player, level, (AtomicReference)v, arg_0));
            if (((AtomicReference)v).get() == null) continue;
            return (Tuple)((AtomicReference)v).get();
        }
        for (BlockPos posizione : posizioniContainer) {
            AtomicReference v2;
            BlockEntity be = level.m_7702_(posizione);
            if (be == null) continue;
            if (SophisticatedBackpacksMetodi.isABackpack(be)) {
                v2 = SophisticatedBackpacksMetodi.removeItemFromBackpack(player, level, be, Target, posizione);
                if (v2 == null) continue;
                return v2;
            }
            v2 = new AtomicReference();
            be.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                for (int x = 0; x < handler.getSlots(); ++x) {
                    ItemStack item = handler.getStackInSlot(x);
                    if (item.m_41720_().equals(Target)) {
                        if (item.m_41720_().equals(Items.f_42447_) || item.m_41720_().equals(Items.f_42448_)) {
                            item.m_41764_(item.m_41613_() - 1);
                            int item_rimasti = Operazioni.addItemToInventory(player.m_150109_(), new ItemStack((ItemLike)Items.f_42446_), 1);
                            if (item_rimasti > 0) {
                                Operazioni.dropItem((Level)level, player.m_20182_(), new ItemStack((ItemLike)Items.f_42446_));
                            }
                        } else {
                            item.m_41764_(item.m_41613_() - 1);
                        }
                        v2.set(new Tuple((Object)true, (Object)posizione.m_252807_()));
                        continue;
                    }
                    if (Mod.ListaModContainerNonConsentiti.contains(BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_()).m_135827_())) continue;
                    ModifiableItemInventory.of(item).ifPresent(inv -> {
                        Container container_item = inv.getContainer();
                        for (int xItem = 0; xItem < container_item.m_6643_(); ++xItem) {
                            ItemStack itemStack = container_item.m_8020_(xItem);
                            if (!itemStack.m_41720_().equals(Target)) continue;
                            if (itemStack.m_41720_().equals(Items.f_42447_) || itemStack.m_41720_().equals(Items.f_42448_)) {
                                itemStack.m_41764_(itemStack.m_41613_() - 1);
                                int item_rimasti = Operazioni.addItemToInventory(player.m_150109_(), new ItemStack((ItemLike)Items.f_42446_), 1);
                                if (item_rimasti > 0) {
                                    Operazioni.dropItem((Level)level, player.m_20182_(), new ItemStack((ItemLike)Items.f_42446_));
                                }
                            } else {
                                itemStack.m_41764_(itemStack.m_41613_() - 1);
                            }
                            v2.set(new Tuple((Object)true, (Object)posizione.m_252807_()));
                        }
                        inv.save();
                    });
                }
            });
            if (v2.get() == null) continue;
            return (Tuple)v2.get();
        }
        return new Tuple((Object)false, (Object)Vec3.f_82478_);
    }

    public static SharedWithMe getSharedBlueprints(ServerLevel level, UUID uuid) {
        File FileShared = Blueprint.getSharedFile(level, uuid);
        SharedWithMe swm = new SharedWithMe();
        try {
            swm = Blueprint.getAllSharedGlobalBlueprintAsSWM(level, uuid, (SharedWithMe)GSON.fromJson((Reader)new FileReader(FileShared), SharedWithMe.class));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return swm;
    }

    public static void addSharedBlueprint(ServerLevel serverLevel, String nome, UUID creatoreRichiesta, UUID ricevente) {
        if (Blueprint.BlueprintExist(serverLevel, nome, creatoreRichiesta)) {
            FileWriter writer;
            SharedWithMe swm = Blueprint.getSharedBlueprints(serverLevel, creatoreRichiesta);
            swm.addSharedWithOthersBlueprint(ricevente, nome);
            try {
                writer = new FileWriter(Blueprint.getSharedFile(serverLevel, creatoreRichiesta));
                try {
                    GSON.toJson((Object)swm, (Appendable)writer);
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            swm = Blueprint.getSharedBlueprints(serverLevel, ricevente);
            swm.addSharedWithMeBlueprint(creatoreRichiesta, nome);
            try {
                writer = new FileWriter(Blueprint.getSharedFile(serverLevel, ricevente));
                try {
                    GSON.toJson((Object)swm, (Appendable)writer);
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void removeSharedBlueprint(ServerLevel serverLevel, String nome, UUID creatoreRichiesta, UUID ricevente) {
        if (Blueprint.BlueprintExist(serverLevel, nome, creatoreRichiesta)) {
            FileWriter writer;
            SharedWithMe swm = Blueprint.getSharedBlueprints(serverLevel, creatoreRichiesta);
            swm.removeSharedWithOthersBlueprint(ricevente, nome);
            try {
                writer = new FileWriter(Blueprint.getSharedFile(serverLevel, creatoreRichiesta));
                try {
                    GSON.toJson((Object)swm, (Appendable)writer);
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            swm = Blueprint.getSharedBlueprints(serverLevel, ricevente);
            swm.removeSharedWithMeBlueprint(creatoreRichiesta, nome);
            try {
                writer = new FileWriter(Blueprint.getSharedFile(serverLevel, ricevente));
                try {
                    GSON.toJson((Object)swm, (Appendable)writer);
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setSharedBlueprintAsGlobal(ServerLevel serverLevel, UUID owner, String blueprint_name) {
        File file = Blueprint.getSharedGlobalFile(serverLevel);
        if (file != null) {
            Map MapGlobal = new HashMap<UUID, List<String>>();
            try {
                Type type = new TypeToken<Map<UUID, List<String>>>(){}.getType();
                MapGlobal = (Map)GSON.fromJson((Reader)new FileReader(file), type);
            }
            catch (FileNotFoundException type) {
                // empty catch block
            }
            if (MapGlobal.containsKey(owner) && !((List)MapGlobal.get(owner)).contains(blueprint_name)) {
                ((List)MapGlobal.get(owner)).add(blueprint_name);
            } else {
                MapGlobal.put(owner, List.of(blueprint_name));
            }
            try (FileWriter writer = new FileWriter(file);){
                GSON.toJson(MapGlobal, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void removeSharedBlueprintAsGlobal(ServerLevel serverLevel, UUID owner, String blueprint_name) {
        File file = Blueprint.getSharedGlobalFile(serverLevel);
        if (file != null) {
            Map MapGlobal = new HashMap();
            try {
                Type type = new TypeToken<Map<UUID, List<String>>>(){}.getType();
                MapGlobal = (Map)GSON.fromJson((Reader)new FileReader(file), type);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            for (UUID uuid : MapGlobal.keySet()) {
                System.out.println("uudi nella map: " + uuid + " | uuid owner: " + owner);
            }
            if (MapGlobal.containsKey(owner) && ((List)MapGlobal.get(owner)).contains(blueprint_name)) {
                ((List)MapGlobal.get(owner)).remove(blueprint_name);
            }
            try (FileWriter writer = new FileWriter(file);){
                GSON.toJson(MapGlobal, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static SharedWithMe getAllSharedGlobalBlueprintAsSWM(ServerLevel serverLevel, UUID Richiedente, SharedWithMe swm) {
        File file = Blueprint.getSharedGlobalFile(serverLevel);
        if (file != null) {
            Map MapGlobal = new HashMap();
            try {
                Type type = new TypeToken<Map<UUID, List<String>>>(){}.getType();
                MapGlobal = (Map)GSON.fromJson((Reader)new FileReader(file), type);
                for (UUID owner : MapGlobal.keySet()) {
                    for (String name : (List)MapGlobal.get(owner)) {
                        if (owner.equals(Richiedente)) {
                            swm.addSharedWithOthersBlueprint(owner, name);
                            continue;
                        }
                        swm.addSharedWithMeBlueprint(owner, name);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return swm;
    }

    public static File getSharedGlobalFile(ServerLevel serverLevel) {
        String file;
        File CartellaMod = new File(serverLevel.m_7654_().m_129843_(LevelResource.f_78182_).toFile(), "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "shared")).exists()) {
            CartellaMod.mkdir();
        }
        if (!new File(CartellaMod, file = "global.sg").exists()) {
            File jsonFile = new File(CartellaMod, file);
            try (FileWriter writer = new FileWriter(jsonFile);){
                GSON.toJson(new HashMap(), (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new File(CartellaMod, file);
    }

    public static File getSharedFile(ServerLevel serverLevel, UUID target) {
        String file;
        File CartellaMod = new File(serverLevel.m_7654_().m_129843_(LevelResource.f_78182_).toFile(), "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "shared")).exists()) {
            CartellaMod.mkdir();
        }
        if (!new File(CartellaMod, file = target.toString() + extension_swm).exists()) {
            SharedWithMe swm = new SharedWithMe();
            File jsonFile = new File(CartellaMod, file);
            try (FileWriter writer = new FileWriter(jsonFile);){
                GSON.toJson((Object)swm, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new File(CartellaMod, file);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static File getGlobalBlueprintDir() {
        File CartellaMod = new File(Minecraft.m_91087_().f_91069_, "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "blueprints")).exists()) {
            CartellaMod.mkdir();
        }
        return CartellaMod;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean globalBlueprintExist(String nome) {
        return new File(Blueprint.getGlobalBlueprintDir(), nome + extension).exists();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getGlobalBlueprintsQuantity() {
        int x = 0;
        for (File file : Blueprint.getGlobalBlueprintDir().listFiles()) {
            if (!file.getName().contains(extension)) continue;
            ++x;
        }
        return x;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<String> getAllGlobalBlueprintsName() {
        ArrayList<String> nomi = new ArrayList<String>();
        for (File file : Blueprint.getGlobalBlueprintDir().listFiles()) {
            if (!file.getName().contains(extension)) continue;
            nomi.add(file.getName().replace(extension, ""));
        }
        return nomi;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void removeGlobalBlueprint(String nome) {
        File f = new File(Blueprint.getGlobalBlueprintDir(), nome + extension);
        if (f.exists()) {
            f.delete();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlueprintDatas getGlobalBlueprintClass(String nome) {
        File f = new File(Blueprint.getGlobalBlueprintDir(), nome + extension);
        if (f.exists()) {
            try {
                return (BlueprintDatas)GSON.fromJson((Reader)new FileReader(f), BlueprintDatas.class);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServerGlobalBlueprint(String nome) {
        if (ClientMethods.SendingGlobalBlueprintToServer) {
            return;
        }
        Thread tickerThread = new Thread(() -> {
            try {
                Thread.sleep(50L);
                int QuantityBlocksMax = ServerToClientDatasShared.getRichiestaInteger(507);
                BlueprintDatas bdc = Blueprint.getGlobalBlueprintClass(nome);
                boolean puoMandarlo = false;
                if (bdc != null) {
                    if (bdc.getAllBlocksCount() <= QuantityBlocksMax) {
                        if (ClientMethods.getQuantitaFileBlueprint() < ServerToClientDatasShared.getRichiestaInteger(508)) {
                            puoMandarlo = true;
                        } else {
                            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"chat_message.portable_blueprints.global_bp_quantity_limit").m_130940_(ChatFormatting.RED), false);
                        }
                    } else {
                        Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"chat_message.portable_blueprints.global_bp_blocks_limit").m_130940_(ChatFormatting.RED), false);
                    }
                }
                if (puoMandarlo) {
                    ClientMethods.SendingGlobalBlueprintToServer = true;
                    File bd = new File(Blueprint.getGlobalBlueprintDir(), nome + extension);
                    if (bd.exists()) {
                        String bd_string_datas = new String(Files.readAllBytes(bd.toPath()));
                        String id_richiesta = UUID.randomUUID().toString();
                        ModToast.showToast((Component)Component.m_237115_((String)"portable_blueprints.toast.global_blueprints.import.title"), (Component)Component.m_237115_((String)"portable_blueprints.toast.global_blueprints.import.subtitle"), new ItemStack((ItemLike)ModItems.GLOBAL_BLUEPRINT.get()), -1453289, -1);
                        PacketHandler.sendToServer(new CtoS_SaveGlobalBlueprintInServer("[INIZIO DATI BLUEPRINT <id>" + id_richiesta + "</id><nome>" + nome + "</nome>"));
                        PacketHandler.sendToServer(new CtoS_SaveGlobalBlueprintInServer("[NOME DEL FILE:" + nome));
                        List<String> dati = Operazioni.splitStringByLength(bd_string_datas, 10000);
                        ProgressBarBlueprintPlayer.aggiungi(3, dati.size() + 1);
                        for (String val : dati) {
                            ProgressBarBlueprintPlayer.progressoPlus(3);
                            PacketHandler.sendToServer(new CtoS_SaveGlobalBlueprintInServer("[" + id_richiesta + "]" + val));
                            Thread.sleep(10L);
                        }
                        ModToast.showToast((Component)Component.m_237115_((String)"portable_blueprints.toast.global_blueprints.import.title"), (Component)Component.m_237115_((String)"portable_blueprints.toast.global_blueprints.import.subtitle2"), new ItemStack((ItemLike)ModItems.GLOBAL_BLUEPRINT.get()), -13447886, -1);
                        ProgressBarBlueprintPlayer.impostaValore(3, dati.size() + 1);
                        PacketHandler.sendToServer(new CtoS_SaveGlobalBlueprintInServer("[FINE DATI BLUEPRINT DI ID: " + id_richiesta + "]"));
                        ClientMethods.SendingGlobalBlueprintToServer = false;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ClientMethods.SendingGlobalBlueprintToServer = false;
            }
        });
        tickerThread.setDaemon(true);
        tickerThread.start();
    }

    public static File getServerBlueprintFile(ServerLevel serverLevel) {
        File CartellaMod = new File(serverLevel.m_7654_().m_129843_(LevelResource.f_78182_).toFile(), "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "server")).exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "blueprints")).exists()) {
            CartellaMod.mkdir();
        }
        return CartellaMod;
    }

    public static File getWornBlueprintFile(ServerLevel serverLevel) {
        File CartellaMod = new File(serverLevel.m_7654_().m_129843_(LevelResource.f_78182_).toFile(), "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "worn blueprints")).exists()) {
            CartellaMod.mkdir();
        }
        return CartellaMod;
    }

    public static File getServerPremissionFile(ServerLevel serverLevel) {
        String file;
        File CartellaMod = new File(serverLevel.m_7654_().m_129843_(LevelResource.f_78182_).toFile(), "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "server")).exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "permission")).exists()) {
            CartellaMod.mkdir();
        }
        if (!new File(CartellaMod, file = "permissions.settings").exists()) {
            BlueprintPermission bp = new BlueprintPermission();
            File jsonFile = new File(CartellaMod, file);
            try (FileWriter writer = new FileWriter(jsonFile);){
                GSON.toJson((Object)bp, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new File(CartellaMod, file);
    }

    public static String getIDBlueprint(String namespace, BlueprintDatas blueprintDatas) {
        if (blueprintDatas != null) {
            Object nome = "";
            for (char c : blueprintDatas.nome.toCharArray()) {
                nome = Character.isUpperCase(c) ? (String)nome + "<" + String.valueOf(c).toLowerCase() + ">" : (String)nome + c;
            }
            String v = namespace.toLowerCase() + "|" + (String)nome + "?" + blueprintDatas.lunghezzaX + blueprintDatas.altezza + blueprintDatas.lunghezzaZ + blueprintDatas.getAllBlocksCount() + (blueprintDatas.BlocksData != null ? blueprintDatas.BlocksData.size() : 0) + (blueprintDatas.NotSolidBlocksData != null ? blueprintDatas.NotSolidBlocksData.size() : 0) + (blueprintDatas.BlocksNBT != null ? blueprintDatas.BlocksNBT.size() : 0);
            return v;
        }
        return "";
    }

    public static String sanitizePathUnique(String input) {
        String base = input.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9/._-]", "_");
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(input.getBytes(StandardCharsets.UTF_8));
            StringBuilder hex = new StringBuilder();
            for (byte b : digest) {
                hex.append(String.format("%02x", b));
            }
            return base + "_" + hex.substring(0, 8);
        }
        catch (NoSuchAlgorithmException e) {
            return base + "_" + Integer.toHexString(input.hashCode());
        }
    }

    public static String getIDBlueprint(ServerLevel level, String namespace, UUID BPOwner, String BPName) {
        File blueprintFile = Arrays.stream(BPOwner == null ? Blueprint.getServerBlueprintFile(level).listFiles() : Blueprint.getFileForBlueprints(level, BPOwner).listFiles()).filter(f -> f.getName().equals(BPName + extension)).findFirst().orElse(null);
        if (blueprintFile != null) {
            try {
                BlueprintDatas bd = (BlueprintDatas)GSON.fromJson((Reader)new FileReader(blueprintFile), BlueprintDatas.class);
                if (bd != null) {
                    return Blueprint.getIDBlueprint(namespace, bd);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public static String getNomeByBlueprintID(String blueprint_Id) {
        String nome = blueprint_Id;
        while (true) {
            int open = nome.indexOf("<");
            int close = nome.indexOf(">");
            if (open == -1 || close == -1 || open >= close) break;
            String v = nome.substring(open + 1, close);
            nome = nome.replace("<" + v + ">", v.toUpperCase());
        }
        int start = nome.indexOf("|");
        int end = nome.lastIndexOf("?");
        if (start == -1 || end == -1 || start + 1 >= end) {
            return nome;
        }
        return nome.substring(start + 1, end);
    }

    private static /* synthetic */ void lambda$removeItemFromTheContainers$5(Item Target, ServerPlayer player, ServerLevel level, AtomicReference v, ModifiableItemInventory inv) {
        Container container = inv.getContainer();
        for (int x = 0; x < container.m_6643_(); ++x) {
            ItemStack itemStack = container.m_8020_(x);
            if (!itemStack.m_41720_().equals(Target)) continue;
            if (itemStack.m_41720_().equals(Items.f_42447_) || itemStack.m_41720_().equals(Items.f_42448_)) {
                itemStack.m_41764_(itemStack.m_41613_() - 1);
                int item_rimasti = Operazioni.addItemToInventory(player.m_150109_(), new ItemStack((ItemLike)Items.f_42446_), 1);
                if (item_rimasti > 0) {
                    Operazioni.dropItem((Level)level, player.m_20182_(), new ItemStack((ItemLike)Items.f_42446_));
                }
            } else {
                itemStack.m_41764_(itemStack.m_41613_() - 1);
            }
            v.set(new Tuple((Object)true, (Object)player.m_20182_().m_82520_(0.0, 1.0, 0.0)));
        }
        inv.save();
    }

    private static class BlueprintStartingData {
        public BlockPos angolo1;
        public BlockPos angolo2;
        public String nome;
        public ServerLevel serverLevel;
        public UUID uuid;
        public int posXControllata;
        public int posYControllata;
        public int posZControllata;
        public int altezzaArrivato = 0;
        public boolean consideraCreativeBlocks = false;
        public List<String> scannerIgnoredBlocks;
        public boolean annullaAnimazioneScanner = false;
        public UUID uuidAnimazioneScanner;

        public BlueprintStartingData(ServerLevel serverLevel, String nome, BlockPos angolo1, BlockPos angolo2, UUID uuid, boolean consideraCreativeBlocks, List<String> scannerIgnoredBlocks, UUID uuidAnimazioneScanner) {
            this.angolo1 = angolo1;
            this.angolo2 = angolo2;
            this.nome = nome;
            this.serverLevel = serverLevel;
            this.uuid = uuid;
            this.posXControllata = angolo1.m_123341_();
            this.posYControllata = angolo1.m_123342_();
            this.posZControllata = angolo1.m_123343_();
            this.consideraCreativeBlocks = consideraCreativeBlocks;
            this.scannerIgnoredBlocks = scannerIgnoredBlocks;
            this.uuidAnimazioneScanner = uuidAnimazioneScanner;
        }
    }

    public static class BlueprintDatas {
        public String nome = "";
        public int altezza = 0;
        public int lunghezzaX = 0;
        public int lunghezzaZ = 0;
        public BlockPos offset = new BlockPos(0, 0, 0);
        public Map<Integer, Map<String, String>> BlocksData = new HashMap<Integer, Map<String, String>>();
        public Map<Integer, Map<String, String>> NotSolidBlocksData = new HashMap<Integer, Map<String, String>>();
        public Map<Integer, Map<String, String>> BlocksNBT = new HashMap<Integer, Map<String, String>>();

        public BlueprintDatas(String NOME) {
            this.nome = NOME;
        }

        public void addBlock(int altezza, String posDalOrigine, String blocco, String nbt) {
            if (BlueprintDatas.ServerBlackListBlock(blocco) || BlueprintDatas.controlloBlocchiModdati(blocco)) {
                return;
            }
            if (this.BlocksData.containsKey(altezza)) {
                this.BlocksData.get(altezza).put(posDalOrigine, blocco);
            } else {
                this.BlocksData.put(altezza, new HashMap());
                this.BlocksData.get(altezza).put(posDalOrigine, blocco);
            }
            if (!nbt.isEmpty()) {
                if (this.BlocksNBT != null && this.BlocksNBT.containsKey(altezza)) {
                    this.BlocksNBT.get(altezza).put(posDalOrigine, nbt);
                } else {
                    this.BlocksNBT.put(altezza, new HashMap());
                    this.BlocksNBT.get(altezza).put(posDalOrigine, nbt);
                }
            }
        }

        public void addNonSolidBlock(int altezza, String posDalOrigine, String blocco, String nbt) {
            if (BlueprintDatas.ServerBlackListBlock(blocco) || BlueprintDatas.controlloBlocchiModdati(blocco)) {
                return;
            }
            if (this.NotSolidBlocksData.containsKey(altezza)) {
                this.NotSolidBlocksData.get(altezza).put(posDalOrigine, blocco);
            } else {
                this.NotSolidBlocksData.put(altezza, new HashMap());
                this.NotSolidBlocksData.get(altezza).put(posDalOrigine, blocco);
            }
            if (!nbt.isEmpty()) {
                if (this.BlocksNBT != null && this.BlocksNBT.containsKey(altezza)) {
                    this.BlocksNBT.get(altezza).put(posDalOrigine, nbt);
                } else {
                    this.BlocksNBT.put(altezza, new HashMap());
                    this.BlocksNBT.get(altezza).put(posDalOrigine, nbt);
                }
            }
        }

        public void setX(int x) {
            this.lunghezzaX = x;
        }

        public void setZ(int z) {
            this.lunghezzaZ = z;
        }

        public List<String> getBlocksDataByAltezza(int altezza) {
            ArrayList<String> bs = new ArrayList<String>();
            for (String pos : this.BlocksData.get(altezza).keySet()) {
                String valore = this.BlocksData.get(altezza).get(pos);
                bs.add(valore);
            }
            return bs;
        }

        public List<String> getBlocksPosByAltezza(int altezza) {
            ArrayList<String> bs = new ArrayList<String>();
            for (String pos : this.BlocksData.get(altezza).keySet()) {
                bs.add(pos);
            }
            return bs;
        }

        public int getAllBlocksCount() {
            int count = 0;
            for (int v = 0; v < 2; ++v) {
                if (v == 0 && this.BlocksData == null || v == 1 && this.NotSolidBlocksData == null) continue;
                for (Integer altezza : v == 0 ? this.BlocksData.keySet() : this.NotSolidBlocksData.keySet()) {
                    count += v == 0 ? this.BlocksData.get(altezza).size() : this.NotSolidBlocksData.get(altezza).size();
                }
            }
            return count;
        }

        public BlueprintDatas rotate(short rot) {
            BlueprintDatas ruotato = new BlueprintDatas(this.nome);
            ruotato.altezza = this.altezza;
            if (rot == 1 || rot == 3) {
                ruotato.lunghezzaZ = this.lunghezzaX;
                ruotato.lunghezzaX = this.lunghezzaZ;
            } else {
                ruotato.lunghezzaZ = this.lunghezzaZ;
                ruotato.lunghezzaX = this.lunghezzaX;
            }
            for (int v = 0; v < 2; ++v) {
                for (Map.Entry<Integer, Map<String, String>> posizione_e_blocco : v == 0 ? this.BlocksData.entrySet() : this.NotSolidBlocksData.entrySet()) {
                    Map<String, String> innerMap = posizione_e_blocco.getValue();
                    for (Map.Entry<String, String> dati_blocco : innerMap.entrySet()) {
                        String nbt;
                        BlockPos pos = new BlockPos(Operazioni.getVec3iFromString(dati_blocco.getKey()));
                        String blockdata = dati_blocco.getValue();
                        String bloccoId = blockdata.substring(blockdata.indexOf("<bid>") + 5, blockdata.indexOf("</bid>"));
                        if (!(blockdata = blockdata.replaceFirst("<bid>" + bloccoId + "</bid>", "")).equalsIgnoreCase("null")) {
                            BlockState state = Operazioni.getPropertiesStringToBlock(Operazioni.getBlockFromString(bloccoId), blockdata);
                            Tuple<Boolean, BlockState> val = BlueprintDatas.setCustomBlockProprietyRotate(bloccoId, state, rot);
                            if (((Boolean)val.m_14418_()).booleanValue()) {
                                state = (BlockState)val.m_14419_();
                            } else {
                                if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
                                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Operazioni.rotateFacing((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_), rot));
                                } else if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Operazioni.rotateFacing((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_), rot));
                                } else if (state.m_61138_((Property)BlockStateProperties.f_61373_)) {
                                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61373_, (Comparable)Operazioni.rotateFacing((Direction)state.m_61143_((Property)BlockStateProperties.f_61373_), rot));
                                }
                                if ((rot == 1 || rot == 3) && state.m_61138_((Property)BlockStateProperties.f_61365_)) {
                                    if (((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)).equals((Object)Direction.Axis.X)) {
                                        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Z);
                                    } else if (((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)).equals((Object)Direction.Axis.Z)) {
                                        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.X);
                                    }
                                }
                                if (state.m_61138_((Property)BlockStateProperties.f_61403_) || state.m_61138_((Property)BlockStateProperties.f_61404_)) {
                                    RailShape shape = state.m_61138_((Property)BlockStateProperties.f_61403_) ? (RailShape)state.m_61143_((Property)BlockStateProperties.f_61403_) : (RailShape)state.m_61143_((Property)BlockStateProperties.f_61404_);
                                    List<RailShape> railShapesAlto = List.of(RailShape.ASCENDING_NORTH, RailShape.ASCENDING_EAST, RailShape.ASCENDING_SOUTH, RailShape.ASCENDING_WEST);
                                    List<RailShape> railShapesCurva = List.of(RailShape.NORTH_WEST, RailShape.NORTH_EAST, RailShape.SOUTH_EAST, RailShape.SOUTH_WEST);
                                    if (railShapesAlto.contains(shape)) {
                                        rotval = (short)(shape.equals((Object)RailShape.ASCENDING_NORTH) ? 0 : (shape.equals((Object)RailShape.ASCENDING_EAST) ? 1 : (shape.equals((Object)RailShape.ASCENDING_SOUTH) ? 2 : 3)));
                                        if ((rotval = (short)(rotval + rot)) > 3) {
                                            rotval = (short)(rotval - 4);
                                        }
                                        state = (BlockState)state.m_61124_((Property)(state.m_61138_((Property)BlockStateProperties.f_61403_) ? BlockStateProperties.f_61403_ : BlockStateProperties.f_61404_), (Comparable)railShapesAlto.get(rotval));
                                    } else if (railShapesCurva.contains(shape)) {
                                        rotval = (short)(shape.equals((Object)RailShape.NORTH_WEST) ? 0 : (shape.equals((Object)RailShape.NORTH_EAST) ? 1 : (shape.equals((Object)RailShape.SOUTH_EAST) ? 2 : 3)));
                                        if ((rotval = (short)(rotval + rot)) > 3) {
                                            rotval = (short)(rotval - 4);
                                        }
                                        state = (BlockState)state.m_61124_((Property)(state.m_61138_((Property)BlockStateProperties.f_61403_) ? BlockStateProperties.f_61403_ : BlockStateProperties.f_61404_), (Comparable)railShapesCurva.get(rotval));
                                    } else {
                                        rotval = (short)(!shape.equals((Object)RailShape.EAST_WEST) ? 1 : 0);
                                        for (rotval = (short)(rotval + rot); rotval > 1; rotval = (short)(rotval - 2)) {
                                        }
                                        state = (BlockState)state.m_61124_((Property)(state.m_61138_((Property)BlockStateProperties.f_61403_) ? BlockStateProperties.f_61403_ : BlockStateProperties.f_61404_), (Comparable)(rotval == 1 ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST));
                                    }
                                }
                                boolean n = state.m_61138_((Property)BlockStateProperties.f_61368_) ? (Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_) : false;
                                boolean s = state.m_61138_((Property)BlockStateProperties.f_61370_) ? (Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_) : false;
                                boolean e = state.m_61138_((Property)BlockStateProperties.f_61369_) ? (Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_) : false;
                                boolean w = state.m_61138_((Property)BlockStateProperties.f_61371_) ? (Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_) : false;
                                boolean vfN = false;
                                boolean vfS = false;
                                boolean vfE = false;
                                boolean vfW = false;
                                if (n) {
                                    if (rot != 0) {
                                        n = false;
                                    }
                                    switch (rot) {
                                        case 1: {
                                            vfE = true;
                                            break;
                                        }
                                        case 2: {
                                            vfS = true;
                                            break;
                                        }
                                        case 3: {
                                            vfW = true;
                                        }
                                    }
                                }
                                if (s) {
                                    if (rot != 0) {
                                        s = false;
                                    }
                                    switch (rot) {
                                        case 1: {
                                            vfW = true;
                                            break;
                                        }
                                        case 2: {
                                            vfN = true;
                                            break;
                                        }
                                        case 3: {
                                            vfE = true;
                                        }
                                    }
                                }
                                if (e) {
                                    if (rot != 0) {
                                        e = false;
                                    }
                                    switch (rot) {
                                        case 1: {
                                            vfS = true;
                                            break;
                                        }
                                        case 2: {
                                            vfW = true;
                                            break;
                                        }
                                        case 3: {
                                            vfN = true;
                                        }
                                    }
                                }
                                if (w) {
                                    if (rot != 0) {
                                        w = false;
                                    }
                                    switch (rot) {
                                        case 1: {
                                            vfN = true;
                                            break;
                                        }
                                        case 2: {
                                            vfE = true;
                                            break;
                                        }
                                        case 3: {
                                            vfS = true;
                                        }
                                    }
                                }
                                if (state.m_61138_((Property)BlockStateProperties.f_61368_)) {
                                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(vfN || n));
                                }
                                if (state.m_61138_((Property)BlockStateProperties.f_61370_)) {
                                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(vfS || s));
                                }
                                if (state.m_61138_((Property)BlockStateProperties.f_61369_)) {
                                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(vfE || e));
                                }
                                if (state.m_61138_((Property)BlockStateProperties.f_61371_)) {
                                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(vfW || w));
                                }
                                if (state.m_61138_((Property)BlockStateProperties.f_61390_)) {
                                    int rotazione_attuale_cartello = (Integer)state.m_61143_((Property)BlockStateProperties.f_61390_) + rot * 4;
                                    if (rotazione_attuale_cartello >= 16) {
                                        rotazione_attuale_cartello -= 16;
                                    }
                                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(rotazione_attuale_cartello));
                                }
                                state = BlueprintDatas.doModdedBlockPropriety(state, true, rot, false, false, false);
                            }
                            blockdata = Operazioni.getBlockStateString(state);
                        } else {
                            blockdata = dati_blocco.getValue();
                        }
                        String string = nbt = this.BlocksNBT != null && this.BlocksNBT.containsKey(pos.m_123342_()) && this.BlocksNBT.get(pos.m_123342_()).containsKey(dati_blocco.getKey()) ? this.BlocksNBT.get(pos.m_123342_()).get(dati_blocco.getKey()) : "";
                        if (rot == 0) {
                            if (v == 0) {
                                ruotato.addBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())), blockdata, nbt);
                                continue;
                            }
                            ruotato.addNonSolidBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())), blockdata, nbt);
                            continue;
                        }
                        if (rot == 1) {
                            if (v == 0) {
                                ruotato.addBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(this.lunghezzaZ - 1 - pos.m_123343_(), pos.m_123342_(), pos.m_123341_())), blockdata, nbt);
                                continue;
                            }
                            ruotato.addNonSolidBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(this.lunghezzaZ - 1 - pos.m_123343_(), pos.m_123342_(), pos.m_123341_())), blockdata, nbt);
                            continue;
                        }
                        if (rot == 2) {
                            if (v == 0) {
                                ruotato.addBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(this.lunghezzaX - 1 - pos.m_123341_(), pos.m_123342_(), this.lunghezzaZ - 1 - pos.m_123343_())), blockdata, nbt);
                                continue;
                            }
                            ruotato.addNonSolidBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(this.lunghezzaX - 1 - pos.m_123341_(), pos.m_123342_(), this.lunghezzaZ - 1 - pos.m_123343_())), blockdata, nbt);
                            continue;
                        }
                        if (rot != 3) continue;
                        if (v == 0) {
                            ruotato.addBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(pos.m_123343_(), pos.m_123342_(), this.lunghezzaX - 1 - pos.m_123341_())), blockdata, nbt);
                            continue;
                        }
                        ruotato.addNonSolidBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(pos.m_123343_(), pos.m_123342_(), this.lunghezzaX - 1 - pos.m_123341_())), blockdata, nbt);
                    }
                }
            }
            return ruotato;
        }

        public BlueprintDatas Mirror(boolean Mx, boolean My, boolean Mz) {
            BlueprintDatas mirror = new BlueprintDatas(this.nome);
            mirror.altezza = this.altezza;
            mirror.lunghezzaZ = this.lunghezzaZ;
            mirror.lunghezzaX = this.lunghezzaX;
            for (int v = 0; v < 2; ++v) {
                for (Map.Entry<Integer, Map<String, String>> posizione_e_blocco : v == 0 ? this.BlocksData.entrySet() : this.NotSolidBlocksData.entrySet()) {
                    Map<String, String> innerMap = posizione_e_blocco.getValue();
                    for (Map.Entry<String, String> dati_blocco : innerMap.entrySet()) {
                        String nbt;
                        BlockPos pos = new BlockPos(Operazioni.getVec3iFromString(dati_blocco.getKey()));
                        String blockdata = dati_blocco.getValue();
                        String bloccoId = blockdata.substring(blockdata.indexOf("<bid>") + 5, blockdata.indexOf("</bid>"));
                        blockdata = blockdata.replaceFirst("<bid>" + bloccoId + "</bid>", "");
                        if (Mx) {
                            pos = new BlockPos(this.lunghezzaX - 1 - pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                        }
                        if (Mz) {
                            pos = new BlockPos(pos.m_123341_(), pos.m_123342_(), this.lunghezzaZ - 1 - pos.m_123343_());
                        }
                        if (My) {
                            pos = new BlockPos(pos.m_123341_(), this.altezza - 1 - pos.m_123342_(), pos.m_123343_());
                        }
                        if (!blockdata.equalsIgnoreCase("null")) {
                            BlockState state = Operazioni.getPropertiesStringToBlock(Operazioni.getBlockFromString(bloccoId), blockdata);
                            Tuple<Boolean, BlockState> val = BlueprintDatas.setCustomBlockProprietyMirrow(bloccoId, state, Mx, My, Mz);
                            if (((Boolean)val.m_14418_()).booleanValue()) {
                                state = (BlockState)val.m_14419_();
                            } else {
                                boolean suXFatta = false;
                                boolean suYFatta = false;
                                boolean suZFatta = false;
                                for (int statesTime = 0; statesTime < 3; ++statesTime) {
                                    StairsShape shape;
                                    if (statesTime == 0 && !Mx || statesTime == 1 && !My || statesTime == 2 && !Mz) continue;
                                    if (statesTime == 0) {
                                        suXFatta = true;
                                        suYFatta = false;
                                        suZFatta = false;
                                    } else if (statesTime == 1) {
                                        suXFatta = false;
                                        suYFatta = true;
                                        suZFatta = false;
                                    } else if (statesTime == 2) {
                                        suXFatta = false;
                                        suYFatta = false;
                                        suZFatta = true;
                                    }
                                    if (suYFatta && state.m_61138_((Property)BlockStateProperties.f_61376_)) {
                                        switch ((AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_)) {
                                            case FLOOR: {
                                                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)AttachFace.CEILING);
                                                break;
                                            }
                                            case CEILING: {
                                                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)AttachFace.FLOOR);
                                            }
                                        }
                                    }
                                    if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
                                        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
                                    } else if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                                        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                                        if (dir.equals((Object)Direction.NORTH) && suZFatta) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH);
                                        } else if (dir.equals((Object)Direction.SOUTH) && suZFatta) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH);
                                        } else if (dir.equals((Object)Direction.EAST) && suXFatta) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST);
                                        } else if (dir.equals((Object)Direction.WEST) && suXFatta) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST);
                                        } else if (dir.equals((Object)Direction.UP) && suYFatta) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.DOWN);
                                        } else if (dir.equals((Object)Direction.DOWN) && suYFatta) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.UP);
                                        }
                                    }
                                    if (state.m_61138_((Property)BlockStateProperties.f_61398_) && !suYFatta) {
                                        shape = (StairsShape)state.m_61143_((Property)BlockStateProperties.f_61398_);
                                        if (shape.equals((Object)StairsShape.INNER_LEFT)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61398_, (Comparable)StairsShape.INNER_RIGHT);
                                        } else if (shape.equals((Object)StairsShape.INNER_RIGHT)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61398_, (Comparable)StairsShape.INNER_LEFT);
                                        } else if (shape.equals((Object)StairsShape.OUTER_LEFT)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61398_, (Comparable)StairsShape.OUTER_RIGHT);
                                        } else if (shape.equals((Object)StairsShape.OUTER_RIGHT)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61398_, (Comparable)StairsShape.OUTER_LEFT);
                                        }
                                    }
                                    if (state.m_61138_((Property)BlockStateProperties.f_61403_) && !suYFatta) {
                                        shape = (RailShape)state.m_61143_((Property)BlockStateProperties.f_61403_);
                                        if (suXFatta) {
                                            if (shape.equals((Object)RailShape.SOUTH_WEST)) {
                                                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)RailShape.SOUTH_EAST);
                                            } else if (shape.equals((Object)RailShape.SOUTH_EAST)) {
                                                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)RailShape.SOUTH_WEST);
                                            } else if (shape.equals((Object)RailShape.NORTH_WEST)) {
                                                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)RailShape.NORTH_EAST);
                                            } else if (shape.equals((Object)RailShape.NORTH_EAST)) {
                                                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)RailShape.NORTH_WEST);
                                            } else if (shape.equals((Object)RailShape.ASCENDING_EAST)) {
                                                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)RailShape.ASCENDING_WEST);
                                            } else if (shape.equals((Object)RailShape.ASCENDING_WEST)) {
                                                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)RailShape.ASCENDING_EAST);
                                            }
                                        } else if (shape.equals((Object)RailShape.NORTH_EAST)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)RailShape.SOUTH_EAST);
                                        } else if (shape.equals((Object)RailShape.SOUTH_EAST)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)RailShape.NORTH_EAST);
                                        } else if (shape.equals((Object)RailShape.NORTH_WEST)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)RailShape.SOUTH_WEST);
                                        } else if (shape.equals((Object)RailShape.SOUTH_WEST)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)RailShape.NORTH_WEST);
                                        } else if (shape.equals((Object)RailShape.ASCENDING_NORTH)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)RailShape.ASCENDING_SOUTH);
                                        } else if (shape.equals((Object)RailShape.ASCENDING_SOUTH)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)RailShape.ASCENDING_NORTH);
                                        }
                                    }
                                    if (state.m_61138_((Property)BlockStateProperties.f_61404_) && !suYFatta) {
                                        shape = (RailShape)state.m_61143_((Property)BlockStateProperties.f_61404_);
                                        if (suXFatta) {
                                            if (shape.equals((Object)RailShape.ASCENDING_EAST)) {
                                                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61404_, (Comparable)RailShape.ASCENDING_WEST);
                                            } else if (shape.equals((Object)RailShape.ASCENDING_WEST)) {
                                                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61404_, (Comparable)RailShape.ASCENDING_EAST);
                                            }
                                        } else if (shape.equals((Object)RailShape.ASCENDING_NORTH)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61404_, (Comparable)RailShape.ASCENDING_SOUTH);
                                        } else if (shape.equals((Object)RailShape.ASCENDING_SOUTH)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61404_, (Comparable)RailShape.ASCENDING_NORTH);
                                        }
                                    }
                                    if (!suYFatta) {
                                        boolean n = state.m_61138_((Property)BlockStateProperties.f_61368_) ? (Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_) : false;
                                        boolean s = state.m_61138_((Property)BlockStateProperties.f_61370_) ? (Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_) : false;
                                        boolean e = state.m_61138_((Property)BlockStateProperties.f_61369_) ? (Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_) : false;
                                        boolean w = state.m_61138_((Property)BlockStateProperties.f_61371_) ? (Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_) : false;
                                        boolean fvN = n;
                                        boolean fvS = s;
                                        boolean fvE = e;
                                        boolean fvW = w;
                                        if (suZFatta) {
                                            if (n && !s) {
                                                fvS = true;
                                                fvN = false;
                                            } else if (s && !n) {
                                                fvN = true;
                                                fvS = false;
                                            }
                                        } else if (w && !e) {
                                            fvE = true;
                                            fvW = false;
                                        } else if (e && !w) {
                                            fvW = true;
                                            fvE = false;
                                        }
                                        if (state.m_61138_((Property)BlockStateProperties.f_61368_)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(fvN));
                                        }
                                        if (state.m_61138_((Property)BlockStateProperties.f_61370_)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(fvS));
                                        }
                                        if (state.m_61138_((Property)BlockStateProperties.f_61369_)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(fvE));
                                        }
                                        if (state.m_61138_((Property)BlockStateProperties.f_61371_)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(fvW));
                                        }
                                    } else {
                                        if (state.m_61138_((Property)BlockStateProperties.f_61402_)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)(((Half)state.m_61143_((Property)BlockStateProperties.f_61402_)).equals((Object)Half.BOTTOM) ? Half.TOP : Half.BOTTOM));
                                        }
                                        if (state.m_61138_((Property)BlockStateProperties.f_61397_)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)(((SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_)).equals((Object)SlabType.BOTTOM) ? SlabType.TOP : SlabType.BOTTOM));
                                        }
                                    }
                                    state = BlueprintDatas.doModdedBlockPropriety(state, false, (short)0, suXFatta, suYFatta, suZFatta);
                                }
                            }
                            blockdata = Operazioni.getBlockStateString(state);
                        } else {
                            blockdata = dati_blocco.getValue();
                        }
                        String string = nbt = this.BlocksNBT != null && this.BlocksNBT.containsKey(pos.m_123342_()) && this.BlocksNBT.get(pos.m_123342_()).containsKey(dati_blocco.getKey()) ? this.BlocksNBT.get(pos.m_123342_()).get(dati_blocco.getKey()) : "";
                        if (v == 0) {
                            mirror.addBlock(pos.m_123342_(), Operazioni.getVec3iString(new Vec3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())), blockdata, nbt);
                            continue;
                        }
                        mirror.addNonSolidBlock(pos.m_123342_(), Operazioni.getVec3iString(new Vec3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())), blockdata, nbt);
                    }
                }
            }
            return mirror;
        }

        public static boolean controlloBlocchiModdati(String blockdata) {
            String bloccoId = blockdata.substring(blockdata.indexOf("<bid>") + 5, blockdata.indexOf("</bid>"));
            String idMod = bloccoId.split(":")[0];
            String proprieta = blockdata = blockdata.replaceFirst("<bid>" + bloccoId + "</bid>", "");
            if (proprieta.equals("null")) {
                return false;
            }
            proprieta = proprieta.replace("<properties>", "").replace("</properties>", "");
            for (String v : proprieta.split(";!v!;")) {
                if (v.equals("")) continue;
                String nome = v.substring(v.indexOf("<name>") + 6, v.indexOf("</name>"));
                String valore = v.substring(v.indexOf("<value>") + 7, v.indexOf("</value>"));
                if (!idMod.equals("dramaticdoors") || !nome.equals("third") || valore.equals("lower")) continue;
                return true;
            }
            return false;
        }

        public static boolean ServerBlackListBlock(String blockdata) {
            String bloccoId = blockdata.substring(blockdata.indexOf("<bid>") + 5, blockdata.indexOf("</bid>"));
            return ModServerConfig.blacklistBlock.contains(bloccoId);
        }

        private static boolean respectCondition(Map<String, Tuple<String, Property>> proprietaBlocco, String condition) {
            String[] condizioni;
            for (String condizione : condizioni = condition.split(",")) {
                String[] data = condizione.split("=");
                if (proprietaBlocco.containsKey(data[0]) && ((String)proprietaBlocco.get(data[0]).m_14418_()).equalsIgnoreCase(data[1])) continue;
                return false;
            }
            return true;
        }

        public static Tuple<Boolean, BlockState> setCustomBlockProprietyRotate(String bloccoID, BlockState blockState, short rot) {
            boolean contieneBloccoID = false;
            try {
                if (CustomBlockProprietyHandle.Rotate.RULES.containsKey(bloccoID)) {
                    contieneBloccoID = true;
                    List<CustomBlockProprietyHandle.Rotate.Rule> rules = CustomBlockProprietyHandle.Rotate.RULES.get(bloccoID);
                    HashMap<String, Tuple<String, Property>> proprietaBlocco = new HashMap<String, Tuple<String, Property>>();
                    for (Property p : blockState.m_61147_()) {
                        proprietaBlocco.put(p.m_61708_(), new Tuple((Object)blockState.m_61143_(p).toString(), (Object)p));
                    }
                    for (CustomBlockProprietyHandle.Rotate.Rule rule : rules) {
                        if (rule.getRot() != rot) continue;
                        for (CustomBlockProprietyHandle.Rotate.PropertyRule pr : rule.properties) {
                            if (!BlueprintDatas.respectCondition(proprietaBlocco, pr.condition)) continue;
                            for (CustomBlockProprietyHandle.Rotate.PropertyValue propertyValue : pr.result) {
                                blockState = Operazioni.setDynamicProperty(blockState, (Property)((Tuple)proprietaBlocco.get(propertyValue.name)).m_14419_(), propertyValue.value);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                Mod.LOGGER.error("[Portable Blueprints] -> Custom block rotation propriety error!");
                Mod.LOGGER.error(e.getMessage());
            }
            return new Tuple((Object)contieneBloccoID, (Object)blockState);
        }

        public static Tuple<Boolean, BlockState> setCustomBlockProprietyMirrow(String bloccoID, BlockState blockState, boolean mirrowX, boolean mirrowY, boolean mirrowZ) {
            boolean contieneBloccoID = false;
            try {
                if (CustomBlockProprietyHandle.Mirror.RULES.containsKey(bloccoID)) {
                    contieneBloccoID = true;
                    List<CustomBlockProprietyHandle.Mirror.Rule> rules = CustomBlockProprietyHandle.Mirror.RULES.get(bloccoID);
                    for (CustomBlockProprietyHandle.Mirror.Rule rule : rules) {
                        if (!(rule.mirror.equals((Object)Direction.Axis.X) && mirrowX || rule.mirror.equals((Object)Direction.Axis.Y) && mirrowY) && (!rule.mirror.equals((Object)Direction.Axis.Z) || !mirrowZ)) continue;
                        HashMap<String, Tuple<String, Property>> proprietaBlocco = new HashMap<String, Tuple<String, Property>>();
                        for (Property p : blockState.m_61147_()) {
                            proprietaBlocco.put(p.m_61708_(), (Tuple<String, Property>)new Tuple((Object)blockState.m_61143_(p).toString(), (Object)p));
                        }
                        for (CustomBlockProprietyHandle.Mirror.PropertyRule pr : rule.properties) {
                            if (!BlueprintDatas.respectCondition(proprietaBlocco, pr.condition)) continue;
                            for (CustomBlockProprietyHandle.Mirror.PropertyValue propertyValue : pr.result) {
                                blockState = Operazioni.setDynamicProperty(blockState, (Property)((Tuple)proprietaBlocco.get(propertyValue.name)).m_14419_(), propertyValue.value);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                Mod.printLoggerError("Custom block mirror propriety error!");
                Mod.printLoggerError(e.getMessage());
            }
            return new Tuple((Object)contieneBloccoID, (Object)blockState);
        }

        public static BlockState doModdedBlockPropriety(BlockState state, boolean rotation, short rot, boolean MX, boolean MY, boolean MZ) {
            String blockModId = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()).m_135827_();
            HashMap<String, Tuple> proprietaBlocco = new HashMap<String, Tuple>();
            for (Property p : state.m_61147_()) {
                proprietaBlocco.put(p.m_61708_(), new Tuple((Object)state.m_61143_(p).toString(), (Object)p));
            }
            if (rotation) {
                if (blockModId.equals("diagonalwalls") || blockModId.equals("diagonalfences")) {
                    boolean nw = proprietaBlocco.containsKey("north_west") ? Boolean.parseBoolean((String)((Tuple)proprietaBlocco.get("north_west")).m_14418_()) : false;
                    boolean ne = proprietaBlocco.containsKey("north_east") ? Boolean.parseBoolean((String)((Tuple)proprietaBlocco.get("north_east")).m_14418_()) : false;
                    boolean sw = proprietaBlocco.containsKey("south_west") ? Boolean.parseBoolean((String)((Tuple)proprietaBlocco.get("south_west")).m_14418_()) : false;
                    boolean se = proprietaBlocco.containsKey("south_east") ? Boolean.parseBoolean((String)((Tuple)proprietaBlocco.get("south_east")).m_14418_()) : false;
                    boolean vfNW = false;
                    boolean vfNE = false;
                    boolean vfSW = false;
                    boolean vfSE = false;
                    if (nw) {
                        if (rot != 0) {
                            nw = false;
                        }
                        switch (rot) {
                            case 1: {
                                vfNE = true;
                                break;
                            }
                            case 2: {
                                vfSE = true;
                                break;
                            }
                            case 3: {
                                vfSW = true;
                            }
                        }
                    }
                    if (ne) {
                        if (rot != 0) {
                            ne = false;
                        }
                        switch (rot) {
                            case 1: {
                                vfSE = true;
                                break;
                            }
                            case 2: {
                                vfSW = true;
                                break;
                            }
                            case 3: {
                                vfNW = true;
                            }
                        }
                    }
                    if (se) {
                        if (rot != 0) {
                            se = false;
                        }
                        switch (rot) {
                            case 1: {
                                vfSW = true;
                                break;
                            }
                            case 2: {
                                vfNW = true;
                                break;
                            }
                            case 3: {
                                vfNE = true;
                            }
                        }
                    }
                    if (sw) {
                        if (rot != 0) {
                            sw = false;
                        }
                        switch (rot) {
                            case 1: {
                                vfNW = true;
                                break;
                            }
                            case 2: {
                                vfNE = true;
                                break;
                            }
                            case 3: {
                                vfSE = true;
                            }
                        }
                    }
                    if (proprietaBlocco.containsKey("north_west")) {
                        state = (BlockState)state.m_61124_((Property)((Tuple)proprietaBlocco.get("north_west")).m_14419_(), (Comparable)Boolean.valueOf(vfNW || nw));
                    }
                    if (proprietaBlocco.containsKey("north_east")) {
                        state = (BlockState)state.m_61124_((Property)((Tuple)proprietaBlocco.get("north_east")).m_14419_(), (Comparable)Boolean.valueOf(vfNE || ne));
                    }
                    if (proprietaBlocco.containsKey("south_west")) {
                        state = (BlockState)state.m_61124_((Property)((Tuple)proprietaBlocco.get("south_west")).m_14419_(), (Comparable)Boolean.valueOf(vfSW || sw));
                    }
                    if (proprietaBlocco.containsKey("south_east")) {
                        state = (BlockState)state.m_61124_((Property)((Tuple)proprietaBlocco.get("south_east")).m_14419_(), (Comparable)Boolean.valueOf(vfSE || se));
                    }
                }
            } else if ((blockModId.equals("diagonalwalls") || blockModId.equals("diagonalfences")) && !MY) {
                boolean nw = proprietaBlocco.containsKey("north_west") ? Boolean.parseBoolean((String)((Tuple)proprietaBlocco.get("north_west")).m_14418_()) : false;
                boolean ne = proprietaBlocco.containsKey("north_east") ? Boolean.parseBoolean((String)((Tuple)proprietaBlocco.get("north_east")).m_14418_()) : false;
                boolean sw = proprietaBlocco.containsKey("south_west") ? Boolean.parseBoolean((String)((Tuple)proprietaBlocco.get("south_west")).m_14418_()) : false;
                boolean se = proprietaBlocco.containsKey("south_east") ? Boolean.parseBoolean((String)((Tuple)proprietaBlocco.get("south_east")).m_14418_()) : false;
                boolean vfNW = nw;
                boolean vfNE = ne;
                boolean vfSW = sw;
                boolean vfSE = se;
                if (MZ) {
                    if (nw && !sw) {
                        vfSW = true;
                        vfNW = false;
                    } else if (sw && !nw) {
                        vfNW = true;
                        vfSW = false;
                    }
                    if (ne && !se) {
                        vfSE = true;
                        vfNE = false;
                    } else if (se && !ne) {
                        vfNE = true;
                        vfSE = false;
                    }
                } else {
                    if (sw && !se) {
                        vfSE = true;
                        vfSW = false;
                    } else if (se && !sw) {
                        vfSW = true;
                        vfSE = false;
                    }
                    if (nw && !ne) {
                        vfNE = true;
                        vfNW = false;
                    } else if (ne && !nw) {
                        vfNW = true;
                        vfNE = false;
                    }
                }
                if (proprietaBlocco.containsKey("north_west")) {
                    state = (BlockState)state.m_61124_((Property)((Tuple)proprietaBlocco.get("north_west")).m_14419_(), (Comparable)Boolean.valueOf(vfNW));
                }
                if (proprietaBlocco.containsKey("north_east")) {
                    state = (BlockState)state.m_61124_((Property)((Tuple)proprietaBlocco.get("north_east")).m_14419_(), (Comparable)Boolean.valueOf(vfNE));
                }
                if (proprietaBlocco.containsKey("south_west")) {
                    state = (BlockState)state.m_61124_((Property)((Tuple)proprietaBlocco.get("south_west")).m_14419_(), (Comparable)Boolean.valueOf(vfSW));
                }
                if (proprietaBlocco.containsKey("south_east")) {
                    state = (BlockState)state.m_61124_((Property)((Tuple)proprietaBlocco.get("south_east")).m_14419_(), (Comparable)Boolean.valueOf(vfSE));
                }
            }
            return state;
        }
    }

    private static class BlueprintStructure {
        public List<BlockPos> posDiEspansione = new ArrayList<BlockPos>();
        public boolean solidi = true;
        public ServerLevel serverLevel;
        public BlueprintDatas bd;
        public List<BlockPos> posizione_container;
        public Player owner;
        public boolean free_build;
        public short allow_nbt = (short)-1;
        public boolean emc_active = false;

        public BlueprintStructure(ServerLevel serverLevel, BlueprintDatas bd, Player player, List<BlockPos> posizione_container, boolean free_build, short allow_nbt, boolean emc_active) {
            this.serverLevel = serverLevel;
            this.owner = player;
            this.bd = bd;
            this.posizione_container = posizione_container;
            this.free_build = free_build;
            this.allow_nbt = allow_nbt;
            if (ModCompatibilityInit.isProjectELoaded) {
                this.emc_active = emc_active;
            }
            this.posDiEspansione.add(new BlockPos(bd.lunghezzaX - 1, 0, bd.lunghezzaZ - 1));
        }
    }

    public static class SharedWithMe {
        public List<String> SharedWithOthersBlueprints = new ArrayList<String>();
        public List<String> SharedWithMeBlueprints = new ArrayList<String>();

        public void addSharedWithMeBlueprint(UUID PlayerCheCondivideIlSuoBlueprint, String NomeBlueprint) {
            String dato = "<owner>" + PlayerCheCondivideIlSuoBlueprint.toString() + "</owner><name>" + NomeBlueprint + "</name>";
            if (!this.SharedWithMeBlueprints.contains(dato)) {
                this.SharedWithMeBlueprints.add(dato);
            }
        }

        public void removeSharedWithMeBlueprint(UUID PlayerCheCondivideIlSuoBlueprint, String NomeBlueprint) {
            String dato = "<owner>" + PlayerCheCondivideIlSuoBlueprint.toString() + "</owner><name>" + NomeBlueprint + "</name>";
            if (this.SharedWithMeBlueprints.contains(dato)) {
                this.SharedWithMeBlueprints.remove(dato);
            }
        }

        public void addSharedWithOthersBlueprint(UUID PlayerAQuiVaIlBlueprint, String NomeBlueprint) {
            String dato = "<shared_with>" + PlayerAQuiVaIlBlueprint.toString() + "</shared_with><name>" + NomeBlueprint + "</name>";
            if (!this.SharedWithOthersBlueprints.contains(dato)) {
                this.SharedWithOthersBlueprints.add(dato);
            }
        }

        public void removeSharedWithOthersBlueprint(UUID PlayerAQuiVaIlBlueprint, String NomeBlueprint) {
            String dato = "<shared_with>" + PlayerAQuiVaIlBlueprint.toString() + "</shared_with><name>" + NomeBlueprint + "</name>";
            if (this.SharedWithOthersBlueprints.contains(dato)) {
                this.SharedWithOthersBlueprints.remove(dato);
            }
        }

        public boolean ContieneSWMBlueprint(UUID PlayerCheCondivideIlSuoBlueprint, String NomeBlueprint) {
            return this.SharedWithMeBlueprints.contains("<owner>" + PlayerCheCondivideIlSuoBlueprint.toString() + "</owner><name>" + NomeBlueprint + "</name>");
        }

        public boolean ContieneSWOBlueprint(UUID PlayerConQuiCondivideBlueprint, String NomeBlueprint) {
            return this.SharedWithOthersBlueprints.contains("<shared_with>" + PlayerConQuiCondivideBlueprint.toString() + "</shared_with><name>" + NomeBlueprint + "</name>");
        }

        public List<UUID> getAllSpecificSWOBPlayersUUID(String nome_blueprint) {
            ArrayList<UUID> trovati = new ArrayList<UUID>();
            for (String v : this.SharedWithOthersBlueprints) {
                if (!Operazioni.getValueInsideTag(v, "name").equals(nome_blueprint)) continue;
                trovati.add(UUID.fromString(Operazioni.getValueInsideTag(v, "shared_with")));
            }
            return trovati;
        }
    }

    public static class BlueprintPermission {
        public Map<String, Boolean> BlueprintsPermissionSetup = new HashMap<String, Boolean>();
        public Map<UUID, List<String>> PlayerPermission = new HashMap<UUID, List<String>>();

        public void addServerBlueprintPermission(String nome, boolean isFree) {
            this.BlueprintsPermissionSetup.put(nome, isFree);
        }

        public void removeServerBlueprintPermission(String nome) {
            this.BlueprintsPermissionSetup.remove(nome);
            for (UUID uuid : this.PlayerPermission.keySet()) {
                ArrayList<String> remValues = new ArrayList<String>();
                for (String permission : this.PlayerPermission.get(uuid)) {
                    if (!permission.contains("<name>" + nome + "</name>")) continue;
                    remValues.add(permission);
                }
                for (String remove : remValues) {
                    this.PlayerPermission.get(uuid).remove(remove);
                }
            }
        }

        public void setPermissionForPlayer(ServerPlayer player, String nome, boolean hasPermission) {
            if (!this.BlueprintsPermissionSetup.containsKey(nome)) {
                return;
            }
            if (!this.PlayerPermission.containsKey(player.m_20148_())) {
                this.PlayerPermission.put(player.m_20148_(), new ArrayList());
            }
            if (this.PlayerPermission.get(player.m_20148_()).contains("<name>" + nome + "</name><permission>false</permission>")) {
                this.PlayerPermission.get(player.m_20148_()).remove("<name>" + nome + "</name><permission>false</permission>");
            }
            if (this.PlayerPermission.get(player.m_20148_()).contains("<name>" + nome + "</name><permission>true</permission>")) {
                this.PlayerPermission.get(player.m_20148_()).remove("<name>" + nome + "</name><permission>true</permission>");
            }
            this.PlayerPermission.get(player.m_20148_()).add("<name>" + nome + "</name><permission>" + hasPermission + "</permission>");
        }

        public List<String> getPlayerAllAllowedBlueprints(UUID player) {
            ArrayList<String> bps = new ArrayList<String>();
            for (String nome : this.BlueprintsPermissionSetup.keySet()) {
                if (!this.BlueprintsPermissionSetup.get(nome).booleanValue() && (!this.PlayerPermission.containsKey(player) || !this.PlayerPermission.get(player).contains("<name>" + nome + "</name><permission>true</permission>"))) continue;
                bps.add(nome);
            }
            return bps;
        }
    }
}

