/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.altro;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import nimble.portable_blueprints.portable_blueprints.Mod;

@Mod.EventBusSubscriber
public class CustomBlockProprietyHandle {
    private static final Gson GSON = new Gson();
    private static final String rotateInterno = "/portable_blueprints/settings/blueprint_rotation_settings.json";
    private static final String mirrorInterno = "/portable_blueprints/settings/blueprint_mirror_settings.json";
    private static final String DirUtente = "config/portable_blueprints/custom_block_propriety_handle";

    @SubscribeEvent
    public static void load(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        Path worldDir = server.m_129843_(LevelResource.f_78182_);
        Path CBPHWorldDir = worldDir.resolve("portable_blueprints/custom_block_propriety_handle");
        Path modpackCBPHSourceDir = FMLPaths.GAMEDIR.get().resolve(DirUtente);
        CustomBlockProprietyHandle.creaDirectoryConFileSetting();
        Map<String, List<Rotate.Rule>> modRules = new HashMap<String, List<Rotate.Rule>>();
        try (InputStream in = CustomBlockProprietyHandle.class.getResourceAsStream(rotateInterno);){
            if (in == null) {
                throw new IOException("Internal Rotation Settings File not found!");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                Type type = new TypeToken<Map<String, List<Rotate.Rule>>>(){}.getType();
                modRules = (Map)GSON.fromJson((Reader)reader, type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map userRules = new HashMap();
        File userFile = CBPHWorldDir.resolve("rotation_settings.json").toFile();
        if (userFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(userFile, StandardCharsets.UTF_8));){
                Type type = new TypeToken<Map<String, List<Rotate.Rule>>>(){}.getType();
                userRules = (Map)GSON.fromJson((Reader)reader, type);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Rotate.RULES = modRules;
        if (userRules != null && !userRules.isEmpty()) {
            for (String key : userRules.keySet()) {
                if (Rotate.RULES.containsKey(key)) {
                    Rotate.RULES.replace(key, (List)userRules.get(key));
                    continue;
                }
                Rotate.RULES.put(key, (List)userRules.get(key));
            }
        }
        Map<String, List<Mirror.Rule>> modmirrorRules = new HashMap<String, List<Mirror.Rule>>();
        try (InputStream in = CustomBlockProprietyHandle.class.getResourceAsStream(mirrorInterno);){
            if (in == null) {
                throw new IOException("Internal mirror Settings File not found!");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                Type type = new TypeToken<Map<String, List<Mirror.Rule>>>(){}.getType();
                modmirrorRules = (Map)GSON.fromJson((Reader)reader, type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map usermirrorRules = new HashMap();
        File usermirrorFile = CBPHWorldDir.resolve("mirror_settings.json").toFile();
        if (usermirrorFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(usermirrorFile, StandardCharsets.UTF_8));){
                Type type = new TypeToken<Map<String, List<Mirror.Rule>>>(){}.getType();
                usermirrorRules = (Map)GSON.fromJson((Reader)reader, type);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Mirror.RULES = modmirrorRules;
        if (usermirrorRules != null && !usermirrorRules.isEmpty()) {
            for (String key : usermirrorRules.keySet()) {
                if (Mirror.RULES.containsKey(key)) {
                    Mirror.RULES.replace(key, (List)usermirrorRules.get(key));
                    continue;
                }
                Mirror.RULES.put(key, (List)usermirrorRules.get(key));
            }
        }
    }

    public static void creaDirectoryConFileSetting() {
        block19: {
            FileWriter writer;
            Path modpackBpSourceDir;
            block18: {
                modpackBpSourceDir = FMLPaths.GAMEDIR.get().resolve(DirUtente);
                try {
                    Files.createDirectories(modpackBpSourceDir, new FileAttribute[0]);
                    File WorldCustomBlockProprietyHandleRotation = new File(modpackBpSourceDir.toFile(), "rotation_settings.json");
                    if (WorldCustomBlockProprietyHandleRotation.exists()) break block18;
                    try {
                        writer = new FileWriter(WorldCustomBlockProprietyHandleRotation);
                        try {
                            writer.write("//Introduction to using Custom Block Property Handle Rotation:\n");
                            writer.write("//Here you can modify the final result of any blocks you want during blueprint rotation.\n");
                            writer.write("//Warning: once you add any block here, it will no longer be affected by the automatic rotation handled by the mod!\n");
                            writer.write("//The mod already includes an internal file like this, but any block you define here will override the internal one and take priority. (Priority order is always: user settings > mod default)\n");
                            writer.write("//For details on how to use this file, please refer to the wiki on the mod\u2019s GitHub: https://github.com/Nimblonia/Mod_Portable_blueprint_Community/discussions/17\n");
                            writer.write("{}");
                        }
                        finally {
                            writer.close();
                        }
                    }
                    catch (IOException e) {
                        Mod.LOGGER.error("[Portable blueprint] -> Create rotation_settings.json File error:");
                        Mod.LOGGER.error(e.getMessage());
                    }
                }
                catch (Exception e) {
                    Mod.LOGGER.error("[Portable blueprint] -> Create rotation_settings.json File error:");
                    Mod.LOGGER.error(e.getMessage());
                }
            }
            try {
                Files.createDirectories(modpackBpSourceDir, new FileAttribute[0]);
                File WorldCustomBlockProprietyHandlemirror = new File(modpackBpSourceDir.toFile(), "mirror_settings.json");
                if (WorldCustomBlockProprietyHandlemirror.exists()) break block19;
                try {
                    writer = new FileWriter(WorldCustomBlockProprietyHandlemirror);
                    try {
                        writer.write("//Introduction to using Custom Block Property Handle mirror:\n");
                        writer.write("//Here you can modify the final result of any blocks you want during blueprint XYZ mirroring.\n");
                        writer.write("//Warning: once you add any block here, it will no longer be affected by the automatic XYZ mirroring handled by the mod!\n");
                        writer.write("//The mod already includes an internal file like this, but any block you define here will override the internal one and take priority. (Priority order is always: user settings > mod default)\n");
                        writer.write("//For details on how to use this file, please refer to the wiki on the mod\u2019s GitHub: https://github.com/Nimblonia/Mod_Portable_blueprint_Community/discussions/17\n");
                        writer.write("{}");
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    Mod.LOGGER.error("[Portable blueprint] -> Create mirror_settings.json File error:");
                    Mod.LOGGER.error(e.getMessage());
                }
            }
            catch (Exception e) {
                Mod.LOGGER.error("[Portable blueprint] -> Create mirror_settings.json File error:");
                Mod.LOGGER.error(e.getMessage());
            }
        }
    }

    public static class Rotate {
        public static Map<String, List<Rule>> RULES = new HashMap<String, List<Rule>>();

        public static class PropertyValue {
            public String name;
            public String value;
        }

        public static class PropertyRule {
            public String condition;
            public List<PropertyValue> result = new ArrayList<PropertyValue>();
        }

        public static class Rule {
            public short rotation;
            public List<PropertyRule> properties;

            public short getRot() {
                return this.rotation;
            }
        }
    }

    public static class Mirror {
        public static Map<String, List<Rule>> RULES = new HashMap<String, List<Rule>>();

        public static class PropertyValue {
            public String name;
            public String value;
        }

        public static class PropertyRule {
            public String condition;
            public List<PropertyValue> result = new ArrayList<PropertyValue>();
        }

        public static class Rule {
            public Direction.Axis mirror;
            public List<PropertyRule> properties;
        }
    }
}

