/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import nimble.portable_blueprints.Events.ModEventClientForge;
import nimble.portable_blueprints.entity.client.BusinessVillagerModel;
import nimble.portable_blueprints.entity.client.ModModelLayers;
import nimble.portable_blueprints.entity.custom.BusinessVillagerEntity;
import nimble.portable_blueprints.network.CtoS_CreateRemoveBlockWorkRequest;
import nimble.portable_blueprints.network.PacketHandler;

public class BusinessVillagerRenderer
extends MobRenderer<BusinessVillagerEntity, BusinessVillagerModel<BusinessVillagerEntity>> {
    private final BusinessVillagerModel<BusinessVillagerEntity> model;
    private UUID TargetBP = null;

    public BusinessVillagerRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new BusinessVillagerModel(ctx.m_174023_(ModModelLayers.BUSINESS_VILLAGER_LAYER)), 0.4f);
        this.model = new BusinessVillagerModel(ctx.m_174023_(ModModelLayers.BUSINESS_VILLAGER_LAYER));
    }

    public ResourceLocation getTextureLocation(BusinessVillagerEntity businessVillagerEntity) {
        return new ResourceLocation("portable_blueprints", "textures/entity/business_villager.png");
    }

    public void render(BusinessVillagerEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.m_7392_((Mob)entity, yaw, partialTicks, poseStack, buffer, packedLight);
        if (this.TargetBP == null) {
            this.TargetBP = entity.getTargetBP();
        } else if (Minecraft.m_91087_().f_91074_.m_20148_().equals(this.TargetBP) && entity.animationProgress >= 0.5f) {
            float size = 0.6f * ((entity.animationProgress - 0.5f) / 0.5f);
            boolean Selected = this.renderItem(poseStack, new Vec3(0.75, 0.5, 0.0), Items.f_42390_, size, entity, buffer, packedLight, partialTicks);
            if (!entity.selezionato && Selected) {
                entity.selezionato = true;
                Thread tickerThread = new Thread(() -> {
                    ArrayList<Tuple<Long, BlockPos>> copy = new ArrayList<Tuple<Long, BlockPos>>(ModEventClientForge.ObstructionBlockManager.Blocks);
                    try {
                        for (Tuple tuple : copy) {
                            PacketHandler.sendToServer(new CtoS_CreateRemoveBlockWorkRequest((BlockPos)tuple.m_14419_()));
                            Thread.sleep(5L);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Thread.currentThread().interrupt();
                    }
                });
                tickerThread.setDaemon(true);
                tickerThread.start();
            }
        }
    }

    private boolean renderItem(PoseStack poseStack, Vec3 currentPos, Item item, float baseSize, BusinessVillagerEntity entity, MultiBufferSource buffer, int packedLight, float partialTicks) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Vec3 worldOffset = this.transformOffset(entity, currentPos);
        Vec3 itemWorldPos = new Vec3(entity.m_20185_() + worldOffset.f_82479_, entity.m_20186_() + worldOffset.f_82480_ + (double)entity.m_20206_() * 0.5, entity.m_20189_() + worldOffset.f_82481_);
        Vec3 eyePos = player.m_20299_(partialTicks);
        Vec3 viewVec = player.m_20252_(partialTicks);
        Vec3 toItem = itemWorldPos.m_82546_(eyePos);
        double distance = toItem.m_82553_();
        Vec3 toItemNorm = distance > 1.0E-4 ? toItem.m_82541_() : Vec3.f_82478_;
        double dot = viewVec.m_82526_(toItemNorm);
        dot = Mth.m_14036_((float)((float)dot), (float)-1.0f, (float)1.0f);
        double angleRad = Math.acos(dot);
        double maxDistance = 20.0;
        double angleThresholdDeg = 6.0;
        double angleThreshold = Math.toRadians(angleThresholdDeg);
        double maxScaleBoost = 1.0;
        float scale = baseSize;
        if (distance <= maxDistance && angleRad <= angleThreshold && player.m_20270_((Entity)entity) <= 3.0f) {
            double angleFactor = 1.0 - angleRad / angleThreshold;
            double distanceFactor = 1.0 - distance / maxDistance;
            if (distanceFactor < 0.0) {
                distanceFactor = 0.0;
            }
            double combined = angleFactor * distanceFactor;
            double boost = 1.0 + combined * maxScaleBoost;
            scale = (float)((double)baseSize * boost);
        }
        poseStack.m_85836_();
        poseStack.m_85837_(worldOffset.f_82479_, worldOffset.f_82480_ + (double)entity.m_20206_() * 0.5, worldOffset.f_82481_);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-entity.m_146908_()));
        poseStack.m_85841_(scale, scale, scale);
        Minecraft.m_91087_().m_91291_().m_269128_(new ItemStack((ItemLike)item), ItemDisplayContext.GROUND, packedLight, OverlayTexture.f_118083_, poseStack, buffer, entity.m_9236_(), 0);
        poseStack.m_85849_();
        return scale != baseSize && Minecraft.m_91087_().f_91066_.f_92095_.m_90857_();
    }

    private Vec3 transformOffset(BusinessVillagerEntity entity, Vec3 localOffset) {
        double yawRad = Math.toRadians(entity.m_146908_());
        double sin = Math.sin(yawRad);
        double cos = Math.cos(yawRad);
        Vec3 forward = new Vec3(-sin, 0.0, cos);
        Vec3 right = new Vec3(cos, 0.0, sin);
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        return forward.m_82490_(localOffset.f_82479_).m_82549_(up.m_82490_(localOffset.f_82480_)).m_82549_(right.m_82490_(localOffset.f_82481_));
    }
}

