/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.init;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.request_server_tags.CtoS_RequestServerTags;
import nimble.portable_blueprints.portable_blueprints.Mod;

public class ModTabletTags {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static List<TagData> TagDatas = new ArrayList<TagData>();
    public static Map<String, List<String>> BlueprintTagsData = new HashMap<String, List<String>>();

    public static TagData getTagByID(String v) {
        for (TagData td : TagDatas) {
            if (!td.getOriginalTag().equals(v)) continue;
            return td;
        }
        return null;
    }

    public static class TagData {
        public Map<String, String> tag_name = new HashMap<String, String>();

        public TagData() {
        }

        public TagData(Map<String, String> tag_name) {
            this.tag_name = tag_name;
        }

        public String getCurrentLenguageTag() {
            Minecraft mc = Minecraft.m_91087_();
            LanguageManager langManager = mc.m_91102_();
            String li = langManager.m_264236_();
            if (this.tag_name.containsKey(li)) {
                return this.tag_name.get(li);
            }
            return this.tag_name.getOrDefault("en_us", "");
        }

        public String getOriginalTag() {
            return this.tag_name.getOrDefault("en_us", "");
        }
    }

    @Mod.EventBusSubscriber(modid="portable_blueprints")
    public class ServerSide {
        @SubscribeEvent
        public static void serverStart(ServerStartedEvent event) {
            block20: {
                FileWriter writer2;
                File CBPHWorldDir;
                Path worldDir;
                block19: {
                    MinecraftServer server = event.getServer();
                    worldDir = server.m_129843_(LevelResource.f_78182_);
                    CBPHWorldDir = worldDir.resolve("serverconfig").toFile();
                    try {
                        CBPHWorldDir.mkdir();
                        File server_tags = new File(CBPHWorldDir, "server_tags.json");
                        if (server_tags.exists()) break block19;
                        try {
                            writer2 = new FileWriter(server_tags);
                            try {
                                GSON.toJson(TagDatas, (Appendable)writer2);
                            }
                            finally {
                                writer2.close();
                            }
                        }
                        catch (IOException writer2) {}
                    }
                    catch (Exception e) {
                        Mod.printLoggerError("Can't load Tags from the world/server!");
                    }
                }
                CBPHWorldDir = worldDir.resolve("portable_blueprints/general").toFile();
                try {
                    CBPHWorldDir.mkdir();
                    File blueprints_tags = new File(CBPHWorldDir, "blueprints_tags.data");
                    if (!blueprints_tags.exists()) {
                        try {
                            writer2 = new FileWriter(blueprints_tags);
                            try {
                                GSON.toJson(BlueprintTagsData, (Appendable)writer2);
                                break block20;
                            }
                            finally {
                                writer2.close();
                            }
                        }
                        catch (IOException writer3) {}
                        break block20;
                    }
                    Type type = new TypeToken<Map<String, List<String>>>(){}.getType();
                    BlueprintTagsData = (Map)GSON.fromJson((Reader)new FileReader(blueprints_tags), type);
                }
                catch (Exception e) {
                    Mod.printLoggerError("Can't load Blueprints Tags from the world/server!");
                }
            }
        }

        @SubscribeEvent
        public static void onServerSave(LevelEvent.Save event) {
            MinecraftServer server = event.getLevel().m_7654_();
            Path worldDir = server.m_129843_(LevelResource.f_78182_);
            File blueprints_tags = new File(worldDir.resolve("portable_blueprints/general").toFile(), "blueprints_tags.data");
            try (FileWriter writer = new FileWriter(blueprints_tags);){
                GSON.toJson(BlueprintTagsData, (Appendable)writer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public static File getFile(ServerLevel level) {
            MinecraftServer server = level.m_7654_();
            Path worldDir = server.m_129843_(LevelResource.f_78182_);
            File CBPHWorldDir = worldDir.resolve("serverconfig").toFile();
            return new File(CBPHWorldDir, "server_tags.json");
        }
    }

    @Mod.EventBusSubscriber(modid="portable_blueprints", value={Dist.CLIENT})
    public class ClientSide {
        @SubscribeEvent
        public static void onClientLogin(ClientPlayerNetworkEvent.LoggingIn event) {
            try (InputStream is = ModTabletTags.class.getResourceAsStream("/portable_blueprints/settings/tags.json");){
                if (is == null) {
                    throw new IOException("tags.json not found in internal settings");
                }
                try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                    Type listType = new TypeToken<List<TagData>>(){}.getType();
                    TagDatas = (List)GSON.fromJson((Reader)reader, listType);
                }
            }
            catch (Exception e) {
                Mod.printLoggerError("Can't load Tags from the mod!");
                e.printStackTrace();
            }
            PacketHandler.sendToServer(new CtoS_RequestServerTags());
        }
    }
}

