/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.init;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import nimble.portable_blueprints.portable_blueprints.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class TabletClientDatas {
    private static final Gson GSON = new Gson();
    private static final Path dir = FMLPaths.GAMEDIR.get().resolve("portable_blueprints/tablet_data");
    private static Datas datas = new Datas();
    private static Settings settings = new Settings();

    @SubscribeEvent
    public static void onClientJoinWorld(ClientPlayerNetworkEvent.LoggingIn event) {
        TabletClientDatas.load();
    }

    public static void save() {
        FileWriter writer2;
        File file;
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            file = new File(dir.toUri());
            file = new File(file, TabletClientDatas.getCurrentWorldOrServerId() + ".data");
            try {
                writer2 = new FileWriter(file);
                try {
                    GSON.toJson((Object)datas, (Appendable)writer2);
                }
                finally {
                    writer2.close();
                }
            }
            catch (IOException writer2) {}
        }
        catch (Exception e) {
            Mod.printLoggerError("Can't create tablet data file `" + TabletClientDatas.getCurrentWorldOrServerId() + "`!");
        }
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            file = new File(dir.toUri());
            file = new File(file, "tablet_settings.data");
            try {
                writer2 = new FileWriter(file);
                try {
                    GSON.toJson((Object)settings, (Appendable)writer2);
                }
                finally {
                    writer2.close();
                }
            }
            catch (IOException iOException) {}
        }
        catch (Exception e) {
            Mod.printLoggerError("Can't create tablet settings data file!");
        }
    }

    public static void load() {
        File file;
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            file = new File(dir.toUri());
            file = new File(file, TabletClientDatas.getCurrentWorldOrServerId() + ".data");
            if (file.exists()) {
                datas = (Datas)GSON.fromJson((Reader)new FileReader(file), Datas.class);
            } else {
                datas = new Datas();
                TabletClientDatas.save();
            }
        }
        catch (Exception e) {
            Mod.printLoggerError("Can't load tablet data file `" + TabletClientDatas.getCurrentWorldOrServerId() + "`!");
        }
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            file = new File(dir.toUri());
            file = new File(file, "tablet_settings.data");
            if (file.exists()) {
                settings = (Settings)GSON.fromJson((Reader)new FileReader(file), Settings.class);
            } else {
                settings = new Settings();
                TabletClientDatas.save();
            }
        }
        catch (Exception e) {
            Mod.printLoggerError("Can't load tablet settings data file!");
        }
    }

    public static String getCurrentWorldOrServerId() {
        IntegratedServer server;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91090_() && (server = mc.m_91092_()) != null) {
            String levelName = server.m_129910_().m_5462_();
            Path worldPath = server.m_6237_().toPath().resolve("saves").resolve(levelName);
            String uniqueId = Integer.toHexString(worldPath.toString().hashCode());
            return "world_" + levelName.toLowerCase().replaceAll("[^a-z0-9_-]", "_") + "_" + uniqueId;
        }
        ServerData data = mc.m_91089_();
        if (data != null) {
            String safeName = data.f_105362_.toLowerCase().replaceAll("[^a-z0-9_-]", "_");
            String ipHash = Integer.toHexString(data.f_105363_.hashCode());
            return "server_" + safeName + "_" + ipHash;
        }
        return "unknown_world";
    }

    public static Datas getDatas() {
        if (datas == null) {
            datas = new Datas();
        }
        return datas;
    }

    public static Settings getSettings() {
        if (settings == null) {
            settings = new Settings();
        }
        return settings;
    }

    public static void setDatas(Datas data) {
        datas = data;
    }

    public static void setSettings(Settings setting) {
        settings = setting;
    }

    public static class Datas {
        public List<Tuple<String, UUID>> followedData = new ArrayList<Tuple<String, UUID>>();
    }

    public static class Settings {
        public short selectedBG = 1;
    }
}

