/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import nimble.portable_blueprints.altro.BlockBlueprintUsage;
import nimble.portable_blueprints.altro.Blueprint;

public class CtoS_CreateBlueprint {
    private static Map<UUID, PachettoDati> DatiPachetto = new HashMap<UUID, PachettoDati>();
    private final BlockPos angolo1;
    private final BlockPos angolo2;
    private final String nome;
    private final boolean consideraCreativeBlocks;
    private final UUID uuidRichiesta;
    private final String datoLista;

    public CtoS_CreateBlueprint() {
        this.angolo1 = new BlockPos(0, 0, 0);
        this.angolo2 = new BlockPos(0, 0, 0);
        this.nome = "";
        this.consideraCreativeBlocks = false;
        this.datoLista = "";
        this.uuidRichiesta = UUID.randomUUID();
    }

    public CtoS_CreateBlueprint(BlockPos angolo1, BlockPos angolo2, String nome, boolean consideraCreativeBlocks, UUID uuidRichiesta) {
        this.angolo1 = angolo1;
        this.angolo2 = angolo2;
        this.nome = nome;
        this.consideraCreativeBlocks = consideraCreativeBlocks;
        this.datoLista = "";
        this.uuidRichiesta = uuidRichiesta;
    }

    public CtoS_CreateBlueprint(String dato, UUID uuidRichiesta) {
        this.angolo1 = new BlockPos(0, 0, 0);
        this.angolo2 = new BlockPos(0, 0, 0);
        this.nome = "";
        this.consideraCreativeBlocks = false;
        this.datoLista = dato;
        this.uuidRichiesta = uuidRichiesta;
    }

    public CtoS_CreateBlueprint(FriendlyByteBuf buffer) {
        this.angolo1 = buffer.m_130135_();
        this.angolo2 = buffer.m_130135_();
        this.nome = buffer.m_130277_();
        this.consideraCreativeBlocks = buffer.readBoolean();
        this.datoLista = buffer.m_130277_();
        this.uuidRichiesta = buffer.m_130259_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.angolo1);
        buffer.m_130064_(this.angolo2);
        buffer.m_130070_(this.nome);
        buffer.writeBoolean(this.consideraCreativeBlocks);
        buffer.m_130070_(this.datoLista);
        buffer.m_130077_(this.uuidRichiesta);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ServerLevel level = player.m_284548_();
            if (BlockBlueprintUsage.PlayersBlock.contains(player.m_7755_().getString())) {
                if (!this.nome.equals("")) {
                    player.m_5661_((Component)Component.m_237115_((String)"chat_message.portable_blueprints.block_scanner").m_130940_(ChatFormatting.RED), false);
                }
                return;
            }
            if ((this.nome.equals("") || this.nome.isEmpty()) && DatiPachetto.containsKey(this.uuidRichiesta)) {
                if (this.datoLista.equals("\ufffdEND\ufffd")) {
                    PachettoDati pachettoDati = DatiPachetto.get(this.uuidRichiesta);
                    Blueprint.CreateBlueprint(level, pachettoDati.angolo1, pachettoDati.angolo2, pachettoDati.nome, player.m_20148_(), pachettoDati.consideraCreativeBlocks, pachettoDati.ScannerIgnoredBlocks);
                    DatiPachetto.remove(this.uuidRichiesta);
                } else {
                    CtoS_CreateBlueprint.DatiPachetto.get((Object)this.uuidRichiesta).ScannerIgnoredBlocks.add(this.datoLista);
                }
            } else if (!(this.nome.equals("") || this.nome.isEmpty() || DatiPachetto.containsKey(this.uuidRichiesta))) {
                DatiPachetto.put(this.uuidRichiesta, new PachettoDati(this.angolo1, this.angolo2, this.nome, this.consideraCreativeBlocks));
            }
        });
        return true;
    }

    public static List<String> creaListaDati(List<String> dati) {
        ArrayList<String> listaDati = new ArrayList<String>();
        for (String s : dati) {
            if (s.length() <= 30000) {
                listaDati.add(s);
                continue;
            }
            listaDati.add(s.substring(0, 30000));
        }
        listaDati.add("\ufffdEND\ufffd");
        return listaDati;
    }

    private class PachettoDati {
        public List<String> ScannerIgnoredBlocks = new ArrayList<String>();
        private final BlockPos angolo1;
        private final BlockPos angolo2;
        private final String nome;
        private final boolean consideraCreativeBlocks;

        public PachettoDati(BlockPos angolo1, BlockPos angolo2, String nome, boolean consideraCreativeBlocks) {
            this.angolo1 = angolo1;
            this.angolo2 = angolo2;
            this.nome = nome;
            this.consideraCreativeBlocks = consideraCreativeBlocks;
        }
    }
}

