/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.blueprint_tags;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.init.ModTabletTags;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.blueprint_tags.StoC_GetBlueprintTags;

public class CtoS_GetBlueprintTags {
    private final UUID OwnerBP;
    private final String BPName;

    public CtoS_GetBlueprintTags(UUID OwnerBP, String BPName) {
        this.OwnerBP = OwnerBP;
        this.BPName = BPName;
    }

    public CtoS_GetBlueprintTags(FriendlyByteBuf buffer) {
        this.OwnerBP = buffer.readBoolean() ? buffer.m_130259_() : null;
        this.BPName = buffer.m_130277_();
    }

    public void encode(FriendlyByteBuf buffer) {
        if (this.OwnerBP == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.m_130077_(this.OwnerBP);
        }
        buffer.m_130070_(this.BPName);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ServerLevel level = player.m_284548_();
            String key = this.OwnerBP == null ? "server" : this.OwnerBP.toString();
            String id = Blueprint.getIDBlueprint(level, key, this.OwnerBP, this.BPName);
            System.out.println(id);
            if (!id.isEmpty() && ModTabletTags.BlueprintTagsData.containsKey(id)) {
                UUID idRequest = UUID.randomUUID();
                PacketHandler.sendToPlayer(new StoC_GetBlueprintTags(idRequest, id, "START"), player);
                for (String tag : ModTabletTags.BlueprintTagsData.get(id)) {
                    PacketHandler.sendToPlayer(new StoC_GetBlueprintTags(idRequest, id, tag), player);
                }
                PacketHandler.sendToPlayer(new StoC_GetBlueprintTags(idRequest, id, "END"), player);
            }
        });
        return true;
    }
}

