/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.ottieni_players_uuid_mondo;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.network.NetworkEvent;
import nimble.portable_blueprints.client.ServerToClientDatasShared;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.ottieni_players_uuid_mondo.StoC_GetWorldPlayersUUID;

public class CtoS_GetWorldPlayersUUID {
    public CtoS_GetWorldPlayersUUID() {
        ServerToClientDatasShared.endTrasferingServerBlueprints = false;
    }

    public CtoS_GetWorldPlayersUUID(FriendlyByteBuf buffer) {
    }

    public void encode(FriendlyByteBuf buffer) {
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ArrayList result;
            UUID RequestID;
            ServerPlayer player;
            block9: {
                player = context.getSender();
                ServerLevel level = player.m_284548_();
                RequestID = UUID.randomUUID();
                result = new ArrayList();
                try {
                    Path playerDataDir = player.m_20194_().m_129843_(LevelResource.f_78176_);
                    if (playerDataDir == null || !Files.exists(playerDataDir, new LinkOption[0]) || !Files.isDirectory(playerDataDir, new LinkOption[0])) break block9;
                    try (Stream<Path> paths = Files.list(playerDataDir);){
                        paths.filter(p -> {
                            String n = p.getFileName().toString().toLowerCase();
                            return n.endsWith(".dat");
                        }).forEach(p -> {
                            String fileName = p.getFileName().toString();
                            String base = fileName.substring(0, fileName.length() - 4);
                            UUID uuid = CtoS_GetWorldPlayersUUID.parseUuidLenient(base);
                            if (uuid != null) {
                                result.add(uuid);
                            }
                        });
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            PacketHandler.sendToPlayer(new StoC_GetWorldPlayersUUID(RequestID, "START"), player);
            for (UUID uuid : result) {
                PacketHandler.sendToPlayer(new StoC_GetWorldPlayersUUID(RequestID, uuid), player);
            }
            PacketHandler.sendToPlayer(new StoC_GetWorldPlayersUUID(RequestID, "END"), player);
        });
        return true;
    }

    private static UUID parseUuidLenient(String s) {
        if (s == null) {
            return null;
        }
        try {
            return UUID.fromString(s);
        }
        catch (IllegalArgumentException ex) {
            String clean = s.replaceAll("[^0-9a-fA-F]", "");
            if (clean.length() == 32) {
                String dashed = clean.substring(0, 8) + "-" + clean.substring(8, 12) + "-" + clean.substring(12, 16) + "-" + clean.substring(16, 20) + "-" + clean.substring(20, 32);
                try {
                    return UUID.fromString(dashed);
                }
                catch (IllegalArgumentException ex2) {
                    return null;
                }
            }
            return null;
        }
    }
}

