/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.update_item_blueprint_nbt;

import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import nimble.portable_blueprints.Events.RenderBlueprintsPreview;

public class StoC_UpdateItemBlueprintNBT {
    private final boolean doCleanUp;
    private final boolean doCleanOnlyBlueprint;

    public StoC_UpdateItemBlueprintNBT(boolean doCleanUp, boolean doCleanOnlyBlueprint) {
        this.doCleanUp = doCleanUp;
        this.doCleanOnlyBlueprint = doCleanOnlyBlueprint;
    }

    public StoC_UpdateItemBlueprintNBT(FriendlyByteBuf buffer) {
        this.doCleanUp = buffer.readBoolean();
        this.doCleanOnlyBlueprint = buffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.doCleanUp);
        buffer.writeBoolean(this.doCleanOnlyBlueprint);
    }

    public static void handle(StoC_UpdateItemBlueprintNBT msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            if (msg.doCleanUp) {
                if (msg.doCleanOnlyBlueprint) {
                    Executors.newSingleThreadScheduledExecutor().schedule(() -> RenderBlueprintsPreview.doCleanupOnlyBlueprint(), 100L, TimeUnit.MILLISECONDS);
                } else {
                    Executors.newSingleThreadScheduledExecutor().schedule(() -> RenderBlueprintsPreview.doCleanUp(), 100L, TimeUnit.MILLISECONDS);
                }
            }
        });
    }
}

