/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.robautile;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import nimble.portable_blueprints.portable_blueprints.Mod;

public class Operazioni {
    private static final HttpClient CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
    private static final Map<UUID, String> CacheUUIDNAME = new HashMap<UUID, String>();

    public static double getRandomBetween(double min, double max) {
        Random random = new Random();
        return random.nextDouble() * (max - min) + min;
    }

    public static int getRandomBetween(int min, int max) {
        Random random = new Random();
        return random.nextInt(max - min + 1) + min;
    }

    public static double lerp(double start, double end, double t) {
        return start + t * (end - start);
    }

    public static float lerp(float start, float end, float t) {
        return start + t * (end - start);
    }

    public static double getDistanceToGround(Level level, Entity entity, double distanzaMax) {
        Vec3 endPosition;
        Vec3 startPosition = entity.m_20182_();
        BlockHitResult result = level.m_45547_(new ClipContext(startPosition, endPosition = startPosition.m_82492_(0.0, distanzaMax, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return result.m_82450_().m_82554_(startPosition);
        }
        return Double.MAX_VALUE;
    }

    public static int lerpColor(int colorStart, int colorEnd, float t) {
        t = Math.max(0.0f, Math.min(1.0f, t));
        int a1 = colorStart >> 24 & 0xFF;
        int r1 = colorStart >> 16 & 0xFF;
        int g1 = colorStart >> 8 & 0xFF;
        int b1 = colorStart & 0xFF;
        int a2 = colorEnd >> 24 & 0xFF;
        int r2 = colorEnd >> 16 & 0xFF;
        int g2 = colorEnd >> 8 & 0xFF;
        int b2 = colorEnd & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * t);
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static Vec3 getColorFromHex(int hex) {
        int r = hex >> 16 & 0xFF;
        int g = hex >> 8 & 0xFF;
        int b = hex & 0xFF;
        return new Vec3((double)((float)r / 255.0f), (double)((float)g / 255.0f), (double)((float)b / 255.0f));
    }

    public static float calculateDistance(Vec2 point1, Vec2 point2) {
        float dx = point2.f_82470_ - point1.f_82470_;
        float dy = point2.f_82471_ - point1.f_82471_;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public static ItemStack getItemStackFromId(String itemId) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
        if (item != null) {
            return new ItemStack((ItemLike)item);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getCorrectItemStackFromId(Block blocco) {
        Item item = Item.m_41439_((Block)blocco);
        if (item == Items.f_41852_) {
            item = blocco.m_5456_();
        }
        if (item == Items.f_41852_) {
            if (blocco.equals(Blocks.f_50082_)) {
                item = Items.f_42000_;
            } else if (blocco.equals(Blocks.f_50123_)) {
                item = Items.f_41978_;
            } else if (blocco.equals(Blocks.f_49990_) || blocco.equals(Blocks.f_50628_)) {
                item = Items.f_42447_;
            } else if (blocco.equals(Blocks.f_49991_)) {
                item = Items.f_42448_;
            }
        }
        return new ItemStack((ItemLike)item);
    }

    public static String getValueInsideTag(String input, String Tag) {
        try {
            int start = input.indexOf("<" + Tag + ">") + Tag.length() + 2;
            int end = input.indexOf("</" + Tag + ">");
            if (start != -1 && end != -1 && start < end) {
                return input.substring(start, end);
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static int addItemToInventory(Inventory pInventory, ItemStack stack, int quantity) {
        int quantitaRimasta;
        ItemStack stackNuovo;
        for (quantitaRimasta = quantity; pInventory.m_36062_() != -1 && quantitaRimasta > 0; quantitaRimasta -= stackNuovo.m_41613_()) {
            stackNuovo = stack.m_41777_();
            stackNuovo.m_41764_(quantitaRimasta >= 64 ? 64 : quantitaRimasta);
            pInventory.m_36054_(stackNuovo);
        }
        for (int slot = 0; slot < pInventory.m_6643_() && quantitaRimasta > 0; ++slot) {
            ItemStack stackSlot = pInventory.m_8020_(slot);
            if (!ItemStack.m_150942_((ItemStack)stackSlot, (ItemStack)stack)) continue;
            int quantitaChePuoMettere = 64 - stackSlot.m_41613_();
            if (quantitaChePuoMettere > quantitaRimasta) {
                quantitaChePuoMettere = quantitaRimasta;
            }
            stackSlot.m_41764_(stackSlot.m_41613_() + quantitaChePuoMettere);
            quantitaRimasta -= quantitaChePuoMettere;
        }
        return quantitaRimasta;
    }

    public static void dropItem(Level level, Vec3 pos, ItemStack stack) {
        if (!level.f_46443_ && !stack.m_41619_()) {
            level.m_7967_((Entity)new ItemEntity(level, pos.f_82479_ + 0.5, pos.f_82480_ + 0.5, pos.f_82481_ + 0.5, stack));
        }
    }

    public static BlockPos SommaBlockPos(BlockPos blockPos, BlockPos offsetBloccoSecondario) {
        int x = blockPos.m_123341_() + offsetBloccoSecondario.m_123341_();
        int y = blockPos.m_123342_() + offsetBloccoSecondario.m_123342_();
        int z = blockPos.m_123343_() + offsetBloccoSecondario.m_123343_();
        return new BlockPos(x, y, z);
    }

    public static int getEuclideaBlockDistance(BlockPos pos1, BlockPos pos2) {
        return (int)Math.round(Math.sqrt(pos1.m_123331_((Vec3i)pos2)));
    }

    public static int getManhattanBlockDistance(BlockPos pos1, BlockPos pos2) {
        return Math.abs(pos1.m_123341_() - pos2.m_123341_()) + Math.abs(pos1.m_123342_() - pos2.m_123342_()) + Math.abs(pos1.m_123343_() - pos2.m_123343_());
    }

    public static void glowingItemStack(ItemStack item, boolean effectOn) {
        if (effectOn) {
            CompoundTag tag = item.m_41784_();
            ListTag encs = new ListTag();
            CompoundTag enc = new CompoundTag();
            enc.m_128359_("id", "minecraft:glowing");
            enc.m_128405_("lvl", 1);
            encs.add((Object)enc);
            tag.m_128365_("Enchantments", (Tag)encs);
        } else {
            CompoundTag tag = item.m_41784_();
            tag.m_128473_("Enchantments");
        }
    }

    public static void saveVec3iToNBTIntArray(String nome, Vec3i vec, CompoundTag nbt) {
        if (vec != null && nbt != null) {
            nbt.m_128385_(nome + "_Vec3i", new int[]{vec.m_123341_(), vec.m_123342_(), vec.m_123343_()});
        }
    }

    public static Vec3i getVec3iByNBTIntArray(String nome, CompoundTag nbt) {
        if (nbt != null && nbt.m_128441_(nome + "_Vec3i")) {
            int[] valori = nbt.m_128465_(nome + "_Vec3i");
            return new Vec3i(valori[0], valori[1], valori[2]);
        }
        return null;
    }

    public static Direction getDirectionBetween(Vec3 vec1, Vec3 vec2) {
        double dx = vec2.f_82479_ - vec1.f_82479_;
        double dy = vec2.f_82480_ - vec1.f_82480_;
        double dz = vec2.f_82481_ - vec1.f_82481_;
        if (Math.abs(dx) > Math.abs(dy) && Math.abs(dx) > Math.abs(dz)) {
            return dx > 0.0 ? Direction.EAST : Direction.WEST;
        }
        if (Math.abs(dy) > Math.abs(dx) && Math.abs(dy) > Math.abs(dz)) {
            return dy > 0.0 ? Direction.UP : Direction.DOWN;
        }
        return dz > 0.0 ? Direction.SOUTH : Direction.NORTH;
    }

    public static String getVec3iString(Vec3i v) {
        return "x=" + v.m_123341_() + ",y=" + v.m_123342_() + ",z=" + v.m_123343_();
    }

    public static String getVec3String(Vec3 v) {
        return "x=" + v.m_7096_() + ",y=" + v.m_7098_() + ",z=" + v.m_7094_();
    }

    public static Vec3i getVec3iFromString(String v) {
        if (v.isEmpty()) {
            return Vec3i.f_123288_;
        }
        v = v.replaceAll("=", "").replaceAll("x", "").replaceAll("y", "").replaceAll("z", "");
        String[] p = v.split(",");
        return new Vec3i(Integer.parseInt(p[0]), Integer.parseInt(p[1]), Integer.parseInt(p[2]));
    }

    public static Vec3 getVec3FromString(String v) {
        if (v.isEmpty()) {
            return Vec3.f_82478_;
        }
        v = v.replaceAll("=", "").replaceAll("x", "").replaceAll("y", "").replaceAll("z", "");
        String[] p = v.split(",");
        return new Vec3(Double.parseDouble(p[0]), Double.parseDouble(p[1]), Double.parseDouble(p[2]));
    }

    public static String getBlockStateString(BlockState state) {
        Block block = state.m_60734_();
        String id = ForgeRegistries.BLOCKS.getKey((Object)block).toString();
        String nbtString = "null";
        if (state.m_61147_().size() > 0) {
            nbtString = Operazioni.ConvertPropertiesToString(state);
        }
        return "<bid>" + id + "</bid>" + nbtString;
    }

    public static String ConvertPropertiesToString(BlockState state) {
        Object compilation = "<properties>";
        for (Property p : state.m_61147_()) {
            compilation = (String)compilation + "<propertie><name>" + p.m_61708_() + "</name><value>" + state.m_61143_(p) + "</value><classe>" + p.m_61709_().toString().replace("class ", "") + "</classe></propertie>;!v!;";
        }
        compilation = (String)compilation + "</properties>";
        return compilation;
    }

    public static Block getBlockFromString(String v) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(v));
    }

    public static BlockState getPropertiesStringToBlock(Block blocco, String proprieta) {
        BlockState state = blocco.m_49966_();
        HashMap<String, Tuple> data = new HashMap<String, Tuple>();
        proprieta = proprieta.replace("<properties>", "").replace("</properties>", "");
        for (String v : proprieta.split(";!v!;")) {
            if (v.equals("")) continue;
            data.put(v.substring(v.indexOf("<name>") + 6, v.indexOf("</name>")), new Tuple((Object)v.substring(v.indexOf("<value>") + 7, v.indexOf("</value>")), (Object)v.substring(v.indexOf("<classe>") + 8, v.indexOf("</classe>"))));
        }
        for (Property p : state.m_61147_()) {
            if (!data.containsKey(p.m_61708_())) continue;
            state = Operazioni.setDynamicProperty(state, p, (String)((Tuple)data.get(p.m_61708_())).m_14418_());
        }
        return state;
    }

    public static <T extends Comparable<T>> BlockState setDynamicProperty(BlockState state, Property<T> property, String value) {
        Optional parsed = property.m_6215_(value.toLowerCase(Locale.ROOT));
        if (parsed.isPresent()) {
            return (BlockState)state.m_61124_(property, (Comparable)parsed.get());
        }
        Mod.LOGGER.warn("[Portable blueprint] Invalid value '{}' for property '{}'. Allowed: {}", (Object)value, (Object)property.m_61708_(), property.m_6908_().stream().map(arg_0 -> property.m_6940_(arg_0)).toList());
        return state;
    }

    public static Direction rotateFacing(Direction currentFacing, int rotations) {
        if (currentFacing.equals((Object)Direction.DOWN) || currentFacing.equals((Object)Direction.UP)) {
            return currentFacing;
        }
        Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        int currentIndex = 0;
        for (int i = 0; i < directions.length; ++i) {
            if (directions[i] != currentFacing) continue;
            currentIndex = i;
            break;
        }
        int newIndex = (currentIndex + rotations) % directions.length;
        return directions[newIndex];
    }

    public static Vec3 lerp(Vec3 start, Vec3 end, double t) {
        double x = start.f_82479_ + (end.f_82479_ - start.f_82479_) * t;
        double y = start.f_82480_ + (end.f_82480_ - start.f_82480_) * t;
        double z = start.f_82481_ + (end.f_82481_ - start.f_82481_) * t;
        return new Vec3(x, y, z);
    }

    public Item getItemFromId(String id) {
        ResourceLocation itemId = new ResourceLocation(id);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
        return item;
    }

    public static BufferedImage getPlayerFace(UUID uuid) {
        try {
            String url = "https://minotar.net/helm/" + uuid + "/8";
            InputStream inputStream = new URL(url).openStream();
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getPlayerNameFromUUID(UUID uuid) {
        try {
            String line;
            URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString().replaceAll("-", ""));
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setConnectTimeout(500);
            con.setReadTimeout(500);
            int status = con.getResponseCode();
            if (status != 200) {
                return null;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder content = new StringBuilder();
            while ((line = in.readLine()) != null) {
                content.append(line);
            }
            in.close();
            JsonObject obj = JsonParser.parseString((String)content.toString()).getAsJsonObject();
            return obj.get("name").getAsString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static List<String> splitStringByLength(String input, int chunkSize) {
        ArrayList<String> result = new ArrayList<String>();
        int length = input.length();
        for (int i = 0; i < length; i += chunkSize) {
            result.add(input.substring(i, Math.min(length, i + chunkSize)));
        }
        return result;
    }

    public static String getWorldTimeString() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return "??:??";
        }
        long time = mc.f_91073_.m_46468_() % 24000L;
        int hours = (int)((time / 1000L + 6L) % 24L);
        int minutes = (int)(time % 1000L * 60L / 1000L);
        String ampm = hours >= 12 ? "PM" : "AM";
        int displayHour = hours % 12;
        if (displayHour == 0) {
            displayHour = 12;
        }
        return String.format("%02d:%02d %s", displayHour, minutes, ampm);
    }

    public static String getNameViaSessionServer(String uuid) {
        String v;
        block7: {
            v = Operazioni.getPlayerName(UUID.fromString(uuid));
            if (!v.isEmpty()) {
                return v;
            }
            if (CacheUUIDNAME.containsKey(UUID.fromString(uuid))) {
                return CacheUUIDNAME.get(UUID.fromString(uuid));
            }
            try {
                String clean = Operazioni.stripDashes(uuid);
                String url = "https://sessionserver.mojang.com/session/minecraft/profile/" + clean;
                HttpRequest req = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(5L)).GET().header("Accept", "application/json").build();
                HttpResponse<String> resp = CLIENT.send(req, HttpResponse.BodyHandlers.ofString());
                if (resp.statusCode() == 200) {
                    JsonObject obj = JsonParser.parseString((String)resp.body()).getAsJsonObject();
                    v = obj.has("name") ? obj.get("name").getAsString() : "";
                    break block7;
                }
                if (resp.statusCode() == 204 || resp.statusCode() == 404) {
                    v = "";
                    break block7;
                }
                throw new RuntimeException("Sessionserver error: " + resp.statusCode());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!CacheUUIDNAME.containsKey(UUID.fromString(uuid))) {
            CacheUUIDNAME.put(UUID.fromString(uuid), v);
        }
        return v;
    }

    private static String stripDashes(String uuid) {
        return uuid.replace("-", "");
    }

    public static String getPlayerName(UUID uuid) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || uuid == null) {
            return "";
        }
        AbstractClientPlayer player = (AbstractClientPlayer)mc.f_91073_.m_46003_(uuid);
        if (player != null) {
            return player.m_36316_().getName();
        }
        if (mc.f_91074_ != null && mc.f_91074_.m_20148_().equals(uuid)) {
            return mc.f_91074_.m_36316_().getName();
        }
        return "";
    }
}

