/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.robautile;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import nimble.portable_blueprints.robautile.Operazioni;
import org.joml.Vector2i;

public class RenderingMethods {
    public static void GuiGraphicsTestoScalato(GuiGraphics gg, String testo, float Scala, Font font, Vec2 position, int Color, boolean Ombra, PosizioneTesto Position) {
        RenderingMethods.guiGraphicsTestoScalato(gg, testo, Scala, font, position, Color, Ombra, Position, false);
    }

    public static void GuiGraphicsTestoScalato(GuiGraphics gg, String testo, float Scala, Font font, Vec2 position, int Color, boolean Ombra, PosizioneTesto Position, boolean YCentrale) {
        RenderingMethods.guiGraphicsTestoScalato(gg, testo, Scala, font, position, Color, Ombra, Position, YCentrale);
    }

    private static void guiGraphicsTestoScalato(GuiGraphics gg, String testo, float Scala, Font font, Vec2 position, int Color, boolean Ombra, PosizioneTesto Position, boolean YCentrale) {
        String valore = Operazioni.getValueInsideTag(testo, "remove_size");
        if (!valore.isEmpty()) {
            testo = testo.replace("<remove_size>" + valore + "</remove_size>", "");
            Scala -= Float.parseFloat(valore);
        }
        PoseStack poseStack = gg.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(Scala, Scala, Scala);
        String[] split = testo.split("\n");
        for (int x = 0; x < split.length; ++x) {
            float Y;
            testo = split[x];
            if (YCentrale) {
                float f = position.f_82471_ / Scala;
                Objects.requireNonNull(font);
                float f2 = f - (float)(9 / 2);
                Objects.requireNonNull(font);
                v2 = f2 + (float)(x * 9);
            } else {
                float f = position.f_82471_ / Scala;
                Objects.requireNonNull(font);
                v2 = Y = f + (float)(x * 9);
            }
            if (Position.equals((Object)PosizioneTesto.CENTRO)) {
                gg.drawString(font, testo, position.f_82470_ / Scala - (float)(font.m_92895_(testo) / 2), Y, Color, Ombra);
                continue;
            }
            if (Position.equals((Object)PosizioneTesto.SINISTRA)) {
                gg.drawString(font, testo, position.f_82470_ / Scala, Y, Color, Ombra);
                continue;
            }
            gg.drawString(font, testo, position.f_82470_ / Scala - (float)font.m_92895_(testo), Y, Color, Ombra);
        }
        poseStack.m_85849_();
    }

    public static void renderTextInWorld(PoseStack poseStack, MultiBufferSource bufferSource, Camera camera, Vec3 pos, String testo, Font font, float Scale, int Color, float MaxDistanceRender, float MinDistanceResize, boolean onTopOfBlocks) {
        Minecraft mc = Minecraft.m_91087_();
        double targetX = pos.f_82479_ + 0.5;
        double targetY = pos.f_82480_ + 0.5;
        double targetZ = pos.f_82481_ + 0.5;
        double camX = camera.m_90583_().f_82479_;
        double camY = camera.m_90583_().f_82480_;
        double camZ = camera.m_90583_().f_82481_;
        double distanceX = targetX - camX;
        double distanceY = targetY - camY;
        double distanceZ = targetZ - camZ;
        double distance = mc.f_91074_.m_20182_().m_82554_(pos);
        if (distance > (double)MaxDistanceRender) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(distanceX, distanceY, distanceZ);
        poseStack.m_252781_(mc.m_91290_().m_253208_());
        poseStack.m_85841_(-0.025f, -0.025f, -0.025f);
        if (distance > (double)MinDistanceResize) {
            Scale = (float)Operazioni.lerp((double)Scale, (double)(Scale * 10.0f), (distance - (double)MinDistanceResize) / (double)(MaxDistanceRender - MinDistanceResize));
        }
        poseStack.m_85841_(Scale, Scale, Scale);
        float textWidth = (float)font.m_92895_(testo) / 2.0f;
        float f = -textWidth;
        Objects.requireNonNull(font);
        font.m_271703_(testo, f, (float)(-(9 / 2)), Color, !onTopOfBlocks, poseStack.m_85850_().m_252922_(), bufferSource, onTopOfBlocks ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, 0, 0xF000F0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void RenderItemInGui(GuiGraphics gg, Vector2i pos, Vec2 offset, float Scale, ItemStack item) {
        PoseStack pMatrixStack = gg.m_280168_();
        pMatrixStack.m_85836_();
        pMatrixStack.m_85841_(Scale, Scale, Scale);
        pMatrixStack.m_252880_(offset.f_82470_, offset.f_82471_, 0.0f);
        gg.m_280203_(item, (int)((float)pos.x / Scale), (int)((float)pos.y / Scale));
        pMatrixStack.m_85849_();
    }

    public static void renderFixedTextInWorld(PoseStack poseStack, MultiBufferSource bufferSource, Camera camera, Vec3 pos, Vec3 rotation, String testo, Font font, float Scale, int Color, float MaxDistanceRender, boolean onTopOfBlocks) {
        Minecraft mc = Minecraft.m_91087_();
        double targetX = pos.f_82479_ + 0.5;
        double targetY = pos.f_82480_ + 0.5;
        double targetZ = pos.f_82481_ + 0.5;
        double camX = camera.m_90583_().f_82479_;
        double camY = camera.m_90583_().f_82480_;
        double camZ = camera.m_90583_().f_82481_;
        double distanceX = targetX - camX;
        double distanceY = targetY - camY;
        double distanceZ = targetZ - camZ;
        double distance = mc.f_91074_.m_20182_().m_82554_(pos);
        if (distance > (double)MaxDistanceRender) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(distanceX, distanceY, distanceZ);
        poseStack.m_252781_(Axis.f_252529_.m_252977_((float)rotation.f_82479_));
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)rotation.f_82480_));
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)rotation.f_82481_));
        poseStack.m_85841_(-Scale, -Scale, -Scale);
        float textWidth = (float)font.m_92895_(testo) / 2.0f;
        float f = -textWidth;
        Objects.requireNonNull(font);
        font.m_271703_(testo, f, (float)(-(9 / 2)), Color, !onTopOfBlocks, poseStack.m_85850_().m_252922_(), bufferSource, onTopOfBlocks ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, 0, 0xF000F0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static void RenderItemInWorld(PoseStack poseStack, Vec3 renderPos, Item item, float scale) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack stack = new ItemStack((ItemLike)item);
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        double x = renderPos.f_82479_ - cameraPos.f_82479_;
        double y = renderPos.f_82480_ - cameraPos.f_82480_;
        double z = renderPos.f_82481_ - cameraPos.f_82481_;
        poseStack.m_85836_();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        Item item2 = stack.m_41720_();
        if (item2 instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item2;
            float val = (1.0f - scale) / 2.0f;
            poseStack.m_85837_(x - 0.5 + (double)val, y - 0.5 + (double)val, z - 0.5 + (double)val);
            poseStack.m_85841_(scale, scale, scale);
            BlockRenderDispatcher render = mc.m_91289_();
            BlockPos pos = new BlockPos(0, 0, 0);
            ModelData modelData = render.m_110910_(blockItem.m_40614_().m_49966_()).getModelData((BlockAndTintGetter)mc.f_91073_, pos, blockItem.m_40614_().m_49966_(), ModelData.builder().build());
            render.renderSingleBlock(blockItem.m_40614_().m_49966_(), poseStack, (MultiBufferSource)mc.m_91269_().m_110108_(), 0xF000F0, OverlayTexture.f_118083_, modelData, RenderType.m_110463_());
        } else {
            poseStack.m_85841_(scale, scale, scale);
            poseStack.m_85837_(x, y, z);
            ItemRenderer itemRenderer = mc.m_91291_();
            itemRenderer.m_115143_(stack, ItemDisplayContext.FIXED, true, poseStack, (MultiBufferSource)buffer, 0xF000F0, 0, itemRenderer.m_174264_(stack, null, null, 0));
        }
        buffer.m_109911_();
        poseStack.m_85849_();
    }

    public static void GUITextAutoResize(GuiGraphics gg, String testo, Font font, int Color, float StartPosX, float StartPosY, int width, int height, boolean Ombra) {
        float scale = 1.0f;
        int textWidth = font.m_92895_(testo);
        Objects.requireNonNull(font);
        int textHeight = 9;
        if ((float)textWidth * scale > (float)width || (float)textHeight * scale > (float)height) {
            while (((float)textWidth * scale > (float)width || (float)textHeight * scale > (float)height) && !((scale -= 0.01f) <= 0.1f)) {
            }
        } else if ((float)textWidth * scale < (float)width && (float)textHeight * scale < (float)height) {
            while ((float)textWidth * scale < (float)width && (float)textHeight * scale < (float)height && !((scale += 0.01f) >= 100.0f)) {
            }
        }
        float scaledWidth = (float)textWidth * scale;
        float scaledHeight = (float)textHeight * scale;
        float centeredPosX = StartPosX + ((float)width - scaledWidth) / 2.0f;
        float centeredPosY = StartPosY + ((float)height - scaledHeight) / 2.0f;
        gg.m_280168_().m_85836_();
        gg.m_280168_().m_85841_(scale, scale, 1.0f);
        gg.drawString(font, testo, centeredPosX / scale, centeredPosY / scale, Color, Ombra);
        gg.m_280168_().m_85849_();
    }

    public static void enableScissorFromGui(Minecraft mc, int x, int y, int width, int height) {
        double scale = mc.m_91268_().m_85449_();
        int windowWidth = mc.m_91268_().m_85441_();
        int windowHeight = mc.m_91268_().m_85442_();
        int px = (int)((double)x * scale);
        int py = (int)((double)y * scale);
        int pw = (int)((double)width * scale);
        int ph = (int)((double)height * scale);
        py = windowHeight - ph - py;
        RenderSystem.enableScissor((int)px, (int)py, (int)pw, (int)ph);
    }

    public static void disableScissor() {
        RenderSystem.disableScissor();
    }

    public static enum PosizioneTesto {
        SINISTRA,
        CENTRO,
        DESTRA;

    }

    public static class GuiGraphicsElement {
        private Tipo type = Tipo.FILL;
        public FILL_Parametri fillParametri = null;
        public BLIT_Parametri blitParametri = null;
        public TESTO_Parametri testoParametri = null;
        private ITEM_Parametri itemParametri = null;

        public GuiGraphicsElement(FILL_Parametri fillParametri) {
            this.type = Tipo.FILL;
            this.fillParametri = fillParametri;
        }

        public GuiGraphicsElement(BLIT_Parametri blitParametri) {
            this.type = Tipo.BLIT;
            this.blitParametri = blitParametri;
        }

        public GuiGraphicsElement(TESTO_Parametri testoParametri) {
            this.type = Tipo.TESTO;
            this.testoParametri = testoParametri;
        }

        public GuiGraphicsElement(ITEM_Parametri itemParametri) {
            this.type = Tipo.ITEM;
            this.itemParametri = itemParametri;
        }

        public void render(GuiGraphics gg) {
            switch (this.type) {
                case FILL: {
                    if (this.fillParametri == null) break;
                    gg.m_280168_().m_85836_();
                    gg.m_280168_().m_85837_(this.fillParametri.PosOffsetX, this.fillParametri.PosOffsetY, 0.0);
                    gg.m_280509_(this.fillParametri.startPosX, this.fillParametri.startPosY, this.fillParametri.endPosX, this.fillParametri.endPosY, this.fillParametri.color);
                    gg.m_280168_().m_85849_();
                }
                case BLIT: {
                    if (this.blitParametri == null) break;
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    gg.m_280168_().m_85836_();
                    gg.m_280168_().m_252880_(this.blitParametri.PosOffsetX, this.blitParametri.PosOffsetY, 0.0f);
                    gg.m_280218_(this.blitParametri.img, this.blitParametri.startPosX, this.blitParametri.startPosY, this.blitParametri.offsetX, this.blitParametri.offsetY, this.blitParametri.width, this.blitParametri.height);
                    gg.m_280168_().m_85849_();
                    RenderSystem.disableBlend();
                }
                case TESTO: {
                    if (this.testoParametri == null) break;
                    RenderingMethods.GuiGraphicsTestoScalato(gg, this.testoParametri.testo, this.testoParametri.scale, this.testoParametri.font, new Vec2(this.testoParametri.startPosX, this.testoParametri.startPosY), this.testoParametri.color, this.testoParametri.ombra, this.testoParametri.posizione, this.testoParametri.YCentrata);
                }
                case ITEM: {
                    if (this.itemParametri == null) break;
                    RenderingMethods.RenderItemInGui(gg, new Vector2i(this.itemParametri.startPosX, this.itemParametri.startPosY), new Vec2(this.itemParametri.offsetX, this.itemParametri.offsetY), this.itemParametri.scale, Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(this.itemParametri.id)));
                }
            }
        }

        public static enum Tipo {
            FILL,
            BLIT,
            TESTO,
            ITEM;

        }

        public static class FILL_Parametri {
            public int startPosX;
            public int startPosY;
            public int endPosX;
            public int endPosY;
            public int color;
            public double PosOffsetX;
            public double PosOffsetY;

            public FILL_Parametri(int startPosX, int startPosY, int endPosX, int endPosY, int color) {
                this.startPosX = startPosX;
                this.startPosY = startPosY;
                this.endPosX = endPosX;
                this.endPosY = endPosY;
                this.color = color;
            }

            public FILL_Parametri(int startPosX, int startPosY, int endPosX, int endPosY, int color, double PosOffsetX, double PosOffsetY) {
                this.startPosX = startPosX;
                this.startPosY = startPosY;
                this.endPosX = endPosX;
                this.endPosY = endPosY;
                this.color = color;
                this.PosOffsetX = PosOffsetX;
                this.PosOffsetY = PosOffsetY;
            }

            public void setPosOffset(double PosOffsetX, double PosOffsetY) {
                this.PosOffsetX = PosOffsetX;
                this.PosOffsetY = PosOffsetY;
            }

            public void setColor(int color) {
                this.color = color;
            }
        }

        public static class BLIT_Parametri {
            public int startPosX;
            public int startPosY;
            public int offsetX;
            public int offsetY;
            public int width;
            public int height;
            public float PosOffsetX = 0.0f;
            public float PosOffsetY = 0.0f;
            public ResourceLocation img;

            public BLIT_Parametri(int startPosX, int startPosY, int offsetX, int offsetY, int width, int height, ResourceLocation img) {
                this.startPosX = startPosX;
                this.startPosY = startPosY;
                this.img = img;
                this.offsetX = offsetX;
                this.offsetY = offsetY;
                this.width = width;
                this.height = height;
            }

            public void setPos(int startPosX, int startPosY) {
                this.startPosX = startPosX;
                this.startPosY = startPosY;
            }

            public void setPosOffset(float PosOffsetX, float PosOffsetY) {
                this.PosOffsetX = PosOffsetX;
                this.PosOffsetY = PosOffsetY;
            }

            public void setImage(int offsetX, int offsetY, int width, int height, ResourceLocation img) {
                this.img = img;
                this.offsetX = offsetX;
                this.offsetY = offsetY;
                this.width = width;
                this.height = height;
            }
        }

        public static class TESTO_Parametri {
            public int color;
            public String testo;
            public Font font;
            public float startPosX;
            public float startPosY;
            public float scale;
            public boolean ombra;
            public boolean YCentrata;
            public PosizioneTesto posizione;

            public TESTO_Parametri(float startPosX, float startPosY, String testo, float scale, Font font, int color, boolean ombra, PosizioneTesto posizione, boolean YCentrata) {
                this.startPosX = startPosX;
                this.startPosY = startPosY;
                this.color = color;
                this.testo = testo;
                this.font = font;
                this.scale = scale;
                this.posizione = posizione;
                this.ombra = ombra;
                this.YCentrata = YCentrata;
            }

            public void setTesto(String val) {
                this.testo = val;
            }
        }

        public static class ITEM_Parametri {
            public String id;
            public int startPosX;
            public int startPosY;
            public float scale;
            public float offsetX;
            public float offsetY;

            public ITEM_Parametri(int startPosX, int startPosY, float offsetX, float offsetY, String id, float scale) {
                this.startPosX = startPosX;
                this.startPosY = startPosY;
                this.offsetX = offsetX;
                this.offsetY = offsetY;
                this.id = id;
                this.scale = scale;
            }
        }
    }
}

