/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.Events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nimble.portable_blueprints.Events.BlueprintEvent;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.client.VisualizeBlueprintDatas;
import nimble.portable_blueprints.init.ModItems;
import nimble.portable_blueprints.portable_blueprints.ModConfig;
import nimble.portable_blueprints.robautile.Operazioni;
import nimble.portable_blueprints.robautile.RenderingGraphics;

@Mod.EventBusSubscriber(modid="portable_blueprints", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class RenderBlueprintsPreview {
    private static final List<Tuple<BlockPos, BlockState>> ListaBlocchiSingleRender = new ArrayList<Tuple<BlockPos, BlockState>>();
    public static boolean prepared = false;
    private static boolean doCleanup = false;
    private static Long TimeAnimation = System.currentTimeMillis();
    private static Vec3i lunghezza = Vec3i.f_123288_;
    private static final Map<RenderLevelStageEvent.Stage, List<RenderType>> STAGE_RENDER_TYPES = Map.of(RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS, List.of(RenderType.m_110451_(), RenderType.m_110463_(), RenderType.m_110457_()), RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS, List.of(RenderType.m_110466_()));
    public static final int MAX_BLOCKS_FOR_Time = 1000;
    private static final Map<RenderType, List<VertexBuffer>> vertexBuffers = new HashMap<RenderType, List<VertexBuffer>>();
    private static final List<Tuple<BlockPos, VertexBuffer>> vertexBuffersLiquids = new ArrayList<Tuple<BlockPos, VertexBuffer>>();
    private static ScheduledExecutorService executor = null;
    private static boolean datiVertexPronti = false;
    private static ItemStack lastBlueprintItem = null;
    private static final Map<RenderType, List<Tuple<BlockPos, BlockState>>> datiBlocchiRender = new HashMap<RenderType, List<Tuple<BlockPos, BlockState>>>();
    private static final List<Tuple<BlockPos, BlockState>> datiRenderLiquid = new ArrayList<Tuple<BlockPos, BlockState>>();
    private static boolean isDatiVertexPronti = false;
    private static Vec3 originPos = Vec3.f_82478_;
    private static Vec3 finalOriginPos = Vec3.f_82478_;
    private static long moveTimeAnimation = 0L;
    public static Direction DirezioneHitboxSelected = null;
    public static int NblockBlueprint = -1;
    public static int nAvanzamento = 0;

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (doCleanup) {
            doCleanup = false;
            RenderBlueprintsPreview.cleanup();
        }
        RenderBlueprintsPreview.renderHologramLoadingBar(event);
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            if (level == null) {
                return;
            }
            if (!prepared) {
                RenderBlueprintsPreview.prepare();
            }
            RenderBlueprintsPreview.preparaVertexBuffers();
        }
        if (Minecraft.m_91087_().f_91074_ != null || event.getStage() == RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS || event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES || event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS || event.getStage() == RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            CompoundTag nbt;
            ItemStack item = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND);
            if (ModItems.getBlueprintItems().contains(item.m_41720_()) && (nbt = item.m_41784_()).m_128441_("originPos")) {
                Minecraft mc = Minecraft.m_91087_();
                Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
                RenderBlueprintsPreview.render(event.getPoseStack(), cameraPos, event.getProjectionMatrix(), event.getStage(), event.getFrustum());
            }
        }
    }

    public static void prepare() {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        ItemStack item = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        if (prepared || VisualizeBlueprintDatas.VisualizeBlueprint == null || !ModItems.getBlueprintItems().contains(item.m_41720_())) {
            return;
        }
        prepared = true;
        RenderBlueprintsPreview.cleanup();
        lastBlueprintItem = item.m_41777_();
        RenderBlueprintsPreview.preparaDatiPerVertexBuffer();
    }

    public static void preparaDatiPerVertexBuffer() {
        if (Minecraft.m_91087_().f_91073_ == null || lastBlueprintItem == null) {
            return;
        }
        if (executor != null) {
            executor.shutdownNow();
        }
        executor = Executors.newSingleThreadScheduledExecutor();
        executor.schedule(() -> {
            try {
                PoseStack poseStack = new PoseStack();
                poseStack.m_85836_();
                try {
                    Blueprint.BlueprintDatas schem = VisualizeBlueprintDatas.VisualizeBlueprint;
                    CompoundTag nbt = lastBlueprintItem.m_41784_();
                    Minecraft mc = Minecraft.m_91087_();
                    BlockRenderDispatcher dispatcher = mc.m_91289_();
                    datiBlocchiRender.clear();
                    datiRenderLiquid.clear();
                    if (nbt.m_128448_("rotateValue") != 0) {
                        schem = schem.rotate(nbt.m_128448_("rotateValue"));
                    }
                    if (nbt.m_128471_("mirrowX") || nbt.m_128471_("mirrowY") || nbt.m_128471_("mirrowZ")) {
                        schem = schem.Mirrow(nbt.m_128471_("mirrowX"), nbt.m_128471_("mirrowY"), nbt.m_128471_("mirrowZ"));
                    }
                    lunghezza = new Vec3i(schem.lunghezzaX, schem.altezza, schem.lunghezzaZ);
                    int n_volte = 0;
                    for (int v = 0; v < 2; ++v) {
                        for (int altezze : v == 0 ? schem.BlocksData.keySet() : schem.NotSolidBlocksData.keySet()) {
                            for (Map.Entry<String, String> bloccoDati : v == 0 ? schem.BlocksData.get(altezze).entrySet() : schem.NotSolidBlocksData.get(altezze).entrySet()) {
                                BlockState bs;
                                BlockPos offsetPos = new BlockPos(Operazioni.getVec3iFromString(bloccoDati.getKey()));
                                String blockstate = bloccoDati.getValue();
                                String bloccoId = blockstate.substring(blockstate.indexOf("<bid>") + 5, blockstate.indexOf("</bid>"));
                                BlockState blockState = bs = (blockstate = blockstate.replaceFirst("<bid>" + bloccoId + "</bid>", "")).equalsIgnoreCase("null") ? Operazioni.getBlockFromString(bloccoId).m_49966_() : Operazioni.getPropertiesStringToBlock(Operazioni.getBlockFromString(bloccoId), blockstate);
                                if (bs.m_61138_((Property)BlockStateProperties.f_61391_) && ((BedPart)bs.m_61143_((Property)BlockStateProperties.f_61391_)).equals((Object)BedPart.HEAD)) continue;
                                BakedModel model = dispatcher.m_110910_(bs);
                                if (RenderBlueprintsPreview.isLiquidBlock(bs)) {
                                    datiRenderLiquid.add((Tuple<BlockPos, BlockState>)new Tuple((Object)offsetPos, (Object)bs));
                                } else {
                                    LegacyRandomSource threadRandom = new LegacyRandomSource(System.currentTimeMillis());
                                    for (RenderType renderType : model.getRenderTypes(bs, (RandomSource)threadRandom, ModelData.EMPTY)) {
                                        if (!datiBlocchiRender.containsKey(renderType)) {
                                            datiBlocchiRender.put(renderType, new ArrayList());
                                        }
                                        datiBlocchiRender.get(renderType).add((Tuple<BlockPos, BlockState>)new Tuple((Object)offsetPos, (Object)bs));
                                    }
                                }
                                if (++n_volte < 1000) continue;
                                Thread.sleep(1L);
                                n_volte = 0;
                            }
                        }
                    }
                    datiVertexPronti = true;
                }
                finally {
                    poseStack.m_85849_();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    public static void preparaVertexBuffers() {
        if (Minecraft.m_91087_().f_91073_ == null || !datiVertexPronti || isDatiVertexPronti || VisualizeBlueprintDatas.originPosVisualizeBlueprint == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        PoseStack poseStack = new PoseStack();
        BlockColors blockColors = Minecraft.m_91087_().m_91298_();
        BlockRenderDispatcher dispatcher = mc.m_91289_();
        try {
            BufferBuilder bufferBuilder;
            for (RenderType renderType : datiBlocchiRender.keySet()) {
                bufferBuilder = Tesselator.m_85913_().m_85915_();
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
                for (Tuple<BlockPos, BlockState> datiBlocco : datiBlocchiRender.get(renderType)) {
                    if (RenderBlueprintsPreview.isBlockEntity((BlockState)datiBlocco.m_14419_())) {
                        if (ListaBlocchiSingleRender.contains(datiBlocco)) continue;
                        ListaBlocchiSingleRender.add(datiBlocco);
                        continue;
                    }
                    poseStack.m_85836_();
                    poseStack.m_85837_((double)((BlockPos)datiBlocco.m_14418_()).m_123341_(), (double)((BlockPos)datiBlocco.m_14418_()).m_123342_(), (double)((BlockPos)datiBlocco.m_14418_()).m_123343_());
                    int color = blockColors.m_92577_((BlockState)datiBlocco.m_14419_(), (BlockAndTintGetter)mc.f_91073_, (BlockPos)datiBlocco.m_14418_(), 0);
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    BakedModel model = dispatcher.m_110910_((BlockState)datiBlocco.m_14419_());
                    dispatcher.m_110937_().renderModel(poseStack.m_85850_(), (VertexConsumer)bufferBuilder, (BlockState)datiBlocco.m_14419_(), model, r, g, b, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
                    poseStack.m_85849_();
                }
                BufferBuilder.RenderedBuffer rendered = bufferBuilder.m_231175_();
                VertexBuffer vertexBuffer = new VertexBuffer();
                vertexBuffer.m_85921_();
                vertexBuffer.m_231221_(rendered);
                if (!vertexBuffers.containsKey(renderType)) {
                    vertexBuffers.put(renderType, new ArrayList());
                }
                vertexBuffers.get(renderType).add(vertexBuffer);
                VertexBuffer.m_85931_();
            }
            for (Tuple tuple : datiRenderLiquid) {
                bufferBuilder = Tesselator.m_85913_().m_85915_();
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
                BlockPos pos = new BlockPos(((BlockPos)tuple.m_14418_()).m_123341_() & 0xF, ((BlockPos)tuple.m_14418_()).m_123342_(), ((BlockPos)tuple.m_14418_()).m_123343_() & 0xF);
                dispatcher.m_234363_(pos, (BlockAndTintGetter)mc.f_91073_, (VertexConsumer)bufferBuilder, (BlockState)tuple.m_14419_(), ((BlockState)tuple.m_14419_()).m_60819_());
                BufferBuilder.RenderedBuffer rendered = bufferBuilder.m_231175_();
                VertexBuffer vertexBuffer = new VertexBuffer();
                vertexBuffer.m_85921_();
                vertexBuffer.m_231221_(rendered);
                vertexBuffersLiquids.add((Tuple<BlockPos, VertexBuffer>)new Tuple((Object)((BlockPos)tuple.m_14418_()), (Object)vertexBuffer));
                VertexBuffer.m_85931_();
            }
            isDatiVertexPronti = true;
            finalOriginPos = originPos = new Vec3((double)VisualizeBlueprintDatas.originPosVisualizeBlueprint.m_123341_(), (double)VisualizeBlueprintDatas.originPosVisualizeBlueprint.m_123342_(), (double)VisualizeBlueprintDatas.originPosVisualizeBlueprint.m_123343_());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void render(PoseStack poseStack, Vec3 cameraPos, Matrix4f matrix4f, RenderLevelStageEvent.Stage stage, Frustum frustum) {
        if (!prepared || !isDatiVertexPronti || VisualizeBlueprintDatas.VisualizeBlueprint == null || VisualizeBlueprintDatas.originPosVisualizeBlueprint == null) {
            return;
        }
        Vec3 vOriginPos = new Vec3((double)VisualizeBlueprintDatas.originPosVisualizeBlueprint.m_123341_(), (double)VisualizeBlueprintDatas.originPosVisualizeBlueprint.m_123342_(), (double)VisualizeBlueprintDatas.originPosVisualizeBlueprint.m_123343_());
        int v = 100000;
        if (!finalOriginPos.equals((Object)vOriginPos)) {
            moveTimeAnimation = System.currentTimeMillis() + (long)v;
            finalOriginPos = vOriginPos;
        }
        float t = 1.0f;
        if (moveTimeAnimation - System.currentTimeMillis() <= (long)v) {
            t = 1.0f - (float)(moveTimeAnimation - System.currentTimeMillis()) / (float)v;
        }
        originPos = Operazioni.lerp(originPos, finalOriginPos, (double)t);
        if (!lunghezza.equals((Object)Vec3i.f_123288_) && stage.equals(RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS)) {
            RenderingGraphics.renderBorderBox(poseStack, originPos, originPos.m_82520_((double)(lunghezza.m_123341_() - 1), (double)(lunghezza.m_123342_() - 1), (double)(lunghezza.m_123343_() - 1)), ModConfig.getBlueprintAreaColor(), 1.0f, false);
        }
        poseStack.m_85836_();
        float yAdd = 0.0f;
        if (TimeAnimation >= System.currentTimeMillis()) {
            yAdd = (float)(-VisualizeBlueprintDatas.VisualizeBlueprint.altezza) * ((float)(TimeAnimation - System.currentTimeMillis()) / 2000.0f);
            yAdd *= 2.0f;
        }
        poseStack.m_85837_(RenderBlueprintsPreview.originPos.f_82479_ - cameraPos.f_82479_, RenderBlueprintsPreview.originPos.f_82480_ + (double)yAdd - cameraPos.f_82480_, RenderBlueprintsPreview.originPos.f_82481_ - cameraPos.f_82481_);
        RenderSystem.m_69482_();
        for (RenderType renderType : vertexBuffers.keySet()) {
            if (!STAGE_RENDER_TYPES.containsKey(stage) || !STAGE_RENDER_TYPES.get(stage).contains(renderType)) continue;
            for (VertexBuffer vertexBuffer : vertexBuffers.get(renderType)) {
                vertexBuffer.m_85921_();
                if (renderType.equals(RenderType.m_110451_()) || renderType.equals(RenderType.m_110463_()) || renderType.equals(RenderType.m_110457_())) {
                    RenderSystem.m_157427_(GameRenderer::m_172835_);
                } else if (renderType.equals(RenderType.m_110466_()) || renderType.equals(RenderType.m_110469_())) {
                    RenderSystem.m_69478_();
                    RenderSystem.m_69453_();
                    RenderSystem.m_69482_();
                    RenderSystem.m_69458_((boolean)true);
                    RenderSystem.m_157427_(GameRenderer::m_172649_);
                } else if (renderType.equals(RenderType.m_110503_())) {
                    RenderSystem.m_157427_(GameRenderer::m_172814_);
                }
                RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
                try {
                    RenderSystem.m_69478_();
                    RenderSystem.m_69453_();
                    RenderSystem.m_69482_();
                    RenderSystem.m_69458_((boolean)true);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)BlueprintEvent.HologramTrasparency);
                    vertexBuffer.m_166867_(poseStack.m_85850_().m_85861_(), matrix4f, Objects.requireNonNull(RenderSystem.m_157196_()));
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.m_69461_();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                RenderSystem.m_69458_((boolean)true);
                RenderSystem.m_69461_();
            }
            VertexBuffer.m_85931_();
        }
        if (stage.equals(RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS)) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_157427_(GameRenderer::m_172649_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            for (Tuple tuple : vertexBuffersLiquids) {
                ((VertexBuffer)tuple.m_14419_()).m_85921_();
                Vec3 blockPos = new Vec3((double)((BlockPos)tuple.m_14418_()).m_123341_(), (double)((BlockPos)tuple.m_14418_()).m_123342_(), (double)((BlockPos)tuple.m_14418_()).m_123343_()).m_82520_(RenderBlueprintsPreview.originPos.f_82479_, RenderBlueprintsPreview.originPos.f_82480_, RenderBlueprintsPreview.originPos.f_82481_);
                AABB blockAABB = new AABB(blockPos, blockPos.m_82520_(1.0, 1.0, 1.0));
                if (!frustum.m_113029_(blockAABB)) continue;
                try {
                    poseStack.m_85836_();
                    BlockPos pos = new BlockPos(((BlockPos)tuple.m_14418_()).m_123341_() & 0xF, ((BlockPos)tuple.m_14418_()).m_123342_() & 0xF, ((BlockPos)tuple.m_14418_()).m_123343_() & 0xF);
                    poseStack.m_85837_((double)(((BlockPos)tuple.m_14418_()).m_123341_() - pos.m_123341_()), (double)(((BlockPos)tuple.m_14418_()).m_123342_() - pos.m_123342_()), (double)(((BlockPos)tuple.m_14418_()).m_123343_() - pos.m_123343_()));
                    RenderSystem.m_69478_();
                    RenderSystem.m_69453_();
                    RenderSystem.m_69482_();
                    RenderSystem.m_69458_((boolean)true);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)BlueprintEvent.HologramTrasparency);
                    ((VertexBuffer)tuple.m_14419_()).m_166867_(poseStack.m_85850_().m_85861_(), matrix4f, Objects.requireNonNull(RenderSystem.m_157196_()));
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.m_69461_();
                    poseStack.m_85849_();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                VertexBuffer.m_85931_();
            }
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69461_();
        }
        if (stage.equals(RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS)) {
            Minecraft mc = Minecraft.m_91087_();
            BlockRenderDispatcher blockRenderDispatcher = mc.m_91289_();
            for (Tuple<BlockPos, BlockState> datiBlocco : ListaBlocchiSingleRender) {
                Vec3 blockPos = new Vec3((double)((BlockPos)datiBlocco.m_14418_()).m_123341_(), (double)((BlockPos)datiBlocco.m_14418_()).m_123342_(), (double)((BlockPos)datiBlocco.m_14418_()).m_123343_()).m_82520_(RenderBlueprintsPreview.originPos.f_82479_, RenderBlueprintsPreview.originPos.f_82480_, RenderBlueprintsPreview.originPos.f_82481_);
                AABB blockAABB = new AABB(blockPos, blockPos.m_82520_(1.0, 1.0, 1.0));
                if (!frustum.m_113029_(blockAABB)) continue;
                poseStack.m_85836_();
                poseStack.m_85837_((double)((BlockPos)datiBlocco.m_14418_()).m_123341_(), (double)((BlockPos)datiBlocco.m_14418_()).m_123342_(), (double)((BlockPos)datiBlocco.m_14418_()).m_123343_());
                try {
                    blockRenderDispatcher.renderSingleBlock((BlockState)datiBlocco.m_14419_(), poseStack, (MultiBufferSource)mc.m_91269_().m_110104_(), 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, (RenderType)(((BlockState)datiBlocco.m_14419_()).m_60799_().equals((Object)RenderShape.MODEL) ? RenderType.m_110451_() : null));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                poseStack.m_85849_();
            }
        }
        poseStack.m_85849_();
        if (DirezioneHitboxSelected != null && stage.equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES)) {
            RenderBlueprintsPreview.renderingSelectMovingArea(poseStack);
        }
    }

    private static void renderingSelectMovingArea(PoseStack poseStack) {
        Vec3 angolo2 = originPos.m_82520_((double)lunghezza.m_123341_(), (double)lunghezza.m_123342_(), (double)lunghezza.m_123343_());
        AABB box = null;
        float plus = 0.001f;
        if (DirezioneHitboxSelected.equals((Object)Direction.NORTH)) {
            box = new AABB(originPos.m_82520_(0.0, 0.0, (double)(-plus)), new Vec3(angolo2.f_82479_, angolo2.f_82480_, RenderBlueprintsPreview.originPos.f_82481_ - (double)plus));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.SOUTH)) {
            box = new AABB(angolo2.m_82520_(0.0, 0.0, (double)plus), new Vec3(RenderBlueprintsPreview.originPos.f_82479_, RenderBlueprintsPreview.originPos.f_82480_, angolo2.f_82481_ + (double)plus));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.WEST)) {
            box = new AABB(originPos.m_82520_((double)(-plus), 0.0, 0.0), new Vec3(RenderBlueprintsPreview.originPos.f_82479_ - (double)plus, angolo2.f_82480_, angolo2.f_82481_));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.EAST)) {
            box = new AABB(angolo2.m_82520_((double)plus, 0.0, 0.0), new Vec3(angolo2.f_82479_ + (double)plus, RenderBlueprintsPreview.originPos.f_82480_, RenderBlueprintsPreview.originPos.f_82481_));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.DOWN)) {
            box = new AABB(originPos.m_82520_(0.0, (double)(-plus), 0.0), new Vec3(angolo2.f_82479_, RenderBlueprintsPreview.originPos.f_82480_ - (double)plus, angolo2.f_82481_));
        } else if (DirezioneHitboxSelected.equals((Object)Direction.UP)) {
            box = new AABB(angolo2.m_82520_(0.0, (double)plus, 0.0), new Vec3(RenderBlueprintsPreview.originPos.f_82479_, angolo2.f_82480_ + (double)plus, RenderBlueprintsPreview.originPos.f_82481_));
        }
        Vec3 colore = ModConfig.getBlueprintAreaColor();
        float r = (float)colore.f_82479_;
        float g = (float)colore.f_82480_;
        float b = (float)colore.f_82481_;
        float a = 0.5f;
        if (box == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Vec3 view = mc.f_91063_.m_109153_().m_90583_();
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix = pose.m_85861_();
        float minX = (float)(box.f_82288_ - view.f_82479_);
        float maxX = (float)(box.f_82291_ - view.f_82479_);
        float minZ = (float)(box.f_82290_ - view.f_82481_);
        float maxZ = (float)(box.f_82293_ - view.f_82481_);
        float maxY = (float)(box.f_82292_ - view.f_82480_);
        float minY = (float)(box.f_82289_ - view.f_82480_);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69472_();
        RenderSystem.m_69482_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        if (DirezioneHitboxSelected.equals((Object)Direction.NORTH) || DirezioneHitboxSelected.equals((Object)Direction.SOUTH)) {
            buffer.m_85982_(matrix, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        }
        if (DirezioneHitboxSelected.equals((Object)Direction.EAST) || DirezioneHitboxSelected.equals((Object)Direction.WEST)) {
            buffer.m_85982_(matrix, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        }
        if (DirezioneHitboxSelected.equals((Object)Direction.UP) || DirezioneHitboxSelected.equals((Object)Direction.DOWN)) {
            buffer.m_85982_(matrix, minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
            buffer.m_85982_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        }
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
        RenderSystem.m_69465_();
    }

    public static boolean isBlockEntity(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block;
            try {
                BlockEntity be = entityBlock.m_142194_(BlockPos.f_121853_, state);
                if (be == null) {
                    return false;
                }
                BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(be);
                return renderer != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isLiquidBlock(BlockState state) {
        if (state.m_60734_() instanceof LiquidBlock) {
            return !state.m_60819_().m_76178_();
        }
        return false;
    }

    private static void cleanup() {
        for (RenderType renderType : vertexBuffers.keySet()) {
            for (VertexBuffer vertex : vertexBuffers.get(renderType)) {
                vertex.close();
            }
        }
        vertexBuffers.clear();
        vertexBuffersLiquids.clear();
        ListaBlocchiSingleRender.clear();
        lunghezza = Vec3i.f_123288_;
        if (executor != null && !executor.isShutdown()) {
            executor.shutdownNow();
            executor = null;
        }
        lastBlueprintItem = null;
        datiVertexPronti = false;
        isDatiVertexPronti = false;
        originPos = Vec3.f_82478_;
        finalOriginPos = Vec3.f_82478_;
    }

    public static void CleanAndPrepare() {
        RenderBlueprintsPreview.doCleanUp();
        prepared = false;
    }

    public static void doCleanUp() {
        doCleanup = true;
    }

    public static void renderHologramLoadingBar(RenderLevelStageEvent event) {
        if (!event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_SKY) || Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (nAvanzamento <= NblockBlueprint) {
            Minecraft.m_91087_().f_91074_.m_5661_(RenderBlueprintsPreview.progresso(), true);
            if (nAvanzamento == NblockBlueprint) {
                NblockBlueprint = -1;
                nAvanzamento = 0;
                prepared = false;
                TimeAnimation = System.currentTimeMillis() + 2000L;
            }
        }
    }

    public static void setNuovoAvanzamentoHologramLoadingBar(int nBlocchi) {
        nAvanzamento = 0;
        NblockBlueprint = nBlocchi;
        RenderBlueprintsPreview.cleanup();
    }

    public static void aggiungiAvanzamento() {
        ++nAvanzamento;
    }

    private static Component progresso() {
        int barrePiene = (int)((float)nAvanzamento / (float)NblockBlueprint * 15.0f);
        int barreVuote = 15 - barrePiene;
        if (barrePiene < 0) {
            barrePiene = 0;
        }
        if (barreVuote < 0) {
            barreVuote = 0;
        }
        return Component.m_237113_((String)"\u2b1b".repeat(barrePiene)).m_130940_(ChatFormatting.DARK_BLUE).m_7220_((Component)Component.m_237113_((String)"\u2b1b".repeat(barreVuote)).m_130940_(ChatFormatting.BLACK));
    }
}

