/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.altro;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nimble.portable_blueprints.portable_blueprints.Mod;

@Mod.EventBusSubscriber
public class BlockBlueprintUsage {
    private static final Gson GSON = new Gson();
    private static Path CBPHWorldDir = null;
    public static List<String> PlayersBlock = new ArrayList<String>();

    @SubscribeEvent
    public static void load(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        Path worldDir = server.m_129843_(LevelResource.f_78182_);
        CBPHWorldDir = worldDir.resolve("portable_blueprints/general");
        try {
            BlockBlueprintUsage.creaDirectoryConFileSetting();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadData() {
        try {
            File BlockBanData = new File(CBPHWorldDir.toFile(), "block.data");
            Type type = new TypeToken<List<UUID>>(){}.getType();
            PlayersBlock = (List)GSON.fromJson((Reader)new FileReader(BlockBanData), type);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveData() {
        try {
            File BlockBanData = new File(CBPHWorldDir.toFile(), "block.data");
            try (FileWriter writer = new FileWriter(BlockBanData);){
                GSON.toJson(PlayersBlock, (Appendable)writer);
            }
            catch (IOException iOException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void creaDirectoryConFileSetting() {
        try {
            Files.createDirectories(CBPHWorldDir, new FileAttribute[0]);
            File BlockBanData = new File(CBPHWorldDir.toFile(), "block.data");
            if (!BlockBanData.exists()) {
                BlockBlueprintUsage.saveData();
            } else {
                BlockBlueprintUsage.loadData();
            }
        }
        catch (Exception e) {
            Mod.LOGGER.error("[Portable blueprint] -> Create block.data File error:");
            Mod.LOGGER.error(e.getMessage());
        }
    }
}

