/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.altro;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import nimble.portable_blueprints.altro.CustomBlockProprietyHandle;
import nimble.portable_blueprints.altro.PlacingBlockManager;
import nimble.portable_blueprints.altro.ProgressBarBlueprintPlayer;
import nimble.portable_blueprints.client.ClientMethods;
import nimble.portable_blueprints.init.ModItems;
import nimble.portable_blueprints.mod_compatibility.ModCompatibilityInit;
import nimble.portable_blueprints.mod_compatibility.projecte.ProjectEMetodi;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.StoC_AnimazionePosizionamentoBlocco;
import nimble.portable_blueprints.network.StoC_ScannerAnimation;
import nimble.portable_blueprints.network.global_blueprint_net.CtoS_SaveGlobalBlueprintInServer;
import nimble.portable_blueprints.portable_blueprints.Mod;
import nimble.portable_blueprints.portable_blueprints.ModServerConfig;
import nimble.portable_blueprints.robautile.ModifiableItemInventory;
import nimble.portable_blueprints.robautile.Operazioni;

@Mod.EventBusSubscriber
public class Blueprint {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final String extension = ".bp";
    public static final String extension_swm = ".swm";
    private static final int MAX_BLOCKS_FOR_TICK = 500;
    public static List<Block> ILLEGAL_BLOCK_IN_SURVIVAL = new ArrayList<Block>();
    private static List<BlueprintStructure> structureDaFare = new ArrayList<BlueprintStructure>();
    private static Map<BlueprintStartingData, BlueprintDatas> creazioneDati = new HashMap<BlueprintStartingData, BlueprintDatas>();

    public static void setup() {
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50752_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50257_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50258_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50142_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50272_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50447_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50448_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50375_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50677_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50454_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50678_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_152480_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50110_);
        ILLEGAL_BLOCK_IN_SURVIVAL.add(Blocks.f_50449_);
    }

    public static void CreateBlueprint(ServerLevel level, BlockPos angolo1, BlockPos angolo2, String nome, UUID richiedente, boolean consideraCreativeBlocks, List<String> ScannerIgnoredBlocks) {
        BlueprintStartingData bsd;
        BlockPos angoloIniziale = new BlockPos(angolo1.m_123341_() < angolo2.m_123341_() ? angolo1.m_123341_() : angolo2.m_123341_(), angolo1.m_123342_() < angolo2.m_123342_() ? angolo1.m_123342_() : angolo2.m_123342_(), angolo1.m_123343_() < angolo2.m_123343_() ? angolo1.m_123343_() : angolo2.m_123343_());
        BlockPos angoloFinale = new BlockPos(angolo1.m_123341_() < angolo2.m_123341_() ? angolo2.m_123341_() : angolo1.m_123341_(), angolo1.m_123342_() < angolo2.m_123342_() ? angolo2.m_123342_() : angolo1.m_123342_(), angolo1.m_123343_() < angolo2.m_123343_() ? angolo2.m_123343_() : angolo1.m_123343_());
        UUID uuidAnimazioneScanner = UUID.randomUUID();
        if (level.m_46003_(richiedente) != null) {
            PacketHandler.sendToPlayer(new StoC_ScannerAnimation(uuidAnimazioneScanner, true, angoloIniziale, angoloFinale), (ServerPlayer)level.m_46003_(richiedente));
        }
        if (!creazioneDati.containsKey(bsd = new BlueprintStartingData(level, nome, angoloIniziale, angoloFinale, richiedente, consideraCreativeBlocks, ScannerIgnoredBlocks, uuidAnimazioneScanner))) {
            BlueprintDatas bd = new BlueprintDatas(nome);
            bd.setX(angoloFinale.m_123341_() - angoloIniziale.m_123341_() + 1);
            bd.setZ(angoloFinale.m_123343_() - angoloIniziale.m_123343_() + 1);
            bd.altezza = angoloFinale.m_123342_() - angoloIniziale.m_123342_() + 1;
            creazioneDati.put(bsd, bd);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        block77: {
            block78: {
                if (event.phase != TickEvent.Phase.END) break block77;
                if (creazioneDati.isEmpty()) break block78;
                BlueprintStartingData key = null;
                Iterator<BlueprintStartingData> iterator = creazioneDati.keySet().iterator();
                if (iterator.hasNext()) {
                    BlueprintStartingData k;
                    key = k = iterator.next();
                }
                if (key.serverLevel.m_46003_(key.uuid) == null) {
                    creazioneDati.remove(key);
                    key = null;
                }
                if (key == null) break block77;
                int controllati = 0;
                while (key.posYControllata != key.angolo2.m_123342_() + 1) {
                    while (key.posXControllata != key.angolo2.m_123341_() + 1) {
                        while (key.posZControllata != key.angolo2.m_123343_() + 1 && controllati < 500) {
                            BlockPos position = new BlockPos(key.posXControllata, key.posYControllata, key.posZControllata);
                            BlockState blockState = key.serverLevel.m_8055_(position);
                            if (blockState.m_60734_().equals(Blocks.f_50628_)) {
                                blockState = Blocks.f_49990_.m_49966_();
                            }
                            if (!(blockState.m_60713_(Blocks.f_50016_) || !key.consideraCreativeBlocks && (key.consideraCreativeBlocks || ILLEGAL_BLOCK_IN_SURVIVAL.contains(blockState.m_60734_())) || key.scannerIgnoredBlocks.contains(ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_()).toString()))) {
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61422_)) {
                                    if (blockState.m_60734_() instanceof LiquidBlock && (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61422_) != 0) {
                                        ++key.posZControllata;
                                        ++controllati;
                                        continue;
                                    }
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61422_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61418_)) {
                                    blockState = blockState.m_60734_().equals(Blocks.f_152476_) || blockState.m_60734_().equals(Blocks.f_152477_) ? Blocks.f_50256_.m_49966_() : (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61418_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61419_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61419_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61420_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61420_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61421_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61421_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61405_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61405_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61406_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61406_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61407_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_222999_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_222999_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61408_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61408_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61409_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61410_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61410_, (Comparable)Integer.valueOf(0));
                                }
                                if (blockState.m_61138_((Property)BlockStateProperties.f_61411_)) {
                                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61411_, (Comparable)Integer.valueOf(0));
                                }
                                String nbt = "";
                                BlockEntity blockEntity = key.serverLevel.m_7702_(position);
                                if (blockEntity != null && !blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
                                    nbt = key.serverLevel.m_7702_(position).serializeNBT().m_7916_();
                                }
                                if (!blockState.m_60811_().name().equals("DESTROY") && !blockState.m_60812_((BlockGetter)key.serverLevel, position).m_83281_()) {
                                    creazioneDati.get(key).addBlock(key.altezzaArrivato, Operazioni.getVec3iString(new Vec3i(key.posXControllata - key.angolo1.m_123341_(), key.posYControllata - key.angolo1.m_123342_(), key.posZControllata - key.angolo1.m_123343_())), Operazioni.getBlockStateString(blockState), nbt);
                                } else {
                                    creazioneDati.get(key).addNonSolidBlock(key.altezzaArrivato, Operazioni.getVec3iString(new Vec3i(key.posXControllata - key.angolo1.m_123341_(), key.posYControllata - key.angolo1.m_123342_(), key.posZControllata - key.angolo1.m_123343_())), Operazioni.getBlockStateString(blockState), nbt);
                                }
                            }
                            if (key.serverLevel.m_46003_(key.uuid) != null) {
                                if (!key.annullaAnimazioneScanner) {
                                    PacketHandler.sendToPlayer(new StoC_ScannerAnimation(key.uuidAnimazioneScanner), (ServerPlayer)key.serverLevel.m_46003_(key.uuid));
                                }
                            } else {
                                key.annullaAnimazioneScanner = true;
                            }
                            ++key.posZControllata;
                            ++controllati;
                        }
                        if (controllati >= 500) break;
                        ++key.posXControllata;
                        key.posZControllata = key.angolo1.m_123343_();
                    }
                    if (controllati >= 500) break;
                    ++key.posYControllata;
                    ++key.altezzaArrivato;
                    key.posXControllata = key.angolo1.m_123341_();
                }
                if (controllati >= 500) break block77;
                File jsonFile = new File(Blueprint.getFileForBlueprints(key.serverLevel, key.uuid), key.nome + extension);
                try (FileWriter writer = new FileWriter(jsonFile);){
                    GSON.toJson((Object)creazioneDati.get(key), (Appendable)writer);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (key.serverLevel.m_46003_(key.uuid) != null) {
                    key.serverLevel.m_46003_(key.uuid).m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"hotbar_message.portable_blueprints.blueprint_saved").getString().replace("%v%", key.nome)).m_130940_(ChatFormatting.GREEN), true);
                    PacketHandler.sendToPlayer(new StoC_ScannerAnimation(key.uuidAnimazioneScanner, false, BlockPos.f_121853_, BlockPos.f_121853_), (ServerPlayer)key.serverLevel.m_46003_(key.uuid));
                }
                creazioneDati.remove(key);
                break block77;
            }
            if (structureDaFare.size() > 0) {
                ArrayList<BlueprintStructure> toRemove = new ArrayList<BlueprintStructure>();
                int nBlocchiArrivati = 0;
                boolean skip = false;
                for (BlueprintStructure bs : structureDaFare) {
                    if (skip) break;
                    if (!Blueprint.playerIsOnline(bs.owner)) {
                        toRemove.add(bs);
                        continue;
                    }
                    ArrayList<BlockPos> blocchiDaScartareDaEspansione = new ArrayList<BlockPos>();
                    for (BlockPos posBlocco : new ArrayList<BlockPos>(bs.posDiEspansione)) {
                        BlockPos newPos;
                        if (skip) break;
                        BlockState b = bs.serverLevel.m_8055_(Operazioni.SommaBlockPos(bs.bd.offset, posBlocco));
                        if (b.m_60713_(Blocks.f_50016_) || PlacingBlockManager.isRimpiazzabile(bs.serverLevel, b, Operazioni.SommaBlockPos(bs.bd.offset, posBlocco))) {
                            if (bs.solidi && bs.bd.BlocksData.containsKey(posBlocco.m_123342_()) && bs.bd.BlocksData.get(posBlocco.m_123342_()).containsKey(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_())))) {
                                datiBlocco = bs.bd.BlocksData.get(posBlocco.m_123342_()).get(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_())));
                                bloccoId = datiBlocco.substring(datiBlocco.indexOf("<bid>") + 5, datiBlocco.indexOf("</bid>"));
                                blockState = (datiBlocco = datiBlocco.replaceFirst("<bid>" + bloccoId + "</bid>", "")).equals("null") ? Operazioni.getBlockFromString(bloccoId).m_49966_() : Operazioni.getPropertiesStringToBlock(Operazioni.getBlockFromString(bloccoId), datiBlocco);
                                posizioneAnim = Vec3.f_82478_;
                                item_trovato = false;
                                if (Blueprint.playerIsOnline(bs.owner)) {
                                    posizioneAnim = bs.owner.m_20182_().m_82520_(0.0, 1.0, 0.0);
                                    if (bs.free_build || ILLEGAL_BLOCK_IN_SURVIVAL.contains(blockState.m_60734_()) && bs.owner.m_7500_() || bs.owner.m_5833_()) {
                                        item_trovato = true;
                                    } else if (ILLEGAL_BLOCK_IN_SURVIVAL.contains(blockState.m_60734_())) {
                                        item_trovato = false;
                                    } else if (bs.owner.m_7500_() || bs.owner.m_5833_() || blockState.m_61138_((Property)BlockStateProperties.f_61401_) && ((DoubleBlockHalf)blockState.m_61143_((Property)BlockStateProperties.f_61401_)).equals((Object)DoubleBlockHalf.UPPER) || blockState.m_61138_((Property)BlockStateProperties.f_61391_) && ((BedPart)blockState.m_61143_((Property)BlockStateProperties.f_61391_)).equals((Object)BedPart.HEAD)) {
                                        item_trovato = true;
                                    } else {
                                        v = Blueprint.removeItemFromTheContainers((ServerPlayer)bs.owner, bs.serverLevel, bs.posizione_container, Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).m_41720_());
                                        if (!((Boolean)v.m_14418_()).booleanValue() && bs.emc_active && ProjectEMetodi.removeEMCForItem((ServerPlayer)bs.owner, Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).m_41720_())) {
                                            item_trovato = true;
                                        } else {
                                            item_trovato = (Boolean)v.m_14418_();
                                            posizioneAnim = (Vec3)v.m_14419_();
                                        }
                                    }
                                } else {
                                    toRemove.add(bs);
                                    continue;
                                }
                                if (item_trovato) {
                                    if (!blockState.m_61138_((Property)BlockStateProperties.f_61401_) || blockState.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
                                        p = Operazioni.SommaBlockPos(bs.bd.offset, posBlocco);
                                        PacketHandler.sendToAllClients(new StoC_AnimazionePosizionamentoBlocco(Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).m_41720_(), System.currentTimeMillis() + 1000L, posizioneAnim, new Vec3((double)((float)p.m_123341_() + 0.5f), (double)((float)p.m_123342_() + 0.5f), (double)((float)p.m_123343_() + 0.5f))));
                                    }
                                    ProgressBarBlueprintPlayer.visualizza((ServerPlayer)bs.owner);
                                    nbt = bs.bd.BlocksNBT != null && bs.bd.BlocksNBT.containsKey(posBlocco.m_123342_()) && bs.bd.BlocksNBT.get(posBlocco.m_123342_()).containsKey(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_()))) ? bs.bd.BlocksNBT.get(posBlocco.m_123342_()).get(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_()))) : "";
                                    PlacingBlockManager.addNewPlaceBlock(bs.serverLevel, Operazioni.SommaBlockPos(bs.bd.offset, posBlocco), blockState, nbt, bs.allow_nbt, 1000L);
                                }
                            } else if (!bs.solidi && bs.bd.NotSolidBlocksData.containsKey(posBlocco.m_123342_()) && bs.bd.NotSolidBlocksData.get(posBlocco.m_123342_()).containsKey(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_())))) {
                                datiBlocco = bs.bd.NotSolidBlocksData.get(posBlocco.m_123342_()).get(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_())));
                                bloccoId = datiBlocco.substring(datiBlocco.indexOf("<bid>") + 5, datiBlocco.indexOf("</bid>"));
                                blockState = (datiBlocco = datiBlocco.replaceFirst("<bid>" + bloccoId + "</bid>", "")).equals("null") ? Operazioni.getBlockFromString(bloccoId).m_49966_() : Operazioni.getPropertiesStringToBlock(Operazioni.getBlockFromString(bloccoId), datiBlocco);
                                posizioneAnim = Vec3.f_82478_;
                                item_trovato = false;
                                if (Blueprint.playerIsOnline(bs.owner)) {
                                    posizioneAnim = bs.owner.m_20182_().m_82520_(0.0, 1.0, 0.0);
                                    if (bs.free_build || ILLEGAL_BLOCK_IN_SURVIVAL.contains(blockState.m_60734_()) && bs.owner.m_7500_() || bs.owner.m_5833_()) {
                                        item_trovato = true;
                                    } else if (ILLEGAL_BLOCK_IN_SURVIVAL.contains(blockState.m_60734_())) {
                                        item_trovato = false;
                                    } else if (bs.owner.m_7500_() || bs.owner.m_5833_() || blockState.m_61138_((Property)BlockStateProperties.f_61401_) && ((DoubleBlockHalf)blockState.m_61143_((Property)BlockStateProperties.f_61401_)).equals((Object)DoubleBlockHalf.UPPER) || blockState.m_61138_((Property)BlockStateProperties.f_61391_) && ((BedPart)blockState.m_61143_((Property)BlockStateProperties.f_61391_)).equals((Object)BedPart.HEAD)) {
                                        item_trovato = true;
                                    } else {
                                        v = Blueprint.removeItemFromTheContainers((ServerPlayer)bs.owner, bs.serverLevel, bs.posizione_container, Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).m_41720_());
                                        if (!((Boolean)v.m_14418_()).booleanValue() && bs.emc_active && ProjectEMetodi.removeEMCForItem((ServerPlayer)bs.owner, Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).m_41720_())) {
                                            item_trovato = true;
                                        } else {
                                            item_trovato = (Boolean)v.m_14418_();
                                            posizioneAnim = (Vec3)v.m_14419_();
                                        }
                                    }
                                } else {
                                    toRemove.add(bs);
                                    continue;
                                }
                                if (item_trovato) {
                                    if (!blockState.m_61138_((Property)BlockStateProperties.f_61401_) || blockState.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
                                        p = Operazioni.SommaBlockPos(bs.bd.offset, posBlocco);
                                        PacketHandler.sendToAllClients(new StoC_AnimazionePosizionamentoBlocco(Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).m_41720_(), System.currentTimeMillis() + 1000L, posizioneAnim, new Vec3((double)((float)p.m_123341_() + 0.5f), (double)((float)p.m_123342_() + 0.5f), (double)((float)p.m_123343_() + 0.5f))));
                                    }
                                    ProgressBarBlueprintPlayer.visualizza((ServerPlayer)bs.owner);
                                    nbt = bs.bd.BlocksNBT != null && bs.bd.BlocksNBT.containsKey(posBlocco.m_123342_()) && bs.bd.BlocksNBT.get(posBlocco.m_123342_()).containsKey(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_()))) ? bs.bd.BlocksNBT.get(posBlocco.m_123342_()).get(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_()))) : "";
                                    PlacingBlockManager.addNewPlaceBlock(bs.serverLevel, Operazioni.SommaBlockPos(bs.bd.offset, posBlocco), blockState, nbt, bs.allow_nbt, 1000L);
                                }
                            }
                        } else if (Blueprint.playerIsOnline(bs.owner) && (bs.solidi && bs.bd.BlocksData.containsKey(posBlocco.m_123342_()) && bs.bd.BlocksData.get(posBlocco.m_123342_()).containsKey(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_()))) || !bs.solidi && bs.bd.NotSolidBlocksData.containsKey(posBlocco.m_123342_()) && bs.bd.NotSolidBlocksData.get(posBlocco.m_123342_()).containsKey(Operazioni.getVec3iString(new Vec3i(posBlocco.m_123341_(), posBlocco.m_123342_(), posBlocco.m_123343_()))))) {
                            ProgressBarBlueprintPlayer.visualizza((ServerPlayer)bs.owner);
                        }
                        if (posBlocco.m_123341_() - 1 >= 0 && !bs.posDiEspansione.contains(newPos = Operazioni.SommaBlockPos(posBlocco, new BlockPos(-1, 0, 0)))) {
                            bs.posDiEspansione.add(newPos);
                        }
                        if (posBlocco.m_123343_() - 1 >= 0 && !bs.posDiEspansione.contains(newPos = Operazioni.SommaBlockPos(posBlocco, new BlockPos(0, 0, -1)))) {
                            bs.posDiEspansione.add(newPos);
                        }
                        if (posBlocco.m_123342_() + 1 < bs.bd.altezza && !bs.posDiEspansione.contains(newPos = Operazioni.SommaBlockPos(posBlocco, new BlockPos(0, 1, 0)))) {
                            bs.posDiEspansione.add(newPos);
                        }
                        if (posBlocco.m_123341_() - 1 >= 0 && posBlocco.m_123343_() - 1 >= 0 && !bs.posDiEspansione.contains(newPos = Operazioni.SommaBlockPos(posBlocco, new BlockPos(-1, 0, -1)))) {
                            bs.posDiEspansione.add(newPos);
                        }
                        blocchiDaScartareDaEspansione.add(posBlocco);
                        if (++nBlocchiArrivati < 500) continue;
                        skip = true;
                    }
                    for (BlockPos posDelet : blocchiDaScartareDaEspansione) {
                        bs.posDiEspansione.remove(posDelet);
                    }
                    if (bs.solidi && bs.posDiEspansione.size() == 0) {
                        bs.solidi = false;
                        bs.posDiEspansione.add(new BlockPos(bs.bd.lunghezzaX - 1, 0, bs.bd.lunghezzaZ - 1));
                    }
                    if (bs.posDiEspansione != null && bs.posDiEspansione.size() != 0) continue;
                    toRemove.add(bs);
                }
                for (BlueprintStructure b : toRemove) {
                    structureDaFare.remove(b);
                }
            }
        }
    }

    private static boolean playerIsOnline(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return serverPlayer.m_20194_().m_6846_().m_11259_(serverPlayer.m_20148_()) != null;
        }
        return false;
    }

    public static File getFileForBlueprints(ServerLevel level, UUID uuid) {
        File CartellaMod = new File(level.m_7654_().m_129843_(LevelResource.f_78182_).toFile(), "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "blueprints")).exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, uuid.toString())).exists()) {
            CartellaMod.mkdir();
        }
        return CartellaMod;
    }

    public static boolean BlueprintExist(ServerLevel level, String nome, UUID richiedente) {
        File cartella = Blueprint.getFileForBlueprints(level, richiedente);
        for (File child : cartella.listFiles()) {
            if (!child.getName().equals(nome + extension)) continue;
            return true;
        }
        return false;
    }

    public static void RimuoviBlueprint(ServerLevel level, ServerPlayer player, String nome) {
        SharedWithMe swm = Blueprint.getSharedBlueprints(level, player.m_20148_());
        for (UUID shared_with : swm.getAllSpecificSWOBPlayersUUID(nome)) {
            Blueprint.removeSharedBlueprint(level, nome, player.m_20148_(), shared_with);
        }
        for (File f : Blueprint.getFileForBlueprints(level, player.m_20148_()).listFiles()) {
            if (!f.getName().equals(nome + extension)) continue;
            f.delete();
            break;
        }
    }

    public static void CreaItemBlueprintEDaiAGiocatore(ServerPlayer player, UUID owner, String nome, int altezza, int lunghezzaX, int lunghezzaZ) {
        boolean added;
        ItemStack blueprint = nome.contains("[Global]") ? new ItemStack((ItemLike)ModItems.GLOBAL_BLUEPRINT.get(), 1) : new ItemStack((ItemLike)ModItems.BLUEPRINT.get(), 1);
        Item item = blueprint.m_41720_();
        if (item instanceof nimble.portable_blueprints.items.Blueprint) {
            nimble.portable_blueprints.items.Blueprint blueprintItem = (nimble.portable_blueprints.items.Blueprint)item;
            blueprintItem.setBlueprint(blueprint, player, owner, nome, altezza, lunghezzaX, lunghezzaZ);
        }
        if (!(added = player.m_150109_().m_36054_(blueprint))) {
            player.m_240418_((Component)Component.m_237115_((String)"system.portable_blueprints.inv_full"), true);
        }
    }

    public static void CreaItemServerBlueprintEDaiAGiocatore(ServerPlayer player, String nome, int altezza, int lunghezzaX, int lunghezzaZ) {
        boolean added;
        ItemStack blueprint = new ItemStack((ItemLike)ModItems.SERVER_BLUEPRINT.get(), 1);
        Item item = blueprint.m_41720_();
        if (item instanceof nimble.portable_blueprints.items.Blueprint) {
            nimble.portable_blueprints.items.Blueprint blueprintItem = (nimble.portable_blueprints.items.Blueprint)item;
            blueprintItem.setServerBlueprint(blueprint, nome, altezza, lunghezzaX, lunghezzaZ);
        }
        if (!(added = player.m_150109_().m_36054_(blueprint))) {
            player.m_240418_((Component)Component.m_237115_((String)"system.portable_blueprints.inv_full"), true);
        }
    }

    public static void AggiungiStructureAllaCoda(ServerLevel level, BlueprintDatas bd, Player player, List<BlockPos> posizione_container, boolean free_build, short allow_nbt, boolean emc_active) {
        if (!structureDaFare.contains(new BlueprintStructure(level, bd, player, posizione_container, free_build, allow_nbt, emc_active))) {
            structureDaFare.add(new BlueprintStructure(level, bd, player, posizione_container, free_build, allow_nbt, emc_active));
            ProgressBarBlueprintPlayer.creaProgressBar((ServerPlayer)player, bd.getAllBlocksCount());
        }
    }

    public static Map<Item, Integer> getAllItemQuantityFromInventory(ServerPlayer player, ServerLevel level, List<BlockPos> posizioniContainer) {
        HashMap<Item, Integer> ItemQuantity = new HashMap<Item, Integer>();
        for (ItemStack item : player.m_150109_().f_35974_) {
            if (ItemQuantity.containsKey(item.m_41720_())) {
                ItemQuantity.replace(item.m_41720_(), (Integer)ItemQuantity.get(item.m_41720_()) + item.m_41613_());
            } else {
                ItemQuantity.put(item.m_41720_(), item.m_41613_());
            }
            ModifiableItemInventory.of(item).ifPresent(inv -> {
                Container container = inv.getContainer();
                for (int x = 0; x < container.m_6643_(); ++x) {
                    ItemStack itemStack = container.m_8020_(x);
                    if (ItemQuantity.containsKey(itemStack.m_41720_())) {
                        ItemQuantity.replace(itemStack.m_41720_(), (Integer)ItemQuantity.get(itemStack.m_41720_()) + itemStack.m_41613_() * item.m_41613_());
                        continue;
                    }
                    ItemQuantity.put(itemStack.m_41720_(), itemStack.m_41613_() * item.m_41613_());
                }
            });
        }
        for (ItemStack armorItem : player.m_150109_().f_35975_) {
            if (ItemQuantity.containsKey(armorItem.m_41720_())) {
                ItemQuantity.replace(armorItem.m_41720_(), (Integer)ItemQuantity.get(armorItem.m_41720_()) + armorItem.m_41613_());
            } else {
                ItemQuantity.put(armorItem.m_41720_(), armorItem.m_41613_());
            }
            ModifiableItemInventory.of(armorItem).ifPresent(inv -> {
                Container container = inv.getContainer();
                for (int x = 0; x < container.m_6643_(); ++x) {
                    ItemStack itemStack = container.m_8020_(x);
                    if (ItemQuantity.containsKey(itemStack.m_41720_())) {
                        ItemQuantity.replace(itemStack.m_41720_(), (Integer)ItemQuantity.get(itemStack.m_41720_()) + itemStack.m_41613_() * armorItem.m_41613_());
                        continue;
                    }
                    ItemQuantity.put(itemStack.m_41720_(), itemStack.m_41613_() * armorItem.m_41613_());
                }
            });
        }
        for (BlockPos posizione : posizioniContainer) {
            BlockEntity be = level.m_7702_(posizione);
            if (be == null) continue;
            be.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                for (int x = 0; x < handler.getSlots(); ++x) {
                    ItemStack item = handler.getStackInSlot(x);
                    if (ItemQuantity.containsKey(item.m_41720_())) {
                        ItemQuantity.replace(item.m_41720_(), (Integer)ItemQuantity.get(item.m_41720_()) + item.m_41613_());
                    } else {
                        ItemQuantity.put(item.m_41720_(), item.m_41613_());
                    }
                    ModifiableItemInventory.of(item).ifPresent(inv -> {
                        Container container_item = inv.getContainer();
                        for (int xItem = 0; xItem < container_item.m_6643_(); ++xItem) {
                            ItemStack itemStack = container_item.m_8020_(xItem);
                            if (ItemQuantity.containsKey(itemStack.m_41720_())) {
                                ItemQuantity.replace(itemStack.m_41720_(), (Integer)ItemQuantity.get(itemStack.m_41720_()) + itemStack.m_41613_() * item.m_41613_());
                                continue;
                            }
                            ItemQuantity.put(itemStack.m_41720_(), itemStack.m_41613_() * item.m_41613_());
                        }
                    });
                }
            });
        }
        return ItemQuantity;
    }

    public static Tuple<Boolean, Vec3> removeItemFromTheContainers(ServerPlayer player, ServerLevel level, List<BlockPos> posizioniContainer, Item Target) {
        AtomicReference v;
        for (ItemStack item : player.m_150109_().f_35974_) {
            if (item.m_41720_().equals(Target)) {
                if (item.m_41720_().equals(Items.f_42447_) || item.m_41720_().equals(Items.f_42448_)) {
                    item.m_41764_(item.m_41613_() - 1);
                    int item_rimasti = Operazioni.addItemToInventory(player.m_150109_(), new ItemStack((ItemLike)Items.f_42446_), 1);
                    if (item_rimasti > 0) {
                        Operazioni.dropItem((Level)level, player.m_20182_(), new ItemStack((ItemLike)Items.f_42446_));
                    }
                } else {
                    item.m_41764_(item.m_41613_() - 1);
                }
                return new Tuple((Object)true, (Object)player.m_20182_().m_82520_(0.0, 1.0, 0.0));
            }
            v = new AtomicReference();
            ModifiableItemInventory.of(item).ifPresent(inv -> {
                Container container = inv.getContainer();
                for (int x = 0; x < container.m_6643_(); ++x) {
                    ItemStack itemStack = container.m_8020_(x);
                    if (!itemStack.m_41720_().equals(Target)) continue;
                    if (itemStack.m_41720_().equals(Items.f_42447_) || itemStack.m_41720_().equals(Items.f_42448_)) {
                        itemStack.m_41764_(itemStack.m_41613_() - 1);
                        int item_rimasti = Operazioni.addItemToInventory(player.m_150109_(), new ItemStack((ItemLike)Items.f_42446_), 1);
                        if (item_rimasti > 0) {
                            Operazioni.dropItem((Level)level, player.m_20182_(), new ItemStack((ItemLike)Items.f_42446_));
                        }
                    } else {
                        itemStack.m_41764_(itemStack.m_41613_() - 1);
                    }
                    v.set(new Tuple((Object)true, (Object)player.m_20182_().m_82520_(0.0, 1.0, 0.0)));
                }
                inv.save();
            });
            if (v.get() == null) continue;
            return (Tuple)v.get();
        }
        for (ItemStack armorItem : player.m_150109_().f_35975_) {
            if (armorItem.m_41720_().equals(Target)) {
                if (armorItem.m_41720_().equals(Items.f_42447_) || armorItem.m_41720_().equals(Items.f_42448_)) {
                    armorItem.m_41764_(armorItem.m_41613_() - 1);
                    int item_rimasti = Operazioni.addItemToInventory(player.m_150109_(), new ItemStack((ItemLike)Items.f_42446_), 1);
                    if (item_rimasti > 0) {
                        Operazioni.dropItem((Level)level, player.m_20182_(), new ItemStack((ItemLike)Items.f_42446_));
                    }
                } else {
                    armorItem.m_41764_(armorItem.m_41613_() - 1);
                }
                return new Tuple((Object)true, (Object)player.m_20182_().m_82520_(0.0, 1.0, 0.0));
            }
            v = new AtomicReference();
            ModifiableItemInventory.of(armorItem).ifPresent(inv -> {
                Container container = inv.getContainer();
                for (int x = 0; x < container.m_6643_(); ++x) {
                    ItemStack itemStack = container.m_8020_(x);
                    if (!itemStack.m_41720_().equals(Target)) continue;
                    if (itemStack.m_41720_().equals(Items.f_42447_) || itemStack.m_41720_().equals(Items.f_42448_)) {
                        itemStack.m_41764_(itemStack.m_41613_() - 1);
                        int item_rimasti = Operazioni.addItemToInventory(player.m_150109_(), new ItemStack((ItemLike)Items.f_42446_), 1);
                        if (item_rimasti > 0) {
                            Operazioni.dropItem((Level)level, player.m_20182_(), new ItemStack((ItemLike)Items.f_42446_));
                        }
                    } else {
                        itemStack.m_41764_(itemStack.m_41613_() - 1);
                    }
                    v.set(new Tuple((Object)true, (Object)player.m_20182_().m_82520_(0.0, 1.0, 0.0)));
                }
                inv.save();
            });
            if (v.get() == null) continue;
            return (Tuple)v.get();
        }
        for (BlockPos posizione : posizioniContainer) {
            BlockEntity be = level.m_7702_(posizione);
            if (be == null) continue;
            AtomicReference v2 = new AtomicReference();
            be.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                for (int x = 0; x < handler.getSlots(); ++x) {
                    ItemStack item = handler.getStackInSlot(x);
                    if (item.m_41720_().equals(Target)) {
                        if (item.m_41720_().equals(Items.f_42447_) || item.m_41720_().equals(Items.f_42448_)) {
                            item.m_41764_(item.m_41613_() - 1);
                            int item_rimasti = Operazioni.addItemToInventory(player.m_150109_(), new ItemStack((ItemLike)Items.f_42446_), 1);
                            if (item_rimasti > 0) {
                                Operazioni.dropItem((Level)level, player.m_20182_(), new ItemStack((ItemLike)Items.f_42446_));
                            }
                        } else {
                            item.m_41764_(item.m_41613_() - 1);
                        }
                        v2.set(new Tuple((Object)true, (Object)new Vec3((double)posizione.m_123341_() + 0.5, (double)posizione.m_123342_() + 0.5, (double)posizione.m_123343_() + 0.5)));
                        continue;
                    }
                    ModifiableItemInventory.of(item).ifPresent(inv -> {
                        Container container_item = inv.getContainer();
                        for (int xItem = 0; xItem < container_item.m_6643_(); ++xItem) {
                            ItemStack itemStack = container_item.m_8020_(xItem);
                            if (!itemStack.m_41720_().equals(Target)) continue;
                            if (itemStack.m_41720_().equals(Items.f_42447_) || itemStack.m_41720_().equals(Items.f_42448_)) {
                                itemStack.m_41764_(itemStack.m_41613_() - 1);
                                int item_rimasti = Operazioni.addItemToInventory(player.m_150109_(), new ItemStack((ItemLike)Items.f_42446_), 1);
                                if (item_rimasti > 0) {
                                    Operazioni.dropItem((Level)level, player.m_20182_(), new ItemStack((ItemLike)Items.f_42446_));
                                }
                            } else {
                                itemStack.m_41764_(itemStack.m_41613_() - 1);
                            }
                            v2.set(new Tuple((Object)true, (Object)player.m_20182_().m_82520_(0.0, 1.0, 0.0)));
                        }
                        inv.save();
                    });
                }
            });
            if (v2.get() == null) continue;
            return (Tuple)v2.get();
        }
        return new Tuple((Object)false, (Object)Vec3.f_82478_);
    }

    public static SharedWithMe getSharedBlueprints(ServerLevel level, UUID uuid) {
        File FileShared = Blueprint.getSharedFile(level, uuid);
        SharedWithMe swm = new SharedWithMe();
        try {
            swm = (SharedWithMe)GSON.fromJson((Reader)new FileReader(FileShared), SharedWithMe.class);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return swm;
    }

    public static void addSharedBlueprint(ServerLevel serverLevel, String nome, UUID creatoreRichiesta, UUID ricevente) {
        if (Blueprint.BlueprintExist(serverLevel, nome, creatoreRichiesta)) {
            FileWriter writer;
            SharedWithMe swm = Blueprint.getSharedBlueprints(serverLevel, creatoreRichiesta);
            swm.addSharedWithOthersBlueprint(ricevente, nome);
            try {
                writer = new FileWriter(Blueprint.getSharedFile(serverLevel, creatoreRichiesta));
                try {
                    GSON.toJson((Object)swm, (Appendable)writer);
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            swm = Blueprint.getSharedBlueprints(serverLevel, ricevente);
            swm.addSharedWithMeBlueprint(creatoreRichiesta, nome);
            try {
                writer = new FileWriter(Blueprint.getSharedFile(serverLevel, ricevente));
                try {
                    GSON.toJson((Object)swm, (Appendable)writer);
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void removeSharedBlueprint(ServerLevel serverLevel, String nome, UUID creatoreRichiesta, UUID ricevente) {
        if (Blueprint.BlueprintExist(serverLevel, nome, creatoreRichiesta)) {
            FileWriter writer;
            SharedWithMe swm = Blueprint.getSharedBlueprints(serverLevel, creatoreRichiesta);
            swm.removeSharedWithOthersBlueprint(ricevente, nome);
            try {
                writer = new FileWriter(Blueprint.getSharedFile(serverLevel, creatoreRichiesta));
                try {
                    GSON.toJson((Object)swm, (Appendable)writer);
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            swm = Blueprint.getSharedBlueprints(serverLevel, ricevente);
            swm.removeSharedWithMeBlueprint(creatoreRichiesta, nome);
            try {
                writer = new FileWriter(Blueprint.getSharedFile(serverLevel, ricevente));
                try {
                    GSON.toJson((Object)swm, (Appendable)writer);
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File getSharedFile(ServerLevel serverLevel, UUID target) {
        String file;
        File CartellaMod = new File(serverLevel.m_7654_().m_129843_(LevelResource.f_78182_).toFile(), "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "shared")).exists()) {
            CartellaMod.mkdir();
        }
        if (!new File(CartellaMod, file = target.toString() + extension_swm).exists()) {
            SharedWithMe swm = new SharedWithMe();
            File jsonFile = new File(CartellaMod, file);
            try (FileWriter writer = new FileWriter(jsonFile);){
                GSON.toJson((Object)swm, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new File(CartellaMod, file);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static File getGlobalBlueprintDir() {
        File CartellaMod = new File(Minecraft.m_91087_().f_91069_, "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "blueprints")).exists()) {
            CartellaMod.mkdir();
        }
        return CartellaMod;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean globalBlueprintExist(String nome) {
        return new File(Blueprint.getGlobalBlueprintDir(), nome + extension).exists();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getGlobalBlueprintsQuantity() {
        int x = 0;
        for (File file : Blueprint.getGlobalBlueprintDir().listFiles()) {
            if (!file.getName().contains(extension)) continue;
            ++x;
        }
        return x;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<String> getAllGlobalBlueprintsName() {
        ArrayList<String> nomi = new ArrayList<String>();
        for (File file : Blueprint.getGlobalBlueprintDir().listFiles()) {
            if (!file.getName().contains(extension)) continue;
            nomi.add(file.getName().replace(extension, ""));
        }
        return nomi;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void removeGlobalBlueprint(String nome) {
        File f = new File(Blueprint.getGlobalBlueprintDir(), nome + extension);
        if (f.exists()) {
            f.delete();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlueprintDatas getGlobalBlueprintClass(String nome) {
        File f = new File(Blueprint.getGlobalBlueprintDir(), nome + extension);
        if (f.exists()) {
            try {
                return (BlueprintDatas)GSON.fromJson((Reader)new FileReader(f), BlueprintDatas.class);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServerGlobalBlueprint(String nome) {
        if (ClientMethods.SendingGlobalBlueprintToServer) {
            return;
        }
        Thread tickerThread = new Thread(() -> {
            try {
                Thread.sleep(50L);
                int QuantityBlocksMax = ClientMethods.getRichiestaInteger(507);
                BlueprintDatas bdc = Blueprint.getGlobalBlueprintClass(nome);
                boolean puoMandarlo = false;
                if (bdc != null) {
                    if (bdc.getAllBlocksCount() <= QuantityBlocksMax) {
                        if (ClientMethods.getQuantitaFileBlueprint() < ClientMethods.getRichiestaInteger(508)) {
                            puoMandarlo = true;
                        } else {
                            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"chat_message.portable_blueprints.global_bp_quantity_limit").m_130940_(ChatFormatting.RED), false);
                        }
                    } else {
                        Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"chat_message.portable_blueprints.global_bp_blocks_limit").m_130940_(ChatFormatting.RED), false);
                    }
                }
                if (puoMandarlo) {
                    ClientMethods.SendingGlobalBlueprintToServer = true;
                    File bd = new File(Blueprint.getGlobalBlueprintDir(), nome + extension);
                    if (bd.exists()) {
                        String bd_string_datas = new String(Files.readAllBytes(bd.toPath()));
                        String id_richiesta = UUID.randomUUID().toString();
                        PacketHandler.sendToServer(new CtoS_SaveGlobalBlueprintInServer("[INIZIO DATI BLUEPRINT <id>" + id_richiesta + "</id><nome>" + nome + "</nome>"));
                        PacketHandler.sendToServer(new CtoS_SaveGlobalBlueprintInServer("[NOME DEL FILE:" + nome));
                        for (String val : Operazioni.splitStringByLength(bd_string_datas, 10000)) {
                            PacketHandler.sendToServer(new CtoS_SaveGlobalBlueprintInServer("[" + id_richiesta + "]" + val));
                            Thread.sleep(10L);
                        }
                        PacketHandler.sendToServer(new CtoS_SaveGlobalBlueprintInServer("[FINE DATI BLUEPRINT DI ID: " + id_richiesta + "]"));
                        ClientMethods.SendingGlobalBlueprintToServer = false;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ClientMethods.SendingGlobalBlueprintToServer = false;
            }
        });
        tickerThread.setDaemon(true);
        tickerThread.start();
    }

    public static File getServerBlueprintFile(ServerLevel serverLevel) {
        File CartellaMod = new File(serverLevel.m_7654_().m_129843_(LevelResource.f_78182_).toFile(), "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "server")).exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "blueprints")).exists()) {
            CartellaMod.mkdir();
        }
        return CartellaMod;
    }

    public static File getServerPremissionFile(ServerLevel serverLevel) {
        String file;
        File CartellaMod = new File(serverLevel.m_7654_().m_129843_(LevelResource.f_78182_).toFile(), "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "server")).exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "permission")).exists()) {
            CartellaMod.mkdir();
        }
        if (!new File(CartellaMod, file = "permissions.settings").exists()) {
            BlueprintPermission bp = new BlueprintPermission();
            File jsonFile = new File(CartellaMod, file);
            try (FileWriter writer = new FileWriter(jsonFile);){
                GSON.toJson((Object)bp, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new File(CartellaMod, file);
    }

    public static File getWornBlueprintFile(ServerLevel serverLevel) {
        File CartellaMod = new File(serverLevel.m_7654_().m_129843_(LevelResource.f_78182_).toFile(), "portable_blueprints");
        if (!CartellaMod.exists()) {
            CartellaMod.mkdir();
        }
        if (!(CartellaMod = new File(CartellaMod, "worn blueprints")).exists()) {
            CartellaMod.mkdir();
        }
        return CartellaMod;
    }

    private static class BlueprintStartingData {
        public BlockPos angolo1;
        public BlockPos angolo2;
        public String nome;
        public ServerLevel serverLevel;
        public UUID uuid;
        public int posXControllata;
        public int posYControllata;
        public int posZControllata;
        public int altezzaArrivato = 0;
        public boolean consideraCreativeBlocks = false;
        public List<String> scannerIgnoredBlocks;
        public boolean annullaAnimazioneScanner = false;
        public UUID uuidAnimazioneScanner;

        public BlueprintStartingData(ServerLevel serverLevel, String nome, BlockPos angolo1, BlockPos angolo2, UUID uuid, boolean consideraCreativeBlocks, List<String> scannerIgnoredBlocks, UUID uuidAnimazioneScanner) {
            this.angolo1 = angolo1;
            this.angolo2 = angolo2;
            this.nome = nome;
            this.serverLevel = serverLevel;
            this.uuid = uuid;
            this.posXControllata = angolo1.m_123341_();
            this.posYControllata = angolo1.m_123342_();
            this.posZControllata = angolo1.m_123343_();
            this.consideraCreativeBlocks = consideraCreativeBlocks;
            this.scannerIgnoredBlocks = scannerIgnoredBlocks;
            this.uuidAnimazioneScanner = uuidAnimazioneScanner;
        }
    }

    public static class BlueprintDatas {
        public String nome = "";
        public int altezza = 0;
        public int lunghezzaX = 0;
        public int lunghezzaZ = 0;
        public BlockPos offset = new BlockPos(0, 0, 0);
        public Map<Integer, Map<String, String>> BlocksData = new HashMap<Integer, Map<String, String>>();
        public Map<Integer, Map<String, String>> NotSolidBlocksData = new HashMap<Integer, Map<String, String>>();
        public Map<Integer, Map<String, String>> BlocksNBT = new HashMap<Integer, Map<String, String>>();

        public BlueprintDatas(String NOME) {
            this.nome = NOME;
        }

        public void addBlock(int altezza, String posDalOrigine, String blocco, String nbt) {
            if (BlueprintDatas.ServerBlackListBlock(blocco) || BlueprintDatas.controlloBlocchiModdati(blocco)) {
                return;
            }
            if (this.BlocksData.containsKey(altezza)) {
                this.BlocksData.get(altezza).put(posDalOrigine, blocco);
            } else {
                this.BlocksData.put(altezza, new HashMap());
                this.BlocksData.get(altezza).put(posDalOrigine, blocco);
            }
            if (!nbt.isEmpty()) {
                if (this.BlocksNBT != null && this.BlocksNBT.containsKey(altezza)) {
                    this.BlocksNBT.get(altezza).put(posDalOrigine, nbt);
                } else {
                    this.BlocksNBT.put(altezza, new HashMap());
                    this.BlocksNBT.get(altezza).put(posDalOrigine, nbt);
                }
            }
        }

        public void addNonSolidBlock(int altezza, String posDalOrigine, String blocco, String nbt) {
            if (BlueprintDatas.ServerBlackListBlock(blocco) || BlueprintDatas.controlloBlocchiModdati(blocco)) {
                return;
            }
            if (this.NotSolidBlocksData.containsKey(altezza)) {
                this.NotSolidBlocksData.get(altezza).put(posDalOrigine, blocco);
            } else {
                this.NotSolidBlocksData.put(altezza, new HashMap());
                this.NotSolidBlocksData.get(altezza).put(posDalOrigine, blocco);
            }
            if (!nbt.isEmpty()) {
                if (this.BlocksNBT != null && this.BlocksNBT.containsKey(altezza)) {
                    this.BlocksNBT.get(altezza).put(posDalOrigine, nbt);
                } else {
                    this.BlocksNBT.put(altezza, new HashMap());
                    this.BlocksNBT.get(altezza).put(posDalOrigine, nbt);
                }
            }
        }

        public void setX(int x) {
            this.lunghezzaX = x;
        }

        public void setZ(int z) {
            this.lunghezzaZ = z;
        }

        public List<String> getBlocksDataByAltezza(int altezza) {
            ArrayList<String> bs = new ArrayList<String>();
            for (String pos : this.BlocksData.get(altezza).keySet()) {
                String valore = this.BlocksData.get(altezza).get(pos);
                bs.add(valore);
            }
            return bs;
        }

        public List<String> getBlocksPosByAltezza(int altezza) {
            ArrayList<String> bs = new ArrayList<String>();
            for (String pos : this.BlocksData.get(altezza).keySet()) {
                bs.add(pos);
            }
            return bs;
        }

        public int getAllBlocksCount() {
            int count = 0;
            for (int v = 0; v < 2; ++v) {
                for (Integer altezza : v == 0 ? this.BlocksData.keySet() : this.NotSolidBlocksData.keySet()) {
                    count += v == 0 ? this.BlocksData.get(altezza).size() : this.NotSolidBlocksData.get(altezza).size();
                }
            }
            return count;
        }

        public BlueprintDatas rotate(short rot) {
            BlueprintDatas ruotato = new BlueprintDatas(this.nome);
            ruotato.altezza = this.altezza;
            if (rot == 1 || rot == 3) {
                ruotato.lunghezzaZ = this.lunghezzaX;
                ruotato.lunghezzaX = this.lunghezzaZ;
            } else {
                ruotato.lunghezzaZ = this.lunghezzaZ;
                ruotato.lunghezzaX = this.lunghezzaX;
            }
            for (int v = 0; v < 2; ++v) {
                for (Map.Entry<Integer, Map<String, String>> posizione_e_blocco : v == 0 ? this.BlocksData.entrySet() : this.NotSolidBlocksData.entrySet()) {
                    Map<String, String> innerMap = posizione_e_blocco.getValue();
                    for (Map.Entry<String, String> dati_blocco : innerMap.entrySet()) {
                        String nbt;
                        BlockPos pos = new BlockPos(Operazioni.getVec3iFromString(dati_blocco.getKey()));
                        String blockdata = dati_blocco.getValue();
                        String bloccoId = blockdata.substring(blockdata.indexOf("<bid>") + 5, blockdata.indexOf("</bid>"));
                        if (!(blockdata = blockdata.replaceFirst("<bid>" + bloccoId + "</bid>", "")).equalsIgnoreCase("null")) {
                            BlockState state = Operazioni.getPropertiesStringToBlock(Operazioni.getBlockFromString(bloccoId), blockdata);
                            Tuple<Boolean, BlockState> val = BlueprintDatas.setCustomBlockProprietyRotate(bloccoId, state, (short)rot);
                            if (((Boolean)val.m_14418_()).booleanValue()) {
                                state = (BlockState)val.m_14419_();
                            } else {
                                if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
                                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Operazioni.rotateFacing((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_), rot));
                                } else if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Operazioni.rotateFacing((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_), rot));
                                }
                                if ((rot == 1 || rot == 3) && state.m_61138_((Property)BlockStateProperties.f_61365_)) {
                                    if (((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)).equals((Object)Direction.Axis.X)) {
                                        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Z);
                                    } else if (((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)).equals((Object)Direction.Axis.Z)) {
                                        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.X);
                                    }
                                }
                                for (int g = 0; g < rot; ++g) {
                                    boolean n = false;
                                    boolean s = false;
                                    boolean e = false;
                                    boolean w = false;
                                    if (state.m_61138_((Property)BlockStateProperties.f_61370_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_)).booleanValue()) {
                                        w = true;
                                    }
                                    if (state.m_61138_((Property)BlockStateProperties.f_61368_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_)).booleanValue()) {
                                        e = true;
                                    }
                                    if (state.m_61138_((Property)BlockStateProperties.f_61371_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_)).booleanValue()) {
                                        n = true;
                                    }
                                    if (state.m_61138_((Property)BlockStateProperties.f_61369_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_)).booleanValue()) {
                                        s = true;
                                    }
                                    if (state.m_61138_((Property)BlockStateProperties.f_61368_)) {
                                        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(n));
                                    }
                                    if (state.m_61138_((Property)BlockStateProperties.f_61370_)) {
                                        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(s));
                                    }
                                    if (state.m_61138_((Property)BlockStateProperties.f_61369_)) {
                                        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(e));
                                    }
                                    if (!state.m_61138_((Property)BlockStateProperties.f_61371_)) continue;
                                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(w));
                                }
                                if (state.m_61138_((Property)BlockStateProperties.f_61390_)) {
                                    int rotazione_attuale_cartello = (Integer)state.m_61143_((Property)BlockStateProperties.f_61390_) + rot * 4;
                                    if (rotazione_attuale_cartello >= 16) {
                                        rotazione_attuale_cartello -= 16;
                                    }
                                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(rotazione_attuale_cartello));
                                }
                            }
                            blockdata = Operazioni.getBlockStateString(state);
                        } else {
                            blockdata = dati_blocco.getValue();
                        }
                        String string = nbt = this.BlocksNBT != null && this.BlocksNBT.containsKey(pos.m_123342_()) && this.BlocksNBT.get(pos.m_123342_()).containsKey(dati_blocco.getKey()) ? this.BlocksNBT.get(pos.m_123342_()).get(dati_blocco.getKey()) : "";
                        if (rot == 0) {
                            if (v == 0) {
                                ruotato.addBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())), blockdata, nbt);
                                continue;
                            }
                            ruotato.addNonSolidBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())), blockdata, nbt);
                            continue;
                        }
                        if (rot == 1) {
                            if (v == 0) {
                                ruotato.addBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(this.lunghezzaZ - 1 - pos.m_123343_(), pos.m_123342_(), pos.m_123341_())), blockdata, nbt);
                                continue;
                            }
                            ruotato.addNonSolidBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(this.lunghezzaZ - 1 - pos.m_123343_(), pos.m_123342_(), pos.m_123341_())), blockdata, nbt);
                            continue;
                        }
                        if (rot == 2) {
                            if (v == 0) {
                                ruotato.addBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(this.lunghezzaX - 1 - pos.m_123341_(), pos.m_123342_(), this.lunghezzaZ - 1 - pos.m_123343_())), blockdata, nbt);
                                continue;
                            }
                            ruotato.addNonSolidBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(this.lunghezzaX - 1 - pos.m_123341_(), pos.m_123342_(), this.lunghezzaZ - 1 - pos.m_123343_())), blockdata, nbt);
                            continue;
                        }
                        if (rot != 3) continue;
                        if (v == 0) {
                            ruotato.addBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(pos.m_123343_(), pos.m_123342_(), this.lunghezzaX - 1 - pos.m_123341_())), blockdata, nbt);
                            continue;
                        }
                        ruotato.addNonSolidBlock(posizione_e_blocco.getKey(), Operazioni.getVec3iString(new Vec3i(pos.m_123343_(), pos.m_123342_(), this.lunghezzaX - 1 - pos.m_123341_())), blockdata, nbt);
                    }
                }
            }
            return ruotato;
        }

        public BlueprintDatas Mirrow(boolean Mx, boolean My, boolean Mz) {
            BlueprintDatas mirrow = new BlueprintDatas(this.nome);
            mirrow.altezza = this.altezza;
            mirrow.lunghezzaZ = this.lunghezzaZ;
            mirrow.lunghezzaX = this.lunghezzaX;
            for (int v = 0; v < 2; ++v) {
                for (Map.Entry<Integer, Map<String, String>> posizione_e_blocco : v == 0 ? this.BlocksData.entrySet() : this.NotSolidBlocksData.entrySet()) {
                    Map<String, String> innerMap = posizione_e_blocco.getValue();
                    for (Map.Entry<String, String> dati_blocco : innerMap.entrySet()) {
                        String nbt;
                        BlockPos pos = new BlockPos(Operazioni.getVec3iFromString(dati_blocco.getKey()));
                        String blockdata = dati_blocco.getValue();
                        String bloccoId = blockdata.substring(blockdata.indexOf("<bid>") + 5, blockdata.indexOf("</bid>"));
                        blockdata = blockdata.replaceFirst("<bid>" + bloccoId + "</bid>", "");
                        if (Mx) {
                            pos = new BlockPos(this.lunghezzaX - 1 - pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                        }
                        if (Mz) {
                            pos = new BlockPos(pos.m_123341_(), pos.m_123342_(), this.lunghezzaZ - 1 - pos.m_123343_());
                        }
                        if (My) {
                            pos = new BlockPos(pos.m_123341_(), this.altezza - 1 - pos.m_123342_(), pos.m_123343_());
                        }
                        if (!blockdata.equalsIgnoreCase("null")) {
                            BlockState state = Operazioni.getPropertiesStringToBlock(Operazioni.getBlockFromString(bloccoId), blockdata);
                            Tuple<Boolean, BlockState> val = BlueprintDatas.setCustomBlockProprietyMirrow(bloccoId, state, Mx, My, Mz);
                            if (((Boolean)val.m_14418_()).booleanValue()) {
                                state = (BlockState)val.m_14419_();
                            } else {
                                boolean suXFatta = false;
                                boolean suYFatta = false;
                                boolean suZFatta = false;
                                for (int statesTime = 0; statesTime < 3; ++statesTime) {
                                    if (statesTime == 0 && !Mx || statesTime == 1 && !My || statesTime == 2 && !Mz) continue;
                                    if (statesTime == 0) {
                                        suXFatta = true;
                                        suYFatta = false;
                                        suZFatta = false;
                                    } else if (statesTime == 1) {
                                        suXFatta = false;
                                        suYFatta = true;
                                        suZFatta = false;
                                    } else if (statesTime == 2) {
                                        suXFatta = false;
                                        suYFatta = false;
                                        suZFatta = true;
                                    }
                                    if (suYFatta && state.m_61138_((Property)BlockStateProperties.f_61376_)) {
                                        switch ((AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_)) {
                                            case FLOOR: {
                                                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)AttachFace.CEILING);
                                                break;
                                            }
                                            case CEILING: {
                                                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)AttachFace.FLOOR);
                                            }
                                        }
                                    }
                                    if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
                                        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
                                        if (dir.equals((Object)Direction.NORTH)) {
                                            if (!suZFatta) break;
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.SOUTH);
                                        } else if (dir.equals((Object)Direction.EAST)) {
                                            if (!suXFatta) break;
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.WEST);
                                        } else if (dir.equals((Object)Direction.SOUTH)) {
                                            if (!suZFatta) break;
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH);
                                        } else if (dir.equals((Object)Direction.WEST)) {
                                            if (!suXFatta) break;
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.EAST);
                                        } else if (dir.equals((Object)Direction.UP)) {
                                            if (!suYFatta) break;
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN);
                                        } else if (dir.equals((Object)Direction.DOWN)) {
                                            if (!suYFatta) break;
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP);
                                        }
                                    } else if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                                        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                                        if (dir.equals((Object)Direction.NORTH)) {
                                            if (!suZFatta) break;
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH);
                                        } else if (dir.equals((Object)Direction.EAST)) {
                                            if (!suXFatta) break;
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST);
                                        } else if (dir.equals((Object)Direction.SOUTH)) {
                                            if (!suZFatta) break;
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH);
                                        } else if (dir.equals((Object)Direction.WEST)) {
                                            if (!suXFatta) break;
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST);
                                        }
                                    }
                                    boolean n = false;
                                    boolean s = false;
                                    boolean e = false;
                                    boolean w = false;
                                    if (!suYFatta) {
                                        if (suZFatta) {
                                            if (state.m_61138_((Property)BlockStateProperties.f_61370_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_)).booleanValue()) {
                                                s = false;
                                                n = true;
                                            }
                                            if (state.m_61138_((Property)BlockStateProperties.f_61368_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_)).booleanValue()) {
                                                n = false;
                                                s = true;
                                            }
                                            if (state.m_61138_((Property)BlockStateProperties.f_61369_)) {
                                                e = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_);
                                            }
                                            if (state.m_61138_((Property)BlockStateProperties.f_61371_)) {
                                                w = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_);
                                            }
                                        } else if (suXFatta) {
                                            if (state.m_61138_((Property)BlockStateProperties.f_61369_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_)).booleanValue()) {
                                                e = false;
                                                w = true;
                                            }
                                            if (state.m_61138_((Property)BlockStateProperties.f_61371_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_)).booleanValue()) {
                                                w = false;
                                                e = true;
                                            }
                                            if (state.m_61138_((Property)BlockStateProperties.f_61368_)) {
                                                n = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_);
                                            }
                                            if (state.m_61138_((Property)BlockStateProperties.f_61370_)) {
                                                s = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_);
                                            }
                                        }
                                        if (state.m_61138_((Property)BlockStateProperties.f_61368_)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(n));
                                        }
                                        if (state.m_61138_((Property)BlockStateProperties.f_61370_)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(s));
                                        }
                                        if (state.m_61138_((Property)BlockStateProperties.f_61369_)) {
                                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(e));
                                        }
                                        if (!state.m_61138_((Property)BlockStateProperties.f_61371_)) continue;
                                        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(w));
                                        continue;
                                    }
                                    if (state.m_61138_((Property)BlockStateProperties.f_61402_)) {
                                        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)(((Half)state.m_61143_((Property)BlockStateProperties.f_61402_)).equals((Object)Half.BOTTOM) ? Half.TOP : Half.BOTTOM));
                                    }
                                    if (!state.m_61138_((Property)BlockStateProperties.f_61397_)) continue;
                                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)(((SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_)).equals((Object)SlabType.BOTTOM) ? SlabType.TOP : SlabType.BOTTOM));
                                }
                            }
                            blockdata = Operazioni.getBlockStateString(state);
                        } else {
                            blockdata = dati_blocco.getValue();
                        }
                        String string = nbt = this.BlocksNBT != null && this.BlocksNBT.containsKey(pos.m_123342_()) && this.BlocksNBT.get(pos.m_123342_()).containsKey(dati_blocco.getKey()) ? this.BlocksNBT.get(pos.m_123342_()).get(dati_blocco.getKey()) : "";
                        if (v == 0) {
                            mirrow.addBlock(pos.m_123342_(), Operazioni.getVec3iString(new Vec3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())), blockdata, nbt);
                            continue;
                        }
                        mirrow.addNonSolidBlock(pos.m_123342_(), Operazioni.getVec3iString(new Vec3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())), blockdata, nbt);
                    }
                }
            }
            return mirrow;
        }

        public static boolean controlloBlocchiModdati(String blockdata) {
            String bloccoId = blockdata.substring(blockdata.indexOf("<bid>") + 5, blockdata.indexOf("</bid>"));
            String idMod = bloccoId.split(":")[0];
            String proprieta = blockdata = blockdata.replaceFirst("<bid>" + bloccoId + "</bid>", "");
            if (proprieta.equals("null")) {
                return false;
            }
            proprieta = proprieta.replace("<properties>", "").replace("</properties>", "");
            for (String v : proprieta.split(";!v!;")) {
                if (v.equals("")) continue;
                String nome = v.substring(v.indexOf("<name>") + 6, v.indexOf("</name>"));
                String valore = v.substring(v.indexOf("<value>") + 7, v.indexOf("</value>"));
                if (!idMod.equals("dramaticdoors") || !nome.equals("third") || valore.equals("lower")) continue;
                return true;
            }
            return false;
        }

        public static boolean ServerBlackListBlock(String blockdata) {
            String bloccoId = blockdata.substring(blockdata.indexOf("<bid>") + 5, blockdata.indexOf("</bid>"));
            return ModServerConfig.blacklistBlock.contains(bloccoId);
        }

        private static boolean respectCondition(Map<String, Tuple<String, Property>> proprietaBlocco, String condition) {
            String[] condizioni;
            for (String condizione : condizioni = condition.split(",")) {
                String[] data = condizione.split("=");
                if (proprietaBlocco.containsKey(data[0]) && ((String)proprietaBlocco.get(data[0]).m_14418_()).equalsIgnoreCase(data[1])) continue;
                return false;
            }
            return true;
        }

        public static Tuple<Boolean, BlockState> setCustomBlockProprietyRotate(String bloccoID, BlockState blockState, short rot) {
            boolean contieneBloccoID = false;
            try {
                if (CustomBlockProprietyHandle.Rotate.RULES.containsKey(bloccoID)) {
                    contieneBloccoID = true;
                    List<CustomBlockProprietyHandle.Rotate.Rule> rules = CustomBlockProprietyHandle.Rotate.RULES.get(bloccoID);
                    HashMap<String, Tuple<String, Property>> proprietaBlocco = new HashMap<String, Tuple<String, Property>>();
                    for (Property p : blockState.m_61147_()) {
                        proprietaBlocco.put(p.m_61708_(), new Tuple((Object)blockState.m_61143_(p).toString(), (Object)p));
                    }
                    for (CustomBlockProprietyHandle.Rotate.Rule rule : rules) {
                        if (rule.getRot() != rot) continue;
                        for (CustomBlockProprietyHandle.Rotate.PropertyRule pr : rule.properties) {
                            if (!BlueprintDatas.respectCondition(proprietaBlocco, pr.condition)) continue;
                            for (CustomBlockProprietyHandle.Rotate.PropertyValue propertyValue : pr.result) {
                                blockState = Operazioni.setDynamicProperty(blockState, (Property)((Tuple)proprietaBlocco.get(propertyValue.name)).m_14419_(), propertyValue.value);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                Mod.LOGGER.error("[Portable Blueprints] -> Custom block rotation propriety error!");
                Mod.LOGGER.error(e.getMessage());
            }
            return new Tuple((Object)contieneBloccoID, (Object)blockState);
        }

        public static Tuple<Boolean, BlockState> setCustomBlockProprietyMirrow(String bloccoID, BlockState blockState, boolean mirrowX, boolean mirrowY, boolean mirrowZ) {
            boolean contieneBloccoID = false;
            try {
                if (CustomBlockProprietyHandle.Mirrow.RULES.containsKey(bloccoID)) {
                    contieneBloccoID = true;
                    List<CustomBlockProprietyHandle.Mirrow.Rule> rules = CustomBlockProprietyHandle.Mirrow.RULES.get(bloccoID);
                    for (CustomBlockProprietyHandle.Mirrow.Rule rule : rules) {
                        if (!(rule.mirrow.equals((Object)Direction.Axis.X) && mirrowX || rule.mirrow.equals((Object)Direction.Axis.Y) && mirrowY) && (!rule.mirrow.equals((Object)Direction.Axis.Z) || !mirrowZ)) continue;
                        HashMap<String, Tuple<String, Property>> proprietaBlocco = new HashMap<String, Tuple<String, Property>>();
                        for (Property p : blockState.m_61147_()) {
                            proprietaBlocco.put(p.m_61708_(), (Tuple<String, Property>)new Tuple((Object)blockState.m_61143_(p).toString(), (Object)p));
                        }
                        for (CustomBlockProprietyHandle.Mirrow.PropertyRule pr : rule.properties) {
                            if (!BlueprintDatas.respectCondition(proprietaBlocco, pr.condition)) continue;
                            for (CustomBlockProprietyHandle.Mirrow.PropertyValue propertyValue : pr.result) {
                                blockState = Operazioni.setDynamicProperty(blockState, (Property)((Tuple)proprietaBlocco.get(propertyValue.name)).m_14419_(), propertyValue.value);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                Mod.LOGGER.error("[Portable Blueprints] -> Custom block mirrow propriety error!");
                Mod.LOGGER.error(e.getMessage());
            }
            return new Tuple((Object)contieneBloccoID, (Object)blockState);
        }
    }

    private static class BlueprintStructure {
        public List<BlockPos> posDiEspansione = new ArrayList<BlockPos>();
        public boolean solidi = true;
        public ServerLevel serverLevel;
        public BlueprintDatas bd;
        public List<BlockPos> posizione_container;
        public Player owner;
        public boolean free_build;
        public short allow_nbt = (short)-1;
        public boolean emc_active = false;

        public BlueprintStructure(ServerLevel serverLevel, BlueprintDatas bd, Player player, List<BlockPos> posizione_container, boolean free_build, short allow_nbt, boolean emc_active) {
            this.serverLevel = serverLevel;
            this.owner = player;
            this.bd = bd;
            this.posizione_container = posizione_container;
            this.free_build = free_build;
            this.allow_nbt = allow_nbt;
            if (ModCompatibilityInit.isProjectELoaded) {
                this.emc_active = emc_active;
            }
            this.posDiEspansione.add(new BlockPos(bd.lunghezzaX - 1, 0, bd.lunghezzaZ - 1));
        }
    }

    public static class SharedWithMe {
        public List<String> SharedWithOthersBlueprints = new ArrayList<String>();
        public List<String> SharedWithMeBlueprints = new ArrayList<String>();

        public void addSharedWithMeBlueprint(UUID PlayerCheCondivideIlSuoBlueprint, String NomeBlueprint) {
            String dato = "<owner>" + PlayerCheCondivideIlSuoBlueprint.toString() + "</owner><name>" + NomeBlueprint + "</name>";
            if (!this.SharedWithMeBlueprints.contains(dato)) {
                this.SharedWithMeBlueprints.add(dato);
            }
        }

        public void removeSharedWithMeBlueprint(UUID PlayerCheCondivideIlSuoBlueprint, String NomeBlueprint) {
            String dato = "<owner>" + PlayerCheCondivideIlSuoBlueprint.toString() + "</owner><name>" + NomeBlueprint + "</name>";
            if (this.SharedWithMeBlueprints.contains(dato)) {
                this.SharedWithMeBlueprints.remove(dato);
            }
        }

        public void addSharedWithOthersBlueprint(UUID PlayerAQuiVaIlBlueprint, String NomeBlueprint) {
            String dato = "<shared_with>" + PlayerAQuiVaIlBlueprint.toString() + "</shared_with><name>" + NomeBlueprint + "</name>";
            if (!this.SharedWithOthersBlueprints.contains(dato)) {
                this.SharedWithOthersBlueprints.add(dato);
            }
        }

        public void removeSharedWithOthersBlueprint(UUID PlayerAQuiVaIlBlueprint, String NomeBlueprint) {
            String dato = "<shared_with>" + PlayerAQuiVaIlBlueprint.toString() + "</shared_with><name>" + NomeBlueprint + "</name>";
            if (this.SharedWithOthersBlueprints.contains(dato)) {
                this.SharedWithOthersBlueprints.remove(dato);
            }
        }

        public boolean ContieneSWMBlueprint(UUID PlayerCheCondivideIlSuoBlueprint, String NomeBlueprint) {
            return this.SharedWithMeBlueprints.contains("<owner>" + PlayerCheCondivideIlSuoBlueprint.toString() + "</owner><name>" + NomeBlueprint + "</name>");
        }

        public boolean ContieneSWOBlueprint(UUID PlayerConQuiCondivideBlueprint, String NomeBlueprint) {
            return this.SharedWithOthersBlueprints.contains("<shared_with>" + PlayerConQuiCondivideBlueprint.toString() + "</shared_with><name>" + NomeBlueprint + "</name>");
        }

        public List<UUID> getAllSpecificSWOBPlayersUUID(String nome_blueprint) {
            ArrayList<UUID> trovati = new ArrayList<UUID>();
            for (String v : this.SharedWithOthersBlueprints) {
                if (!Operazioni.getValueInsideTag(v, "name").equals(nome_blueprint)) continue;
                trovati.add(UUID.fromString(Operazioni.getValueInsideTag(v, "shared_with")));
            }
            return trovati;
        }
    }

    public static class BlueprintPermission {
        public Map<String, Boolean> BlueprintsPermissionSetup = new HashMap<String, Boolean>();
        public Map<UUID, List<String>> PlayerPermission = new HashMap<UUID, List<String>>();

        public void addServerBlueprintPermission(String nome, boolean isFree) {
            this.BlueprintsPermissionSetup.put(nome, isFree);
        }

        public void removeServerBlueprintPermission(String nome) {
            this.BlueprintsPermissionSetup.remove(nome);
            for (UUID uuid : this.PlayerPermission.keySet()) {
                ArrayList<String> remValues = new ArrayList<String>();
                for (String permission : this.PlayerPermission.get(uuid)) {
                    if (!permission.contains("<name>" + nome + "</name>")) continue;
                    remValues.add(permission);
                }
                for (String remove : remValues) {
                    this.PlayerPermission.get(uuid).remove(remove);
                }
            }
        }

        public void setPermissionForPlayer(ServerPlayer player, String nome, boolean hasPermission) {
            if (!this.BlueprintsPermissionSetup.containsKey(nome)) {
                return;
            }
            if (!this.PlayerPermission.containsKey(player.m_20148_())) {
                this.PlayerPermission.put(player.m_20148_(), new ArrayList());
            }
            if (this.PlayerPermission.get(player.m_20148_()).contains("<name>" + nome + "</name><permission>false</permission>")) {
                this.PlayerPermission.get(player.m_20148_()).remove("<name>" + nome + "</name><permission>false</permission>");
            }
            if (this.PlayerPermission.get(player.m_20148_()).contains("<name>" + nome + "</name><permission>true</permission>")) {
                this.PlayerPermission.get(player.m_20148_()).remove("<name>" + nome + "</name><permission>true</permission>");
            }
            this.PlayerPermission.get(player.m_20148_()).add("<name>" + nome + "</name><permission>" + hasPermission + "</permission>");
        }

        public List<String> getPlayerAllAllowedBlueprints(UUID player) {
            ArrayList<String> bps = new ArrayList<String>();
            for (String nome : this.BlueprintsPermissionSetup.keySet()) {
                if (!this.BlueprintsPermissionSetup.get(nome).booleanValue() && (!this.PlayerPermission.containsKey(player) || !this.PlayerPermission.get(player).contains("<name>" + nome + "</name><permission>true</permission>"))) continue;
                bps.add(nome);
            }
            return bps;
        }
    }
}

