/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.altro;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import nimble.portable_blueprints.init.ModGameRules;
import nimble.portable_blueprints.robautile.Operazioni;

@Mod.EventBusSubscriber
public class PlacingBlockManager {
    public static final List<PlaceBlock> PlaceBlocks = Collections.synchronizedList(new ArrayList());
    private static ScheduledExecutorService scheduler;

    @SubscribeEvent
    public static void onServerStarted(ServerStartingEvent event) {
        if (scheduler == null || scheduler.isShutdown() || scheduler.isTerminated()) {
            scheduler = Executors.newSingleThreadScheduledExecutor();
            scheduler.scheduleAtFixedRate(() -> {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server == null || server.m_129918_()) {
                    return;
                }
                long now = System.currentTimeMillis();
                ArrayList<PlaceBlock> toPlace = new ArrayList<PlaceBlock>();
                List<PlaceBlock> list = PlaceBlocks;
                synchronized (list) {
                    Iterator<PlaceBlock> iterator = PlaceBlocks.iterator();
                    while (iterator.hasNext()) {
                        PlaceBlock pb = iterator.next();
                        if (!pb.canPlaceNow(now)) continue;
                        toPlace.add(pb);
                        iterator.remove();
                    }
                }
                if (!toPlace.isEmpty()) {
                    server.execute(() -> {
                        for (PlaceBlock pb : toPlace) {
                            pb.placeNow();
                        }
                    });
                }
            }, 0L, 100L, TimeUnit.MILLISECONDS);
        }
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        if (scheduler != null && !scheduler.isShutdown()) {
            scheduler.shutdownNow();
            scheduler = null;
        }
        PlaceBlocks.clear();
    }

    public static ScheduledExecutorService getScheduler() {
        return scheduler;
    }

    public static void addNewPlaceBlock(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, String nbt, short allow_nbt, long delay) {
        if (blockState.m_61138_((Property)BlockStateProperties.f_61401_) && blockState.m_61143_((Property)BlockStateProperties.f_61401_) != DoubleBlockHalf.LOWER) {
            return;
        }
        PlaceBlocks.add(new PlaceBlock(serverLevel, blockPos, blockState, nbt, allow_nbt, delay));
    }

    public static boolean isRimpiazzabile(ServerLevel level, BlockState blockState, BlockPos pos) {
        return blockState.m_60734_().equals(Blocks.f_50016_) || PlacingBlockManager.canBeReplaced(level, blockState, pos) || blockState.m_60811_().equals((Object)PushReaction.DESTROY);
    }

    public static boolean droppaBloccoRimpiazzabile(ServerLevel serverLevel, BlockPos pos) {
        BlockState blockState = serverLevel.m_8055_(pos);
        if (blockState.m_60734_().equals(Blocks.f_50016_)) {
            return true;
        }
        if (PlacingBlockManager.isRimpiazzabile(serverLevel, blockState, pos)) {
            Block.m_49892_((BlockState)blockState, (LevelAccessor)serverLevel, (BlockPos)pos, (BlockEntity)serverLevel.m_7702_(pos));
            return true;
        }
        return false;
    }

    private static void placeBlockContext(ServerLevel level, BlockPos pos, BlockState desiredState) {
        Block block = desiredState.m_60734_();
        Item item = (Item)Item.f_41373_.get(block);
        if (!(item instanceof BlockItem)) {
            System.err.println("Impossibile piazzare come BlockItem. " + item);
            PlacingBlockManager.placeNormal(level, pos, desiredState);
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerLevel)level);
        ItemStack stack = new ItemStack((ItemLike)block);
        Direction clickedFace = Direction.UP;
        BlockPlaceContext context = new BlockPlaceContext((Level)level, (Player)fakePlayer, InteractionHand.MAIN_HAND, stack, new BlockHitResult(Vec3.m_82512_((Vec3i)pos), clickedFace, pos, false)){

            public boolean m_7059_() {
                return true;
            }

            public boolean m_43721_() {
                return false;
            }
        };
        InteractionResult result = blockItem.m_40576_(context);
        if (result.m_19077_()) {
            BlockState placed = level.m_8055_(pos);
            if (placed.m_60734_() == block) {
                BlockState finalState = PlacingBlockManager.copyBlockStateProperties(desiredState, placed);
                level.m_7731_(pos, finalState, 3);
            }
        } else {
            PlacingBlockManager.placeNormal(level, pos, desiredState);
        }
    }

    private static void placeNormal(ServerLevel serverLevel, BlockPos pos, BlockState desiredState) {
        serverLevel.m_7731_(pos, desiredState, 3);
        serverLevel.m_46672_(pos, desiredState.m_60734_());
        if (desiredState.m_61138_((Property)BlockStateProperties.f_61401_) && desiredState.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER && PlacingBlockManager.droppaBloccoRimpiazzabile(serverLevel, pos.m_7494_())) {
            BlockState upperState = (BlockState)desiredState.m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.UPPER);
            BlockPos upperPos = pos.m_7494_();
            serverLevel.m_7731_(upperPos, upperState, 3);
            serverLevel.m_46672_(upperPos, upperState.m_60734_());
        }
    }

    public static BlockState copyBlockStateProperties(BlockState from, BlockState to) {
        for (Property property : from.m_61147_()) {
            if (!to.m_61138_(property)) continue;
            to = PlacingBlockManager.setPropertySafe(to, property, from.m_61143_(property));
        }
        return to;
    }

    private static <T extends Comparable<T>> BlockState setPropertySafe(BlockState state, Property<T> property, Comparable<?> value) {
        try {
            return (BlockState)state.m_61124_(property, (Comparable)property.m_61709_().cast(value));
        }
        catch (Exception e) {
            return state;
        }
    }

    private static boolean canBeReplaced(ServerLevel level, BlockState blockstate, BlockPos pos) {
        BlockPlaceContext context = new BlockPlaceContext((Level)level, null, InteractionHand.MAIN_HAND, ItemStack.f_41583_, new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.UP, pos, false));
        return blockstate.m_60629_(context);
    }

    public static class PlaceBlock {
        public final ServerLevel serverLevel;
        public final BlockPos blockPos;
        public final BlockState blockState;
        public final long placeAtMillis;
        public final CompoundTag nbt;
        public final short allow_nbt;

        public PlaceBlock(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, String nbt, short allow_nbt, long delayMillis) {
            this.serverLevel = serverLevel;
            this.blockPos = blockPos;
            this.blockState = blockState;
            this.placeAtMillis = System.currentTimeMillis() + delayMillis;
            this.allow_nbt = allow_nbt;
            CompoundTag tag = new CompoundTag();
            try {
                if (TagParser.m_129359_((String)nbt) != null) {
                    tag = TagParser.m_129359_((String)nbt);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.nbt = tag;
        }

        public boolean canPlaceNow(long now) {
            return now >= this.placeAtMillis;
        }

        public void placeNow() {
            try {
                if (this.serverLevel != null) {
                    if (PlacingBlockManager.droppaBloccoRimpiazzabile(this.serverLevel, this.blockPos)) {
                        BlockEntity be;
                        PlacingBlockManager.placeBlockContext(this.serverLevel, this.blockPos, this.blockState);
                        if ((this.allow_nbt == 1 || this.allow_nbt == -1 && this.serverLevel.m_46469_().m_46207_(ModGameRules.AllowNBTDataCopy)) && !this.nbt.m_128456_() && (be = this.serverLevel.m_7702_(this.blockPos)) != null) {
                            be.m_142466_(this.nbt);
                            be.m_6596_();
                            this.serverLevel.m_7260_(this.blockPos, this.blockState, this.blockState, 3);
                        }
                    } else {
                        Block.m_49840_((Level)this.serverLevel, (BlockPos)this.blockPos, (ItemStack)Operazioni.getCorrectItemStackFromId(this.blockState.m_60734_()));
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Placement Block Error!");
                e.printStackTrace();
            }
        }
    }
}

