/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.StoC_OpenScannerScreen;
import nimble.portable_blueprints.robautile.Operazioni;
import org.jetbrains.annotations.Nullable;

public class Scanner
extends Item {
    public static final int MaxScrollingDistance = 100;
    public static final int MinScrollingDistance = 5;
    public static int ScrollingDistanceAttuale = 5;
    private int Tick = 0;

    public Scanner(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (!context.m_43725_().m_5776_() && context.m_43724_().equals((Object)InteractionHand.MAIN_HAND)) {
            BlockPos positionClicked = context.m_8083_();
            Player pl = context.m_43723_();
            CompoundTag nbt = context.m_43722_().m_41784_();
            boolean angolo1 = nbt.m_128441_("angolo1") ? nbt.m_128471_("angolo1") : false;
            boolean angolo2 = nbt.m_128441_("angolo2") ? nbt.m_128471_("angolo2") : false;
            BlockHitResult rayTraceResult = Scanner.rayTrace(pl, context.m_43725_(), pl.m_6047_() ? ClipContext.Fluid.NONE : ClipContext.Fluid.ANY, ScrollingDistanceAttuale);
            this.impostaCoordinata(context.m_43722_(), rayTraceResult.m_82425_(), angolo1 && angolo2 ? true : !angolo1);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!(pEntity instanceof Player) || !pIsSelected) {
            return;
        }
        if (this.Tick++ > 20) {
            this.Tick = 0;
        }
        CompoundTag nbt = pStack.m_41784_();
        Player pl = (Player)pEntity;
        if (this.Tick % 2 == 0) {
            BlockHitResult rayTraceResult = Scanner.rayTrace(pl, pLevel, pl.m_6047_() ? ClipContext.Fluid.NONE : ClipContext.Fluid.ANY, ScrollingDistanceAttuale);
            if (!(nbt.m_128441_("angolo1") && nbt.m_128471_("angolo1") && nbt.m_128441_("angolo2") && nbt.m_128471_("angolo2"))) {
                nbt.m_128379_("angoloFantasma", true);
                nbt.m_128359_("coordinateAngoloFantasma", Operazioni.getVec3iString(new Vec3i(rayTraceResult.m_82425_().m_123341_(), rayTraceResult.m_82425_().m_123342_(), rayTraceResult.m_82425_().m_123343_())));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        BlockHitResult rayTraceResult = Scanner.rayTrace(pPlayer, pLevel, pPlayer.m_6047_() ? ClipContext.Fluid.NONE : ClipContext.Fluid.ANY, ScrollingDistanceAttuale);
        if (!pLevel.f_46443_) {
            ItemStack item = pPlayer.m_21205_();
            CompoundTag nbt = item.m_41784_();
            if (pPlayer.m_6144_()) {
                this.annullaSelezione(pPlayer.m_21205_());
            } else if (!pPlayer.m_6144_() && nbt.m_128441_("angolo1") && nbt.m_128471_("angolo1") && !nbt.m_128461_("coordinateAngolo1").equals("") && nbt.m_128441_("angolo2") && nbt.m_128471_("angolo2") && !nbt.m_128461_("coordinateAngolo2").equals("")) {
                BlockPos angolo1 = new BlockPos(Operazioni.getVec3iFromString(nbt.m_128461_("coordinateAngolo1")));
                BlockPos angolo2 = new BlockPos(Operazioni.getVec3iFromString(nbt.m_128461_("coordinateAngolo2")));
                BlockPos angoloIniziale = new BlockPos(angolo1.m_123341_() < angolo2.m_123341_() ? angolo1.m_123341_() : angolo2.m_123341_(), angolo1.m_123342_() < angolo2.m_123342_() ? angolo1.m_123342_() : angolo2.m_123342_(), angolo1.m_123343_() < angolo2.m_123343_() ? angolo1.m_123343_() : angolo2.m_123343_());
                BlockPos angoloFinale = new BlockPos(angolo1.m_123341_() < angolo2.m_123341_() ? angolo2.m_123341_() : angolo1.m_123341_(), angolo1.m_123342_() < angolo2.m_123342_() ? angolo2.m_123342_() : angolo1.m_123342_(), angolo1.m_123343_() < angolo2.m_123343_() ? angolo2.m_123343_() : angolo1.m_123343_());
                int quantitaBlocchi = (angoloFinale.m_123341_() - angoloIniziale.m_123341_() + 1) * (angoloFinale.m_123343_() - angoloIniziale.m_123343_() + 1) * (angoloFinale.m_123342_() - angoloIniziale.m_123342_() + 1);
                PacketHandler.sendToPlayer(new StoC_OpenScannerScreen(item, quantitaBlocchi), (ServerPlayer)pPlayer);
            } else if (!pPlayer.m_6144_()) {
                boolean angolo1 = nbt.m_128441_("angolo1") ? nbt.m_128471_("angolo1") : false;
                boolean angolo2 = nbt.m_128441_("angolo2") ? nbt.m_128471_("angolo2") : false;
                this.impostaCoordinata(pPlayer.m_21205_(), rayTraceResult.m_82425_(), angolo1 && angolo2 ? true : !angolo1);
            }
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public void impostaCoordinata(ItemStack item, BlockPos pos, Boolean angolo1) {
        CompoundTag nbt = item.m_41784_();
        if (nbt.m_128441_("angolo1") && nbt.m_128471_("angolo1") && nbt.m_128441_("angolo2") && nbt.m_128471_("angolo2")) {
            this.annullaSelezione(item);
        }
        if (angolo1.booleanValue()) {
            nbt.m_128359_("coordinateAngolo1", Operazioni.getVec3iString((Vec3i)pos));
            nbt.m_128379_("angolo1", true);
            Operazioni.glowingItemStack(item, true);
        } else {
            BlockPos posAngolo1 = new BlockPos(Operazioni.getVec3iFromString(nbt.m_128461_("coordinateAngolo1")));
            BlockPos posAngolo2 = pos;
            BlockPos angoloMaggiore = new BlockPos(Math.max(posAngolo1.m_123341_(), posAngolo2.m_123341_()), Math.max(posAngolo1.m_123342_(), posAngolo2.m_123342_()), Math.max(posAngolo1.m_123343_(), posAngolo2.m_123343_()));
            BlockPos angoloMinore = new BlockPos(Math.min(posAngolo1.m_123341_(), posAngolo2.m_123341_()), Math.min(posAngolo1.m_123342_(), posAngolo2.m_123342_()), Math.min(posAngolo1.m_123343_(), posAngolo2.m_123343_()));
            nbt.m_128359_("coordinateAngolo1", Operazioni.getVec3iString((Vec3i)angoloMinore));
            nbt.m_128359_("coordinateAngolo2", Operazioni.getVec3iString((Vec3i)angoloMaggiore));
            nbt.m_128379_("angolo2", true);
        }
        if (nbt.m_128441_("angolo1") && nbt.m_128471_("angolo1") && nbt.m_128441_("angolo2") && nbt.m_128471_("angolo2")) {
            Operazioni.glowingItemStack(item, false);
        }
        item.m_41751_(nbt);
    }

    public void annullaSelezione(ItemStack item) {
        CompoundTag nbt = item.m_41784_();
        nbt.m_128379_("angolo1", false);
        nbt.m_128359_("coordinateAngolo1", "");
        nbt.m_128379_("angolo2", false);
        nbt.m_128359_("coordinateAngolo2", "");
        nbt.m_128379_("angoloFantasma", false);
        nbt.m_128359_("coordinateAngoloFantasma", "");
        Operazioni.glowingItemStack(item, false);
        item.m_41751_(nbt);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag nbt = stack.m_41784_();
        if (Screen.m_96638_()) {
            boolean alterna_colore = true;
            for (String val : Component.m_237115_((String)"item.portable_blueprints.description.scanner_2").getString().split("%n%")) {
                if (val.equals("")) continue;
                tooltip.add((Component)Component.m_237113_((String)val).m_130940_(alterna_colore ? ChatFormatting.GOLD : ChatFormatting.YELLOW));
                alterna_colore = !alterna_colore;
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.portable_blueprints.description.scanner_1").m_130940_(ChatFormatting.GOLD));
        }
        super.m_7373_(stack, world, tooltip, flag);
    }

    public static BlockHitResult rayTrace(Player player, Level world, ClipContext.Fluid fluidMode, double maxDistance) {
        Vec3 eyePosition = player.m_20299_(1.0f);
        Vec3 lookVector = player.m_20252_(1.0f);
        Vec3 reachVector = eyePosition.m_82520_(lookVector.f_82479_ * maxDistance, lookVector.f_82480_ * maxDistance, lookVector.f_82481_ * maxDistance);
        ClipContext context = new ClipContext(eyePosition, reachVector, ClipContext.Block.OUTLINE, fluidMode, (Entity)player);
        return world.m_45547_(context);
    }
}

