/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.mod_compatibility.projecte;

import java.math.BigInteger;
import java.util.UUID;
import moze_intel.projecte.api.ProjectEAPI;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import nimble.portable_blueprints.mod_compatibility.ModCompatibilityInit;

public class ProjectEMetodi {
    public static long getEMCPlayer(UUID player) {
        if (!ModCompatibilityInit.isProjectELoaded) {
            return 0L;
        }
        return ProjectEAPI.getTransmutationProxy().getKnowledgeProviderFor(player).getEmc().longValueExact();
    }

    public static long getEMCForItem(Item item) {
        if (!ModCompatibilityInit.isProjectELoaded) {
            return 0L;
        }
        return ProjectEAPI.getEMCProxy().getValue(item);
    }

    public static boolean removeEMCForPlayer(ServerPlayer player, Long emc_value) {
        if (!ModCompatibilityInit.isProjectELoaded) {
            return false;
        }
        if (emc_value == 0L) {
            return false;
        }
        long playerEMC = ProjectEMetodi.getEMCPlayer(player.m_20148_());
        if (playerEMC <= 0L || playerEMC < emc_value) {
            return false;
        }
        BigInteger value = BigInteger.valueOf(playerEMC - emc_value);
        ProjectEAPI.getTransmutationProxy().getKnowledgeProviderFor(player.m_20148_()).setEmc(value);
        ProjectEAPI.getTransmutationProxy().getKnowledgeProviderFor(player.m_20148_()).syncEmc(player);
        return true;
    }

    public static boolean removeEMCForItem(ServerPlayer player, Item item) {
        if (!ModCompatibilityInit.isProjectELoaded) {
            return false;
        }
        return ProjectEMetodi.removeEMCForPlayer(player, ProjectEMetodi.getEMCForItem(item));
    }
}

