/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import nimble.portable_blueprints.altro.Blueprint;

public class CtoS_CreaItemBlueprint {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final String nome;
    private final UUID BPOwner;
    private final boolean is_global_instance;
    private final boolean isServerBlueprint;

    public CtoS_CreaItemBlueprint() {
        this.nome = "";
        this.BPOwner = null;
        this.is_global_instance = false;
        this.isServerBlueprint = false;
    }

    public CtoS_CreaItemBlueprint(String nome) {
        this.nome = nome;
        this.BPOwner = null;
        this.is_global_instance = false;
        this.isServerBlueprint = false;
    }

    public CtoS_CreaItemBlueprint(UUID BPOwner, String nome) {
        this.nome = nome;
        this.BPOwner = BPOwner;
        this.is_global_instance = false;
        this.isServerBlueprint = false;
    }

    public CtoS_CreaItemBlueprint(boolean isServerBlueprint, String nome) {
        this.nome = nome;
        this.BPOwner = UUID.randomUUID();
        this.is_global_instance = false;
        this.isServerBlueprint = isServerBlueprint;
    }

    public CtoS_CreaItemBlueprint(UUID BPOwner, String nome, boolean is_global_instance) {
        this.nome = nome;
        this.BPOwner = BPOwner;
        this.is_global_instance = is_global_instance;
        this.isServerBlueprint = false;
    }

    public CtoS_CreaItemBlueprint(FriendlyByteBuf buffer) {
        this.nome = buffer.m_130277_();
        this.BPOwner = buffer.readBoolean() ? buffer.m_130259_() : null;
        this.is_global_instance = buffer.readBoolean();
        this.isServerBlueprint = buffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.nome);
        buffer.writeBoolean(this.BPOwner != null);
        if (this.BPOwner != null) {
            buffer.m_130077_(this.BPOwner);
        }
        buffer.writeBoolean(this.is_global_instance);
        buffer.writeBoolean(this.isServerBlueprint);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ServerLevel level = player.m_9236_();
            if (this.isServerBlueprint) {
                File blueprintFile = null;
                for (File f : Blueprint.getServerBlueprintFile(level).listFiles()) {
                    if (!f.getName().equals(this.nome + ".bp")) continue;
                    blueprintFile = f;
                    break;
                }
                if (blueprintFile != null) {
                    try {
                        Blueprint.BlueprintDatas bd = (Blueprint.BlueprintDatas)GSON.fromJson((Reader)new FileReader(blueprintFile), Blueprint.BlueprintDatas.class);
                        Blueprint.CreaItemServerBlueprintEDaiAGiocatore(player, this.nome, bd.altezza, bd.lunghezzaX, bd.lunghezzaZ);
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            } else {
                File blueprintFile = null;
                for (File f : Blueprint.getFileForBlueprints(level, this.BPOwner == null ? player.m_20148_() : this.BPOwner).listFiles()) {
                    if (!f.getName().equals(this.nome + ".bp")) continue;
                    blueprintFile = f;
                    break;
                }
                if (blueprintFile != null) {
                    try {
                        Blueprint.BlueprintDatas bd = (Blueprint.BlueprintDatas)GSON.fromJson((Reader)new FileReader(blueprintFile), Blueprint.BlueprintDatas.class);
                        if (this.BPOwner == null) {
                            Blueprint.CreaItemBlueprintEDaiAGiocatore(player, player.m_20148_(), this.nome, bd.altezza, bd.lunghezzaX, bd.lunghezzaZ);
                        } else {
                            Blueprint.CreaItemBlueprintEDaiAGiocatore(player, this.BPOwner, this.nome, bd.altezza, bd.lunghezzaX, bd.lunghezzaZ);
                        }
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        return true;
    }
}

