/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkEvent;
import nimble.portable_blueprints.altro.BlockBlueprintUsage;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.altro.BlueprintUsageCooldown;
import nimble.portable_blueprints.altro.PlacingBlockManager;
import nimble.portable_blueprints.init.ModItems;
import nimble.portable_blueprints.mod_compatibility.ModCompatibilityInit;
import nimble.portable_blueprints.mod_compatibility.projecte.ProjectEMetodi;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.StoC_ObstructionBlock;
import nimble.portable_blueprints.portable_blueprints.ModServerConfig;
import nimble.portable_blueprints.robautile.Operazioni;

public class CtoS_CreateStructureByBlueprint {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final boolean isServerBlueprint;
    private final boolean isWornBlueprint;
    private final ItemStack blueprint_item;

    public CtoS_CreateStructureByBlueprint() {
        this.blueprint_item = ItemStack.f_41583_;
        this.isServerBlueprint = false;
        this.isWornBlueprint = false;
    }

    public CtoS_CreateStructureByBlueprint(ItemStack blueprint_item, boolean isServerBlueprint, boolean isWornBlueprint) {
        this.blueprint_item = blueprint_item;
        this.isServerBlueprint = isServerBlueprint;
        this.isWornBlueprint = isWornBlueprint;
    }

    public CtoS_CreateStructureByBlueprint(FriendlyByteBuf buffer) {
        this.isServerBlueprint = buffer.readBoolean();
        this.isWornBlueprint = buffer.readBoolean();
        this.blueprint_item = buffer.m_130267_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isServerBlueprint);
        buffer.writeBoolean(this.isWornBlueprint);
        buffer.m_130055_(this.blueprint_item);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            UUID owner_blueprint;
            if (this.blueprint_item.equals(ItemStack.f_41583_)) {
                return;
            }
            ServerPlayer player = context.getSender();
            ServerLevel level = player.m_9236_();
            if (BlockBlueprintUsage.PlayersBlock.contains(player.m_7755_().getString())) {
                player.m_5661_((Component)Component.m_237115_((String)"chat_message.portable_blueprints.block").m_130940_(ChatFormatting.RED), false);
                return;
            }
            if (BlueprintUsageCooldown.hasCooldown(player.m_20148_()) != 0) {
                player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"chat_message.portable_blueprints.blueprint_cooldown").getString().replace("%v%", String.valueOf(BlueprintUsageCooldown.hasCooldown(player.m_20148_())))).m_130940_(ChatFormatting.RED), false);
                return;
            }
            CompoundTag nbt = this.blueprint_item.m_41784_();
            BlockPos origin_pos = new BlockPos(Operazioni.getVec3iFromString(nbt.m_128461_("originPos")));
            boolean mirrowX = nbt.m_128471_("mirrowX");
            boolean mirrowY = nbt.m_128471_("mirrowY");
            boolean mirrowZ = nbt.m_128471_("mirrowZ");
            boolean skipObstructionBlock = nbt.m_128471_("skipObstructionBlock");
            short rotation = nbt.m_128448_("rotateValue");
            String nome = nbt.m_128461_("nome");
            String posizioni_inventari_blocco = nbt.m_128461_("inventari_blocco_selezionati");
            try {
                owner_blueprint = !nbt.m_128461_("owner").equals("") && !this.isServerBlueprint && !this.isWornBlueprint ? UUID.fromString(nbt.m_128461_("owner")) : null;
            }
            catch (Exception e) {
                owner_blueprint = null;
            }
            boolean buildAniway = nbt.m_128471_("buildAnyway");
            if (player.m_21205_() != null && player.m_21205_().m_41720_().equals(ModItems.BLUEPRINT.get())) {
                nbt.m_128379_("visualizeBuild", false);
                nbt.m_128473_("originPos");
            }
            File blueprintFile = Arrays.stream(this.isServerBlueprint ? Blueprint.getServerBlueprintFile(level).listFiles() : (this.isWornBlueprint ? Blueprint.getWornBlueprintFile(level).listFiles() : Blueprint.getFileForBlueprints(level, owner_blueprint).listFiles())).filter(f -> f.getName().equals(nome + ".bp")).findFirst().orElse(null);
            ArrayList BlocksDataToRemove = new ArrayList();
            ArrayList NotSolidBlocksDataToRemove = new ArrayList();
            if (blueprintFile != null) {
                new Thread(() -> {
                    block34: {
                        try {
                            Blueprint.BlueprintDatas bd = (Blueprint.BlueprintDatas)GSON.fromJson((Reader)new FileReader(blueprintFile), Blueprint.BlueprintDatas.class);
                            if (rotation != 0) {
                                bd = bd.rotate(rotation);
                            }
                            if (mirrowX || mirrowY || mirrowZ) {
                                bd = bd.Mirrow(mirrowX, mirrowY, mirrowZ);
                            }
                            bd.offset = Operazioni.SommaBlockPos(bd.offset == null ? BlockPos.f_121853_ : bd.offset, origin_pos);
                            ArrayList<BlockPos> posInventari = new ArrayList<BlockPos>();
                            for (String pos : posizioni_inventari_blocco.split("!;!")) {
                                if (pos.equals("")) continue;
                                posInventari.add(new BlockPos(Operazioni.getVec3iFromString(pos)));
                            }
                            Map<Item, Integer> ItemDisponibili = Blueprint.getAllItemQuantityFromInventory(player, level, posInventari);
                            boolean free_build = nbt.m_128441_("free_build") && nbt.m_128471_("free_build");
                            boolean emc_active = nbt.m_128441_("projecte_active_emc") && nbt.m_128471_("projecte_active_emc");
                            HashMap<Item, Integer> QuantitaItemRichiesti = new HashMap<Item, Integer>();
                            long PlayerEMC = ProjectEMetodi.getEMCPlayer(player.m_20148_());
                            boolean AreaLibera = true;
                            boolean erroreBloccoOstruzione = false;
                            ArrayList<BlockPos> posBlocchiCheOstruiscono = new ArrayList<BlockPos>();
                            for (int alt = 0; alt <= bd.altezza && (AreaLibera || erroreBloccoOstruzione); ++alt) {
                                block6: for (int x = 0; x < 2; ++x) {
                                    boolean isSolidBlocks;
                                    boolean bl = isSolidBlocks = x == 0;
                                    if (!(isSolidBlocks ? bd.BlocksData.containsKey(alt) : bd.NotSolidBlocksData.containsKey(alt))) continue;
                                    int counting = 0;
                                    for (String pos : isSolidBlocks ? bd.BlocksData.get(alt).keySet() : bd.NotSolidBlocksData.get(alt).keySet()) {
                                        if (!AreaLibera && !erroreBloccoOstruzione) continue block6;
                                        BlockPos blockPos = new BlockPos(Operazioni.getVec3iFromString(pos));
                                        String datiBlocco = isSolidBlocks ? bd.BlocksData.get(alt).get(Operazioni.getVec3iString(new Vec3i(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()))) : bd.NotSolidBlocksData.get(alt).get(Operazioni.getVec3iString(new Vec3i(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_())));
                                        String bloccoId = datiBlocco.substring(datiBlocco.indexOf("<bid>") + 5, datiBlocco.indexOf("</bid>"));
                                        datiBlocco = datiBlocco.replaceFirst("<bid>" + bloccoId + "</bid>", "");
                                        if (ModServerConfig.blacklistBlock.contains(bloccoId)) {
                                            if (isSolidBlocks) {
                                                BlocksDataToRemove.add(alt + "<daRimuovere>" + pos);
                                                continue;
                                            }
                                            NotSolidBlocksDataToRemove.add(alt + "<daRimuovere>" + pos);
                                            continue;
                                        }
                                        BlockState blockState = datiBlocco.equals("null") ? Operazioni.getBlockFromString(bloccoId).m_49966_() : Operazioni.getPropertiesStringToBlock(Operazioni.getBlockFromString(bloccoId), datiBlocco);
                                        Block blocco = Operazioni.getBlockFromString(bloccoId);
                                        BlockState PlacedBlockBlockState = level.m_8055_(Operazioni.SommaBlockPos(bd.offset, blockPos));
                                        Item bi = Operazioni.getCorrectItemStackFromId(blocco).m_41720_();
                                        if (QuantitaItemRichiesti.containsKey(bi)) {
                                            QuantitaItemRichiesti.replace(bi, (Integer)QuantitaItemRichiesti.get(bi) + 1);
                                        } else {
                                            QuantitaItemRichiesti.put(bi, 1);
                                        }
                                        if (!(skipObstructionBlock || PlacedBlockBlockState.m_60713_(Blocks.f_50016_) || PlacedBlockBlockState.m_60713_(blocco) || PlacingBlockManager.isRimpiazzabile(level, PlacedBlockBlockState, Operazioni.SommaBlockPos(bd.offset, blockPos)))) {
                                            AreaLibera = false;
                                            erroreBloccoOstruzione = true;
                                            posBlocchiCheOstruiscono.add(Operazioni.SommaBlockPos(bd.offset, blockPos));
                                        }
                                        if (free_build || buildAniway || player.m_7500_() || player.m_5833_() || blockState.m_61138_((Property)BlockStateProperties.f_61401_) && !((DoubleBlockHalf)blockState.m_61143_((Property)BlockStateProperties.f_61401_)).equals((Object)DoubleBlockHalf.LOWER) || blockState.m_61138_((Property)BlockStateProperties.f_61391_) && !((BedPart)blockState.m_61143_((Property)BlockStateProperties.f_61391_)).equals((Object)BedPart.FOOT)) continue;
                                        if (ItemDisponibili.containsKey(blocco.m_5456_())) {
                                            int newQuantity = ItemDisponibili.get(blocco.m_5456_()) - 1;
                                            if (newQuantity <= 0) {
                                                ItemDisponibili.remove(blocco.m_5456_());
                                            } else {
                                                ItemDisponibili.replace(blocco.m_5456_(), newQuantity);
                                            }
                                        } else if (!blocco.m_5456_().equals(Items.f_41852_)) {
                                            if (ModCompatibilityInit.isProjectELoaded && emc_active) {
                                                long vEMC = ProjectEMetodi.getEMCForItem(Operazioni.getCorrectItemStackFromId(blocco).m_41720_());
                                                if (vEMC == 0L) {
                                                    AreaLibera = false;
                                                    player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"hotbar_message.portable_blueprints.item_missing").getString().replace("%v%", Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).m_41720_().toString())).m_130940_(ChatFormatting.RED), false);
                                                } else if (PlayerEMC >= vEMC) {
                                                    PlayerEMC -= vEMC;
                                                } else {
                                                    AreaLibera = false;
                                                    player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"gui.portable_blueprints.compatibility.projecte.emc_missing").getString().replace("%v%", Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).m_41720_().toString())).m_130940_(ChatFormatting.RED), false);
                                                }
                                            } else {
                                                AreaLibera = false;
                                                player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"hotbar_message.portable_blueprints.item_missing").getString().replace("%v%", Operazioni.getCorrectItemStackFromId(Operazioni.getBlockFromString(bloccoId)).m_41720_().toString())).m_130940_(ChatFormatting.RED), false);
                                            }
                                        }
                                        if (++counting % 50 != 0) continue;
                                        Thread.sleep(2L);
                                    }
                                }
                                Thread.sleep(1L);
                            }
                            if (AreaLibera) {
                                if (this.isWornBlueprint) {
                                    for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                                        ItemStack stack = player.m_150109_().m_8020_(i);
                                        if (stack.m_41619_() || !ItemStack.m_41746_((ItemStack)stack, (ItemStack)this.blueprint_item) || !stack.m_41784_().m_128461_("blueprint_name").equals(this.blueprint_item.m_41784_().m_128461_("blueprint_name"))) continue;
                                        CompoundTag _nbt = stack.m_41784_();
                                        if (!_nbt.m_128441_("remaining_uses")) break;
                                        int uses = _nbt.m_128451_("remaining_uses") - 1;
                                        _nbt.m_128405_("remaining_uses", uses);
                                        stack.m_41751_(_nbt);
                                        if (uses > 0) break;
                                        level.m_5594_(null, player.m_20183_(), SoundEvents.f_12018_, SoundSource.AMBIENT, 1.0f, 2.0f);
                                        player.m_150109_().m_36057_(stack);
                                        break;
                                    }
                                }
                                for (String elemento : BlocksDataToRemove) {
                                    String[] split = elemento.split("<daRimuovere>");
                                    bd.BlocksData.get(Integer.parseInt(split[0])).remove(split[1]);
                                }
                                for (String elemento : NotSolidBlocksDataToRemove) {
                                    String[] split = elemento.split("<daRimuovere>");
                                    bd.BlocksData.get(Integer.parseInt(split[0])).remove(split[1]);
                                }
                                if (!player.m_20310_(1)) {
                                    BlueprintUsageCooldown.setInCooldown(level, player.m_20148_());
                                }
                                Blueprint.AggiungiStructureAllaCoda(level, bd, (Player)player, posInventari, free_build, (short)(nbt.m_128441_("allow_nbt") ? (nbt.m_128471_("allow_nbt") ? 1 : 0) : -1), emc_active);
                                break block34;
                            }
                            if (!erroreBloccoOstruzione) break block34;
                            player.m_5661_((Component)Component.m_237113_((String)Component.m_237115_((String)"hotbar_message.portable_blueprints.block_obstruction").getString().replace("%v%", String.valueOf(posBlocchiCheOstruiscono.size()))).m_130940_(ChatFormatting.RED), false);
                            int count = 0;
                            for (BlockPos pos : posBlocchiCheOstruiscono) {
                                try {
                                    if (++count % 500 == 0) {
                                        Thread.sleep(10L);
                                    }
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                PacketHandler.sendToPlayer(new StoC_ObstructionBlock(pos), player);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
            }
        });
        return true;
    }
}

