/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.portable_blueprints;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;
import nimble.portable_blueprints.robautile.Operazioni;

public class ModConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> ScannerIgnoredBlocks;
    public static ForgeConfigSpec.ConfigValue<String> ScannerAreaColor;
    public static ForgeConfigSpec.ConfigValue<String> ContainerAreaColor;
    public static ForgeConfigSpec.ConfigValue<String> BlueprintAreaColor;
    public static ForgeConfigSpec.BooleanValue ScanningAnimationEnabled;
    public static ForgeConfigSpec.BooleanValue ScanningAreaTextureEnabled;
    public static ForgeConfigSpec.BooleanValue SelectedContainerAreaTextureEnabled;
    public static ForgeConfigSpec.ConfigValue<Integer> DefaultHologramTransparency;
    public static ForgeConfigSpec.BooleanValue ContainerMessagesEnabled;

    public static void updateConfigFile() {
        Path configPath = FMLPaths.CONFIGDIR.get().resolve("portable_blueprints-client.toml");
        CommentedFileConfig cfg = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).sync().autosave().writingMode(WritingMode.REPLACE).build();
        cfg.load();
        cfg.save();
    }

    public static Vec3 getScannerAreaColor() {
        String color = (String)ScannerAreaColor.get();
        if (color.length() != 7 || color.charAt(0) != '#') {
            return new Vec3(0.0, 0.0, 0.0);
        }
        return Operazioni.getColorFromHex(Integer.parseInt(color.replace("#", ""), 16));
    }

    public static Vec3 getContainerAreaColor() {
        String color = (String)ContainerAreaColor.get();
        if (color.length() != 7 || color.charAt(0) != '#') {
            return new Vec3(0.0, 0.0, 0.0);
        }
        return Operazioni.getColorFromHex(Integer.parseInt(color.replace("#", ""), 16));
    }

    public static Vec3 getBlueprintAreaColor() {
        String color = (String)BlueprintAreaColor.get();
        if (color.length() != 7 || color.charAt(0) != '#') {
            return new Vec3(0.0, 0.0, 0.0);
        }
        return Operazioni.getColorFromHex(Integer.parseInt(color.replace("#", ""), 16));
    }

    public static float getDefaultHologramTransparency() {
        int v = (Integer)DefaultHologramTransparency.get();
        if (v > 100) {
            v = 100;
        }
        if (v < 0) {
            v = 0;
        }
        return 1.0f - (float)v / 100.0f;
    }

    static {
        ScannerIgnoredBlocks = BUILDER.comment("List of block IDs ignored by the scanner (example: [\"minecraft:stone\", \"minecraft:dirt\"] )").defineListAllowEmpty(List.of("scannerIgnoredBlocks"), () -> List.of(), entry -> entry instanceof String);
        ScannerAreaColor = BUILDER.comment("Scanner selection area color (default: \"#00FFFF\")").define("scannerAreaColor", (Object)"#00FFFF");
        ContainerAreaColor = BUILDER.comment("Container selected area color (default: \"#FFFF00\")").define("containerAreaColor", (Object)"#FFFF00");
        BlueprintAreaColor = BUILDER.comment("Blueprint preview area color (default: \"#0000FF\")").define("blueprintAreaColor", (Object)"#0000FF");
        ScanningAnimationEnabled = BUILDER.comment("Enable scanner animation when creating a new blueprint (default: true)").define("scanningAnimationEnabled", true);
        ScanningAreaTextureEnabled = BUILDER.comment("Enable texture borders in the scanner selected area, disabling it will show only outlines (default: true)").define("scanningAreaTextureEnabled", true);
        SelectedContainerAreaTextureEnabled = BUILDER.comment("Enable texture borders in the container area selected by blueprint, disabling it will show only outlines (default: true)").define("selectedContainerAreaTextureEnabled", true);
        DefaultHologramTransparency = BUILDER.comment("Default hologram transparency value (default: 0 | min: 0 | max: 100)").define("defaultHologramTransparency", (Object)0);
        ContainerMessagesEnabled = BUILDER.comment("Enables messages related to containers linked via the blueprint item").define("containerMessagesEnabled", true);
        SPEC = BUILDER.build();
    }
}

