/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.robautile;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nimble.portable_blueprints.robautile.Operazioni;
import nimble.portable_blueprints.robautile.RenderingMethods;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedButton
extends AbstractWidget {
    protected final OnPress onPress;
    private final int tickTime;
    private final Font font;
    private int fontColor;
    private final int originalColor;
    private final Vec2 fontOffset;
    private final boolean fontHasShadow;
    private final float fontSize;
    private final Vec2 messagePositionOffset;
    private final Vec2 messageMaxSize;
    private Component Message;
    private Image DefaultImage;
    private Image ImageCondition;
    private Image PressedImageTick;
    private Image HoverImage;
    private boolean hasPressedCondition;
    private boolean hasPressedTick;
    public boolean PressedImageCondition = false;
    private int PressedTickRemain = 0;
    private ColorHover colorHover;
    private boolean hasHoverImage = false;
    private long LastPressTime = System.currentTimeMillis();
    private long AspettaTot = System.currentTimeMillis();
    private long TempoCheDevePassarePerIlProssimo = 500L;
    private boolean hasHoldPress = false;
    private Vec2 LongPressPosStart;
    public Component tooltip;
    public Component originTooltip;
    public int posX;
    public int posY;
    private boolean tenendoPremuto = false;

    public AdvancedButton(int pX, int pY, int pWidth, int pHeight, Component pMessage, OnPress onPress, Image DefaultImage, Image ImageCondition, boolean hasPressedCondition, boolean hasPressedTick, Image PressedImageTick, int tickTime, int fontColor, Vec2 fontOffset, boolean fontHasShadow, float fontSize, Vec2 messagePositionOffset, Vec2 messageMaxSize, boolean hasHoverImage, Image HoverImage, ColorHover colorHover, boolean hasHoldPress, long TempoCheDevePassarePerIlProssimo) {
        super(pX, pY, pWidth, pHeight, pMessage);
        this.posX = pX;
        this.posY = pY;
        this.onPress = onPress;
        this.Message = pMessage;
        this.tickTime = tickTime;
        this.DefaultImage = DefaultImage;
        this.ImageCondition = ImageCondition;
        this.PressedImageTick = PressedImageTick;
        this.HoverImage = HoverImage;
        this.colorHover = colorHover;
        this.hasPressedCondition = hasPressedCondition;
        this.hasPressedTick = hasPressedTick;
        this.hasHoverImage = hasHoverImage;
        this.font = Minecraft.m_91087_().f_91062_;
        this.originalColor = fontColor;
        this.fontColor = fontColor;
        this.hasHoldPress = hasHoldPress;
        this.TempoCheDevePassarePerIlProssimo = TempoCheDevePassarePerIlProssimo;
        if (fontOffset == null) {
            fontOffset = new Vec2(0.0f, 0.0f);
        }
        this.fontOffset = fontOffset;
        this.fontSize = fontSize;
        this.fontHasShadow = fontHasShadow;
        this.messagePositionOffset = messagePositionOffset;
        this.messageMaxSize = messageMaxSize == null ? new Vec2((float)pWidth, (float)pHeight) : messageMaxSize;
    }

    public AdvancedButton(Builder builder) {
        this(builder.x, builder.y, builder.width, builder.height, builder.message, builder.onPress, builder.DefaultImage, builder.PressedImageCondition, builder.hasPressedImage, builder.hasPressedTick, builder.PressedImageTick, builder.tickTime, builder.fontColor, builder.fontOffset, builder.fontHasShadow, builder.fontSize, builder.messagePositionOffset, builder.messageMaxSize, builder.hasHoverImage, builder.HoverImage, builder.colorHover, builder.hasHoldPress, builder.DistaccoDaUnaChiamataELAltra);
        this.tooltip = builder.tooltip;
        this.originTooltip = builder.tooltip;
    }

    public static Builder builder(Component pMessage, OnPress pOnPress) {
        return new Builder(pMessage, pOnPress);
    }

    public void setOffsetButton(int offsetX, int offsetY) {
        this.f_93620_ = this.posX + offsetX;
        this.f_93621_ = this.posY + offsetY;
    }

    public void setTooltip(Component component) {
        this.tooltip = component;
    }

    public void m_6305_(PoseStack poseStack, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.hasHoldPress && this.tenendoPremuto && System.currentTimeMillis() > this.LastPressTime + this.TempoCheDevePassarePerIlProssimo && System.currentTimeMillis() > this.AspettaTot) {
            this.LastPressTime = System.currentTimeMillis();
            this.onPress();
        }
        int messageX = this.f_93620_ + this.f_93618_ / 2;
        int messageY = this.f_93621_ + this.f_93619_ / 2;
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.hasHoldPress && this.tenendoPremuto) {
            if (this.ImageCondition != null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.ImageCondition.ButtonImageResource);
                this.m_93228_(poseStack, this.ImageCondition.x, this.ImageCondition.y, this.ImageCondition.offsetX, this.ImageCondition.offsetY, this.ImageCondition.width, this.ImageCondition.height);
                messageX = this.ImageCondition.x + this.f_93618_ / 2;
                messageY = this.ImageCondition.y + this.f_93619_ / 2;
            } else if (this.PressedImageTick != null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.PressedImageTick.ButtonImageResource);
                this.m_93228_(poseStack, this.PressedImageTick.x, this.PressedImageTick.y, this.PressedImageTick.offsetX, this.PressedImageTick.offsetY, this.PressedImageTick.width, this.PressedImageTick.height);
                messageX = this.PressedImageTick.x + this.f_93618_ / 2;
                messageY = this.PressedImageTick.y + this.f_93619_ / 2;
            }
        } else if (this.hasPressedCondition && this.PressedImageCondition && this.ImageCondition != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.ImageCondition.ButtonImageResource);
            this.m_93228_(poseStack, this.ImageCondition.x, this.ImageCondition.y, this.ImageCondition.offsetX, this.ImageCondition.offsetY, this.ImageCondition.width, this.ImageCondition.height);
            messageX = this.ImageCondition.x + this.f_93618_ / 2;
            messageY = this.ImageCondition.y + this.f_93619_ / 2;
        } else if (this.hasPressedTick && this.PressedTickRemain > 0) {
            --this.PressedTickRemain;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.PressedImageTick.ButtonImageResource);
            this.m_93228_(poseStack, this.PressedImageTick.x, this.PressedImageTick.y, this.PressedImageTick.offsetX, this.PressedImageTick.offsetY, this.PressedImageTick.width, this.PressedImageTick.height);
            messageX = this.PressedImageTick.x + this.f_93618_ / 2;
            messageY = this.PressedImageTick.y + this.f_93619_ / 2;
        } else if (this.hasHoverImage && this.m_5953_(pMouseX, pMouseY)) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.HoverImage.ButtonImageResource);
            this.m_93228_(poseStack, this.HoverImage.x, this.HoverImage.y, this.HoverImage.offsetX, this.HoverImage.offsetY, this.HoverImage.width, this.HoverImage.height);
        } else if (this.DefaultImage != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.DefaultImage.ButtonImageResource);
            this.m_93228_(poseStack, this.DefaultImage.x, this.DefaultImage.y, this.DefaultImage.offsetX, this.DefaultImage.offsetY, this.DefaultImage.width, this.DefaultImage.height);
        }
        RenderSystem.m_69461_();
        if (this.colorHover != null && this.m_5953_(pMouseX, pMouseY) && this.PressedTickRemain == 0) {
            RenderSystem.m_157429_((float)((float)(this.colorHover.R / 255.0)), (float)((float)(this.colorHover.G / 255.0)), (float)((float)(this.colorHover.B / 255.0)), (float)((float)(this.colorHover.alpha / 255.0)));
            AdvancedButton.m_93172_((PoseStack)poseStack, (int)((int)this.colorHover.StartPos.f_82470_), (int)((int)this.colorHover.StartPos.f_82471_), (int)((int)this.colorHover.EndPos.f_82470_), (int)((int)this.colorHover.EndPos.f_82471_), (int)-1);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (!this.Message.getString().equalsIgnoreCase("")) {
            float scale = 1.0f * this.fontSize;
            String valore = Operazioni.getValueInsideTag(this.Message.getString(), "remove_size");
            String messaggio = this.Message.getString();
            if (!valore.isEmpty()) {
                messaggio = messaggio.replace("<remove_size>" + valore + "</remove_size>", "");
                scale -= Float.parseFloat(valore);
            }
            if ((float)((int)((float)this.font.m_92895_(messaggio) * this.fontSize)) > this.messageMaxSize.f_82470_) {
                scale = this.messageMaxSize.f_82470_ / ((float)this.font.m_92895_(messaggio) * this.fontSize);
            }
            RenderingMethods.GuiGraphicsTestoScalato(poseStack, this.Message.getString(), scale, this.font, new Vec2((float)messageX, (float)messageY), this.fontColor, false, RenderingMethods.PosizioneTesto.CENTRO, true);
        }
        if (this.m_5953_(pMouseX, pMouseY)) {
            this.m_7428_(poseStack, pMouseX, pMouseY);
        }
    }

    public void m_7428_(PoseStack poseStack, int pMouseX, int pMouseY) {
        super.m_7428_(poseStack, pMouseX, pMouseY);
    }

    public boolean m_6375_(double MouseX, double MouseY, int Button) {
        if (this.m_5953_(MouseX, MouseY)) {
            if (this.hasHoldPress) {
                this.tenendoPremuto = true;
                this.LastPressTime = System.currentTimeMillis();
                this.AspettaTot = System.currentTimeMillis() + 500L;
                this.LongPressPosStart = new Vec2((float)MouseX, (float)MouseY);
                this.onPress();
            } else {
                if (this.hasPressedTick) {
                    this.PressedTickRemain = this.tickTime;
                }
                this.onPress();
            }
        }
        return super.m_6375_(MouseX, MouseY, Button);
    }

    public boolean m_6348_(double p_93684_, double p_93685_, int p_93686_) {
        if (this.tenendoPremuto) {
            this.tenendoPremuto = false;
        }
        return super.m_6348_(p_93684_, p_93685_, p_93686_);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.tenendoPremuto) {
            Vec2 vec2 = new Vec2((float)mouseX, (float)mouseY);
            if (Operazioni.calculateDistance(this.LongPressPosStart, vec2) > (float)this.f_93618_) {
                this.tenendoPremuto = false;
            }
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void onPress() {
        this.onPress.onPress(this);
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    public void setFontColor(int color) {
        this.fontColor = color;
    }

    public void resetFontColor() {
        this.fontColor = this.originalColor;
    }

    public Component getTooltip() {
        return this.tooltip;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnPress {
        public void onPress(AdvancedButton var1);
    }

    public static class Image {
        private final ResourceLocation ButtonImageResource;
        private final int x;
        private final int y;
        private final int offsetX;
        private final int offsetY;
        private final int width;
        private final int height;

        public Image(ResourceLocation buttonImageResource, int x, int y, int offsetX, int offsetY, int width, int height) {
            this.ButtonImageResource = buttonImageResource;
            this.x = x;
            this.y = y;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.width = width;
            this.height = height;
        }
    }

    public static class ColorHover {
        public double R;
        public double G;
        public double B;
        public double alpha;
        public Vec2 StartPos;
        public Vec2 EndPos;

        public ColorHover(int Color, Vec2 StartPos, Vec2 EndPos) {
            this.alpha = Color >> 24 & 0xFF;
            this.R = Color >> 16 & 0xFF;
            this.G = Color >> 8 & 0xFF;
            this.B = Color & 0xFF;
            this.StartPos = StartPos;
            this.EndPos = EndPos;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final Component message;
        private final OnPress onPress;
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;
        private Image DefaultImage;
        private Image PressedImageCondition;
        private Image PressedImageTick;
        private Image HoverImage;
        private boolean hasPressedImage = false;
        private boolean hasPressedTick = false;
        private int tickTime;
        private int fontColor;
        private Vec2 fontOffset;
        private boolean fontHasShadow;
        private Component tooltip;
        private float fontSize = 1.0f;
        private Vec2 messagePositionOffset = new Vec2(0.0f, 0.0f);
        private Vec2 messageMaxSize;
        private ColorHover colorHover;
        private boolean hasHoverImage = false;
        private long DistaccoDaUnaChiamataELAltra;
        private boolean hasHoldPress = false;

        public Builder(Component TestoPulsante, OnPress pOnPress) {
            this.message = TestoPulsante;
            this.onPress = pOnPress;
        }

        public Builder pos(int pX, int pY) {
            this.x = pX;
            this.y = pY;
            return this;
        }

        public Builder size(int pWidth, int pHeight) {
            this.width = pWidth;
            this.height = pHeight;
            return this;
        }

        public Builder addColorHover(ColorHover colorHover) {
            this.colorHover = colorHover;
            return this;
        }

        public Builder defaultImage(Image DefaultImage) {
            this.DefaultImage = DefaultImage;
            return this;
        }

        public Builder pressedImageCondition(Image PressedImageCondition) {
            this.PressedImageCondition = PressedImageCondition;
            this.hasPressedImage = true;
            return this;
        }

        public Builder pressedImageTick(Image PressedImageTick, int tickTime) {
            this.hasPressedTick = true;
            this.PressedImageTick = PressedImageTick;
            this.tickTime = tickTime;
            return this;
        }

        public Builder hoverImage(Image HoverImage) {
            this.HoverImage = HoverImage;
            this.hasHoverImage = true;
            return this;
        }

        public Builder fontColor(int colore) {
            this.fontColor = colore;
            return this;
        }

        public Builder fontOffset(int offsetX, int offsetY) {
            this.fontOffset = new Vec2((float)offsetX, (float)offsetY);
            return this;
        }

        public Builder fontHasShadow(boolean fontHasShadow) {
            this.fontHasShadow = fontHasShadow;
            return this;
        }

        public Builder fontSize(float fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public Builder setHoldButton(long DistaccoDaUnaChiamataELAltra) {
            this.DistaccoDaUnaChiamataELAltra = DistaccoDaUnaChiamataELAltra;
            this.hasHoldPress = true;
            return this;
        }

        public Builder tooltip(@Nullable Component pTooltip) {
            this.tooltip = pTooltip;
            return this;
        }

        public AdvancedButton build() {
            return this.build(AdvancedButton::new);
        }

        public AdvancedButton build(Function<Builder, AdvancedButton> builder) {
            return builder.apply(this);
        }

        public Builder messagePositionOffset(int offsetX, int offsetY) {
            this.messagePositionOffset = new Vec2((float)offsetX, (float)offsetY);
            return this;
        }

        public Builder messageMaxSize(int sizeX, int sizeY) {
            this.messageMaxSize = new Vec2((float)sizeX, (float)sizeY);
            return this;
        }
    }
}

