/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.robautile;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;

public class ModifiableItemInventory {
    private final ItemStack source;
    private final Container container;
    private final boolean isVanillaShulker;

    private ModifiableItemInventory(ItemStack source, Container container, boolean isVanillaShulker) {
        this.source = source;
        this.container = container;
        this.isVanillaShulker = isVanillaShulker;
    }

    public static Optional<ModifiableItemInventory> of(ItemStack stack) {
        IItemHandlerModifiable handler;
        if (stack.m_41619_()) {
            return Optional.empty();
        }
        LazyOptional opt = stack.getCapability(ForgeCapabilities.ITEM_HANDLER).cast();
        if (opt.isPresent() && (handler = (IItemHandlerModifiable)opt.orElse(null)) != null && handler.getSlots() > 0) {
            SimpleContainer container = new SimpleContainer(handler.getSlots());
            for (int i = 0; i < handler.getSlots(); ++i) {
                container.m_6836_(i, handler.getStackInSlot(i));
            }
            return Optional.of(new ModifiableItemInventory(stack, (Container)container, false));
        }
        CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
        if (tag != null && tag.m_128425_("Items", 9)) {
            int size = tag.m_128425_("Size", 3) ? tag.m_128451_("Size") : 27;
            NonNullList items = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)items);
            SimpleContainer container = new SimpleContainer(size);
            for (int i = 0; i < items.size(); ++i) {
                container.m_6836_(i, (ItemStack)items.get(i));
            }
            return Optional.of(new ModifiableItemInventory(stack, (Container)container, true));
        }
        return Optional.empty();
    }

    public Container getContainer() {
        return this.container;
    }

    public void save() {
        if (this.isVanillaShulker) {
            CompoundTag tag = BlockItem.m_186336_((ItemStack)this.source);
            if (tag == null) {
                tag = new CompoundTag();
            }
            ContainerHelper.m_18973_((CompoundTag)tag, this.containerItems());
            tag.m_128405_("Size", this.container.m_6643_());
            BlockItem.m_186338_((ItemStack)this.source, Objects.requireNonNull(ModifiableItemInventory.getBlockEntityType(this.source)), (CompoundTag)tag);
        } else {
            this.source.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                if (handler instanceof IItemHandlerModifiable) {
                    IItemHandlerModifiable modHandler = (IItemHandlerModifiable)handler;
                    for (int i = 0; i < modHandler.getSlots(); ++i) {
                        modHandler.setStackInSlot(i, this.container.m_8020_(i));
                    }
                }
            });
        }
    }

    @Nullable
    public static BlockEntityType<?> getBlockEntityType(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return null;
        }
        BlockItem blockItem = (BlockItem)item;
        for (BlockEntityType type : ForgeRegistries.BLOCK_ENTITY_TYPES) {
            if (!type.m_155262_(blockItem.m_40614_().m_49966_())) continue;
            return type;
        }
        return null;
    }

    private NonNullList<ItemStack> containerItems() {
        NonNullList items = NonNullList.m_122780_((int)this.container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.container.m_6643_(); ++i) {
            items.set(i, (Object)this.container.m_8020_(i));
        }
        return items;
    }
}

