/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.blockentity;

import com.belgie.creaking_expanded.blocks.ResinCampfireBlock;
import com.belgie.creaking_expanded.registry.BlockEntityRegistry;
import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;

public class ResinCampfireBlockEntity
extends BlockEntity
implements Clearable {
    private static final int BURN_COOL_SPEED = 2;
    private static final int NUM_SLOTS = 4;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private final int[] cookingProgress = new int[4];
    private final int[] cookingTime = new int[4];

    public ResinCampfireBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntityRegistry.RESIN_CAMPFIRE.get(), pos, blockState);
    }

    public static void cookTick(ServerLevel p_380207_, BlockPos p_155308_, BlockState p_155309_, ResinCampfireBlockEntity p_155310_, RecipeManager.CachedCheck<SingleRecipeInput, CampfireCookingRecipe> p_380193_) {
        p_380207_.setBlock(p_155308_, (BlockState)p_155309_.setValue((Property)ResinCampfireBlock.LIT, (Comparable)Boolean.valueOf((Boolean)p_380207_.environmentAttributes().getValue(EnvironmentAttributes.CREAKING_ACTIVE, p_155308_) != false)), 3);
        boolean flag = false;
        for (int i = 0; i < p_155310_.items.size(); ++i) {
            SingleRecipeInput singlerecipeinput;
            ItemStack itemstack1;
            ItemStack itemstack = (ItemStack)p_155310_.items.get(i);
            if (itemstack.isEmpty()) continue;
            flag = true;
            int n = i;
            p_155310_.cookingProgress[n] = p_155310_.cookingProgress[n] + 1;
            if (p_155310_.cookingProgress[i] < p_155310_.cookingTime[i] || !(itemstack1 = p_380193_.getRecipeFor((RecipeInput)(singlerecipeinput = new SingleRecipeInput(itemstack)), p_380207_).map(p_379274_ -> ((CampfireCookingRecipe)p_379274_.value()).assemble(singlerecipeinput, (HolderLookup.Provider)p_380207_.registryAccess())).orElse(itemstack)).isItemEnabled(p_380207_.enabledFeatures())) continue;
            Containers.dropItemStack((Level)p_380207_, (double)p_155308_.getX(), (double)p_155308_.getY(), (double)p_155308_.getZ(), (ItemStack)itemstack1);
            p_155310_.items.set(i, (Object)ItemStack.EMPTY);
            p_380207_.sendBlockUpdated(p_155308_, p_155309_, p_155309_, 3);
            p_380207_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_155308_, GameEvent.Context.of((BlockState)p_155309_));
        }
        if (flag) {
            ResinCampfireBlockEntity.setChanged((Level)p_380207_, (BlockPos)p_155308_, (BlockState)p_155309_);
        }
    }

    public static void cooldownTick(Level level, BlockPos pos, BlockState state, ResinCampfireBlockEntity blockEntity) {
        level.setBlock(pos, (BlockState)state.setValue((Property)ResinCampfireBlock.LIT, (Comparable)Boolean.valueOf((Boolean)level.environmentAttributes().getValue(EnvironmentAttributes.CREAKING_ACTIVE, pos) != false)), 3);
        boolean flag = false;
        for (int i = 0; i < blockEntity.items.size(); ++i) {
            if (blockEntity.cookingProgress[i] <= 0) continue;
            flag = true;
            blockEntity.cookingProgress[i] = Mth.clamp((int)(blockEntity.cookingProgress[i] - 2), (int)0, (int)blockEntity.cookingTime[i]);
        }
        if (flag) {
            ResinCampfireBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void particleTick(Level level, BlockPos pos, BlockState state, ResinCampfireBlockEntity blockEntity) {
        int l;
        RandomSource randomsource = level.random;
        if (randomsource.nextFloat() < 0.11f) {
            for (l = 0; l < randomsource.nextInt(2) + 2; ++l) {
                ResinCampfireBlock.makeParticles(level, pos, (Boolean)state.getValue((Property)ResinCampfireBlock.SIGNAL_FIRE), false);
            }
        }
        l = ((Direction)state.getValue(ResinCampfireBlock.FACING)).get2DDataValue();
        for (int j = 0; j < blockEntity.items.size(); ++j) {
            if (((ItemStack)blockEntity.items.get(j)).isEmpty() || !(randomsource.nextFloat() < 0.2f)) continue;
            Direction direction = Direction.from2DDataValue((int)Math.floorMod(j + l, 4));
            float f = 0.3125f;
            double d0 = (double)pos.getX() + 0.5 - (double)((float)direction.getStepX() * 0.3125f) + (double)((float)direction.getClockWise().getStepX() * 0.3125f);
            double d1 = (double)pos.getY() + 0.5;
            double d2 = (double)pos.getZ() + 0.5 - (double)((float)direction.getStepZ() * 0.3125f) + (double)((float)direction.getClockWise().getStepZ() * 0.3125f);
            for (int k = 0; k < 4; ++k) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        this.items.clear();
        ContainerHelper.loadAllItems((ValueInput)tag, this.items);
        tag.getIntArray("CookingTimes").ifPresentOrElse(p_390957_ -> System.arraycopy(p_390957_, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, ((int[])p_390957_).length)), () -> Arrays.fill(this.cookingProgress, 0));
        tag.getIntArray("CookingTotalTimes").ifPresentOrElse(p_390958_ -> System.arraycopy(p_390958_, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, ((int[])p_390958_).length)), () -> Arrays.fill(this.cookingTime, 0));
    }

    protected void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        ContainerHelper.saveAllItems((ValueOutput)tag, this.items, (boolean)true);
        tag.putIntArray("CookingTimes", this.cookingProgress);
        tag.putIntArray("CookingTotalTimes", this.cookingTime);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider p_329092_) {
        CompoundTag compoundtag;
        try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(this.problemPath(), LOGGER);){
            TagValueOutput tagvalueoutput = TagValueOutput.createWithContext((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)p_329092_);
            ContainerHelper.saveAllItems((ValueOutput)tagvalueoutput, this.items, (boolean)true);
            compoundtag = tagvalueoutput.buildResult();
        }
        return compoundtag;
    }

    public boolean placeFood(ServerLevel p_380019_, @Nullable LivingEntity p_347582_, ItemStack p_238286_) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            if (!itemstack.isEmpty()) continue;
            Optional optional = p_380019_.recipeAccess().getRecipeFor(RecipeType.CAMPFIRE_COOKING, (RecipeInput)new SingleRecipeInput(p_238286_), (Level)p_380019_);
            if (optional.isEmpty()) {
                return false;
            }
            this.cookingTime[i] = ((CampfireCookingRecipe)((RecipeHolder)optional.get()).value()).cookingTime();
            this.cookingProgress[i] = 0;
            this.items.set(i, (Object)p_238286_.consumeAndReturn(1, p_347582_));
            p_380019_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((Entity)p_347582_, (BlockState)this.getBlockState()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void clearContent() {
        this.items.clear();
    }

    public void dowse() {
        if (this.level != null) {
            this.markUpdated();
        }
    }

    protected void applyImplicitComponents(DataComponentGetter componentInput) {
        super.applyImplicitComponents(componentInput);
        ((ItemContainerContents)componentInput.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.getItems());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getItems()));
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("Items");
    }
}

