/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.blockentity;

import com.belgie.creaking_expanded.blocks.SightBlock;
import com.belgie.creaking_expanded.registry.BlockEntityRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class SightBlockEntity
extends BlockEntity {
    public SightBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntityRegistry.SIGHT.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SightBlockEntity be) {
        int radius = 16;
        List players = level.getEntitiesOfClass(Player.class, new AABB(be.worldPosition.offset(-radius, -radius, -radius).getCenter(), be.worldPosition.offset(radius, radius, radius).getCenter()));
        Creaking creaking = new Creaking(EntityType.CREAKING, level);
        creaking.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5 - (double)creaking.getEyeHeight(), (double)pos.getZ() + 0.5);
        for (Player player : players) {
            ItemStack head_slot = player.getItemBySlot(EquipmentSlot.HEAD);
            creaking.lookAt((Entity)player, 180.0f, 180.0f);
            if (head_slot.is(ItemTags.GAZE_DISGUISE_EQUIPMENT)) continue;
            BlockHitResult traceResult = player.level().clip(new ClipContext(player.getEyePosition(1.0f), player.getEyePosition(1.0f).add(player.getViewVector(1.0f).scale(6.0)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)player));
            if (traceResult != null && traceResult.getType() == HitResult.Type.BLOCK && traceResult.getBlockPos().equals((Object)be.worldPosition)) {
                level.setBlock(pos, (BlockState)level.getBlockState(pos).setValue((Property)SightBlock.POWER, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)SightBlock.INVERTED) == false)), 3);
                continue;
            }
            level.setBlock(pos, (BlockState)level.getBlockState(pos).setValue((Property)SightBlock.POWER, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)SightBlock.INVERTED) != false)), 3);
        }
    }
}

