/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.effects;

import com.belgie.creaking_expanded.registry.ParticleRegistry;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gamerules.GameRules;

public class CreakingMobEffect
extends MobEffect {
    private final ToIntFunction<RandomSource> maxCobwebs;

    public CreakingMobEffect(MobEffectCategory category, int color, ToIntFunction<RandomSource> maxCobwebs) {
        super(category, color);
        this.maxCobwebs = maxCobwebs;
    }

    public ParticleOptions createParticleOptions(MobEffectInstance effect) {
        return (ParticleOptions)ParticleRegistry.RESIN_BLOB.get();
    }

    public void onMobRemoved(ServerLevel p_376925_, LivingEntity p_338209_, int p_338446_, Entity.RemovalReason p_338624_) {
        if (p_338624_ == Entity.RemovalReason.KILLED && (p_338209_ instanceof Player || ((Boolean)p_376925_.getGameRules().get(GameRules.MOB_GRIEFING)).booleanValue())) {
            this.spawnCobwebsRandomlyAround(p_376925_, p_338209_.getRandom(), p_338209_.blockPosition());
        }
    }

    private void spawnCobwebsRandomlyAround(ServerLevel p_376905_, RandomSource p_338709_, BlockPos p_338472_) {
        HashSet set = Sets.newHashSet();
        int i = this.maxCobwebs.applyAsInt(p_338709_);
        for (BlockPos blockpos2 : BlockPos.randomInCube((RandomSource)p_338709_, (int)30, (BlockPos)p_338472_, (int)1)) {
            BlockPos blockpos1 = blockpos2.below();
            if (set.contains(blockpos2) || !p_376905_.getBlockState(blockpos2).canBeReplaced() || !p_376905_.getBlockState(blockpos1).isFaceSturdy((BlockGetter)p_376905_, blockpos1, Direction.UP)) continue;
            set.add(blockpos2.immutable());
            if (set.size() < i) continue;
            break;
        }
        for (BlockPos blockpos2 : set) {
            p_376905_.setBlock(blockpos2, (BlockState)Blocks.RESIN_CLUMP.defaultBlockState().setValue((Property)MultifaceBlock.getFaceProperty((Direction)Direction.DOWN), (Comparable)Boolean.valueOf(true)), 3);
            p_376905_.levelEvent(3018, blockpos2, 0);
        }
    }
}

