/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.entity;

import java.util.EnumSet;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class GenericAttackPickerEntity
extends Monster {
    private static final EntityDataAccessor<Byte> DATA_SPELL_CASTING_ID = SynchedEntityData.defineId(GenericAttackPickerEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected int AttackTickCount;
    private Attack currentAttack = Attack.NONE;

    protected GenericAttackPickerEntity(EntityType<? extends GenericAttackPickerEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SPELL_CASTING_ID, (Object)0);
    }

    public void readAdditionalSaveData(ValueInput compound) {
        super.readAdditionalSaveData(compound);
        this.AttackTickCount = compound.getIntOr("AttackTicks", 0);
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("AttackTicks", this.AttackTickCount);
    }

    public boolean isAttacking() {
        return this.level().isClientSide() ? (Byte)this.entityData.get(DATA_SPELL_CASTING_ID) > 0 : this.AttackTickCount > 0;
    }

    public void setIsAttacking(Attack currentSpell) {
        this.currentAttack = currentSpell;
        this.entityData.set(DATA_SPELL_CASTING_ID, (Object)((byte)currentSpell.id));
    }

    protected Attack getCurrentAttack() {
        return !this.level().isClientSide() ? this.currentAttack : Attack.byId(((Byte)this.entityData.get(DATA_SPELL_CASTING_ID)).byteValue());
    }

    protected void customServerAiStep(ServerLevel p_376834_) {
        super.customServerAiStep(p_376834_);
        if (this.AttackTickCount > 0) {
            --this.AttackTickCount;
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide() && this.isAttacking()) {
            Attack spellcasterillager$illagerspell = this.getCurrentAttack();
            float f = (float)spellcasterillager$illagerspell.AttackColor[0];
            float f1 = (float)spellcasterillager$illagerspell.AttackColor[1];
            float f2 = (float)spellcasterillager$illagerspell.AttackColor[2];
            float f3 = this.yBodyRot * ((float)Math.PI / 180) + Mth.cos((double)((float)this.tickCount * 0.6662f)) * 0.25f;
            float f4 = Mth.cos((double)f3);
            float f5 = Mth.sin((double)f3);
            double d0 = 0.6 * (double)this.getScale();
            double d1 = 1.8 * (double)this.getScale();
            this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)f, (float)f1, (float)f2), this.getX() + (double)f4 * d0, this.getY() + d1, this.getZ() + (double)f5 * d0, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)f, (float)f1, (float)f2), this.getX() - (double)f4 * d0, this.getY() + d1, this.getZ() - (double)f5 * d0, 0.0, 0.0, 0.0);
        }
    }

    protected int getAttackingTime() {
        return this.AttackTickCount;
    }

    protected static enum Attack {
        NONE(0, 0.0, 0.0, 0.0),
        SUMMON_VEX(1, 0.7, 0.7, 0.8),
        FANGS(2, 0.4, 0.3, 0.35),
        WOLOLO(3, 0.7, 0.5, 0.2),
        DISAPPEAR(4, 0.3, 0.3, 0.8),
        BLINDNESS(5, 0.1, 0.1, 0.2);

        private static final IntFunction<Attack> BY_ID;
        final int id;
        final double[] AttackColor;

        private Attack(int id, double red, double green, double blue) {
            this.id = id;
            this.AttackColor = new double[]{red, green, blue};
        }

        public static Attack byId(int id) {
            return BY_ID.apply(id);
        }

        static {
            BY_ID = ByIdMap.continuous(p_263091_ -> p_263091_.id, (Object[])Attack.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    protected class SpellcasterCastingSpellGoal
    extends Goal {
        public SpellcasterCastingSpellGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return GenericAttackPickerEntity.this.getAttackingTime() > 0;
        }

        public void start() {
            super.start();
            GenericAttackPickerEntity.this.navigation.stop();
        }

        public void stop() {
            super.stop();
            GenericAttackPickerEntity.this.setIsAttacking(Attack.NONE);
        }

        public void tick() {
            if (GenericAttackPickerEntity.this.getTarget() != null) {
                GenericAttackPickerEntity.this.getLookControl().setLookAt((Entity)GenericAttackPickerEntity.this.getTarget(), (float)GenericAttackPickerEntity.this.getMaxHeadYRot(), (float)GenericAttackPickerEntity.this.getMaxHeadXRot());
            }
        }
    }

    protected abstract class SpellcasterUseSpellGoal
    extends Goal {
        protected int attackWarmupDelay;
        protected int nextAttackTickCount;

        protected SpellcasterUseSpellGoal() {
        }

        public boolean canUse() {
            LivingEntity livingentity = GenericAttackPickerEntity.this.getTarget();
            if (livingentity != null && livingentity.isAlive()) {
                return GenericAttackPickerEntity.this.isAttacking() ? false : GenericAttackPickerEntity.this.tickCount >= this.nextAttackTickCount;
            }
            return false;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = GenericAttackPickerEntity.this.getTarget();
            return livingentity != null && livingentity.isAlive() && this.attackWarmupDelay > 0;
        }

        public void start() {
            this.attackWarmupDelay = this.adjustedTickDelay(this.getCastWarmupTime());
            GenericAttackPickerEntity.this.AttackTickCount = this.getCastingTime();
            this.nextAttackTickCount = GenericAttackPickerEntity.this.tickCount + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                GenericAttackPickerEntity.this.playSound(soundevent, 1.0f, 1.0f);
            }
            GenericAttackPickerEntity.this.setIsAttacking(this.getSpell());
        }

        public void tick() {
            --this.attackWarmupDelay;
            if (this.attackWarmupDelay == 0) {
                this.performSpellCasting();
                GenericAttackPickerEntity.this.playSound(SoundEvents.HONEYCOMB_WAX_ON, 1.0f, 1.0f);
            }
        }

        protected abstract void performSpellCasting();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @Nullable
        protected abstract SoundEvent getSpellPrepareSound();

        protected abstract Attack getSpell();
    }
}

