/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.entity;

import com.belgie.creaking_expanded.entity.GenericAttackPickerEntity;
import com.belgie.creaking_expanded.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.zombie.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.throwableitemprojectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.scores.PlayerTeam;

public class PaleGardenBossEntity
extends GenericAttackPickerEntity {
    private static final EntityDataAccessor<Integer> DATA_ID_STAGE = SynchedEntityData.defineId(PaleGardenBossEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_ID_HEART_COUNT = SynchedEntityData.defineId(PaleGardenBossEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    protected PaleGardenBossEntity(EntityType<? extends GenericAttackPickerEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SummonPuppetsGoal());
        this.goalSelector.addGoal(1, (Goal)new ShockwaveGoal());
        this.goalSelector.addGoal(1, (Goal)new ThornAttack());
        this.goalSelector.addGoal(1, (Goal)new RangedAttack());
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
    }

    @Override
    public void tick() {
        if (this.GetHeartCount() == 0 && this.GetStage() == 0) {
            this.SetStage(1);
        }
        super.tick();
    }

    public int GetStage() {
        return (Integer)this.entityData.get(DATA_ID_STAGE);
    }

    public void SetStage(int stage) {
        this.entityData.set(DATA_ID_STAGE, (Object)stage);
    }

    public int GetHeartCount() {
        return (Integer)this.entityData.get(DATA_ID_HEART_COUNT);
    }

    public void SetHeartCount(int hearts) {
        this.entityData.set(DATA_ID_HEART_COUNT, (Object)hearts);
    }

    public void RemoveHeart() {
        this.entityData.set(DATA_ID_HEART_COUNT, (Object)(this.GetHeartCount() - 1));
    }

    public void AddStage() {
        this.entityData.set(DATA_ID_HEART_COUNT, (Object)(this.GetStage() + 1));
    }

    class SummonPuppetsGoal
    extends GenericAttackPickerEntity.SpellcasterUseSpellGoal {
        private final TargetingConditions puppet_count = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();

        SummonPuppetsGoal() {
        }

        @Override
        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            int i = SummonPuppetsGoal.getServerLevel((Level)PaleGardenBossEntity.this.level()).getNearbyEntities(Vex.class, this.puppet_count, (LivingEntity)PaleGardenBossEntity.this, PaleGardenBossEntity.this.getBoundingBox().inflate(16.0)).size();
            return PaleGardenBossEntity.this.GetStage() == 0 && PaleGardenBossEntity.this.random.nextInt(8) + 1 > i;
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 340;
        }

        @Override
        protected void performSpellCasting() {
            ServerLevel serverlevel = (ServerLevel)PaleGardenBossEntity.this.level();
            PlayerTeam playerteam = PaleGardenBossEntity.this.getTeam();
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos = PaleGardenBossEntity.this.blockPosition().offset(-2 + PaleGardenBossEntity.this.random.nextInt(5), 1, -2 + PaleGardenBossEntity.this.random.nextInt(5));
                Zombie vex = (Zombie)EntityType.ZOMBIE.create(PaleGardenBossEntity.this.level(), EntitySpawnReason.MOB_SUMMONED);
                if (vex == null) continue;
                vex.snapTo(blockpos, 0.0f, 0.0f);
                vex.finalizeSpawn((ServerLevelAccessor)serverlevel, serverlevel.getCurrentDifficultyAt(blockpos), EntitySpawnReason.MOB_SUMMONED, (SpawnGroupData)null);
                if (playerteam != null) {
                    serverlevel.getScoreboard().addPlayerToTeam(vex.getScoreboardName(), playerteam);
                }
                serverlevel.addFreshEntityWithPassengers((Entity)vex);
                serverlevel.gameEvent((Holder)GameEvent.ENTITY_PLACE, blockpos, GameEvent.Context.of((Entity)PaleGardenBossEntity.this));
            }
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_SUMMON;
        }

        @Override
        protected GenericAttackPickerEntity.Attack getSpell() {
            return GenericAttackPickerEntity.Attack.SUMMON_VEX;
        }
    }

    class ShockwaveGoal
    extends GenericAttackPickerEntity.SpellcasterUseSpellGoal {
        ShockwaveGoal() {
        }

        @Override
        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            return PaleGardenBossEntity.this.GetStage() == 0;
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 340;
        }

        @Override
        protected void performSpellCasting() {
            BlockPos pos = PaleGardenBossEntity.this.blockPosition();
            BlockPos.betweenClosed((BlockPos)pos.offset(-16, -2, -16), (BlockPos)pos.offset(16, 2, 16)).forEach(p_383198_ -> {
                BlockState blockstate = PaleGardenBossEntity.this.level().getBlockState(p_383198_);
                if (blockstate.is(Blocks.MAGMA_BLOCK)) {
                    PaleGardenBossEntity.this.level().setBlock(pos, ((Block)BlockRegistry.PALE_PUMPKIN.get()).defaultBlockState(), 3);
                    PaleGardenBossEntity.this.level().scheduleTick(p_383198_, blockstate.getBlock(), 3);
                }
            });
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_SUMMON;
        }

        @Override
        protected GenericAttackPickerEntity.Attack getSpell() {
            return GenericAttackPickerEntity.Attack.SUMMON_VEX;
        }
    }

    class ThornAttack
    extends GenericAttackPickerEntity.SpellcasterUseSpellGoal {
        ThornAttack() {
        }

        @Override
        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            return PaleGardenBossEntity.this.GetStage() == 0;
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 340;
        }

        @Override
        protected void performSpellCasting() {
            BlockPos pos = PaleGardenBossEntity.this.blockPosition();
            BlockPos.betweenClosed((BlockPos)pos.offset(-16, -2, -16), (BlockPos)pos.offset(16, 2, 16)).forEach(p_383198_ -> {
                BlockState blockstate1 = PaleGardenBossEntity.this.level().getBlockState(p_383198_.below());
                if (blockstate1.isSolid()) {
                    PaleGardenBossEntity.this.level().setBlock(pos, ((Block)BlockRegistry.THORN_BUSH.get()).defaultBlockState(), 3);
                    PaleGardenBossEntity.this.level().scheduleTick(p_383198_, ((Block)BlockRegistry.THORN_BUSH.get()).defaultBlockState().getBlock(), 3);
                }
            });
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_SUMMON;
        }

        @Override
        protected GenericAttackPickerEntity.Attack getSpell() {
            return GenericAttackPickerEntity.Attack.SUMMON_VEX;
        }
    }

    class RangedAttack
    extends GenericAttackPickerEntity.SpellcasterUseSpellGoal {
        RangedAttack() {
        }

        @Override
        public boolean canUse() {
            if (!super.canUse()) {
                return false;
            }
            return PaleGardenBossEntity.this.GetStage() == 0;
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 340;
        }

        @Override
        protected void performSpellCasting() {
            LivingEntity target = PaleGardenBossEntity.this.getTarget();
            double d0 = target.getX() - PaleGardenBossEntity.this.getX();
            double d1 = target.getEyeY() - (double)1.1f;
            double d2 = target.getZ() - PaleGardenBossEntity.this.getZ();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.2f;
            Level var12 = PaleGardenBossEntity.this.level();
            if (var12 instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)var12;
                ItemStack itemstack = new ItemStack((ItemLike)Items.SNOWBALL);
                Projectile.spawnProjectile((Projectile)new Snowball((Level)serverlevel, (LivingEntity)PaleGardenBossEntity.this, itemstack), (ServerLevel)serverlevel, (ItemStack)itemstack, p_390225_ -> p_390225_.shoot(d0, d1 + d3 - p_390225_.getY(), d2, 1.6f, 12.0f));
            }
            PaleGardenBossEntity.this.playSound(SoundEvents.SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (PaleGardenBossEntity.this.getRandom().nextFloat() * 0.4f + 0.8f));
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_SUMMON;
        }

        @Override
        protected GenericAttackPickerEntity.Attack getSpell() {
            return GenericAttackPickerEntity.Attack.SUMMON_VEX;
        }
    }
}

