/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.entity.renderer;

import com.belgie.creaking_expanded.CreakingExpanded;
import com.belgie.creaking_expanded.entity.AI.PaleCreeperPowerLayer;
import com.belgie.creaking_expanded.entity.PaleCreeperEntity;
import com.belgie.creaking_expanded.entity.model.PaleCreeperModel;
import com.belgie.creaking_expanded.entity.renderstate.PaleCreeperRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaleCreeperRenderer
extends MobRenderer<PaleCreeperEntity, PaleCreeperRenderState, PaleCreeperModel> {
    public PaleCreeperRenderer(EntityRendererProvider.Context p_173958_) {
        super(p_173958_, (EntityModel)new PaleCreeperModel(p_173958_.bakeLayer(CreakingExpanded.EntityBits.PALE_CREEPER)), 0.5f);
        this.addLayer((RenderLayer)new PaleCreeperPowerLayer((RenderLayerParent<PaleCreeperRenderState, PaleCreeperModel>)this, p_173958_.getModelSet()));
    }

    protected void scale(PaleCreeperRenderState p_362568_, PoseStack p_114047_) {
        float f = p_362568_.swelling;
        float f1 = 1.0f + Mth.sin((double)(f * 100.0f)) * f * 0.01f;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        p_114047_.scale(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(PaleCreeperRenderState p_360678_) {
        float f = p_360678_.swelling;
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)f, (float)0.5f, (float)1.0f);
    }

    public Identifier getTextureLocation(PaleCreeperRenderState p_363813_) {
        return p_363813_.texture;
    }

    public PaleCreeperRenderState createRenderState() {
        return new PaleCreeperRenderState();
    }

    public void extractRenderState(PaleCreeperEntity p_364394_, PaleCreeperRenderState p_361451_, float p_364659_) {
        super.extractRenderState((LivingEntity)p_364394_, (LivingEntityRenderState)p_361451_, p_364659_);
        p_361451_.swelling = p_364394_.getSwelling(p_364659_);
        p_361451_.isPowered = p_364394_.isPowered();
        p_361451_.texture = p_364394_.getTexture();
        p_361451_.Shieldtexture = p_364394_.getShieldTexture();
    }
}

